<?php

use App\Models\Supplier;

test('can create a supplier', function () {
    $supplier = Supplier::create([
        'name' => 'Test Supplier',
        'contact_person' => 'John Doe',
        'email' => 'john@testsupplier.com',
        'phone' => '123-456-7890',
        'address' => '123 Test Street'
    ]);
    
    expect($supplier->name)->toBe('Test Supplier');
    expect($supplier->contact_person)->toBe('John Doe');
    expect($supplier->email)->toBe('john@testsupplier.com');
    expect($supplier->phone)->toBe('123-456-7890');
    expect($supplier->address)->toBe('123 Test Street');
});

test('can update a supplier', function () {
    $supplier = Supplier::factory()->create([
        'name' => 'Original Supplier',
        'contact_person' => 'Jane Doe'
    ]);
    
    $supplier->update([
        'name' => 'Updated Supplier',
        'contact_person' => 'John Smith'
    ]);
    
    expect($supplier->fresh()->name)->toBe('Updated Supplier');
    expect($supplier->fresh()->contact_person)->toBe('John Smith');
});

test('supplier has stock batches relationship', function () {
    $supplier = Supplier::factory()->create();
    
    expect($supplier->stockBatches())->toBeInstanceOf(\Illuminate\Database\Eloquent\Relations\HasMany::class);
});

test('supplier full contact attribute works', function () {
    $supplier = Supplier::factory()->create([
        'name' => 'Test Supplier',
        'contact_person' => 'John Doe'
    ]);
    
    expect($supplier->full_contact)->toBe('Test Supplier (John Doe)');
    
    $supplierWithoutContact = Supplier::factory()->create([
        'name' => 'Test Supplier 2',
        'contact_person' => null
    ]);
    
    expect($supplierWithoutContact->full_contact)->toBe('Test Supplier 2');
});

test('supplier can be deleted when no stock batches exist', function () {
    $supplier = Supplier::factory()->create();
    
    // Verify the supplier has no stock batches
    expect($supplier->stockBatches()->count())->toBe(0);
    
    // The supplier should be deletable
    $supplier->delete();
    
    expect(Supplier::find($supplier->id))->toBeNull();
});