<div class="container-fluid px-4 py-3">
    <!-- User Type Selection Card -->
    <div class="card mb-4 border-0 shadow">
        <div class="card-header bg-white py-3 border-bottom">
            <h5 class="mb-0 text-primary fw-semibold">
                <i class="fas fa-user-tag me-2"></i>Select User Type
            </h5>
        </div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-12">
                    <div class="d-flex flex-wrap gap-3">
                        <div class="form-check card-radio">
                            <input class="form-check-input" style="margin-left: 5px" type="radio" name="sector" id="internal" value="internal" wire:model.live="selectedSector" checked>
                            <label class="form-check-label card-radio-label" style="padding-left: 20px" for="internal">
                                <span class="card-radio-content" style="white-space: nowrap; margin-left: 20px">
                                    <i class="fas fa-building me-2"></i>Internal
                                </span>
                            </label>
                        </div>
                        <div class="form-check card-radio">
                            <input class="form-check-input" style="margin-left: 5px" type="radio" name="sector" id="other_educational_institute" value="other_educational_institute" wire:model.live="selectedSector">
                            <label class="form-check-label card-radio-label" style="padding-left: 20px" for="other_educational_institute">
                                <span class="card-radio-content" style="white-space: nowrap; margin-left: 20px">
                                    <i class="fas fa-school me-2"></i>Educational Institute
                                </span>
                            </label>
                        </div>
                        <div class="form-check card-radio">
                            <input class="form-check-input" style="margin-left: 5px" type="radio" name="sector" id="r_and_d_labs" value="r_and_d_labs" wire:model.live="selectedSector">
                            <label class="form-check-label card-radio-label" style="padding-left: 20px" for="r_and_d_labs">
                                <span class="card-radio-content" style="white-space: nowrap; margin-left: 20px">
                                    <i class="fas fa-flask me-2"></i>R&D Labs
                                </span>
                            </label>
                        </div>
                        <div class="form-check card-radio">
                            <input class="form-check-input" style="margin-left: 5px" type="radio" name="sector" id="industries" value="industries" wire:model.live="selectedSector">
                            <label class="form-check-label card-radio-label" style="padding-left: 20px" for="industries">
                                <span class="card-radio-content" style="white-space: nowrap; margin-left: 20px">
                                    <i class="fas fa-industry me-2"></i>Industries
                                </span>
                            </label>
                        </div>
                        <div class="form-check card-radio">
                            <input class="form-check-input" style="margin-left: 5px" type="radio" name="sector" id="startups" value="startups" wire:model.live="selectedSector">
                            <label class="form-check-label card-radio-label" style="padding-left: 20px" for="startups">
                                <span class="card-radio-content" style="white-space: nowrap; margin-left: 20px">
                                    <i class="fas fa-rocket me-2"></i>Startups
                                </span>
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Charge Calculator Card -->
    <div class="card mb-4 border-0 shadow">
        <div class="card-header bg-white py-3 border-bottom">
            <h5 class="mb-0 text-primary fw-semibold">
                <i class="fas fa-calculator me-2"></i>Charge Calculator
            </h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-8">
                    <div class="table-responsive">
                        <table class="table table-bordered mb-0">
                            <tbody>
                            <tr>
                                <th style="width: 40%; background-color: #f8f9fa;">User Type</th>
                                <td><?php echo e(ucfirst(str_replace('_', ' ', $selectedSector))); ?></td>
                            </tr>
                            <tr>
                                <th style="background-color: #f8f9fa;">Instrument Charges</th>
                                <td>₹<?php echo e($charges['instrument']); ?></td>
                            </tr>
                            <tr>
                                <th style="background-color: #f8f9fa;">GST (<?php echo e($charges['gst_percentage'] ?? 18); ?>%)</th>
                                <td>₹<?php echo e($charges['gst']); ?></td>
                            </tr>
                            <tr style="background-color: #e7f1ff;">
                                <th class="fw-bold">Total Charges</th>
                                <td class="fw-bold">₹<?php echo e($charges['total']); ?></td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-md-4 d-flex align-items-center justify-content-center">
                    <div class="text-center p-3 rounded" style="background-color: #f8f9fa; border: 1px dashed #dee2e6;">
                        <h4 class="text-primary mb-1">₹<?php echo e($charges['total']); ?></h4>
                        <p class="mb-0 text-muted small">Total Estimated Cost</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Instruments List Card -->
    <div class="card border-0 shadow">
        <div class="card-header bg-white py-3 border-bottom d-flex justify-content-between align-items-center">
            <h5 class="mb-0 text-primary fw-semibold">
                <i class="fas fa-microscope me-2"></i>Available Instruments
            </h5>
            <div class="d-flex align-items-center">
                <button type="button" class="btn btn-primary px-4" wire:click="$dispatch('openQuotationModal')" <?php if(empty($selected)): ?> disabled <?php endif; ?>>
                    <i class="fas fa-file-invoice me-2"></i>Request Quotation
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-light">
                    <tr>
                        <th style="width: 40px;"><input type="checkbox" class="form-check-input" wire:model.live="selectAll"></th>
                        <th style="width: 60px;">#</th>
                        <th style="width: 80px;">Image</th>
                        <th>Instrument Details</th>
                        <th style="width: 120px;">Booking Type</th>
                        <th style="width: 200px;">Quantity</th>
                        <th style="width: 220px;">Pricing Details</th>
                    </tr>
                    </thead>
                    <tbody>
                    <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $instruments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $instrument): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><input type="checkbox" class="form-check-input" wire:model.live="selected" value="<?php echo e($instrument->id); ?>"></td>
                            <td class="text-muted"><?php echo e($instruments->firstItem() + $index); ?></td>
                            <td>
                                <!--[if BLOCK]><![endif]--><?php if($instrument->photos): ?>
                                    <img src="<?php echo e(asset('storage/' . json_decode($instrument->photos)[0])); ?>" alt="<?php echo e($instrument->name); ?>" class="img-thumbnail rounded" style="width: 60px; height: 60px; object-fit: cover;">
                                <?php else: ?>
                                    <div class="bg-light d-flex align-items-center justify-content-center rounded" style="width: 60px; height: 60px;">
                                        <i class="fas fa-image text-muted"></i>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </td>
                            <td>
                                <div class="fw-semibold"><?php echo e($instrument->name); ?></div>
                                <div class="text-muted small">Model: <?php echo e($instrument->model_number); ?></div>
                                <div class="text-muted small">Location: <?php echo e($instrument->location); ?></div>
                            </td>
                            <td>
                                    <span class="badge bg-<?php echo e($instrument->booking_type == 'sample' ? 'info' : ($instrument->booking_type == 'slot' ? 'primary' : 'warning')); ?>">
                                        <?php echo e(ucfirst($instrument->booking_type)); ?>

                                    </span>
                            </td>
                            <td>
                                <!--[if BLOCK]><![endif]--><?php if($instrument->booking_type == 'sample'): ?>
                                    <input type="number" wire:model.live="quantities.<?php echo e($instrument->id); ?>.sample" min="0" class="form-control form-control-sm" placeholder="Samples">
                                <?php elseif($instrument->booking_type == 'slot'): ?>
                                    <!--[if BLOCK]><![endif]--><?php if(isset($instrument->booking_cost[$selectedSector]['slot'])): ?>
                                        <input type="number" wire:model.live="quantities.<?php echo e($instrument->id); ?>.slot" min="0" class="form-control form-control-sm mb-1" placeholder="Slots">
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <!--[if BLOCK]><![endif]--><?php if(isset($instrument->booking_cost[$selectedSector]['booking'])): ?>
                                        <input type="number" wire:model.live="quantities.<?php echo e($instrument->id); ?>.booking" min="0" class="form-control form-control-sm" placeholder="Bookings">
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <?php elseif($instrument->booking_type == 'both'): ?>
                                    <select wire:model.live="quantities.<?php echo e($instrument->id); ?>.type" class="form-select form-select-sm mb-2">
                                        <option value="">Select Type</option>
                                        <option value="sample">Sample</option>
                                        <option value="slot">Slot/Booking</option>
                                    </select>
                                    <!--[if BLOCK]><![endif]--><?php if(isset($quantities[$instrument->id]['type'])): ?>
                                        <!--[if BLOCK]><![endif]--><?php if($quantities[$instrument->id]['type'] == 'sample'): ?>
                                            <input type="number" wire:model.live="quantities.<?php echo e($instrument->id); ?>.sample" min="0" class="form-control form-control-sm" placeholder="Samples">
                                        <?php else: ?>
                                            <!--[if BLOCK]><![endif]--><?php if(isset($instrument->booking_cost[$selectedSector]['slot'])): ?>
                                                <input type="number" wire:model.live="quantities.<?php echo e($instrument->id); ?>.slot" min="0" class="form-control form-control-sm mb-1" placeholder="Slots">
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <!--[if BLOCK]><![endif]--><?php if(isset($instrument->booking_cost[$selectedSector]['booking'])): ?>
                                                <input type="number" wire:model.live="quantities.<?php echo e($instrument->id); ?>.booking" min="0" class="form-control form-control-sm" placeholder="Bookings">
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </td>
                            <td>
                                <div class="pricing-details">
                                    <!--[if BLOCK]><![endif]--><?php if($instrument->booking_type == 'slot' || $instrument->booking_type == 'both'): ?>
                                        <!--[if BLOCK]><![endif]--><?php if(isset($instrument->booking_cost[$selectedSector]['slot'])): ?>
                                        <div class="d-flex justify-content-between small mb-1">
                                            <span>Slot:</span>
                                            <span>₹<?php echo e($instrument->booking_cost[$selectedSector]['slot']); ?> + <?php echo e($instrument->booking_cost[$selectedSector]['slot_gst']); ?>% GST</span>
                                        </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <!--[if BLOCK]><![endif]--><?php if(isset($instrument->booking_cost[$selectedSector]['booking'])): ?>
                                        <div class="d-flex justify-content-between small mb-1">
                                            <span>Booking:</span>
                                            <span>₹<?php echo e($instrument->booking_cost[$selectedSector]['booking']); ?> + <?php echo e($instrument->booking_cost[$selectedSector]['booking_gst']); ?>% GST</span>
                                        </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <!--[if BLOCK]><![endif]--><?php if($instrument->booking_type == 'sample' || $instrument->booking_type == 'both'): ?>
                                        <div class="d-flex justify-content-between small">
                                            <span>Sample:</span>
                                            <span>₹<?php echo e($instrument->booking_cost[$selectedSector]['sample']); ?> + <?php echo e($instrument->booking_cost[$selectedSector]['sample_gst']); ?>% GST</span>
                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="text-center py-4">
                                <div class="d-flex flex-column align-items-center justify-content-center">
                                    <i class="fas fa-inbox fs-1 text-muted mb-2"></i>
                                    <div class="text-muted">No instruments found</div>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-between align-items-center mt-3">
                <div class="text-muted small">
                    Showing <?php echo e($instruments->firstItem()); ?> to <?php echo e($instruments->lastItem()); ?> of <?php echo e($instruments->total()); ?> entries
                </div>
                <div>
                    <?php echo e($instruments->links()); ?>

                </div>
            </div>
        </div>
    </div>

    <!-- Quotation Modal -->
    <div class="modal fade" id="quotationModal" tabindex="-1" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content border-0 shadow">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">Request Quotation</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form wire:submit="sendQuotation">
                        <div class="mb-3">
                            <label for="customerName" class="form-label">Full Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="customerName" wire:model="quotationForm.customerName" required>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['quotationForm.customerName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="mb-3">
                            <label for="organization" class="form-label">Organization Name <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" id="organization" wire:model="quotationForm.organization" required>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['quotationForm.organization'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" id="email" wire:model="quotationForm.email" required>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['quotationForm.email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="col-md-6 mb-3">
                                <label for="phone" class="form-label">Phone <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control" id="phone" wire:model="quotationForm.phone" required>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['quotationForm.phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Selected Instruments</label>
                            <div class="border rounded p-2" style="max-height: 150px; overflow-y: auto;">
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $instruments->whereIn('id', $selected); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $selectedInstrument): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="d-flex justify-content-between small py-1 border-bottom">
                                        <span><?php echo e($selectedInstrument->name); ?></span>
                                        <span class="text-muted"><?php echo e($selectedInstrument->model_number); ?></span>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        <div class="d-flex justify-content-between mt-4">
                            <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">Cancel</button>
                            <button type="submit" class="btn btn-primary px-4">
                                <span wire:loading.remove wire:target="sendQuotation">Submit Request</span>
                                <span wire:loading wire:target="sendQuotation">
                                    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
                                    Processing...
                                </span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <style>
        .card-radio {
            padding: 0;
        }
        .card-radio-label {
            display: block;
            padding: 10px 15px;
            border: 1px solid #dee2e6;
            border-radius: 6px;
            cursor: pointer;
            transition: all 0.2s;
        }
        .card-radio-label:hover {
            border-color: #0d6efd;
        }
        .card-radio .form-check-input:checked + .card-radio-label {
            border-color: #0d6efd;
            background-color: rgba(13, 110, 253, 0.05);
        }
        .card-radio-content {
            display: flex;
            align-items: center;
        }
        .pricing-details {
            background-color: #f8f9fa;
            padding: 8px;
            border-radius: 4px;
        }
        .table th {
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.75rem;
            letter-spacing: 0.5px;
            color: #6c757d;
        }
        .badge {
            padding: 5px 8px;
            font-weight: 500;
        }
    </style>

    <script>
        document.addEventListener('livewire:initialized', () => {
            Livewire.on('openQuotationModal', () => {
                const modal = new bootstrap.Modal(document.getElementById('quotationModal'));
                modal.show();

                document.getElementById('quotationModal').addEventListener('hidden.bs.modal', () => {
                    Livewire.dispatch('resetModal');
                });
            });

            Livewire.on('closeQuotationModal', () => {
                const modal = bootstrap.Modal.getInstance(document.getElementById('quotationModal'));
                modal.hide();
            });
        });
    </script>
</div>
<?php /**PATH D:\work\kinker\resources\views/livewire/instruments/public-instruments-list.blade.php ENDPATH**/ ?>