<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Suppliers Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            font-size: 10px;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .contact-info {
            font-size: 9px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1><?php echo e($title); ?></h1>
        <p>Generated on: <?php echo e($generatedAt); ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Name</th>
                <th>Contact Person</th>
                <th>Email</th>
                <th>Phone</th>
                <th>Address</th>
                <th>Stock Batches</th>
                <th>Created</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($supplier->name); ?></td>
                    <td><?php echo e($supplier->contact_person ?? 'N/A'); ?></td>
                    <td class="contact-info"><?php echo e($supplier->email ?? 'N/A'); ?></td>
                    <td class="contact-info"><?php echo e($supplier->phone ?? 'N/A'); ?></td>
                    <td class="contact-info"><?php echo e($supplier->address ?? 'N/A'); ?></td>
                    <td><?php echo e($supplier->stockBatches->count() ?? 0); ?></td>
                    <td><?php echo e($supplier->created_at->format('Y-m-d')); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="7" style="text-align: center; color: #666;">No suppliers found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="footer">
        <p>Laboratory Inventory Management System - Suppliers Report</p>
        <p>Total Suppliers: <?php echo e($data->count()); ?></p>
    </div>
</body>
</html><?php /**PATH /home1/kinkarlab/public_html/resources/views/exports/supplier-pdf.blade.php ENDPATH**/ ?>