<!DOCTYPE html>
<html>
<head>
    <title>Quotation Details</title>
    <style>
        body { font-family: Arial, sans-serif; line-height: 1.6; }
        .header { text-align: center; margin-bottom: 30px; }
        .company-logo { max-width: 200px; margin-bottom: 15px; }
        .quotation-info { margin-bottom: 20px; }
        .customer-info { margin-bottom: 30px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 30px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f5f5f5; }
        .total-section { text-align: right; margin-top: 20px; }
        .footer { margin-top: 50px; text-align: center; font-size: 0.9em; color: #666; }
    </style>
</head>
<body>
    <div class="header">
        <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="Company Logo" class="company-logo">
        <h2><?php echo e(config('app.name')); ?></h2>
        <p>Your Trusted Research Partner</p>
    </div>

    <div class="quotation-info">
        <h3>Quotation</h3>
        <p>Date: <?php echo e(date('d/m/Y')); ?></p>
        <p>Quotation No: QT-<?php echo e(time()); ?></p>
    </div>

    <div class="customer-info">
        <h4>Customer Details:</h4>
        <p>Name: <?php echo e($customerName); ?></p>
        <p>Organization: <?php echo e($organization); ?></p>
        <p>Email: <?php echo e($email); ?></p>
        <p>Phone: <?php echo e($phone); ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Sr No.</th>
                <th>Instrument Name</th>
                <th>Type</th>
                <th>Quantity</th>
                <th>Rate</th>
                <th>GST</th>
                <th>Amount</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $instruments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $instrument): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e($instrument['name']); ?></td>
                    <td><?php echo e($instrument['type']); ?></td>
                    <td><?php echo e($instrument['quantity']); ?></td>
                    <td>₹<?php echo e($instrument['rate']); ?></td>
                    <td><?php echo e($instrument['gst']); ?>%</td>
                    <td>₹<?php echo e($instrument['amount']); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <div class="total-section">
        <p><strong>Instrument Charges:</strong> ₹<?php echo e($charges['instrument']); ?></p>
        <p><strong>GST Amount:</strong> ₹<?php echo e($charges['gst']); ?></p>
        <p><strong>Total Amount:</strong> ₹<?php echo e($charges['total']); ?></p>
    </div>

    <div class="footer">
        <p>Thank you for your interest in our services.</p>
        <p>For any queries, please contact us at <?php echo e(config('mail.from.address')); ?></p>
    </div>
</body>
</html><?php /**PATH /home1/kinkarlab/public_html/resources/views/emails/QuotationMail.blade.php ENDPATH**/ ?>