<div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col mt-4">
    <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
        <span class="font-semibold text-primary text-lg">Bookings</span>
    </div>
    <div class="p-4">
        <!-- Search Filters -->

        <div class="w-full flex justify-between gap-2 items-center mb-2">
            <div class="flex gap-2">



            </div>
            <div class="flex items-center gap-2">
                <input type="date" wire:model.live="search_date" name="search" required placeholder="Search Bookings"
                       class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>

                <select wire:model.live="search_instrument" required
                        class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">-- Search instrument---</option>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $instruments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instrument): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($instrument->id); ?>"><?php echo e($instrument->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
            </div>
        </div>



        <div class="relative overflow-x-auto">
            <table class="w-full border-[2px] border-secondary/40 border-collapse">
                <tr>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Sr. No.</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Date</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Instrument</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Slot/ Samples</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Status</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Cost</td>
                </tr>
                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-secondary/10 cursor-pointer transition ease-in duration-2000">
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm"><?php echo e($loop->iteration); ?></td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm"><?php echo e(Carbon\Carbon::parse($booking->date)->format('d M, Y')); ?></td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm"><?php echo e($booking->instrument->name); ?></td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                            <!--[if BLOCK]><![endif]--><?php if($booking->slots && $booking->slots->isNotEmpty()): ?>
                                <?php echo e($booking->slots->first()->start_time); ?> - <?php echo e($booking->slots->last()->end_time); ?>

                            <?php else: ?>
                                <?php echo e($booking->sample_quantity); ?> samples booked
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </td>

                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <span>
                                        <!--[if BLOCK]><![endif]--><?php if($booking->status == 'confirmed'): ?>
                                            <span class="bg-success/20 text-success px-2 py-0.5 rounded-full text-xs">Confirmed</span>
                                        <?php else: ?>
                                            <span class="bg-danger/20 text-danger px-2 py-0.5 rounded-full text-xs">Cancelled</span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </span>

                            <span><i class="fa-regular text-<?php echo e($booking->status == 'confirmed'?'success':'danger'); ?> fa-comment mr-2"></i><?php echo e($booking->description??'--'); ?></span>
                        </td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                            <!--[if BLOCK]><![endif]--><?php if($booking->status == 'confirmed'): ?>
                                <?php echo e($booking->booking_cost); ?> ₹
                            <?php else: ?>
                                <span class="text-danger">No fee applied</span>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td class="border-[2px] border-secondary/40 px-4 py-1 text-ternary/80 font-medium text-sm text-center" colspan="6">No bookings found</td>
                    </tr>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </table>
            <div class="mt-4">
                <?php echo e($bookings->links()); ?>

            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\work\kinker\resources\views/livewire/student/student-booking-table.blade.php ENDPATH**/ ?>