
<?php use \Namu\WireChat\Facades\WireChat; ?>

<ul wire:loading.delay.long.remove wire:target="search" class="p-2 grid w-full spacey-y-2">
    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $conversations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $conversation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
    //$receiver =$conversation->getReceiver();
    $group = $conversation->isGroup() ? $conversation->group : null;
    $receiver = $conversation->isGroup() ? null : ($conversation->isPrivate() ? $conversation->peer_participant?->participantable : $this->auth);
    //$receiver = $conversation->isGroup() ? null : ($conversation->isPrivate() ? $conversation->peerParticipant()?->participantable : $this->auth);
    $lastMessage = $conversation->lastMessage;
    //mark isReadByAuth true if user has chat opened
    $isReadByAuth = $conversation?->readBy($conversation->auth_participant??$this->auth) || $selectedConversationId == $conversation->id;
    $belongsToAuth = $lastMessage?->belongsToAuth();


    ?>

    <li x-data="{
        conversationID: <?php echo \Illuminate\Support\Js::from($conversation->id)->toHtml() ?>,
        showUnreadStatus: <?php echo \Illuminate\Support\Js::from(!$isReadByAuth)->toHtml() ?>,
        handleChatOpened(event) {
            // Hide unread dot
            if (event.detail.conversation== this.conversationID) {
                this.showUnreadStatus= false;
            }
            //update this so that the the selected conversation highlighter can be updated
            $wire.selectedConversationId= event.detail.conversation;
        },
        handleChatClosed(event) {
                // Clear the globally selected conversation.
                $wire.selectedConversationId = null;
                selectedConversationId = null;
        },
        handleOpenChat(event) {
            // Clear the globally selected conversation.
            if (this.showUnreadStatus==  event.detail.conversation== this.conversationID) {
                this.showUnreadStatus= false;
            }
    }
    }"

    id="conversation-<?php echo e($conversation->id); ?>"
        wire:key="conversation-em-<?php echo e($conversation->id); ?>-<?php echo e($conversation->updated_at->timestamp); ?>"
        x-on:chat-opened.window="handleChatOpened($event)"
        x-on:chat-closed.window="handleChatClosed($event)">
        <a <?php if($widget): ?> tabindex="0"
        role="button"
        dusk="openChatWidgetButton"
        @click="$dispatch('open-chat',{conversation:<?php echo \Illuminate\Support\Js::from($conversation->id)->toHtml() ?>})"
        @keydown.enter="$dispatch('open-chat',{conversation:<?php echo \Illuminate\Support\Js::from($conversation->id)->toHtml() ?>})"
        <?php else: ?>
        wire:navigate href="<?php echo e(route(WireChat::viewRouteName(), $conversation->id)); ?>" <?php endif; ?>
            style="<?php echo \Illuminate\Support\Arr::toCssStyles(['border-color:var(--wc-brand-primary)' => $selectedConversationId == $conversation?->id]) ?>"
            class="py-3 flex gap-4 bg-primary/10 hover:bg-white rounded-xs transition-colors duration-150  relative w-full cursor-pointer px-2"
            :class="$wire.selectedConversationId == conversationID &&
                ' bg-white/70 border-r-4  border-opacity-20 border-primary'">

            <div class="shrink-0">
                <?php if (isset($component)) { $__componentOriginal573e53ccc82ae542bef1ba188da3d396 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal573e53ccc82ae542bef1ba188da3d396 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'wirechat::components.avatar','data' => ['disappearing' => ''.e($conversation->hasDisappearingTurnedOn()).'','group' => ''.e($conversation->isGroup()).'','src' => 
                                                    $group
                                                        ? $group->cover_url
                                                        : (
                                                            $receiver?->students->isNotEmpty()
                                                                ? asset('storage/' . $receiver->students->first()->profile_photo)
                                                                : (
                                                                    $receiver?->principalInvestigators->isNotEmpty()
                                                                        ? asset('storage/' . $receiver->principalInvestigators->first()->profile_photo)
                                                                        : asset('assets/images/whiteLogo.png')
                                                                )
                                                        )
                                                ,'class' => 'w-12 h-12']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('wirechat::avatar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['disappearing' => ''.e($conversation->hasDisappearingTurnedOn()).'','group' => ''.e($conversation->isGroup()).'','src' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(
                                                    $group
                                                        ? $group->cover_url
                                                        : (
                                                            $receiver?->students->isNotEmpty()
                                                                ? asset('storage/' . $receiver->students->first()->profile_photo)
                                                                : (
                                                                    $receiver?->principalInvestigators->isNotEmpty()
                                                                        ? asset('storage/' . $receiver->principalInvestigators->first()->profile_photo)
                                                                        : asset('assets/images/whiteLogo.png')
                                                                )
                                                        )
                                                ),'class' => 'w-12 h-12']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal573e53ccc82ae542bef1ba188da3d396)): ?>
<?php $attributes = $__attributesOriginal573e53ccc82ae542bef1ba188da3d396; ?>
<?php unset($__attributesOriginal573e53ccc82ae542bef1ba188da3d396); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal573e53ccc82ae542bef1ba188da3d396)): ?>
<?php $component = $__componentOriginal573e53ccc82ae542bef1ba188da3d396; ?>
<?php unset($__componentOriginal573e53ccc82ae542bef1ba188da3d396); ?>
<?php endif; ?>
            </div>

            <aside class="grid  grid-cols-12 w-full">
                <div class="col-span-10 border-b pb-2 border-primary  relative overflow-hidden truncate leading-5 w-full flex-nowrap p-1">

                    
                    <div class="flex gap-1 mb-1 w-full items-center">
                        <h6 class="truncate font-medium text-gray-900">
                            <?php echo e($group ? $group?->name : $receiver?->display_name); ?>

                        </h6>

                        <!--[if BLOCK]><![endif]--><?php if($conversation->isSelfConversation()): ?>
                            <span class="font-medium">(<?php echo e(__('wirechat::chats.labels.you')); ?>)</span>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    </div>

                    
                    <!--[if BLOCK]><![endif]--><?php if($lastMessage != null): ?>
                        <?php echo $__env->make('wirechat::livewire.chats.partials.message-body', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                </div>

                
                
                <!--[if BLOCK]><![endif]--><?php if($lastMessage != null && !$lastMessage?->ownedBy($this->auth) && !$isReadByAuth): ?>
                    <div x-show="showUnreadStatus" dusk="unreadMessagesDot" class=" col-span-2 flex flex-col text-center my-auto">
                        
                        <span dusk="unreadDotItem" class="sr-only">unread dot</span>
                        <svg style="<?php echo \Illuminate\Support\Arr::toCssStyles(['color:primary']) ?>" xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                            fill="currentColor" class="bi bi-dot w-10 h-10 text-blue-500" viewBox="0 0 16 16">
                            <path d="M8 9.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3z" />
                        </svg>

                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->


            </aside>
        </a>

    </li>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->

</ul>
<?php /**PATH D:\work\kinker\resources\views/vendor/wirechat/livewire/chats/partials/list.blade.php ENDPATH**/ ?>