<div>
    <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('success')); ?>

            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php if(session()->has('error')): ?>
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('error')); ?>

            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <!--[if BLOCK]><![endif]--><?php if($showInstrumentServiceDetails): ?>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('instruments.view-instrument-service-details', ['instrument' => $selectedInstrument]);

$__html = app('livewire')->mount($__name, $__params, 'lw-2767063772-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        <?php else: ?>
            <div class="w-full <?php echo e($forSingleInstrument?'':'border-[1px] border-t-[4px] border-primary/20 border-t-primary'); ?>  bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">
                <!--[if BLOCK]><![endif]--><?php if(!$forSingleInstrument): ?>
                    <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between">
                        <span class="font-semibold text-primary text-xl">Instrument Service Records</span>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                <div class="w-full overflow-x-auto p-4">
                    <div class="w-full flex justify-between gap-2 items-center mb-4">
                        <div class="flex gap-2">
                            <button title="Export to pdf" wire:click="exportToPdf" class="bg-danger/20 text-danger h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white cursor-pointer transition ease-in duration-2000">
                                <i class="fa fa-file-pdf"></i>
                            </button>
                        </div>
                        <div class="flex items-center gap-2">
                            <input type="text" wire:model.live.debounce.1000ms="search" name="search" required placeholder="Search Services"
                                   class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>

                            <!--[if BLOCK]><![endif]--><?php if(!$forSingleInstrument): ?>
                                <select wire:model.live="instrumentSearch" required
                                        class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <option value="">Select Instrument</option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $instruments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instrument): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($instrument->name); ?>"><?php echo e($instrument->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <select wire:model.live="serviceType" required
                                    class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <option value="">Select Service Type</option>
                                <option value="repair">Repair</option>
                                <option value="maintenance">Maintenance</option>
                            </select>

                            <select wire:model.live="status" required
                                    class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <option value="All">All Status</option>
                                <option value="pending">Pending</option>
                                <option value="completed">Completed</option>
                            </select>
                        </div>
                    </div>

                    <table class="w-full border-[2px] border-secondary/40 border-collapse" wire:loading.class="opacity-25">
                        <tr>
                            <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Sr. No.</td>
                            <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Instrument</td>
                            <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Service Type</td>
                            <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Description</td>
                            <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Cost</td>
                            <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Photos</td>
                            <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Status</td>
                            <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Action</td>
                        </tr>

                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                            <tr class="hover:bg-secondary/10 cursor-pointer transition ease-in duration-2000">
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm"><?php echo e($loop->iteration); ?></td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <span><i class="fa-solid fa-flask mr-1 text-success"></i> <?php echo e($service->instrument->name); ?></span> <br>
                                    <span class="text-xs"><i class="fa fa-clock mr-1 text-danger"></i> <?php echo e($service->created_at->format('d/M/Y h:i A')); ?></span>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <!--[if BLOCK]><![endif]--><?php if($service->service_type == 'repair'): ?>
                                        <span class="bg-danger/20 text-danger px-2 py-0.5 rounded-full text-xs">Repair</span>
                                    <?php else: ?>
                                        <span class="bg-warning/20 text-warning px-2 py-0.5 rounded-full text-xs">Maintenance</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm w-[200px]">
                                    <span class="text-md"><?php echo e($service->description); ?></span>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <?php
                                        $invoiceCost = json_decode($service->invoice_details, true);
                                    ?>
                                    <span><i class="fa-solid fa-money-bill mr-1 text-success"></i> ₹<?php echo e($invoiceCost['invoice_cost']??'-'); ?></span> <br>
                                   <!--[if BLOCK]><![endif]--><?php if($invoiceCost===null): ?>
                                       <?php else: ?>
                                        <span class="text-xs">
                                       <a href="<?php echo e(asset('storage/'.$invoiceCost['invoice_image']??'-')); ?>"><i class="fa fa-eye mr-1 text-danger"></i> View Invoice</a>
                                    </span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <!--[if BLOCK]><![endif]--><?php if($service->photos): ?>
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = json_decode($service->photos); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(asset('storage/'.$photo)); ?>" target="_blank" class="inline-block">
                                                <img src="<?php echo e(asset('storage/'.$photo)); ?>" class="h-12 w-auto mb-1" alt="Service Photo">
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php else: ?>
                                        <span class="text-md">No Photos Available</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <!--[if BLOCK]><![endif]--><?php if($service->status == 'pending'): ?>
                                        <span class="bg-warning/20 text-warning px-2 py-0.5 rounded-full text-xs">Pending</span>
                                    <?php else: ?>
                                        <span class="bg-success/20 text-success px-2 py-0.5 rounded-full text-xs">Completed</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <div class="flex gap-2">
                                        <!--[if BLOCK]><![endif]--><?php if($service->status == 'pending'): ?>
                                            <button wire:click="markServiceDone(<?php echo e($service->id); ?>)" title="Mark as done" class="bg-success/20 text-success h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-success hover:text-white cursor-pointer transition ease-in duration-2000">
                                                <i class="fa fa-check text-xs"></i>
                                            </button>
                                        <?php else: ?>
                                            <button wire:click="viewServiceDetail(<?php echo e($service->id); ?>)" title="Mark as done" class="bg-success/20 text-success h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-success hover:text-white cursor-pointer transition ease-in duration-2000">
                                                <i class="fa fa-eye text-xs"></i>
                                            </button>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm text-center" colspan="9">No service records found</td>
                            </tr>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </table>

                    <div class="mt-4">
                        <?php echo e($services->links()); ?>

                    </div>
                </div>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->





    <!--[if BLOCK]><![endif]--><?php if($showCompleteModal): ?>
        <div class="fixed inset-0  bg-black/50 z-50 ">
            <div class="h-full w-full overflow-y-auto p-6 flex justify-center items-center">
                <div class="bg-white p-6 rounded-lg shadow-xl max-w-3xl w-full">
                    <h3 class="text-lg font-semibold mb-4 text-success">Complete Service</h3>
                    <form wire:submit="completeService">
                        <div class="w-full flex flex-col gap-4">
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Service Type <span class="text-danger">*</span></label>
                                <select wire:model="serviceType" required class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <option value="">Select Service Type</option>
                                    <option value="repair">Repair</option>
                                    <option value="maintenance">Maintenance</option>
                                </select>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['serviceType'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Description <span class="text-danger">*</span></label>
                                <textarea wire:model="description" rows="3" placeholder="Enter service description" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"></textarea>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>


                            <h3 class="text-lg font-semibold text-success">Addition of parts</h3>

                            <div class="w-full grid lg:grid-cols-3 gap-2">
                                <div class="w-full flex flex-col gap-1">
                                    <label class="font-semibold text-primary">Part Name</label>
                                    <input type="text" wire:model="part_name" placeholder="Enter part name" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['part_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="w-full flex flex-col gap-1">
                                    <label class="font-semibold text-primary">Description</label>
                                    <input type="text" wire:model="part_description" placeholder="Description" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['part_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="w-full flex flex-col gap-1">
                                    <label class="font-semibold text-primary">Upload Image</label>
                                    <input type="file" wire:model="part_images" accept="image/*" class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <div wire:loading wire:target="part_images" class="text-sm text-danger"><i class="fas fa-hourglass-half fa-spin mr-2"></i> Uploading files... Please wait</div>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['part_images'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="w-full flex flex-col gap-1">
                                    <label class="inline-flex items-center">
                                        <input type="checkbox"
                                               wire:model="oldPartReceived"
                                               value=""
                                               class="form-checkbox h-5 w-5 text-primary rounded-[2px] focus:outline-none focus:ring-0">
                                        <span class="ml-2">Old Part Received?</span>
                                    </label>
                                </div>
                                <div class="w-full flex flex-col gap-1">
                                    <button type="button" wire:click="addMorePartInformation" class="w-max bg-primary/80 hover:bg-primary text-white px-4 py-0.5 rounded-sm transition ease-in duration-2000">Add More</button>
                                </div>
                            </div>

                            <!--[if BLOCK]><![endif]--><?php if(!empty($parts)): ?>
                                <div class="w-full mt-4">
                                    <h4 class="text-md font-semibold text-primary mb-2">Added Parts</h4>
                                    <div class=" grid lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-4">
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $parts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $part): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="border p-3 rounded">
                                                <div class="flex gap-4">
                                                    <div class="grow">
                                                        <p class="font-semibold">Part Name: <?php echo e($part['part_name']); ?></p>
                                                        <p class="text-sm">Description: <?php echo e($part['part_description']); ?></p>
                                                        <p class="text-sm">Old Part Received: <?php echo e($part['oldPartReceived'] ? 'Yes' : 'No'); ?></p>
                                                    </div>
                                                    <div class="flex-none">
                                                        <!--[if BLOCK]><![endif]--><?php if(!empty($part['part_images'])): ?>
                                                            <div class="flex  gap-2">
                                                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $part['part_images']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <img src="<?php echo e(asset('storage/' . $image)); ?>" class="h-16 w-16 object-cover rounded" alt="Part Image">
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                            </div>
                                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->


                            <h3 class="text-lg font-semibold text-success">Invoice Information</h3>
                            <div class="w-max flex flex-col gap-1">
                                <label class="inline-flex items-center">
                                    <input type="checkbox"
                                           wire:model.live="service_paid_or_not"
                                           value=""
                                           class="form-checkbox h-5 w-5 text-primary rounded-[2px] focus:outline-none focus:ring-0">
                                    <span class="ml-2">Is Service Paid? </span>
                                </label>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php if($service_paid_or_not): ?>
                                <div class="w-full grid lg:grid-cols-3 gap-2">
                                    <div class="w-full flex flex-col gap-1">
                                        <label class="font-semibold text-primary">Invoice Cost (₹)</label>
                                        <input type="number" wire:model="invoice_cost" placeholder="Enter service cost" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['invoice_cost'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                    <div class="w-full flex flex-col gap-1">
                                        <label class="font-semibold text-primary">Invoice Date</label>
                                        <input type="date" wire:model="invoice_date" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['invoice_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                    <div class="w-full flex flex-col gap-1">
                                        <label class="font-semibold text-primary">Upload Invoice</label>
                                        <input type="file" wire:model="invoice_image"  accept="image/*" class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                        <div wire:loading wire:target="invoice_image" class="text-sm text-danger"><i class="fas fa-hourglass-half fa-spin mr-2"></i> Uploading files... Please wait</div>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['invoice_image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->



                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Next Service Date</label>
                                <input type="date" wire:model="next_service_date" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['next_service_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>

                        </div>
                        <div class="flex justify-end space-x-3 mt-4">
                            <button type="button" wire:click="$set('showCompleteModal', false)" class="text-sm bg-danger/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/90 text-ternary hover:text-white hover:bg-danger hover:border-danger/30 transition ease-in duration-2000">Cancel</button>
                            <button type="submit" class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-success/30 transition ease-in duration-2000">
                                <span wire:loading.remove wire:target="completeService">Complete Service</span>
                                <span wire:loading wire:target="completeService">Completing... <i class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div>
<?php /**PATH D:\work\kinker\resources\views/livewire/instruments/instrument-service-record.blade.php ENDPATH**/ ?>