<div>

    <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">
        <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between flex-wrap">
            <span class="font-semibold text-primary text-xl">Booking for Approval</span>
        </div>
        <div class="w-full overflow-x-auto p-4">
            <div class="w-full flex justify-between gap-2 items-center mb-4">
                <div class="flex gap-2">

                </div>
                <div class="flex items-center gap-2">
                    <input type="text" wire:model.live.debounce.1000ms="search" name="search" required placeholder="Search Bookings"
                           class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>

                    <!--[if BLOCK]><![endif]--><?php if(!$studentView): ?>
                        <select wire:model.live="studentSearch" required
                                class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <option value="">Select Student</option>
                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($student->first_name); ?>"><?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                        </select>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <select wire:model.live="instrumentSearch" required
                            class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                        <option value="">Select Instrument</option>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $instruments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instrument): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($instrument->name); ?>"><?php echo e($instrument->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </select>

                    <select wire:model.live="status" required
                            class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                        <option value="All">All Status</option>
                        <option value="confirmed">Confirmed</option>
                        <option value="pending">Pending</option>
                        <option value="cancelled">Cancelled</option>
                    </select>
                </div>
            </div>

            <table class="w-full border-[2px] border-secondary/40 border-collapse" wire:loading.class="opacity-25">
                <tr>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Sr. No.</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Booking For</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Booking By</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Date/ Slot</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Status</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Action</td>
                </tr>


                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                    <tr class="hover:bg-secondary/10 cursor-pointer transition ease-in duration-2000">
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm"><?php echo e($loop->iteration); ?></td>

                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                            <div class="flex w-full items-center gap-2">
                                <?php if($booking->booking->instrument->photos): ?>
                                    <?php $photos = json_decode($booking->booking->instrument->photos); ?>
                                    <!--[if BLOCK]><![endif]--><?php if(count($photos) > 0): ?>
                                        <img src="<?php echo e(asset('storage/' . $photos[0])); ?>"
                                             alt="<?php echo e($instrument->name); ?>"
                                             class="h-12 w-12 object-cover rounded-full"/>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <div class="w-full">
                                    <span class=" text-md"><?php echo e($booking->booking->instrument->name); ?></span> <br>
                                    <span class="mt-1 text-xs"><?php echo e($booking->booking->instrument->instrumentCategory->title??''); ?></span>
                                </div>
                            </div>

                        </td>

                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm w-[300px]">
                            <div class="flex items-center gap-2">
                                <img src="<?php echo e(asset('storage/' . $booking->booking->student?->profile_photo)); ?>"
                                     alt="<?php echo e($booking->booking->student->first_name); ?>" class="h-12 w-12 object-cover rounded-full"/>
                                <div class="w-max">
                                    <span class=" text-md text-center"><?php echo e($booking->booking->student->first_name); ?> <?php echo e($booking->booking->student->last_name); ?></span> <br>
                                    <span class="mt-1 text-xs"><?php echo e($booking->booking->student->academic_id); ?></span>
                                </div>
                            </div>
                        </td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm w-[300px]">
                            <div class="w-max">
                                <span><i class="fa fa-calendar-days mr-1 text-success"></i> <?php echo e($booking->booking->date); ?></span> <br>
                                <span>
                                     <!--[if BLOCK]><![endif]--><?php if($booking->booking->slots && $booking->booking->slots->isNotEmpty()): ?>
                                        <i class="fa fa-clock mr-1 text-danger"></i>  <?php echo e($booking->booking->slots->first()->start_time); ?> - <?php echo e($booking->booking->slots->last()->end_time); ?>

                                    <?php else: ?>
                                        <i class="fa fa-flask mr-1 text-danger"></i>  <?php echo e($booking->booking->sample_quantity); ?> samples booked
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </td>

                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm w-[300px]">
                            <div class="w-max" style="max-width: 300px">
                                    <span>
                                        <!--[if BLOCK]><![endif]--><?php if($booking->status == 'approved'): ?>
                                            <span class="bg-success/20 text-success px-2 py-0.5 rounded-full text-xs">Approved</span>
                                        <?php elseif($booking->status == 'pending'): ?>
                                            <span class="bg-warning/20 text-warning px-2 py-0.5 rounded-full text-xs">Pending</span>
                                        <?php elseif($booking->status == 'rejected'): ?>
                                            <span class="bg-warning/20 text-warning px-2 py-0.5 rounded-full text-xs">Rejected</span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </span>
                                <br>
                                <!--[if BLOCK]><![endif]--><?php if($booking->status == 'approved'): ?>
                                    <span> <i class="fa-regular text-success fa-comment mr-2"></i><?php echo e($booking->remark??'--'); ?></span>
                                <?php elseif($booking->status == 'pending'): ?>
                                    <span> <i class="fa-regular text-warning fa-comment mr-2"></i><?php echo e($booking->remark??'--'); ?></span>
                                <?php elseif($booking->status == 'rejected'): ?>
                                    <span> <i class="fa-regular text-danger fa-comment mr-2"></i><?php echo e($booking->remark??'--'); ?></span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </td>
                       
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                            <div class="flex gap-2">
                                <!--[if BLOCK]><![endif]--><?php if($booking->status === 'pending'): ?>
                                    <button wire:click="updateBookingStatus(<?php echo e($booking->id); ?>)" title="Update Status" class="bg-danger/20 text-danger h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white cursor-pointer transition ease-in duration-2000">
                                        <i class="fa fa-edit text-xs"></i>
                                    </button>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm text-center" colspan="6">No bookings for approval</td>
                    </tr>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </table>

            <div class="mt-4">
                <?php echo e($bookings->links()); ?>

            </div>
        </div>
    </div>

    <!--[if BLOCK]><![endif]--><?php if($showUpdateStatusModel): ?>
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50">
            <form onsubmit="" class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                <h3 class="text-lg font-semibold mb-4 text-danger">Update Booking Status</h3>
                <div class="w-full flex flex-col gap-1 xl:col-span-2">
                    <label class="font-semibold text-primary"> Status <span class="text-danger">*</span></label>
                    <select  wire:model="currentBookingStatus"  class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                        <option value="">--- select ---</option>
                        <option value="approve">Approve</option>
                        <option value="reject">Reject</option>
                    </select>
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['remark'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <div class="w-full flex flex-col gap-1 xl:col-span-2 mt-2">
                    <label class="font-semibold text-primary"> Remark <span class="text-danger">*</span></label>
                    <textarea wire:model="remark" rows="2" placeholder="Enter cancellation remark" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"></textarea>
                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['remark'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <div class="flex justify-end space-x-3 mt-4">
                    <button
                        wire:click="$set('showCancelModal', false)"
                        class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000"
                    >
                        Back
                    </button>
                    <button type="submit"  wire:click="updateStatus" class="text-sm bg-danger/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/90 text-ternary hover:text-white hover:bg-danger hover:border-danger/30 transition ease-in duration-2000">
                        <span wire:loading.remove wire:target="submit">
                             Update Status
                        </span>
                        <span wire:loading wire:target="submit">
                           Updating Status....  <i class="fas fa-hourglass-half fa-spin ml-2"></i>
            </span>
                    </button>
                </div>
            </form>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->


</div><?php /**PATH /home1/kinkarlab/iitr.kinkarlab.com/resources/views/livewire/bookings/pending-for-approval.blade.php ENDPATH**/ ?>