<div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">

    <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('success')); ?>

            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php if(session()->has('error')): ?>
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('error')); ?>

            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php if(session()->has('warning')): ?>
        <div id="warningMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-warning bg-yellow-100 border-l-4 border-yellow-500 text-yellow-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('warning')); ?>

            <div onclick="document.getElementById('warningMessage').classList.add('hidden')"
                 class="cursor-pointer bg-yellow-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between flex-wrap">
        <span class="font-semibold text-primary text-xl">Items</span>
        <div class="flex items-center gap-2 justify-end">
            <span wire:click="toggleShowAddNewItemModal"
                  class="text-sm bg-primary/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                <i class="fa fa-plus mr-2"></i>Add Item
            </span>
        </div>
    </div>
        <div class="w-full flex flex-col lg:flex-row justify-between gap-4 px-4">
            <div class="flex flex-col sm:flex-row gap-2">
                <button wire:click="exportItems"
                        class="text-sm bg-success/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/80 text-white hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000 disabled:opacity-50 disabled:cursor-not-allowed"
                        wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="exportItems">
                        <i class="fa fa-file-excel mr-2"></i>Excel
                    </span>
                    <span wire:loading wire:target="exportItems">
                        <i class="fas fa-hourglass-half fa-spin mr-2"></i>Exporting...
                    </span>
                </button>

                <button wire:click="exportItemsPdf"
                        class="text-sm bg-danger/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/80 text-white hover:text-white hover:bg-danger hover:border-ternary/30 transition ease-in duration-2000 disabled:opacity-50 disabled:cursor-not-allowed"
                        wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="exportItemsPdf">
                        <i class="fa fa-file-pdf mr-2"></i>PDF
                    </span>
                    <span wire:loading wire:target="exportItemsPdf">
                        <i class="fas fa-hourglass-half fa-spin mr-2"></i>Exporting...
                    </span>
                </button>
            </div>

            <div class="flex flex-col sm:flex-row gap-2">
                <div class="relative">
                    <input type="text" wire:model.live.debounce.500ms="search" placeholder="Search items..."
                           class="px-3 py-1.5 w-full sm:max-w-64 text-sm font-medium bg-white placeholder-gray-500 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <!--[if BLOCK]><![endif]--><?php if($search): ?>
                        <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-danger">
                            <i class="fa fa-times"></i>
                        </button>
                    <?php else: ?>
                        <span class="absolute right-3 top-1/2 -translate-y-1/2 text-success">
                        <i class="fa fa-search"></i>
                    </span>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>

                <select wire:model.live="categoryFilter"
                        class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">All Categories</option>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>

                <select wire:model.live="itemTypeFilter"
                        class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">All Types</option>
                    <option value="regular">Regular</option>
                    <option value="chemical">Chemical</option>
                </select>
            </div>
        </div>

    <div class="w-full overflow-x-auto p-4 pt-0">
        <!--[if BLOCK]><![endif]--><?php if($items->count() > 0): ?>
            <!-- Desktop Table View -->
            <div class="hidden lg:block overflow-x-auto">
                <table class="w-full border-[2px] border-secondary/40 border-collapse"
                       wire:loading.class="opacity-25">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Sr. No.</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Name</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Category</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Type</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Min Stock</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Current Stock</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Variants</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-secondary/10 transition ease-in duration-2000">
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <?php echo e(($items->currentPage() - 1) * $items->perPage() + $index + 1); ?>

                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <div class="flex items-start">
                                        <i class="fa <?php echo e($item->item_type === 'chemical' ? 'fa-flask' : 'fa-box'); ?> text-primary mr-2 text-xs mt-1"></i>
                                        <div>
                                            <div class="font-semibold"><?php echo e($item->name); ?></div>
                                            <!--[if BLOCK]><![endif]--><?php if($item->description): ?>
                                                <div class="text-xs text-gray-500 mt-1"><?php echo e(Str::limit($item->description, 60)); ?></div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <!--[if BLOCK]><![endif]--><?php if($item->isChemical() && $item->hazard_information): ?>
                                                <div class="text-xs text-red-600 mt-1">
                                                    <i class="fa fa-exclamation-triangle mr-1"></i>
                                                    <?php echo e(Str::limit($item->hazard_information, 40)); ?>

                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    </div>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs font-medium rounded-full bg-secondary/10 text-secondary">
                                        <i class="fa fa-tag mr-1"></i><?php echo e($item->category->name ?? 'N/A'); ?>

                                    </span>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs font-medium rounded-full
                                        <?php echo e($item->item_type === 'chemical' ? 'bg-purple-100 text-purple-800' : 'bg-blue-100 text-blue-800'); ?>">
                                        <?php echo e(ucfirst($item->item_type)); ?>

                                    </span>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <?php echo e($item->min_stock_level ?? 'Not set'); ?>

                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <?php
                                        $currentStock = $item->getCurrentStock();
                                        $isLowStock = $item->isLowStock();
                                        $isOutOfStock = $item->isOutOfStock();
                                    ?>
                                    <span class="px-2 py-1 text-xs font-medium rounded-full
                                        <?php echo e($isOutOfStock ? 'bg-red-100 text-red-800' : ($isLowStock ? 'bg-yellow-100 text-yellow-800' : 'bg-green-100 text-green-800')); ?>">
                                        <?php echo e(number_format($currentStock, 2)); ?>

                                        <!--[if BLOCK]><![endif]--><?php if($isOutOfStock): ?>
                                            <i class="fa fa-times-circle ml-1"></i>
                                        <?php elseif($isLowStock): ?>
                                            <i class="fa fa-exclamation-triangle ml-1"></i>
                                        <?php else: ?>
                                            <i class="fa fa-check-circle ml-1"></i>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </span>
                                    <!--[if BLOCK]><![endif]--><?php if($isOutOfStock): ?>
                                        <div class="text-xs text-red-600 mt-1">Out of Stock</div>
                                    <?php elseif($isLowStock): ?>
                                        <div class="text-xs text-yellow-600 mt-1">Low Stock</div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <?php if($item->isChemical() && $item->variants->count() > 0): ?>
                                        <div class="space-y-1">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $item->variants->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="text-xs bg-gradient-to-r from-purple-50 to-purple-100 px-2 py-1 rounded border border-purple-200">
                                                    <div class="flex items-center justify-between">
                                                        <span class="font-medium text-purple-800 flex items-center">
                                                            <i class="fa <?php echo e($variant->isLiquidUnit() ? 'fa-flask' : 'fa-weight-hanging'); ?> mr-1 text-xs"></i>
                                                            <?php echo e($variant->display_name); ?>

                                                        </span>
                                                        <!--[if BLOCK]><![endif]--><?php if($variant->barcode): ?>
                                                            <span class="text-purple-600 text-xs">
                                                                <i class="fa fa-barcode mr-1"></i><?php echo e(Str::limit($variant->barcode, 8)); ?>

                                                            </span>
                                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                    </div>
                                                    <!--[if BLOCK]><![endif]--><?php if($variant->hasStockBatches() || $variant->hasTransactions()): ?>
                                                        <div class="text-xs text-purple-600 mt-1 flex items-center gap-2">
                                                            <?php if($variant->hasStockBatches()): ?>
                                                                <span class="flex items-center">
                                                                    <i class="fa fa-boxes mr-1"></i>
                                                                    <?php echo e($variant->stockBatches()->count()); ?> batches
                                                                </span>
                                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                            <!--[if BLOCK]><![endif]--><?php if($variant->hasTransactions()): ?>
                                                                <span class="flex items-center">
                                                                    <i class="fa fa-exchange-alt mr-1"></i>
                                                                    <?php echo e($variant->transactions()->count()); ?> transactions
                                                                </span>
                                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                            <!--[if BLOCK]><![endif]--><?php if($variant->getTotalStockQuantity() > 0): ?>
                                                                <span class="flex items-center text-green-600">
                                                                    <i class="fa fa-check-circle mr-1"></i>
                                                                    <?php echo e($variant->getTotalStockQuantity()); ?> in stock
                                                                </span>
                                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                        </div>
                                                    <?php else: ?>
                                                        <div class="text-xs text-gray-500 mt-1">
                                                            <i class="fa fa-info-circle mr-1"></i>No stock or transactions
                                                        </div>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                            <!--[if BLOCK]><![endif]--><?php if($item->variants->count() > 3): ?>
                                                <div class="text-xs text-gray-500 text-center py-1">
                                                    <i class="fa fa-ellipsis-h mr-1"></i>+<?php echo e($item->variants->count() - 3); ?> more variants
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    <?php else: ?>
                                        <span class="text-gray-400 text-xs flex items-center">
                                            <i class="fa fa-info-circle mr-1"></i>
                                            <?php echo e($item->isChemical() ? 'No variants defined' : 'Not applicable'); ?>

                                        </span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <div class="flex items-center gap-2">
                                        <button wire:click="loadItemData(<?php echo e($item->id); ?>)"
                                                class="text-primary hover:text-primary-dark transition-colors"
                                                title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </button>

                                        <!--[if BLOCK]><![endif]--><?php if($item->stock_batches_count == 0): ?>
                                            <button wire:click="deleteItem(<?php echo e($item->id); ?>)"
                                                    wire:confirm="Are you sure you want to delete this item?"
                                                    class="text-red-600 hover:text-red-800 transition-colors"
                                                    title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        <?php else: ?>
                                            <span class="text-gray-400" title="Cannot delete - has associated stock batches">
                                                <i class="fas fa-trash"></i>
                                            </span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>

            <!-- Mobile Card View -->
            <div class="lg:hidden space-y-4" wire:loading.class="opacity-25">
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white border-[2px] border-secondary/40 rounded-lg p-4 shadow-sm">
                        <div class="flex justify-between items-start mb-3">
                            <div class="flex-1">
                                <h3 class="font-semibold text-primary flex items-center">
                                    <i class="fa <?php echo e($item->item_type === 'chemical' ? 'fa-flask' : 'fa-box'); ?> text-primary mr-2 text-xs"></i>
                                    <?php echo e($item->name); ?>

                                </h3>
                                <!--[if BLOCK]><![endif]--><?php if($item->description): ?>
                                    <p class="text-sm text-gray-600 mt-1"><?php echo e(Str::limit($item->description, 80)); ?></p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <!--[if BLOCK]><![endif]--><?php if($item->isChemical() && $item->hazard_information): ?>
                                    <div class="text-xs text-red-600 mt-1 bg-red-50 p-2 rounded">
                                        <i class="fa fa-exclamation-triangle mr-1"></i>
                                        <?php echo e(Str::limit($item->hazard_information, 60)); ?>

                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="flex items-center gap-2 ml-4">
                                <button wire:click="loadItemData(<?php echo e($item->id); ?>)"
                                        class="bg-primary/20 text-primary h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-primary hover:text-white cursor-pointer transition ease-in duration-2000"
                                        title="Edit">
                                    <i class="fas fa-edit text-xs"></i>
                                </button>

                                <!--[if BLOCK]><![endif]--><?php if($item->stock_batches_count == 0): ?>
                                    <button wire:click="deleteItem(<?php echo e($item->id); ?>)"
                                            wire:confirm="Are you sure you want to delete this item?"
                                            class="bg-red-100 text-red-600 h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-red-600 hover:text-white cursor-pointer transition ease-in duration-2000"
                                            title="Delete">
                                        <i class="fas fa-trash text-xs"></i>
                                    </button>
                                <?php else: ?>
                                    <span class="bg-gray-100 text-gray-400 h-8 w-8 flex justify-center items-center rounded-[3px]" title="Cannot delete - has associated stock batches">
                                        <i class="fas fa-trash text-xs"></i>
                                    </span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        
                        <div class="grid grid-cols-2 gap-4 text-sm mb-3">
                            <div>
                                <span class="text-gray-500 block">Category:</span>
                                <span class="px-2 py-1 text-xs font-medium rounded-full bg-secondary/10 text-secondary">
                                    <i class="fa fa-tag mr-1"></i><?php echo e($item->category->name ?? 'N/A'); ?>

                                </span>
                            </div>
                            <div>
                                <span class="text-gray-500 block">Type:</span>
                                <span class="px-2 py-1 text-xs font-medium rounded-full <?php echo e($item->item_type === 'chemical' ? 'bg-purple-100 text-purple-800' : 'bg-blue-100 text-blue-800'); ?>">
                                    <?php echo e(ucfirst($item->item_type)); ?>

                                </span>
                            </div>
                            <div>
                                <span class="text-gray-500 block">Min Stock:</span>
                                <span class="text-gray-700"><?php echo e($item->min_stock_level ?? 'Not set'); ?></span>
                            </div>
                            <div>
                                <span class="text-gray-500 block">Current Stock:</span>
                                <?php
                                    $currentStock = $item->getCurrentStock();
                                    $isLowStock = $item->isLowStock();
                                    $isOutOfStock = $item->isOutOfStock();
                                ?>
                                <span class="px-2 py-1 text-xs font-medium rounded-full <?php echo e($isOutOfStock ? 'bg-red-100 text-red-800' : ($isLowStock ? 'bg-yellow-100 text-yellow-800' : 'bg-green-100 text-green-800')); ?>">
                                    <?php echo e(number_format($currentStock, 2)); ?>

                                    <!--[if BLOCK]><![endif]--><?php if($isOutOfStock): ?>
                                        <i class="fa fa-times-circle ml-1"></i>
                                    <?php elseif($isLowStock): ?>
                                        <i class="fa fa-exclamation-triangle ml-1"></i>
                                    <?php else: ?>
                                        <i class="fa fa-check-circle ml-1"></i>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </span>
                            </div>
                        </div>

                        <?php if($item->isChemical() && $item->variants->count() > 0): ?>
                            <div class="border-t border-gray-200 pt-3">
                                <span class="text-gray-500 text-sm block mb-2">Variants (<?php echo e($item->variants->count()); ?>):</span>
                                <div class="space-y-2">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $item->variants->take(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="text-xs bg-gradient-to-r from-purple-50 to-purple-100 px-2 py-1 rounded border border-purple-200">
                                            <span class="font-medium text-purple-800 flex items-center">
                                                <i class="fa <?php echo e($variant->isLiquidUnit() ? 'fa-flask' : 'fa-weight-hanging'); ?> mr-1 text-xs"></i>
                                                <?php echo e($variant->display_name); ?>

                                            </span>
                                            <!--[if BLOCK]><![endif]--><?php if($variant->barcode): ?>
                                                <div class="text-purple-600 text-xs mt-1">
                                                    <i class="fa fa-barcode mr-1"></i><?php echo e($variant->barcode); ?>

                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($item->variants->count() > 2): ?>
                                        <div class="text-xs text-gray-500 text-center py-1">
                                            <i class="fa fa-ellipsis-h mr-1"></i>+<?php echo e($item->variants->count() - 2); ?> more variants
                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </div>

            <!-- Pagination -->
            <div class="mt-4">
                <?php echo e($items->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-12 bg-gray-50 rounded-lg border-2 border-dashed border-gray-200">
                <div class="text-gray-400 mb-4">
                    <i class="fas fa-boxes text-5xl"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-600 mb-2">
                    <!--[if BLOCK]><![endif]--><?php if($search): ?>
                        No items found for "<?php echo e($search); ?>"
                    <?php else: ?>
                        No Items Found
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </h3>
                <p class="text-gray-500 max-w-md mx-auto mb-4">
                    <!--[if BLOCK]><![endif]--><?php if($search): ?>
                        Try adjusting your search terms or clear the search to see all items.
                    <?php else: ?>
                        You don't have any inventory items yet. Create your first item to start managing your laboratory inventory.
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </p>
                <!--[if BLOCK]><![endif]--><?php if(!$search): ?>
                    <button wire:click="toggleShowAddNewItemModal"
                            class="bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-md inline-flex items-center transition-colors">
                        <i class="fas fa-plus mr-2"></i> Create New Item
                    </button>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <!-- Add/Edit Item Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showAddNewItemModal): ?>
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-4xl w-full max-h-[90vh] overflow-y-auto">
                <h3 class="text-lg font-semibold mb-4 text-primary"><?php echo e($isEditing ? 'Edit Item' : 'Add New Item'); ?></h3>
                <form wire:submit="saveItem">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Item Name -->
                        <div class="md:col-span-2">
                            <label class="font-semibold text-primary">Item Name <span class="text-danger">*</span></label>
                            <input type="text" wire:model="name" placeholder="Enter item name"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Category -->
                        <div>
                            <label class="font-semibold text-primary">Category <span class="text-danger">*</span></label>
                            <select wire:model="category_id"
                                    class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <option value="">Select Category</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['category_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Item Type -->
                        <div>
                            <label class="font-semibold text-primary">Item Type <span class="text-danger">*</span></label>
                            <select wire:model.live="item_type"
                                    class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <option value="regular">Regular</option>
                                <option value="chemical">Chemical</option>
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['item_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Minimum Stock Level -->
                        <div>
                            <label class="font-semibold text-primary">Minimum Stock Level</label>
                            <input type="number" wire:model="min_stock_level" min="0" placeholder="Enter minimum stock level"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['min_stock_level'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Chemical-specific fields -->
                        <!--[if BLOCK]><![endif]--><?php if($item_type === 'chemical'): ?>
                            <!-- Storage Conditions -->
                            <div>
                                <label class="font-semibold text-primary">Storage Conditions</label>
                                <input type="text" wire:model="storage_conditions" placeholder="Enter storage conditions"
                                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['storage_conditions'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!-- Description -->
                        <div class="md:col-span-2">
                            <label class="font-semibold text-primary">Description</label>
                            <textarea wire:model="description" placeholder="Enter item description (optional)" rows="3"
                                      class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000 resize-none"></textarea>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Hazard Information for chemicals -->
                        <!--[if BLOCK]><![endif]--><?php if($item_type === 'chemical'): ?>
                            <div class="md:col-span-2">
                                <label class="font-semibold text-primary">Hazard Information</label>
                                <textarea wire:model="hazard_information" placeholder="Enter hazard information" rows="3"
                                          class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000 resize-none"></textarea>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['hazard_information'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!-- Variants Section for Chemicals -->
                    <!--[if BLOCK]><![endif]--><?php if($item_type === 'chemical'): ?>
                        <div class="mt-6">
                            <div class="flex justify-between items-center mb-4">
                                <h4 class="text-md font-semibold text-primary">Item Variants</h4>
                                <button type="button" wire:click="addVariant"
                                        class="text-sm bg-success/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/80 text-white hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                                    <i class="fa fa-plus mr-2"></i>Add Variant
                                </button>
                            </div>

                            <!--[if BLOCK]><![endif]--><?php if(count($variants) > 0): ?>
                                <div class="space-y-3">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="border-[2px] border-secondary/40 rounded-md p-3">
                                            <div class="grid grid-cols-1 md:grid-cols-4 gap-3">
                                                <div>
                                                    <label class="font-semibold text-primary">Volume/Amount <span class="text-danger">*</span></label>
                                                    <input type="number" step="0.01" wire:model="variants.<?php echo e($index); ?>.volume_per_unit" placeholder="Enter volume"
                                                           class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ["variants.{$index}.volume_per_unit"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                                <div>
                                                    <label class="font-semibold text-primary">Unit <span class="text-danger">*</span></label>
                                                    <select wire:model="variants.<?php echo e($index); ?>.unit_type"
                                                            class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                        <optgroup label="Liquid Units">
                                                            <option value="ml">Milliliters (ml)</option>
                                                            <option value="L">Liters (L)</option>
                                                        </optgroup>
                                                        <optgroup label="Solid Units">
                                                            <option value="mg">Milligrams (mg)</option>
                                                            <option value="g">Grams (g)</option>
                                                            <option value="kg">Kilograms (kg)</option>
                                                        </optgroup>
                                                    </select>
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ["variants.{$index}.unit_type"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                                <div>
                                                    <label class="font-semibold text-primary">Barcode <span class="text-xs text-gray-500">(Optional)</span></label>
                                                    <div class="relative">
                                                        <input type="text" wire:model="variants.<?php echo e($index); ?>.barcode" placeholder="Scan or enter barcode"
                                                               class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000 pr-8">
                                                        <span class="absolute right-2 top-1/2 -translate-y-1/2 text-gray-400">
                                                            <i class="fa fa-barcode"></i>
                                                        </span>
                                                    </div>
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ["variants.{$index}.barcode"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                                <div class="flex items-end gap-2">
                                                    <button type="button" wire:click="duplicateVariant(<?php echo e($index); ?>)"
                                                            class="text-sm bg-secondary/80 px-3 py-2 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-secondary/80 text-white hover:text-white hover:bg-secondary hover:border-ternary/30 transition ease-in duration-2000"
                                                            title="Duplicate variant">
                                                        <i class="fa fa-copy"></i>
                                                    </button>
                                                    <button type="button" wire:click="removeVariant(<?php echo e($index); ?>)"
                                                            class="text-sm bg-danger/80 px-3 py-2 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/80 text-white hover:text-white hover:bg-danger hover:border-ternary/30 transition ease-in duration-2000"
                                                            title="Remove variant">
                                                        <i class="fa fa-trash"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php else: ?>
                                <p class="text-gray-500 text-sm bg-gray-50 p-4 rounded-lg border-2 border-dashed border-gray-200 text-center">
                                    No variants added yet. Click "Add Variant" to create one.
                                </p>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <div class="flex justify-end space-x-3 mt-6">
                        <button type="button" wire:click="closeAddNewItemModal"
                                class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                            Cancel
                        </button>
                        <button type="submit"
                                class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                            <span wire:loading.remove wire:target="saveItem"><?php echo e($isEditing ? 'Update' : 'Save'); ?></span>
                            <span wire:loading wire:target="saveItem"><?php echo e($isEditing ? 'Updating...' : 'Saving...'); ?> <i class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH /home1/kinkarlab/iitr.kinkarlab.com/resources/views/livewire/inventory/item-list.blade.php ENDPATH**/ ?>