<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Stock Alerts Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            font-size: 10px;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .alert-low-stock {
            color: #dc2626;
            font-weight: bold;
        }
        .alert-expiry {
            color: #f59e0b;
            font-weight: bold;
        }
        .status-resolved {
            color: #059669;
        }
        .status-active {
            color: #dc2626;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1><?php echo e($title); ?></h1>
        <p>Generated on: <?php echo e($generatedAt); ?></p>
        <?php if(isset($dateFrom) && isset($dateTo)): ?>
            <p>Period: <?php echo e($dateFrom); ?> to <?php echo e($dateTo); ?></p>
        <?php endif; ?>
    </div>

    <table>
        <thead>
            <tr>
                <th>Item Name</th>
                <th>Category</th>
                <th>Alert Type</th>
                <th>Message</th>
                <th>Status</th>
                <th>Created</th>
                <th>Resolved By</th>
                <th>Resolved At</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($alert->inventoryItem->name ?? 'N/A'); ?></td>
                    <td><?php echo e($alert->inventoryItem->category->name ?? 'N/A'); ?></td>
                    <td class="alert-<?php echo e(str_replace('_', '-', $alert->alert_type)); ?>">
                        <?php echo e(ucfirst(str_replace('_', ' ', $alert->alert_type))); ?>

                    </td>
                    <td><?php echo e($alert->alert_message); ?></td>
                    <td class="status-<?php echo e($alert->resolved ? 'resolved' : 'active'); ?>">
                        <?php echo e($alert->resolved ? 'Resolved' : 'Active'); ?>

                    </td>
                    <td><?php echo e($alert->created_at->format('Y-m-d H:i')); ?></td>
                    <td><?php echo e($alert->resolved_by ?? 'N/A'); ?></td>
                    <td><?php echo e($alert->resolved_at ? $alert->resolved_at->format('Y-m-d H:i') : 'N/A'); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8" style="text-align: center; color: #666;">No alerts found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="footer">
        <p>Laboratory Inventory Management System - Stock Alerts Report</p>
        <p>Total Alerts: <?php echo e($data->count()); ?></p>
        <p>Active Alerts: <?php echo e($data->where('resolved', false)->count()); ?></p>
        <p>Resolved Alerts: <?php echo e($data->where('resolved', true)->count()); ?></p>
    </div>
</body>
</html><?php /**PATH /home1/kinkarlab/public_html/resources/views/exports/stock-alert-pdf.blade.php ENDPATH**/ ?>