<!DOCTYPE html>
<html>
<head>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        .qr-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10mm;
        }
        .qr-table td {
            width: 20%;
            text-align: center;
            vertical-align: top;
        }
        .qr-code {
            width: 30mm;
            height: 30mm;
            margin: 0 auto;
            display: block;
        }
        .qr-text {
            font-size: 10pt;
            margin-top: 1mm;
        }
        .box-name {
            font-weight: bold;
        }
        .lab-info {
            color: #555;
        }
        .stats {
            color: #007990;
            font-size: 8pt;
        }
        .empty-cell {
            border: none;
        }
    </style>
</head>
<body>
<?php
    $qrCodesPerPage = 30;
    $totalPages = ceil($count / $qrCodesPerPage);
?>

    <div class="page">
        <h2 style="text-align: center;">Storage Box QR Codes</h2>
        <p style="text-align: center;">
            <span class="box-name"><?php echo e($box->box_name); ?></span> - 
            <span class="lab-info"><?php echo e($box->lab->lab_name); ?></span>
        </p>
        <?php for($page = 0; $page < $totalPages; $page++): ?>
        <table class="qr-table">
            <?php
                $start = $page * $qrCodesPerPage;
                $end = min(($page + 1) * $qrCodesPerPage, $count);
                $itemsOnThisPage = $end - $start;
                $rows = ceil($itemsOnThisPage / 5);
            ?>

            <?php for($row = 0; $row < $rows; $row++): ?>
                <tr>
                    <?php for($col = 0; $col < 5; $col++): ?>
                        <?php
                            $index = $start + ($row * 5) + $col;
                        ?>

                        <?php if($index < $end): ?>
                            <td>
                                <img src="<?php echo e($qrCodeData); ?>" class="qr-code" alt="QR Code <?php echo e($index + 1); ?>">
                                <div class="qr-text">
                                    <div class="box-name"><?php echo e($box->box_name); ?></div>
                                    <div class="lab-info"><?php echo e($box->lab->lab_name); ?></div>
                                    <div class="stats"><?php echo e($box->subBoxes->count()); ?> Sub-boxes</div>
                                    <div class="stats"><?php echo e($totalItems); ?> Items | <?php echo e($totalFiles); ?> Files</div>
                                </div>
                            </td>
                        <?php else: ?>
                            <td class="empty-cell"></td>
                        <?php endif; ?>
                    <?php endfor; ?>
                </tr>
            <?php endfor; ?>
        </table>
        <?php endfor; ?>

    </div>
</body>
</html><?php /**PATH /home1/kinkarlab/public_html/resources/views/livewire/inventory/box-qr-code-pdf.blade.php ENDPATH**/ ?>