<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>KINKAR - Lab Instrument Management Software</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&family=Inter:slnt,wght@-10..0,100..900&display=swap" rel="stylesheet">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>



    <!-- Icon Font Stylesheet -->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css"/>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/lib/animate/animate.min.css')); ?>"/>
    <link href="<?php echo e(asset('assets/front/lib/lightbox/css/lightbox.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/front/lib/owlcarousel/assets/owl.carousel.min.css')); ?>" rel="stylesheet">


    <!-- Customized Bootstrap Stylesheet -->
    <link href="<?php echo e(asset('assets/front/css/bootstrap.min.css')); ?>" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="<?php echo e(asset('assets/front/css/style.css')); ?>" rel="stylesheet">


    <link href="https://assets.calendly.com/assets/external/widget.css" rel="stylesheet">
    <script src="https://assets.calendly.com/assets/external/widget.js" type="text/javascript" async></script>
    <script type="text/javascript">window.onload = function() { Calendly.initBadgeWidget({ url: '', text: 'Demo', color: '#0b0b0b', textColor: '#ffffff' }); }</script>
    <!-- Calendly badge widget end -->




    <script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function () {
            document.querySelectorAll('.calendlyDemoBtn').forEach(function (button) {
                button.addEventListener('click', function (e) {
                    e.preventDefault();
                    Calendly.initPopupWidget({
                        url: 'https://calendly.com/md-himsoftsolution/kinkar-lab-demo'
                    });
                });
            });
        });
    </script>


</head>

<body>

<?php if(session('success')): ?>
    <div class="col-12" id="successMessageDiv" style="width: 100%; z-index: 999; position: absolute; right: 10px; top: 10px; display: flex; justify-content: end">
        <div class="alert alert-success" style="width: max-content">
            <?php echo e(session('success')); ?>  <i class="fa fa-plus" style="transform: rotate(45deg); margin-left: 30px; cursor: pointer"
              onclick="document.getElementById('successMessageDiv').style.display='none'"
            ></i>
        </div>
    </div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="col-12"  style="width: 100%; position: absolute; right: 10px; top: 10px; display: flex; justify-content: end">
        <div class="alert alert-danger" style="width: max-content">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>
<?php endif; ?>



<!-- Spinner Start -->





<!-- Spinner End -->

<!-- Topbar Start -->
<div class="container-fluid topbar px-0 px-lg-4 bg-light py-2 d-none d-lg-block">
    <div class="container">
        <div class="row gx-0 align-items-center">
            <div class="col-lg-8 text-center text-lg-start mb-lg-0">
                <div class="d-flex flex-wrap">
                    <div class="ps-3">
                        <a href="mailto:md@himsoftsolution.com" class="text-muted small"><i class="fas fa-envelope text-primary me-2"></i>md@himsoftsolution.com</a>
                    </div>
                    <div class="ps-3">
                        <a href="tel:+91 9988420634" class="text-muted small"><i class="fas fa-phone text-primary me-2"></i>+91 9988420634</a>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 text-center text-lg-end">
                <div class="d-flex justify-content-end">
                    <div class="d-flex border-end border-primary pe-3">
                        <a class="btn p-0 text-primary me-3" target="_blank" href="https://www.facebook.com/himsoftsolution#"><i class="fab fa-facebook-f"></i></a>
                        <a class="btn p-0 text-primary me-0" target="_blank" href="https://www.linkedin.com/company/him-soft-solution/?originalSubdomain=in"><i class="fab fa-linkedin-in"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Topbar End -->

<!-- Navbar & Hero Start -->
<div class="container-fluid nav-bar px-0 px-lg-4 py-lg-0">
    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light">
            <a href="#" class="navbar-brand p-0">

                <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="Logo">
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                <span class="fa fa-bars"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav mx-0 mx-lg-auto">
                    <a href="<?php echo e(route('index')); ?>" class="nav-item nav-link active">Home</a>
                    <a href="#about" class="nav-item nav-link">About</a>
                    <a href="#challenges" class="nav-item nav-link">Challenges</a>
                    <a href="#solution" class="nav-item nav-link">Solution</a>
                    <a href="#features" class="nav-item nav-link">Features</a>
                    <a href="#contact" class="nav-item nav-link">Contact</a>

                    <div class="nav-btn">
                        <a href="<?php echo e(route('publicInstruments')); ?>" class=" btn btn-success rounded-pill py-1 px-3 ms-3 flex-shrink-0">Book Instrument</a>

                        <a href="#contact" class=" btn btn-primary rounded-pill py-1 px-3 ms-3 flex-shrink-0">Get Quote</a>

                    </div>
                </div>
            </div>
            <div class="d-none d-xl-flex flex-shrink-0 ps-4">
                <a href="tel:+ 0123 456 7890" class="btn btn-light btn-lg-square rounded-circle position-relative wow tada" data-wow-delay=".9s">
                    <i class="fa fa-phone-alt fa-2x"></i>
                    <div class="position-absolute" style="top: 7px; right: 12px;">
                        <span><i class="fa fa-comment-dots text-secondary"></i></span>
                    </div>
                </a>
                <div class="d-flex flex-column ms-3">
                    <span style="color: black">Call to Our Experts</span>
                    <a href="tel:+ 0123 456 7890"><span class="text-dark">(+91) 172-4082961</span></a>
                </div>
            </div>
        </nav>
    </div>
</div>
<!-- Navbar & Hero End -->

<!-- Carousel Start -->
<div class="header-carousel owl-carousel">
    <div class="header-carousel-item bg-primary">
        <div class="carousel-caption">
            <div class="container">
                <div class="row g-4 align-items-center">
                    <div class="col-lg-7 animated fadeInLeft">
                        <div class="text-sm-center text-md-start">
                            <h4 class="text-white text-uppercase fw-bold mb-4">Welcome to KINKAR</h4>
                            <h1 class="display-1 text-white mb-4">Lab Instrument Management System</h1>
                            <p class="mb-5 fs-5">Streamlining lab resource scheduling, monitoring, and reporting in one unified platform.</p>
                            <div class="d-flex justify-content-center justify-content-md-start flex-shrink-0 mb-4">
                                <a class="btn btn-light rounded-pill py-3 px-4 px-md-5 me-2" target="_blank" href="<?php echo e(asset('assets/front/pdf/Brochure.pdf')); ?>"><i class="fas fa-download me-2"></i>Brochure</a>

                                <a class="btn btn-dark rounded-pill py-3 px-4 px-md-5 ms-2 calendlyDemoBtn" href="#">Demo</a>


                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 animated fadeInRight">
                        <div class="calrousel-img" style="object-fit: cover;; display: flex; justify-content: center">
                            <img src="<?php echo e(asset('assets/front/img/banner/banner2.png')); ?>" class="img-fluid" style="width: 100%; height: auto" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="header-carousel-item bg-primary">
        <div class="carousel-caption">
            <div class="container">
                <div class="row g-4 align-items-center">
                    <div class="col-lg-5 animated fadeInRight">
                        <div class="calrousel-img" style="object-fit: cover;; display: flex; justify-content: center">
                            <img src="<?php echo e(asset('assets/front/img/banner/banner3.png')); ?>" class="img-fluid" style="width: 100%; height: auto" alt="">
                        </div>
                    </div>
                    <div class="col-lg-7 animated fadeInLeft">
                        <div class="text-sm-center text-md-start">
                            <h4 class="text-white text-uppercase fw-bold mb-4">Welcome to KINKAR</h4>
                            <h1 class="display-1 text-white mb-4">Simplify Scheduling, Maximize Efficiency</h1>
                            <p class="mb-5 fs-5">Say goodbye to manual bookings and underutilized instruments.</p>
                            <div class="d-flex justify-content-center justify-content-md-start flex-shrink-0 mb-4">
                                <a class="btn btn-light rounded-pill py-3 px-4 px-md-5 me-2" target="_blank" href="<?php echo e(asset('assets/front/pdf/Brochure.pdf')); ?>"><i class="fas fa-download me-2"></i>Brochure</a>

                                <a class="btn btn-dark rounded-pill py-3 px-4 px-md-5 ms-2 calendlyDemoBtn" href="#">Demo</a>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="header-carousel-item bg-primary">
        <div class="carousel-caption">
            <div class="container">
                <div class="row g-4 align-items-center">
                    <div class="col-lg-7 animated fadeInLeft">
                        <div class="text-sm-center text-md-start">
                            <h4 class="text-white text-uppercase fw-bold mb-4">Welcome to KINKAR</h4>
                            <h1 class="display-1 text-white mb-4">Designed for Students, PIs & Admins Alike</h1>
                            <p class="mb-5 fs-5">From instrument booking to billing and analytics, KINKAR offers tailored dashboards and access control to ensure the right tools are always at your fingertips.</p>
                            <div class="d-flex justify-content-center justify-content-md-start flex-shrink-0 mb-4">
                                <a class="btn btn-light rounded-pill py-3 px-4 px-md-5 me-2" target="_blank" href="<?php echo e(asset('assets/front/pdf/Brochure.pdf')); ?>"><i class="fas fa-download me-2"></i>Brochure</a>

                                <a class="btn btn-dark rounded-pill py-3 px-4 px-md-5 ms-2 calendlyDemoBtn" href="#">Demo</a>

                            </div>
                        </div>
                    </div>
                    <div class="col-lg-5 animated fadeInRight">
                        <div class="calrousel-img" style="object-fit: cover;; display: flex; justify-content: center">
                            <img src="<?php echo e(asset('assets/front/img/banner/banner4.png')); ?>" class="img-fluid" style="width: 100%; height: auto" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Carousel End -->

<!-- About Start -->
<div class="container-fluid bg-light about py-5" id="about">
    <div class="container">
        <div class="row g-5">
            <div class="col-xl-6 wow fadeInLeft" data-wow-delay="0.2s">
                <div class="about-item-content bg-white rounded p-5 h-100">
                    <h1 class="display-4 mb-4">What is KINKAR?</h1>
                    <p class="text-dark">KINKAR is a web-based lab instrument management system designed to empower academic and research labs with streamlined workflows, transparent bookings, and data-driven resource planning. Built to serve students, principal investigators, and lab admins, KINKAR centralizes every aspect of instrument usage, maintenance, and billing.</p>
                    <p class="text-dark">Unlike generic resource managers, KINKAR is tailored specifically for laboratory environments—where precision, accountability, and timely access to resources are critical. Whether you manage a central instrumentation facility or a departmental lab, KINKAR adapts to your needs with flexible configurations, smart analytics, and seamless user experiences.</p>
                    <p class="text-dark"><i class="fa fa-check text-primary me-3"></i>Streamlined Booking & Scheduling</p>
                    <p class="text-dark"><i class="fa fa-check text-primary me-3"></i>Automated Usage Billing</p>
                    <p class="text-dark mb-4"><i class="fa fa-check text-primary me-3"></i>Improved Instrument Longevity</p>
                    <p class="text-dark mb-4"><i class="fa fa-check text-primary me-3"></i>Data-Driven Decision Making</p>
                    <p class="text-dark mb-4"><i class="fa fa-check text-primary me-3"></i>Transparent Lab Operations</p>
                    <p class="text-dark mb-4"><i class="fa fa-check text-primary me-3"></i>Role-Based Access Control</p>
                </div>
            </div>
            <div class="col-xl-6 wow fadeInRight" data-wow-delay="0.2s">
                <div class="bg-white rounded p-5 h-100">
                    <div class="row g-4 justify-content-center">
                        <div class="col-12">
                            <div class="rounded bg-light">
                                <img src="<?php echo e(asset('assets/front/img/about-1.png')); ?>" class="img-fluid rounded w-100" alt="">
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="counter-item bg-light rounded p-3 h-100">
                                <div class="counter-counting">
                                    <span class="text-primary fs-2 fw-bold" data-toggle="counter-up">95</span>
                                    <span class="h1 fw-bold text-primary">%</span>
                                </div>
                                <h4 class="mb-0 text-dark">Booking Accuracy</h4>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="counter-item bg-light rounded p-3 h-100">
                                <div class="counter-counting">
                                    <span class="text-primary fs-2 fw-bold" data-toggle="counter-up">30</span>
                                    <span class="h1 fw-bold text-primary">%</span>
                                </div>
                                <h4 class="mb-0 text-dark">Admin Time Saved</h4>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="counter-item bg-light rounded p-3 h-100">
                                <div class="counter-counting">
                                    <span class="text-primary fs-2 fw-bold" data-toggle="counter-up">25</span>
                                    <span class="h1 fw-bold text-primary">%</span>
                                </div>
                                <h4 class="mb-0 text-dark">Higher Instrument Utilization</h4>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="counter-item bg-light rounded p-3 h-100">
                                <div class="counter-counting">
                                    <span class="text-primary fs-2 fw-bold" data-toggle="counter-up">100</span>
                                    <span class="h1 fw-bold text-primary">%</span>
                                </div>
                                <h4 class="mb-0 text-dark">Transparency</h4>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- About End -->

<!-- Challenges Start -->
<div class="container-fluid feature py-5" id="challenges">
    <div class="container">
        <div class="text-center mx-auto pb-5 wow fadeInUp" data-wow-delay="0.2s" style="max-width: 800px;">
            <h4 class="text-primary">Challenges</h4>
            <h1 class="display-4 mb-4">Challenges in Managing Lab Instruments Effectively</h1>
            <p class="mb-0 text-dark">Laboratories, especially those in academic and research institutions, face complex challenges when it comes to managing shared scientific instruments. From scheduling conflicts and tracking maintenance to generating reports and billing users accurately, traditional methods fall short—leading to inefficiencies, frustration, and lost productivity.</p>
        </div>
        <div class="row g-4">
            <div class="col-md-6 col-lg-6 col-xl-3 wow fadeInUp" data-wow-delay="0.2s">
                <div class="feature-item p-4 pt-0">
                    <div class="feature-icon p-4 mb-4">
                        <i class="far fa-clock fa-3x"></i>
                    </div>
                    <h4 class="mb-4">Scheduling Conflicts & Overlapping Bookings</h4>
                    <p class="mb-4">Manual or spreadsheet-based systems often lead to double bookings, miscommunication, and disputes between users.</p>
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-3 wow fadeInUp" data-wow-delay="0.4s">
                <div class="feature-item p-4 pt-0">
                    <div class="feature-icon p-4 mb-4">
                        <i class="fa fa-flask fa-3x"></i>
                    </div>
                    <h4 class="mb-4">Underutilized Equipment</h4>
                    <p class="mb-4 ">Without clear visibility into instrument availability, valuable resources remain idle while demand goes unmet.</p>
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-3 wow fadeInUp" data-wow-delay="0.6s">
                <div class="feature-item p-4 pt-0">
                    <div class="feature-icon p-4 mb-4">
                        <i class="fa fa-file fa-3x"></i>
                    </div>
                    <h4 class="mb-4">Manual & Complex Billing</h4>
                    <p class="mb-4">Calculating and allocating usage charges manually is time-consuming, error-prone, and lacks transparency.</p>
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-3 wow  fadeInUp" data-wow-delay="0.8s">
                <div class="feature-item p-4 pt-0 ">
                    <div class="feature-icon p-4 mb-4">
                        <i class="fa fa-hammer fa-3x"></i>
                    </div>
                    <h4 class="mb-4">Lack of Maintenance Visibility</h4>
                    <p class="mb-4">Tracking service history or upcoming maintenance is difficult, risking equipment breakdowns and unsafe usage.</p>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Challenges End -->

<!-- Solution Start -->
<div class="container-fluid service bg-light py-5" id="solution">
    <div class="container">
        <div class="text-center mx-auto pb-5 wow fadeInUp" data-wow-delay="0.2s" style="max-width: 800px;">
            <h4 class="text-primary">Solution</h4>
            <h1 class="display-4 mb-4">How KINKAR Solves the Challenges</h1>
            <p class="mb-0 text-dark">KINKAR is purpose-built to address the unique operational and administrative challenges of laboratory environments. With a combination of smart automation, intuitive interfaces, and deep analytics, it transforms how labs manage instruments, users, and data—resulting in better efficiency, accuracy, and transparency.</p>
        </div>
        <div class="row g-4 justify-content-center">
            <div class="col-md-6 col-lg-6 col-xl-3 wow fadeInUp" data-wow-delay="0.2s">
                <div class="service-item">
                    <div class="service-img">
                        <img src="<?php echo e(asset('assets/front/img/solutions/solution1.png')); ?>" class="img-fluid rounded-top w-100" alt="">
                        <div class="service-icon p-3">
                            <i class="fa fa-calendar-check fa-2x"></i>
                        </div>
                    </div>
                    <div class="service-content p-4">
                        <div class="service-content-inner">
                            <a href="#" class="d-inline-block h4 mb-4"> Real-Time Calendar-Based Booking</a>
                            <p class="mb-4">Our live booking system eliminates scheduling overlaps with an easy-to-use calendar interface that updates availability instantly.</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-3 wow fadeInUp" data-wow-delay="0.4s">
                <div class="service-item">
                    <div class="service-img">
                        <img src="<?php echo e(asset('assets/front/img/solutions/solution2.png')); ?>" class="img-fluid rounded-top w-100" alt="">
                        <div class="service-icon p-3">
                            <i class="fa fa-check fa-2x"></i>
                        </div>
                    </div>
                    <div class="service-content p-4">
                        <div class="service-content-inner">
                            <a href="#" class="d-inline-block h4 mb-4">Transparent Availability & Resource Planning</a>
                            <p class="mb-4">Users can see which instruments are available at a glance, helping maximize equipment usage and reduce idle time.</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-3 wow fadeInUp" data-wow-delay="0.6s">
                <div class="service-item">
                    <div class="service-img">
                        <img src="<?php echo e(asset('assets/front/img/solutions/solution2.png')); ?>" class="img-fluid rounded-top w-100" alt="">
                        <div class="service-icon p-3">
                            <i class="fa fa-hammer fa-2x"></i>
                        </div>
                    </div>
                    <div class="service-content p-4">
                        <div class="service-content-inner">
                            <a href="#" class="d-inline-block h4 mb-4">Centralized Maintenance Tracking</a>
                            <p class="mb-4">All service records, upcoming maintenance schedules, and alerts are managed in one place—ensuring instruments are safe and functional.</p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6 col-lg-6 col-xl-3 wow fadeInUp" data-wow-delay="0.8s">
                <div class="service-item">
                    <div class="service-img">
                        <img src="<?php echo e(asset('assets/front/img/solutions/solution1.png')); ?>" class="img-fluid rounded-top w-100" alt="">
                        <div class="service-icon p-3">
                            <i class="fa fa-tv fa-2x"></i>
                        </div>
                    </div>
                    <div class="service-content p-4">
                        <div class="service-content-inner">
                            <a href="#" class="d-inline-block h4 mb-4">Integrated Analytics Dashboard</a>
                            <p class="mb-4">Lab managers and PIs get powerful visual insights into usage trends, cost breakdowns, and user activity—helping make informed decisions.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Service End -->

<!-- FAQs Start -->
<div class="container-fluid faq-section py-5" id="features">
    <div class="container ">
        <div class="row g-5 align-items-center">
            <div class="col-xl-6 wow fadeInLeft" data-wow-delay="0.2s">
                <div class="h-100">
                    <div class="mb-5">
                        <h4 class="text-primary">Key Features</h4>
                        <h1 class="display-4 mb-0">Powerful Features to Optimize Lab Management</h1>
                    </div>
                    <div class="accordion" id="accordionExample">
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingOne">
                                <button class="accordion-button border-0" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                    Intuitive Calendar-Based Booking System
                                </button>
                            </h2>
                            <div id="collapseOne" class="accordion-collapse collapse show active" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                <div class="accordion-body rounded">
                                    Easily reserve instruments with a real-time calendar interface that shows availability, bookings, and upcoming schedules at a glance.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingTwo">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                    Automated Usage Billing
                                </button>
                            </h2>
                            <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                                <div class="accordion-body text-dark">
                                    Generate accurate charges for instrument use automatically based on booking data—eliminating manual errors and reducing administrative burden.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingThree">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                    Centralized Instrument Catalog
                                </button>
                            </h2>
                            <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                                <div class="accordion-body text-dark">
                                    Access a detailed catalog of lab instruments, including maintenance history, status updates, and usage statistics in one easy-to-navigate interface.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingFour">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                    Real-Time Search & Dynamic Filters
                                </button>
                            </h2>
                            <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour" data-bs-parent="#accordionExample">
                                <div class="accordion-body text-dark">
                                    Search and filter across all instrument data with ease, allowing you to quickly find the information you need and export it in a custom report.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingFive">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                    Comprehensive Maintenance Tracking
                                </button>
                            </h2>
                            <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive" data-bs-parent="#accordionExample">
                                <div class="accordion-body text-dark">
                                    Track all maintenance activities, from routine service checks to unexpected repairs, ensuring that your equipment is always in optimal condition.
                                </div>
                            </div>
                        </div>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingSix">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
                                    Customizable Reports & Data Export
                                </button>
                            </h2>
                            <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix" data-bs-parent="#accordionExample">
                                <div class="accordion-body text-dark">
                                    Generate, customize, and export detailed usage and billing reports in PDF format, helping labs make data-backed decisions and stay compliant.
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-6 wow fadeInRight" data-wow-delay="0.4s">
                <img src="<?php echo e(asset('assets/front/img/banner/banner4.png')); ?>" class="img-fluid w-100" alt="">
            </div>
        </div>
    </div>
</div>
<!-- FAQs End -->


<div class="container-fluid contact bg-light py-5" id="contact">
    <div class="container py-5">
        <div class="text-center mx-auto pb-5 wow fadeInUp" data-wow-delay="0.2s" style="max-width: 800px; visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">
            <h4 class="text-primary">Get in Touch</h4>
            <h1 class="display-4 mb-4"> If you have any comments please share </h1>
        </div>
        <div class="row g-5">
            <div class="col-xl-6 wow fadeInLeft" data-wow-delay="0.2s" style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInLeft;">
                <div class="contact-img d-flex justify-content-center">
                    <div class="contact-img-inner">
                        <img src="<?php echo e(asset('assets/front/img/banner/banner4.png')); ?>" class="img-fluid w-100" alt="Image">
                    </div>
                </div>
            </div>
            <div class="col-xl-6 wow fadeInRight" data-wow-delay="0.4s" style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInRight;">
                <div>
                    <h4 class="text-primary">Send Your Message</h4>
                    <p class="mb-4 text-dark">We’d love to give you a personalized demo or answer your questions.</p>
                    <form action="<?php echo e(route('contact.submit')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="row g-3">
                            <div class="col-lg-12 col-xl-6">
                                <div class="form-floating">
                                    <input type="text" name="name" class="form-control border-0" id="name" placeholder="Your Name" required>
                                    <label for="name">Your Name</label>
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-6">
                                <div class="form-floating">
                                    <input type="email" name="email" class="form-control border-0" id="email" placeholder="Your Email" required>
                                    <label for="email">Your Email</label>
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-6">
                                <div class="form-floating">
                                    <input type="tel" name="phone" class="form-control border-0" id="phone" placeholder="Phone" required>
                                    <label for="phone">Your Phone</label>
                                </div>
                            </div>
                            <div class="col-lg-12 col-xl-6">
                                <div class="form-floating">
                                    <input type="text" name="subject" class="form-control border-0" id="subject" placeholder="Subject" required>
                                    <label for="subject">Subject</label>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-floating">
                                    <textarea class="form-control border-0" placeholder="Leave a message here" id="message" name="message" style="height: 120px" required></textarea>
                                    <label for="message">Message</label>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="g-recaptcha" data-sitekey="<?php echo e(env('RECAPTCHA_SITE_KEY')); ?>"></div>

                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary w-100 py-3">Send Message</button>
                            </div>
                         </div>
                    </form>
                </div>
            </div>
            <div class="col-12">
                <div>
                    <div class="row g-4">
                        <div class="col-md-6 col-lg-3 wow fadeInUp" data-wow-delay="0.2s" style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">
                            <div class="contact-add-item">
                                <div class="contact-icon text-primary mb-4">
                                    <i class="fas fa-map-marker-alt fa-2x"></i>
                                </div>
                                <div>
                                    <h4>Address</h4>
                                    <p class="mb-0">Plot No F-165, Sector 74, Phase 8B Mohali Punjab 160055 India</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-3 wow fadeInUp" data-wow-delay="0.4s" style="visibility: visible; animation-delay: 0.4s; animation-name: fadeInUp;">
                            <div class="contact-add-item">
                                <div class="contact-icon text-primary mb-4">
                                    <i class="fas fa-envelope fa-2x"></i>
                                </div>
                                <div>
                                    <h4>Mail Us</h4>
                                    <p class="mb-0">md@himsoftsolution.com</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-3 wow fadeInUp" data-wow-delay="0.6s" style="visibility: visible; animation-delay: 0.6s; animation-name: fadeInUp;">
                            <div class="contact-add-item">
                                <div class="contact-icon text-primary mb-4">
                                    <i class="fa fa-phone-alt fa-2x"></i>
                                </div>
                                <div>
                                    <h4>Telephone</h4>
                                    <p class="mb-0">(+91) 172-4082961</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-3 wow fadeInUp" data-wow-delay="0.8s" style="visibility: visible; animation-delay: 0.8s; animation-name: fadeInUp;">
                            <div class="contact-add-item">
                                <div class="contact-icon text-primary mb-4">
                                    <i class="fab fa-firefox-browser fa-2x"></i>
                                </div>
                                <div>
                                    <h4>Website</h4>
                                    <p class="mb-0">www.kinkarlab.com</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 wow fadeInUp" data-wow-delay="0.2s" style="visibility: visible; animation-delay: 0.2s; animation-name: fadeInUp;">
                <div class="rounded">
                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d4229.90496295271!2d76.68933827619966!3d30.707800486835986!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x390fecc05f76dcfd%3A0x31b2dfc8aff7c938!2sHim%20Soft%20Solution%20OPC%20Pvt.%20Ltd!5e1!3m2!1sen!2sin!4v1747733964313!5m2!1sen!2sin" width="100%" height="400" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                </div>
            </div>
        </div>
    </div>
</div>


<!-- Copyright Start -->
<div class="container-fluid copyright py-4">
    <div class="container">
        <div class="row g-4 align-items-center">
            <div class="col-md-6 text-center text-md-end mb-md-0">
                <span class=" text-white"><a href="#" class="border-bottom text-white" style="font-weight: bold"><i class="fas fa-copyright text-light me-2"></i>KINKAR</a>, All right reserved.</span>
            </div>
            <div class="col-md-6 text-center text-md-start text-white">
                <!--/*** This template is free as long as you keep the below author’s credit link/attribution link/backlink. ***/-->
                <!--/*** If you'd like to use the template without the below author’s credit link/attribution link/backlink, ***/-->
                <!--/*** you can purchase the Credit Removal License from "https://htmlcodex.com/credit-removal". ***/-->
                Designed By <a class="border-bottom text-white font-bold" style="font-weight: bold" href="https://himsoftsolution.com">Him Soft Solution</a>
            </div>
        </div>
    </div>
</div>
<!-- Copyright End -->


<!-- Back to Top -->
<a href="#" class="btn btn-primary btn-lg-square rounded-circle back-to-top"><i class="fa fa-arrow-up"></i></a>


<!-- JavaScript Libraries -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="<?php echo e(asset('assets/front/lib/wow/wow.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/lib/easing/easing.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/lib/waypoints/waypoints.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/lib/counterup/counterup.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/lib/lightbox/js/lightbox.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/lib/owlcarousel/owl.carousel.min.js')); ?>"></script>


<!-- Template Javascript -->
<script src="<?php echo e(asset('assets/front/js/main.js')); ?>"></script>
</body>

</html>
<?php /**PATH D:\work\kinker\resources\views/index.blade.php ENDPATH**/ ?>