<!DOCTYPE html>
<html>
<head>
    <title>Complaints List</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .status-pending {
            color: orange;
        }
        .status-approved {
            color: green;
        }
        .status-rejected {
            color: red;
        }
    </style>
</head>
<body>
<div class="header">
    <h2>Instrument Complaints List</h2>
    <p>Generated on: <?php echo e(date('Y-m-d H:i:s')); ?></p>
</div>

<table>
    <thead>
    <tr>
        <th>Sr. No.</th>
        <th>Student Name</th>
        <th>Instrument</th>
        <th>Subject</th>
        <th>Description</th>
        <th>Status</th>
        <th>Date</th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $complaints; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $complaint): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($loop->iteration); ?></td>
            <td><?php echo e($complaint->student->first_name); ?> <?php echo e($complaint->student->last_name); ?></td>
            <td><?php echo e($complaint->instrument->name); ?></td>
            <td><?php echo e($complaint->subject); ?></td>
            <td><?php echo e($complaint->description); ?></td>
            <td class="status-<?php echo e($complaint->status); ?>"><?php echo e(ucfirst($complaint->status)); ?></td>
            <td><?php echo e($complaint->created_at->format('Y-m-d H:i:s')); ?></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</body>
</html><?php /**PATH /home1/kinkarlab/public_html/resources/views/exports/complaint-pdf.blade.php ENDPATH**/ ?>