<div
    class=" w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">

    <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('success')); ?>

            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php if(session()->has('error')): ?>
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('error')); ?>

            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between flex-wrap">
        <span class="font-semibold text-primary text-xl">Boxes</span>
        <div class="flex items-center gap-2  justify-end">
            <div class="relative">
                <input type="text" wire:model.live.debounce.1000ms="search" placeholder="Search items & files..."
                       class="px-3 py-1.5 max-w-64 text-sm font-medium bg-white placeholder-gray-500 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                <!--[if BLOCK]><![endif]--><?php if($search): ?>
                    <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-danger">
                        <i class="fa fa-times"></i>
                    </button>
                <?php else: ?>
                    <span class="absolute right-3 top-1/2 -translate-y-1/2 text-success">
                        <i class="fa fa-search"></i>
                    </span>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create storage')): ?>
                <span wire:click="toggleShowAddNewBoxModel"
                      class="text-sm bg-primary/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                <i class="fa fa-plus mr-2"></i>Add Box
            </span>
            <?php endif; ?>
        </div>
    </div>

    <div class="w-full overflow-x-auto p-4">
        <!-- Search Results Table -->
        <!--[if BLOCK]><![endif]--><?php if(!empty($search) && strlen($search) >= 3): ?>
            <div class="mb-6" wire:loading.class="opacity-50">
                <h3 class="text-lg font-semibold text-primary mb-3 flex items-center">
                    <i class="fas fa-search mr-2"></i> Search Results for "<?php echo e($search); ?>"
                    <span class="ml-2 text-sm font-medium bg-primary/10 text-primary px-2 py-0.5 rounded-full"><?php echo e(count($searchResults)); ?></span>
                </h3>

                <!--[if BLOCK]><![endif]--><?php if(count($searchResults) > 0): ?>
                    <div class="overflow-x-auto">
                        <table class="w-full border-[2px] border-secondary/40 border-collapse mt-4">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Sr. No.</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Type</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Item Name</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Info</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">User</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Item Path</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $searchResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="hover:bg-secondary/10 cursor-pointer transition ease-in duration-2000">
                                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap"><?php echo e($index + 1); ?></td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                            <!--[if BLOCK]><![endif]--><?php if($result['type'] === 'item'): ?>
                                                 <span class="px-2 py-1 text-xs font-medium rounded-full bg-success/10 text-success"> <i class="fa fa-box mr-2 text-xs"></i> Item</span>
                                            <?php else: ?>
                                                 <span class="px-2 py-1 text-xs font-medium rounded-full bg-primary/10 text-primary"><i class="fa fa-file mr-2 text-xs"></i> File</span>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap"><i class="fa fa-gift text-primary mr-1 text-xs"></i> <?php echo e($result['name']); ?></td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap max-w-xl overflow-x-auto"><i class="fa fa-tag text-primary mr-1 text-xs"></i><?php echo e($result['info']); ?></td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap"><i class="fa fa-user text-primary mr-1 text-xs"></i><?php echo e($result['user']); ?></td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap"><i class="fa fa-route text-danger mr-1 text-xs"></i><?php echo e($result['path']); ?></td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                            <button wire:click="viewSearchResult('<?php echo e($result['type']); ?>', <?php echo e($result['id']); ?>)"
                                                    class="text-primary hover:text-primary-dark transition-colors">
                                                <i class="fas fa-eye mr-1"></i> View
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="bg-gray-50 p-6 text-center rounded-lg border border-gray-200">
                        <div class="text-gray-400 mb-2">
                            <i class="fas fa-search fa-2x"></i>
                        </div>
                        <p class="text-gray-600">No results found for "<?php echo e($search); ?>"</p>
                        <p class="text-gray-500 text-sm mt-1">Try a different search term or check your spelling</p>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!-- Boxes Grid -->
        <?php if(empty($search) || strlen($search) < 3): ?>
            <!--[if BLOCK]><![endif]--><?php if($boxes->count() > 0): ?>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6" wire:loading.class="opacity-50">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $boxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $box): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div
                        class="bg-white border-2 border-primary/20 rounded-lg shadow-md hover:shadow-lg transition-all duration-300 transform hover:-translate-y-1 relative overflow-hidden">
                        <!-- Box label sticker effect -->
                        <div
                            class="absolute top-2 left-2 bg-primary/90 text-white px-3 py-1 rounded-r-md text-xs font-bold shadow-sm">
                            BOX #<?php echo e($box->id); ?>

                        </div>
                            <button wire:click="generateQrCode(<?php echo e($box->id); ?>)"
                                    class="absolute <?php echo e(!$box->subBoxes->count()>0?'right-20':'right-10'); ?> top-2 text-secondary/80 hover:text-white transition-colors h-6 w-6 flex justify-center items-center rounded-full bg-secondary/20 hover:bg-secondary"
                                    title="Generate QR Code">
                                <i class="fas fa-qrcode text-[11px]"></i>
                            </button>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit storage')): ?>
                            <button wire:click="loadBoxData(<?php echo e($box->id); ?>)"
                                    class="absolute  <?php echo e(!$box->subBoxes->count()>0?'right-10':'right-2'); ?>  top-2 text-primary/80 hover:text-white transition-colors h-6 w-6 flex justify-center items-center rounded-full bg-primary/20 hover:bg-primary"
                                    title="Edit">
                                <i class="fas fa-edit text-[11px]"></i>
                            </button>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete storage')): ?>

                            <!--[if BLOCK]><![endif]--><?php if(!$box->subBoxes->count()>0): ?>
                                <button wire:click="deleteBox(<?php echo e($box->id); ?>)"
                                        wire:confirm="Are you sure you want to delete this box?"
                                        class="absolute right-2 top-2 text-red-600 hover:text-white transition-colors h-6 w-6 flex justify-center items-center rounded-full bg-danger/20 hover:bg-danger"
                                        title="Delete">
                                    <i class="fas fa-trash text-[11px]"></i>
                                </button>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?>

                        <!-- Box tape effect at top -->
                        <div
                            class="absolute top-0 left-1/2 transform -translate-x-1/2 w-16 h-4 bg-yellow-100/80 border border-yellow-200 rounded-sm"></div>

                        <div class="p-5 pt-8">
                            <div class="flex justify-between items-start mb-3">
                                <div>
                                    <h4 class="font-bold text-primary text-lg truncate max-w-[180px]"><?php echo e($box->box_name); ?></h4>
                                </div>

                            </div>

                            <!-- Storage details with icons -->
                            <div class="space-y-2 text-sm mb-4">
                                <!--[if BLOCK]><![endif]--><?php if($box->lab): ?>
                                    <div class="flex items-center gap-2">
                                        <i class="fas fa-flask text-primary"></i>
                                        <span class="truncate"><?php echo e($box->lab->lab_name); ?></span>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <i class="fas fa-user-tie text-primary"></i>
                                        <span
                                            class="truncate text-xs"><?php echo e($box->lab->principalInvestigator ? $box->lab->principalInvestigator->first_name . ' ' . $box->lab->principalInvestigator->last_name : 'No PI'); ?></span>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-layer-group text-primary"></i>
                                    <span>Sub-boxes: <?php echo e($box->sub_boxes_count ?? '0'); ?></span>
                                </div>
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-cube text-primary"></i>
                                    <span>
    Items: <?php echo e($box->subBoxes?->flatMap(fn($subBox) =>
            $subBox->itemsSlots?->flatMap(fn($slot) =>
                $slot->items ?? collect()
            ) ?? collect()
        )?->count() ?? '0'); ?>

</span>

                                </div>
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-file text-primary"></i>
                                    <span>Files: <?php echo e($box->total_files ?? '0'); ?></span>
                                </div>
                                <div class="flex items-center gap-2">
                                    <i class="fas fa-tag text-primary"></i>
                                    <span wire:click="toggleStatus(<?php echo e($box->id); ?>)"
                                          class="px-2 py-0.5 rounded-full text-xs font-bold cursor-pointer  <?php echo e($box->status ? 'bg-success/20 text-success' : 'bg-danger/20 text-danger'); ?>">
                                    <?php echo e($box->status ? 'Active' : 'Inactive'); ?>

                            </span>
                                </div>
                            </div>

                            <!-- Box bottom details (like a shipping label) -->
                            <div class="border-t border-dashed border-gray-200 pt-3">
                                <div class="flex justify-between items-center text-xs text-gray-500">
                                    <div class="text-primary">
                                        <i class="far fa-calendar-alt mr-1 text-danger"></i>
                                        <?php echo e($box->created_at->format('M d, Y')); ?>

                                    </div>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view storage')): ?>
                                        <a href="<?php echo e(route('inventory.sub-boxes',['id'=>$box->id])); ?>"
                                           class="text-primary hover:text-primary-dark text-xs font-medium flex items-center">
                                            View Contents <i class="fas fa-chevron-right ml-1 text-xs"></i>
                                        </a>
                                    <?php endif; ?>

                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            <?php else: ?>
                <div class="text-center py-12 bg-gray-50 rounded-lg border-2 border-dashed border-gray-200">
                    <div class="text-gray-400 mb-4">
                        <i class="fas fa-box-open text-5xl"></i>
                    </div>
                    <h3 class="text-lg font-medium text-gray-600 mb-2">No Storage Boxes Found</h3>
                    <p class="text-gray-500 max-w-md mx-auto mb-4">You don't have any storage boxes yet. Create your first
                        box to start organizing your items.</p>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create storage')): ?>
                        <button wire:click="toggleShowAddNewBoxModel"
                                class="bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-md inline-flex items-center transition-colors">
                            <i class="fas fa-plus mr-2"></i> Create New Box
                        </button>
                    <?php endif; ?>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <!--[if BLOCK]><![endif]--><?php if($showAddNewBoxModel): ?>
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                <h3 class="text-lg font-semibold mb-4 text-primary"><?php echo e($isEditing ? 'Edit Box' : 'Add New Box'); ?></h3>
                <form wire:submit="saveBox">
                    <div class="w-full flex flex-col gap-4">
                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Lab <span class="text-danger">*</span></label>
                            <select wire:model="lab_id"
                                    class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <option value="">Select Lab</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availableLabs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($lab['id']); ?>">
                                        <?php echo e($lab['name']); ?> - <?php echo e($lab['pi_name']); ?> (<?php echo e($lab['building']); ?>,
                                        Room <?php echo e($lab['room']); ?>)
                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['lab_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Box name <span
                                    class="text-danger">*</span></label>
                            <input type="text" wire:model="box_name" placeholder="Enter box name"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['box_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i
                                    class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                    <div class="flex justify-end space-x-3 mt-4">
                        <button type="button" wire:click="closeAddNewBoxModel"
                                class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                            Back
                        </button>
                        <button type="submit"
                                class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                            <span wire:loading.remove wire:target="saveBox"><?php echo e($isEditing ? 'Update' : 'Save'); ?></span>
                            <span wire:loading wire:target="saveBox"><?php echo e($isEditing ? 'Updating...' : 'Saving...'); ?> <i
                                    class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!--[if BLOCK]><![endif]--><?php if($showQrCodeModal): ?>
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 h-screen py-20 overflow-y-auto">
            <div class="bg-white rounded-lg shadow-xl w-full max-w-md">
                <!-- Modal Header -->
                <div class="flex justify-between items-center border-b px-6 py-4">
                    <h3 class="text-lg font-semibold">Storage Box QR Code</h3>
                    <button wire:click="$set('showQrCodeModal', false)" class="text-gray-500 hover:text-gray-700">
                        <i class="fa fa-times"></i>
                    </button>
                </div>

                <!-- Modal Content -->
                <div class="p-6">
                    <div class="flex flex-col items-center">
                        <!--[if BLOCK]><![endif]--><?php if($qrCodeData): ?>
                            <img src="<?php echo e($qrCodeData); ?>" alt="QR Code" class="w-64 h-64">
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <div class="text-center mt-4">
                            <h4 class="font-medium text-gray-900"><?php echo e($selectedBox->box_name ?? ''); ?></h4>
                            <!--[if BLOCK]><![endif]--><?php if($selectedBox && $selectedBox->lab): ?>
                                <p class="text-sm text-gray-600"><?php echo e($selectedBox->lab->lab_name); ?></p>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Printing section -->
                        <div class="mt-6 w-full">
                            <div class="flex items-center justify-center gap-2">
                                <input type="number" wire:model="qrCodeCount" min="1" max="100" placeholder="How many QR codes?"
                                       class="px-2 py-1 w-32 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <button wire:click="printQrCodes(<?php echo e($selectedBox->id ?? 0); ?>)"
                                        class="px-4 py-1 bg-primary text-white rounded hover:bg-primary-dark transition">
                                    Print QR Codes
                                </button>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['qrCodeCount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <p class="text-red-500 text-xs mt-1 text-center"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                </div>

                <!-- Modal Footer -->
                <div class="border-t px-6 py-3 bg-gray-50 flex justify-end">
                    <button wire:click="$set('showQrCodeModal', false)"
                            class="px-4 py-2 bg-danger text-white rounded hover:bg-primary-dark transition">
                        Close
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH /home1/kinkarlab/public_html/resources/views/livewire/inventory/storage.blade.php ENDPATH**/ ?>