<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Items Slot Details</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#001A6E',
                        secondary: '#009990',
                    }
                }
            }
        }
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
          integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
          crossorigin="anonymous" referrerpolicy="no-referrer"/>
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        .info-card {
            transition: all 0.3s ease;
        }
        .info-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body class="bg-gray-50">
<div class="max-w-4xl mx-auto px-2 py-2">
    <?php
        $itemsSlot = App\Models\ItemsSlot::with(['user', 'subBox.box.lab.principalInvestigator', 'items.itemFiles', 'slotFiles'])
                                         ->findOrFail(decode_id(request()->route('hash')));
    ?>

    <!-- Main Card -->
    <div class="bg-white rounded-xl shadow-lg overflow-hidden border-t-4 border-secondary">
        <div class="w-full flex justify-center flex-col items-center ">
            <img src="<?php echo e(asset('assets/images/logo.png')); ?>" alt="" class="h-28">
            <span class="text-center font-semibold text-primary">DEPARTMENT OF BIOSCIENCES AND BIOENGINEERING</span>
        </div>
        
        <!-- Card Header -->
        <div class="bg-gradient-to-r from-secondary to-secondary/90 px-6 py-2 mt-4">
            <h2 class="text-xl font-semibold text-white">
                <i class="fa-solid fa-th-large"></i> <?php echo e($itemsSlot->items_slot_name); ?>

            </h2>
            <p class="text-secondary-200 text-sm text-white/80">
                Items Slot ID: #<?php echo e($itemsSlot->id); ?> • 
                Capacity: <?php echo e($itemsSlot->items_capacity); ?> items
            </p>
        </div>

        <!-- Card Body -->
        <div class="p-2 grid grid-cols-1 gap-8">
            <!-- Basic Information -->
            <div class="space-y-6">
                <div class="info-card bg-gray-50 p-5 rounded-lg border border-gray-200">
                    <h3 class="text-lg font-semibold text-secondary mb-4 pb-2 border-b border-gray-200 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2h-1V9z" clip-rule="evenodd" />
                        </svg>
                        Basic Information
                    </h3>
                    <div class="space-y-3">
                        <?php if($itemsSlot->user): ?>
                            <div class="grid lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-2">
                                <span class="text-black font-semibold text-sm">Assigned User:</span>
                                <span class="font-semibold text-secondary text-md"><?php echo e($itemsSlot->user->name); ?></span>
                            </div>
                        <?php endif; ?>
                        <div class="grid lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-2">
                            <span class="text-black font-semibold text-sm">Storage Location:</span>
                            <span class="font-semibold text-secondary text-md">
                                <?php echo e($itemsSlot->subBox->box->lab->lab_name); ?> → 
                                <?php echo e($itemsSlot->subBox->box->box_name); ?> → 
                                <?php echo e($itemsSlot->subBox->sub_box_name); ?>

                            </span>
                        </div>
                        <div class="grid lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-2">
                            <span class="text-black font-semibold text-sm">Items Capacity:</span>
                            <span class="font-semibold text-secondary text-md"><?php echo e($itemsSlot->items_capacity); ?> items</span>
                        </div>
                        <div class="grid lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-2">
                            <span class="text-black font-semibold text-sm">Available Space:</span>
                            <span class="font-semibold text-secondary text-md"><?php echo e($itemsSlot->available_capacity); ?> items</span>
                        </div>
                        <div class="grid lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-2">
                            <span class="text-black font-semibold text-sm">Status:</span>
                            <span class="font-semibold text-secondary text-md">
                                <span class="inline-block w-3 h-3 rounded-full <?php echo e($itemsSlot->status ? 'bg-green-500' : 'bg-red-500'); ?>"></span>
                                <?php echo e($itemsSlot->status ? 'Active' : 'Inactive'); ?>

                            </span>
                        </div>
                    </div>
                </div>

                <!-- Storage Statistics -->
                <div class="info-card bg-gray-50 p-5 rounded-lg border border-gray-200">
                    <h3 class="text-lg font-semibold text-secondary mb-4 pb-2 border-b border-gray-200 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                            <path d="M9 2a1 1 0 000 2h2a1 1 0 100-2H9z" />
                            <path fill-rule="evenodd" d="M4 5a2 2 0 012-2 3 3 0 003 3h2a3 3 0 003-3 2 2 0 012 2v6a2 2 0 01-2 2H6a2 2 0 01-2-2V5zm3 4a1 1 0 000 2h.01a1 1 0 100-2H7zm3 0a1 1 0 000 2h3a1 1 0 100-2h-3zm-3 4a1 1 0 100 2h.01a1 1 0 100-2H7zm3 0a1 1 0 100 2h3a1 1 0 100-2h-3z" clip-rule="evenodd" />
                        </svg>
                        Content Statistics
                    </h3>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                        <div class="text-center p-3 bg-white rounded-lg border">
                            <div class="text-2xl font-bold text-primary"><?php echo e($itemsSlot->items->count()); ?></div>
                            <div class="text-sm text-gray-600">Items Stored</div>
                        </div>
                        <div class="text-center p-3 bg-white rounded-lg border">
                            <div class="text-2xl font-bold text-secondary"><?php echo e($itemsSlot->slotFiles->count()); ?></div>
                            <div class="text-sm text-gray-600">Slot Files</div>
                        </div>
                        <div class="text-center p-3 bg-white rounded-lg border">
                            <div class="text-2xl font-bold text-green-600"><?php echo e($itemsSlot->items->sum(function($item) { return $item->itemFiles->count(); })); ?></div>
                            <div class="text-sm text-gray-600">Item Files</div>
                        </div>
                        <div class="text-center p-3 bg-white rounded-lg border">
                            <div class="text-2xl font-bold text-blue-600"><?php echo e($itemsSlot->items->count() + $itemsSlot->slotFiles->count() + $itemsSlot->items->sum(function($item) { return $item->itemFiles->count(); })); ?></div>
                            <div class="text-sm text-gray-600">Total Files</div>
                        </div>
                    </div>
                </div>

                <!-- Items Overview -->
                <?php if($itemsSlot->items->count() > 0): ?>
                    <div class="info-card bg-gray-50 p-5 rounded-lg border border-gray-200">
                        <h3 class="text-lg font-semibold text-secondary mb-4 pb-2 border-b border-gray-200 flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                                <path d="M3 4a1 1 0 011-1h12a1 1 0 011 1v2a1 1 0 01-1 1H4a1 1 0 01-1-1V4zM3 10a1 1 0 011-1h6a1 1 0 011 1v6a1 1 0 01-1 1H4a1 1 0 01-1-1v-6zM14 9a1 1 0 00-1 1v6a1 1 0 001 1h2a1 1 0 001-1v-6a1 1 0 00-1-1h-2z" />
                            </svg>
                            Stored Items
                        </h3>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <?php $__currentLoopData = $itemsSlot->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="bg-white p-4 rounded-lg border border-gray-200">
                                    <div class="flex items-start gap-3">
                                        <?php if($item->item_photo): ?>
                                            <img src="<?php echo e(asset('storage/' . $item->item_photo)); ?>" alt="<?php echo e($item->item_name); ?>" class="w-16 h-16 object-cover rounded-lg">
                                        <?php else: ?>
                                            <div class="w-16 h-16 bg-gray-200 rounded-lg flex items-center justify-center">
                                                <i class="fas fa-box text-gray-400"></i>
                                            </div>
                                        <?php endif; ?>
                                        <div class="flex-1">
                                            <h4 class="font-semibold text-gray-800 mb-1"><?php echo e($item->item_name); ?></h4>
                                            <?php if($item->item_info): ?>
                                                <p class="text-sm text-gray-600 mb-2"><?php echo e(Str::limit($item->item_info, 100)); ?></p>
                                            <?php endif; ?>
                                            <div class="text-xs text-gray-500">
                                                <div>Added: <?php echo e($item->created_at->format('M d, Y')); ?></div>
                                                <?php if($item->itemFiles->count() > 0): ?>
                                                    <div>Files: <?php echo e($item->itemFiles->count()); ?></div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Quick Actions -->
                <div class="info-card bg-secondary/5 p-5 rounded-lg border border-secondary/20">
                    <h3 class="text-lg font-semibold text-secondary mb-3">Quick Actions</h3>
                    <div class="flex flex-wrap gap-3">
                        <a href="<?php echo e(route('login')); ?>" class="px-4 py-2 bg-secondary text-white rounded-md hover:bg-secondary/90 transition flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M3 3a1 1 0 000 2v8a2 2 0 002 2h2.586l-1.293 1.293a1 1 0 101.414 1.414L10 15.414l2.293 2.293a1 1 0 001.414-1.414L12.414 15H15a2 2 0 002-2V5a1 1 0 100-2H3zm11.707 4.707a1 1 0 00-1.414-1.414L10 9.586 8.707 8.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd" />
                            </svg>
                            Access Items Slot
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Card Footer -->
        <div class="bg-gray-50 px-6 py-3 border-t border-gray-200 text-sm text-secondary">
            Last updated: <span class="text-primary"><?php echo e(now()->format('M d, Y \a\t h:i A')); ?></span> <br>
            Developed by: <a href="https://himsoftsolution.com" class="font-semibold text-primary">Him Soft Solution</a>
        </div>
    </div>
</div>
</body>
</html><?php /**PATH /home1/kinkarlab/public_html/resources/views/pages/inventory/itemsSlotInfo.blade.php ENDPATH**/ ?>