<?php use \Namu\WireChat\Facades\WireChat; ?>

<div x-data="{ selectedConversationId: '<?php echo e(request()->conversation ?? $selectedConversationId); ?>' }"
    x-on:open-chat.window="selectedConversationId= $event.detail.conversation; $wire.selectedConversationId= $event.detail.conversation;"
    x-init=" setTimeout(() => {
         conversationElement = document.getElementById('conversation-' + selectedConversationId);

         // Scroll to the conversation element
         if (conversationElement) {
             conversationElement.scrollIntoView({ behavior: 'smooth' });
         }
     }, 200);"
    class="flex flex-col bg-primary/20 transition-all h-full overflow-hidden w-full sm:p-3">

    <?php
        /* Show header if any of these conditions are true  */
        $showHeader = $showNewChatModalButton || $allowChatsSearch || $showHomeRouteButton || !empty($title);
    ?>

    
    <?php echo $__env->renderWhen($showHeader, 'wirechat::livewire.chats.partials.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>

    <main x-data
        @scroll.self.debounce="
           
            // Calculate scroll values
            scrollTop = $el.scrollTop;
            scrollHeight = $el.scrollHeight;
            clientHeight = $el.clientHeight;

            // Check if the user is at the bottom of the scrollable element
            if ((scrollTop + clientHeight) >= (scrollHeight - 1) && $wire.canLoadMore) {
                // Trigger load more if we're at the bottom
                await $nextTick();
                $wire.loadMore();
            }
            "
        class=" overflow-y-auto py-2   grow  h-full relative " style="contain:content">

        

        <!--[if BLOCK]><![endif]--><?php if(count($conversations) > 0): ?>
            
            <?php echo $__env->make('wirechat::livewire.chats.partials.list', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>


            
            <?php echo $__env->renderWhen($canLoadMore, 'wirechat::livewire.chats.partials.load-more-button', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
        <?php else: ?>
            <div class="w-full flex items-center h-full justify-center">
                <h6 class=" font-bold text-gray-700"><?php echo e(__('wirechat::chats.labels.no_conversations_yet')); ?></h6>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </main>



</div>
<?php /**PATH /home1/kinkarlab/public_html/resources/views/vendor/wirechat/livewire/chats/chats.blade.php ENDPATH**/ ?>