<!DOCTYPE html>
<html>
<head>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        .qr-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10mm;
        }
        .qr-table td {
            width: 20%;
            text-align: center;
            vertical-align: top;
        }
        .qr-code {
            width: 30mm;
            height: 30mm;
            margin: 0 auto;
            display: block;
        }
        .qr-text {
            font-size: 10pt;
            margin-top: 1mm;
        }
        .instrument-name {
            font-weight: bold;
        }
        .model-number {
            color: #555;
        }
        .empty-cell {
            border: none;
        }
    </style>
</head>
<body>
<?php
    // Calculate total pages based on maximum QR codes that fit per page
    // Each page can fit approximately 15 QR codes (5 columns x 3 rows comfortably)
    $qrCodesPerPage = 30;
    $totalPages = ceil($count / $qrCodesPerPage);
?>

    <div class="page">
        <h2 style="text-align: center;">Instrument QR Codes</h2>
        <p style="text-align: center;">
            <span class="instrument-name"><?php echo e($instrument->name); ?></span> -
            <span class="model-number"><?php echo e($instrument->model_number); ?></span>
        </p>
        <?php for($page = 0; $page < $totalPages; $page++): ?>
        <table class="qr-table">
            <?php
                $start = $page * $qrCodesPerPage;
                $end = min(($page + 1) * $qrCodesPerPage, $count);
                $itemsOnThisPage = $end - $start;
                $rows = ceil($itemsOnThisPage / 5);
            ?>

            <?php for($row = 0; $row < $rows; $row++): ?>
                <tr>
                    <?php for($col = 0; $col < 5; $col++): ?>
                        <?php
                            $index = $start + ($row * 5) + $col;
                        ?>

                        <?php if($index < $end): ?>
                            <td>
                                <img src="<?php echo e($qrCodeData); ?>" class="qr-code" alt="QR Code <?php echo e($index + 1); ?>">
                                <div class="qr-text">
                                    <div class="instrument-name"><?php echo e($instrument->name); ?></div>
                                    <div class="model-number"><?php echo e($instrument->model_number); ?></div>
                                    <div class="serial-number"><?php echo e($instrument->serial_number); ?></div>
                                </div>
                            </td>
                        <?php else: ?>
                            <td class="empty-cell"></td>
                        <?php endif; ?>
                    <?php endfor; ?>
                </tr>
            <?php endfor; ?>
        </table>
        <?php endfor; ?>

    </div>
</body>
</html><?php /**PATH /home1/kinkarlab/public_html/resources/views/livewire/instruments/qr-code-pdf.blade.php ENDPATH**/ ?>