<div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">

    <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('success')); ?>

            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php if(session()->has('error')): ?>
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('error')); ?>

            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php if(session()->has('info')): ?>
        <div id="infoMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-info bg-blue-100 border-l-4 border-blue-500 text-blue-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('info')); ?>

            <div onclick="document.getElementById('infoMessage').classList.add('hidden')"
                 class="cursor-pointer bg-blue-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between flex-wrap">
        <span class="font-semibold text-primary text-xl">Stock Alerts</span>
        <div class="flex items-center gap-2 justify-end">
            <div class="relative">
                <input type="text" wire:model.live.debounce.500ms="search" placeholder="Search alerts..."
                       class="px-3 py-1.5 max-w-64 text-sm font-medium bg-white placeholder-gray-500 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                <!--[if BLOCK]><![endif]--><?php if($search): ?>
                    <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-danger">
                        <i class="fa fa-times"></i>
                    </button>
                <?php else: ?>
                    <span class="absolute right-3 top-1/2 -translate-y-1/2 text-success">
                        <i class="fa fa-search"></i>
                    </span>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>

            <select wire:model.live="alertTypeFilter"
                    class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                <option value="">All Types</option>
                <option value="low_stock">Low Stock</option>
                <option value="expiry">Expiry</option>
            </select>

            <select wire:model.live="statusFilter"
                    class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                <option value="">All Status</option>
                <option value="unresolved">Unresolved</option>
                <option value="resolved">Resolved</option>
            </select>

            <select wire:model.live="itemFilter"
                    class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                <option value="">All Items</option>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $inventoryItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </select>

            <button wire:click="exportAlerts"
                    class="text-sm bg-success/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/80 text-white hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                <i class="fa fa-file-excel mr-2"></i>Excel
            </button>
            
            <button wire:click="exportAlertsPdf"
                    class="text-sm bg-danger/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/80 text-white hover:text-white hover:bg-danger hover:border-ternary/30 transition ease-in duration-2000">
                <i class="fa fa-file-pdf mr-2"></i>PDF
            </button>

            <span wire:click="generateAlerts"
                  class="text-sm bg-secondary/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-secondary/80 text-white hover:text-white hover:bg-secondary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                <i class="fa fa-refresh mr-2"></i>Refresh Alerts
            </span>
        </div>
    </div>

    <!-- Alert Statistics -->
    <div class="px-4 py-2 bg-gray-50 border-b border-gray-200">
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <div class="text-center">
                <div class="text-2xl font-bold text-gray-700"><?php echo e($alertStats['total']); ?></div>
                <div class="text-sm text-gray-500">Total Alerts</div>
            </div>
            <div class="text-center">
                <div class="text-2xl font-bold text-red-600"><?php echo e($alertStats['unresolved']); ?></div>
                <div class="text-sm text-gray-500">Unresolved</div>
            </div>
            <div class="text-center">
                <div class="text-2xl font-bold text-yellow-600"><?php echo e($alertStats['low_stock']); ?></div>
                <div class="text-sm text-gray-500">Low Stock</div>
            </div>
            <div class="text-center">
                <div class="text-2xl font-bold text-orange-600"><?php echo e($alertStats['expiry']); ?></div>
                <div class="text-sm text-gray-500">Expiry</div>
            </div>
        </div>
    </div>

    <div class="w-full overflow-x-auto p-4">
        <!--[if BLOCK]><![endif]--><?php if($alerts->count() > 0): ?>
            <div class="overflow-x-auto">
                <table class="w-full border-[2px] border-secondary/40 border-collapse">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Sr. No.</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Alert Type</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Item</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Message</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Batch Info</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Created</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Status</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $alerts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $alert): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-secondary/10 transition ease-in duration-2000 <?php echo e($alert->resolved ? 'opacity-60' : ''); ?>">
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <?php echo e(($alerts->currentPage() - 1) * $alerts->perPage() + $index + 1); ?>

                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <span class="px-2 py-1 text-xs font-medium rounded-full
                                        <?php echo e($alert->alert_type === 'low_stock' ? 'bg-yellow-100 text-yellow-800' : 'bg-orange-100 text-orange-800'); ?>">
                                        <i class="fa <?php echo e($alert->alert_type === 'low_stock' ? 'fa-exclamation-triangle' : 'fa-clock'); ?> mr-1"></i>
                                        <?php echo e($alert->alert_type_display); ?>

                                    </span>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <div class="flex items-start">
                                        <i class="fa <?php echo e($alert->inventoryItem->item_type === 'chemical' ? 'fa-flask' : 'fa-box'); ?> text-primary mr-2 text-xs mt-1"></i>
                                        <div>
                                            <div class="font-semibold"><?php echo e($alert->inventoryItem->name); ?></div>
                                            <span class="px-2 py-1 text-xs font-medium rounded-full
                                                <?php echo e($alert->inventoryItem->item_type === 'chemical' ? 'bg-purple-100 text-purple-800' : 'bg-blue-100 text-blue-800'); ?>">
                                                <?php echo e(ucfirst($alert->inventoryItem->item_type)); ?>

                                            </span>
                                        </div>
                                    </div>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <div class="max-w-xs">
                                        <?php echo e($alert->alert_message); ?>

                                    </div>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <!--[if BLOCK]><![endif]--><?php if($alert->batch): ?>
                                        <div class="space-y-1">
                                            <div class="flex items-center">
                                                <i class="fa fa-barcode text-primary mr-2"></i>
                                                <span class="font-semibold"><?php echo e($alert->batch->batch_number); ?></span>
                                            </div>
                                            <!--[if BLOCK]><![endif]--><?php if($alert->batch->expiry_date): ?>
                                                <div class="text-xs text-gray-500">
                                                    Expires: <?php echo e($alert->batch->expiry_date->format('M d, Y')); ?>

                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <!--[if BLOCK]><![endif]--><?php if($alert->batch->supplier): ?>
                                                <div class="text-xs text-gray-500">
                                                    Supplier: <?php echo e($alert->batch->supplier->name); ?>

                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    <?php else: ?>
                                        <span class="text-gray-400 text-xs">N/A</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <div class="text-sm"><?php echo e($alert->created_at->format('M d, Y')); ?></div>
                                    <div class="text-xs text-gray-500"><?php echo e($alert->created_at->format('H:i')); ?></div>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <!--[if BLOCK]><![endif]--><?php if($alert->resolved): ?>
                                        <div class="space-y-1">
                                            <span class="px-2 py-1 text-xs font-medium rounded-full bg-green-100 text-green-800">
                                                <i class="fa fa-check mr-1"></i>Resolved
                                            </span>
                                            <!--[if BLOCK]><![endif]--><?php if($alert->resolved_by): ?>
                                                <div class="text-xs text-gray-500">By: <?php echo e($alert->resolved_by); ?></div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <!--[if BLOCK]><![endif]--><?php if($alert->resolved_at): ?>
                                                <div class="text-xs text-gray-500"><?php echo e($alert->resolved_at->format('M d, Y')); ?></div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    <?php else: ?>
                                        <span class="px-2 py-1 text-xs font-medium rounded-full bg-red-100 text-red-800">
                                            <i class="fa fa-exclamation-circle mr-1"></i>Unresolved
                                        </span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <div class="flex items-center gap-2">
                                        <!--[if BLOCK]><![endif]--><?php if(!$alert->resolved): ?>
                                            <button wire:click="openResolveModal(<?php echo e($alert->id); ?>)"
                                                    class="text-green-600 hover:text-green-800 transition-colors"
                                                    title="Resolve Alert">
                                                <i class="fas fa-check-circle"></i>
                                            </button>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-4">
                <?php echo e($alerts->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-12 bg-gray-50 rounded-lg border-2 border-dashed border-gray-200">
                <div class="text-gray-400 mb-4">
                    <i class="fas fa-bell-slash text-5xl"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-600 mb-2">
                    <!--[if BLOCK]><![endif]--><?php if($search): ?>
                        No alerts found for "<?php echo e($search); ?>"
                    <?php else: ?>
                        No Alerts Found
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </h3>
                <p class="text-gray-500 max-w-md mx-auto mb-4">
                    <!--[if BLOCK]><![endif]--><?php if($search): ?>
                        Try adjusting your search terms or clear the search to see all alerts.
                    <?php else: ?>
                        Great! You don't have any alerts at the moment. The system will automatically generate alerts for low stock and expiring items.
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </p>
                <!--[if BLOCK]><![endif]--><?php if(!$search): ?>
                    <button wire:click="generateAlerts"
                            class="bg-secondary hover:bg-secondary-dark text-white px-4 py-2 rounded-md inline-flex items-center transition-colors">
                        <i class="fas fa-refresh mr-2"></i> Check for Alerts
                    </button>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <!-- Resolve Alert Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showResolveModal && $selectedAlert): ?>
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                <h3 class="text-lg font-semibold mb-4 text-primary">Resolve Alert</h3>
                
                <div class="mb-4">
                    <div class="bg-gray-50 p-3 rounded-lg">
                        <div class="font-medium text-sm text-gray-700 mb-2">Alert Details:</div>
                        <div class="text-sm text-gray-600"><?php echo e($selectedAlert->alert_message); ?></div>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="font-semibold text-primary">Resolution Notes (Optional)</label>
                    <textarea wire:model="resolveNotes" rows="3" placeholder="Add any notes about how this alert was resolved..."
                              class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-gray-500 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"></textarea>
                </div>

                <div class="flex justify-end gap-2">
                    <button wire:click="closeResolveModal"
                            class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-200 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] hover:bg-gray-300 transition-colors">
                        Cancel
                    </button>
                    <button wire:click="resolveAlert"
                            class="px-4 py-2 text-sm font-medium text-white bg-green-600 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] hover:bg-green-700 transition-colors">
                        <i class="fa fa-check mr-2"></i>Resolve Alert
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH /home1/kinkarlab/iitr.kinkarlab.com/resources/views/livewire/inventory/alert-management.blade.php ENDPATH**/ ?>