<div>
    <form wire:submit.prevent="submit" wire:loading.class="opacity-50">
        <div class="w-full grid lg:grid-cols-4 gap-2 p-4">
            <div class="w-full lg:col-span-4 bg-primary/10 px-4 py-2 font-semibold text-primary mb-4">
                Basic Information
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Instrument Category <span class="text-danger">*</span></label>
                <select wire:model="instrument_category" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">--- select category ---</option>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $instrumentCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category->id); ?>"><?php echo e($category->title); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['instrument_category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"> <i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Lab <span class="text-danger">*</span></label>
                <select wire:model="lab" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">--- select lab ---</option>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $labs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($lab->id); ?>"><?php echo e($lab->lab_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['lab'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"> <i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Lab In-Charge</label>
                <select wire:model="technician" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">--- select lab in-charge ---</option>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $technicians; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $person): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($person->id); ?>"><?php echo e($person->getFullNameAttribute()); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['lab'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"> <i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Name <span class="text-danger">*</span></label>
                <input type="text" wire:model="name"  placeholder="Instrument name"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Model Number </label>
                <input type="text" wire:model="model_number"  placeholder="Model number"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['model_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Serial Number</label>
                <input type="text" wire:model="serial_number"  placeholder="Serial number"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['serial_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Description</label>
                <textarea wire:model="description" name="description" rows="1" placeholder="Enter category description"
                          class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"></textarea>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>

            <div class="w-full lg:col-span-4 bg-primary/10 px-4 py-2 font-semibold text-primary mt-4 mb-4">
                Booking Information
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Operating Status </label>
                <select wire:model="operating_status" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                        <option value="working">Working</option>
                        <option value="under_maintenance">Under Maintenance</option>
                        <option value="calibration_required">Calibration Required</option>
                        <option value="faulty">Faulty</option>
                        <option value="retired">Retired/ Obsolete</option>
                </select>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['operating_status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"> <i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Booking Type <span class="text-danger">*</span></label>
                <select wire:model.live="booking_type" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">-- select booking type --</option>
                    <option value="slot">Slot Based</option>
                    <option value="sample">Sample Based</option>
                    <option value="both">Both</option>
                </select>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['booking_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>

            <!--[if BLOCK]><![endif]--><?php if($booking_type == 'sample' || $booking_type == 'both'): ?>
            <div class="w-full lg:col-span-4">
                <div class="font-semibold text-primary mb-2">Sample Based Pricing</div>
                <div class="grid grid-cols-2 md:grid-cols-5 gap-4">
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Internal (₹/sample)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.internal.sample" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.internal.sample_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Educational Institute (₹/sample)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.other_educational_institute.sample" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.other_educational_institute.sample_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">R&D Labs (₹/sample)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.r_and_d_labs.sample" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.r_and_d_labs.sample_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Industries (₹/sample)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.industries.sample" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.industries.sample_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Startups (₹/sample)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.startups.sample" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.startups.sample_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <!--[if BLOCK]><![endif]--><?php if($booking_type == 'slot' || $booking_type == 'both'): ?>
            <div class="w-full lg:col-span-4">
                <div class="flex items-center gap-4 mb-2">
                    <div class="font-semibold text-primary"><?php echo e(ucfirst($slot_pricing_type)); ?> Based Pricing</div>
                    <select wire:model.live="slot_pricing_type" class="px-2 py-1 text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary">
                        <option value="slot">Per Slot</option>
                        <option value="booking">Per Booking</option>
                    </select>
                </div>
                <div class="grid grid-cols-2 md:grid-cols-5 gap-4">
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Internal (₹/<?php echo e($slot_pricing_type); ?>)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.internal.<?php echo e($slot_pricing_type); ?>" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.internal.<?php echo e($slot_pricing_type); ?>_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Educational Institute (₹/<?php echo e($slot_pricing_type); ?>)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.other_educational_institute.<?php echo e($slot_pricing_type); ?>" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.other_educational_institute.<?php echo e($slot_pricing_type); ?>_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">R&D Labs (₹/<?php echo e($slot_pricing_type); ?>)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.r_and_d_labs.<?php echo e($slot_pricing_type); ?>" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.r_and_d_labs.<?php echo e($slot_pricing_type); ?>_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Industries (₹/<?php echo e($slot_pricing_type); ?>)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.industries.<?php echo e($slot_pricing_type); ?>" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.industries.<?php echo e($slot_pricing_type); ?>_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                    <div class="flex flex-col gap-1">
                        <label class="text-sm">Startups (₹/<?php echo e($slot_pricing_type); ?>)</label>
                        <div class="flex gap-2">
                            <input type="number" wire:model="booking_cost.startups.<?php echo e($slot_pricing_type); ?>" placeholder="0" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                            <input type="number" wire:model="booking_cost.startups.<?php echo e($slot_pricing_type); ?>_gst" placeholder="GST %" class="px-2 py-2 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary"/>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->





            <div class="w-full lg:col-span-4 bg-primary/10 px-4 py-2 font-semibold text-primary mt-4 mb-4">
                Purchase Information
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Manufacturer Name</label>
                <input type="text" wire:model="manufacturer_name"  placeholder="Name"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['manufacturer_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Manufacturing Date</label>
                <input type="date" wire:model="manufacturing_date"  placeholder="Name"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['manufacturing_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Purchase Date </label>
                <input type="date" wire:model="purchase_date"  placeholder="Name"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['purchase_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Purchase Order Number</label>
                <input type="text" wire:model="purchase_order_number"  placeholder="Purchase order number"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['purchase_order_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Cost (₹) </label>
                <input type="number" wire:model="cost"  placeholder="Cost"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['cost'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Funding Source </label>
                <input type="text" wire:model="funding_source"  placeholder="Funding Source"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['funding_source'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Installation Date </label>
                <input type="date" wire:model="installation_date"  placeholder="Funding Source"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['installation_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full lg:col-span-4 bg-primary/10 px-4 py-2 font-semibold text-primary mt-4 mb-4">
                Service Engineer Information
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Engineer Name  <span class="text-danger">*</span></label>
                <input type="text" wire:model="engineer_name"  placeholder="Name"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['engineer_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Email  <span class="text-danger">*</span></label>
                <input type="email" wire:model="engineer_email"  placeholder="Email"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['engineer_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Mobile Number  <span class="text-danger">*</span></label>
                <input type="number" wire:model="engineer_mobile"  placeholder="Mobile Number" oninput="if(this.value.length > 15) this.value=this.value.slice(0,15)"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['engineer_mobile'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary"> Address <span class="text-danger">*</span></label>
                <textarea wire:model="engineer_address" rows="2" placeholder="Address" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"></textarea>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['engineer_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>



            <div class="w-full lg:col-span-4 bg-primary/10 px-4 py-2 font-semibold text-primary mt-4 mb-4">
                Photos and Documents
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Instrument Photos<span class="text-danger">*</span></label>
                <span class="text-danger text-xs">*Max size: 2MB</span>
                <input type="file" wire:model="photos"  placeholder="" multiple accept="image/png, image/jpeg, image/jpg"
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <div wire:loading wire:target="photos" class="text-sm text-danger"><i class="fas fa-hourglass-half fa-spin mr-2"></i> Uploading file... Please wait</div>

                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['photos'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Operational Manual (pdf)</label>
                <span class="text-danger text-xs">*Max size: 2MB</span>
                <input type="file" wire:model="operational_manual"  placeholder=""
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <div wire:loading wire:target="operational_manual" class="text-sm text-danger"><i class="fas fa-hourglass-half fa-spin mr-2"></i> Uploading file... Please wait</div>

                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['operational_manual'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Service Manual (pdf)</label>
                <span class="text-danger text-xs">*Max size: 2MB</span>
                <input type="file" wire:model="service_manual"  placeholder=""
                       class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <div wire:loading wire:target="service_manual" class="text-sm text-danger"><i class="fas fa-hourglass-half fa-spin mr-2"></i> Uploading file... Please wait</div>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['service_manual'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <div class="w-full flex flex-col gap-1">
                <label class="font-semibold text-primary">Video Link (url)</label>
                <span class="text-danger text-xs">&nbsp</span>
                <input type="text" wire:model="video_link"  placeholder="https://www.instrumentvideo.com"
                       class="px-2 py-2.5 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['video_link'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
            </div>


        </div>
        <div class="w-full flex justify-end px-4 pb-4 gap-2">
            <button type="submit"
                    class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                <span wire:loading.remove wire:target="submit">
                    <i class="fa fa-<?php echo e($isEditing ? 'check' : 'plus'); ?> mr-2"></i>
                    <?php echo e($isEditing ? 'Update Instrument' : 'Create Instrument'); ?>

                </span>
                <span wire:loading wire:target="submit">
                    <?php echo e($isEditing ? 'Updating Instrument...' : 'Creating Instrument...'); ?> <i class="fas fa-hourglass-half fa-spin ml-2"></i>
                </span>
            </button>
        </div>
    </form>
</div><?php /**PATH /home1/kinkarlab/iitr.kinkarlab.com/resources/views/livewire/instruments/instrument-form.blade.php ENDPATH**/ ?>