<div>

    <div class="w-full grid xl:grid-cols-5 lg:grid-cols-3 md:grid-cols-4 sm:grid-cols-2 grid-cols-1 gap-2">
        <a href="<?php echo e(route('lab.list')); ?>">
            <div class="w-full border-[1px] border-t-[4px] border-ternary/20 border-t-primary bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Labs</span>
                    <span class="font-bold text-2xl text-primary"><?php echo e($totalLabs); ?></span>
                </div>
                <div>
                    <i class="fa-solid fa-flask text-4xl text-primary"></i>
                </div>
            </div>
        </a>

        <!-- Total PIs -->
        <a href="<?php echo e(route('pi.list')); ?>">
            <div class="w-full border-[1px] border-t-[4px] border-warning/20 border-t-warning bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Principal Investigators</span>
                    <span class="font-bold text-2xl text-warning"><?php echo e($totalPis); ?></span>
                </div>
                <div>
                    <i class="fa fa-user-tie text-4xl text-warning"></i>
                </div>
            </div>
        </a>

        <!-- Total Students -->
        <a href="<?php echo e(route('student.list')); ?>">
            <div class="w-full border-[1px] border-t-[4px] border-success/20 border-t-success bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Students</span>
                    <span class="font-bold text-2xl text-success"><?php echo e($totalStudents); ?></span>
                </div>
                <div>
                    <i class="fa fa-user-graduate text-4xl text-success"></i>
                </div>
            </div>
        </a>

        <!-- Total Categories -->
        <a href="<?php echo e(route('instrument.instrument-category')); ?>">
            <div class="w-full border-[1px] border-t-[4px] border-danger/20 border-t-danger bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Instrument Categories</span>
                    <span class="font-bold text-2xl text-danger"><?php echo e($instrumentCategories); ?></span>
                </div>
                <div>
                    <i class="fa fa-list text-4xl text-danger"></i>
                </div>
            </div>
        </a>
        <!-- Total Instruments -->
        <a href="<?php echo e(route('instrument.instrument')); ?>">
            <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Instruments</span>
                    <span class="font-bold text-2xl text-primary"><?php echo e($totalInstruments); ?></span>
                </div>
                <div>
                    <i class="fa fa-microscope text-4xl text-primary"></i>
                </div>
            </div>
        </a>

        <a href="<?php echo e(route('instrument.instrument')); ?>">
            <!-- Instruments Not Working -->
            <div class="w-full border-[1px] border-t-[4px] border-warning/20 border-t-warning bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Instruments Down</span>
                    <span class="font-bold text-2xl text-warning"><?php echo e($instrumentUnderMaintenance); ?></span>
                </div>
                <div>
                    <i class="fa fa-battery-quarter text-4xl text-warning"></i>
                </div>
            </div>
        </a>

        <!-- Pending Services -->
        <a href="<?php echo e(route('instrument.service')); ?>">
            <div class="w-full border-[1px] border-t-[4px] border-success/20 border-t-success bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Under Services</span>
                    <span class="font-bold text-2xl text-success"><?php echo e($underService); ?></span>
                </div>
                <div>
                    <i class="fa fa-wrench text-4xl text-success"></i>
                </div>
            </div>
        </a>
        <!-- Pending Approvals -->
        <a href="<?php echo e(route('instrument.complaints')); ?>">
            <div class="w-full border-[1px] border-t-[4px] border-danger/20 border-t-danger bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Complaints</span>
                    <span class="font-bold text-2xl text-danger"><?php echo e($totalComplaints); ?></span>
                </div>
                <div>
                    <i class="fa fa-exclamation-triangle text-4xl text-danger"></i>
                </div>
            </div>
        </a>
        <!-- Active Bookings -->
        <a href="<?php echo e(route('bookings.create')); ?>">
            <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Active Bookings</span>
                    <span class="font-bold text-2xl text-primary"> <?php echo e($activeBookings); ?> </span>
                </div>
                <div>
                    <i class="fa fa-calendar-check text-4xl text-primary"></i>
                </div>
            </div>
        </a>


        <!-- Monthly Collection -->
        <div class="w-full border-[1px] border-t-[4px] border-success/20 border-t-success bg-white flex gap-2 items-center justify-between p-4">
            <div class="flex flex-col gap-2">
                <span class="font-semibold text-black text-md">Collection <span class="text-xs">(This Month)</span></span>
                <span class="font-bold text-2xl text-success">₹<?php echo e($thisMonthCollection); ?></span>
            </div>
            <div>
                <i class="fa fa-money-bill-trend-up text-4xl text-success"></i>
            </div>
        </div>


    </div>
    <div class="w-full grid lg:grid-cols-2 md:grid-cols-2 grid-cols-1 mt-6 gap-4">
        <div class="w-full  border-[1px] border-t-[4px] border-ternary/20 border-t-primary bg-white flex gap-2 flex-col">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between items-center">
                <span class="font-semibold text-ternary text-lg">Monthly Booking Calendar</span>
                <span class="font-medium text-primary"><?php echo e($currentMonthName); ?></span>
            </div>

            <div class="w-full p-4">
                <!-- Calendar Header (Day names) -->
                <div class="grid grid-cols-7 gap-1 mb-2">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="text-center text-sm font-medium text-ternary/70 py-1">
                            <?php echo e($day); ?>

                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <!-- Calendar Grid -->
                <div class="grid grid-cols-7 gap-1">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $calendarData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $week): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $week; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <!--[if BLOCK]><![endif]--><?php if($day === null): ?>
                                <!-- Empty cell -->
                                <div class="aspect-square bg-gray-50 rounded"></div>
                            <?php else: ?>
                                <!-- Day cell with booking indicators -->
                                <div class="aspect-square border border-gray-200 h-full <?php if(Carbon\Carbon::parse($day['date'])->isToday()): ?> bg-gray-300 <?php endif; ?> rounded p-1 flex flex-col justify-between">
                                    <div class="text-right h-maxi lg:text-sm md:text-sm  text-xs <?php if(Carbon\Carbon::parse($day['date'])->isToday()): ?> font-bold text-primary <?php endif; ?>">
                                        <?php echo e($day['day']); ?>

                                    </div>
                                    <div class="flex-grow flex h-max items-center justify-center gap-1 text-left">
                                        <!--[if BLOCK]><![endif]--><?php if($day['confirmed'] > 0): ?>
                                            <span class="font-semibold lg:text-sm md:text-sm  text-xs text-green-700"><?php echo e($day['confirmed']); ?> <?php echo e($day['cancelled'] > 0?'/':''); ?> </span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <!--[if BLOCK]><![endif]--><?php if($day['cancelled'] > 0): ?>
                                            <span class="font-semibold lg:text-sm md:text-sm  text-xs text-red-700"><?php echo e($day['cancelled']); ?></span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        </div>
        <div class="w-full border-[1px] border-t-[4px] border-ternary/20 border-t-warning bg-white flex gap-2 flex-col">
            <div class="bg-warning/10 px-4 py-2 border-b-[2px] border-b-warning/20">
                <span class="font-semibold text-warning text-lg">Top Students </span>
            </div>

            <div class="w-full overflow-x-auto p-4">
                <div id="topStudentWithMostBookings"></div>
            </div>
        </div>
        <div class="w-full border-[1px] border-t-[4px] border-ternary/20 border-t-primary bg-white flex gap-2 flex-col ">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
                <span class="font-semibold text-primary text-lg">Top Booked Instruments</span>
            </div>
            <div class="w-full overflow-x-auto p-4">
                <div id="topInstrumentsBooked"></div>
            </div>
        </div>
        <div class="w-full border-[1px] border-t-[4px] border-ternary/20 border-t-success bg-white flex gap-2 flex-col ">
            <div class="bg-success/10 px-4 py-2 border-b-[2px] border-b-success/20">
                <span class="font-semibold text-success text-lg">Most Serviced Instruments</span>
            </div>

            <div class="w-full overflow-x-auto p-4">
                <div id="mostServicedInstruments"></div>
            </div>
        </div>

    </div>
    <script>

        // Top Booked Instruments Chart initialization function
        function initTopBookedInstrumentsChart() {
            // Check if element exists and data is available
            if (!document.querySelector("#topInstrumentsBooked")) {
                console.error("Element #topInstrumentsBooked not found");
                return;
            }

            const seriesData = <?php echo json_encode(array_column($topBookedInstruments, 'count'), 512) ?>;
            const labelsData = <?php echo json_encode(array_column($topBookedInstruments, 'name'), 512) ?>;

            if (seriesData.length === 0) {
                console.warn("No data available for top booked instruments");
                return;
            }

            const topInstrumentsOptions = {
                series: seriesData,
                chart: {
                    type: 'pie',
                    height: 250
                },
                labels: labelsData,
                colors: ['#001A6E', '#22C55E', '#DC2626'],
                legend: {
                    position: 'bottom'
                },
                tooltip: {
                    y: {
                        formatter: function(value) {
                            return value + ' bookings'
                        }
                    }
                },
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 200
                        },
                        legend: {
                            position: 'bottom'
                        }
                    }
                }]
            };

            try {
                const topInstrumentsChart = new ApexCharts(document.querySelector("#topInstrumentsBooked"), topInstrumentsOptions);
                topInstrumentsChart.render();

                Livewire.on('refreshTopInstruments', () => {
                    topInstrumentsChart.updateSeries(<?php echo json_encode(array_column($topBookedInstruments, 'count'), 512) ?>);
                    topInstrumentsChart.updateOptions({
                        labels: <?php echo json_encode(array_column($topBookedInstruments, 'name'), 512) ?>
                    });
                });
            } catch (error) {
                console.error("Error initializing top instruments chart:", error);
            }
        }

        // Most Serviced Instruments Chart initialization function
        function initMostServicedInstrumentsChart() {
            // Debug output
            console.log("Initializing Most Serviced Instruments chart");

            // Check if element exists
            if (!document.querySelector("#mostServicedInstruments")) {
                console.error("Element #mostServicedInstruments not found");
                return;
            }

            const seriesData = <?php echo json_encode(array_column($mostServicedInstruments, 'count'), 512) ?>;
            const labelsData = <?php echo json_encode(array_column($mostServicedInstruments, 'name'), 512) ?>;

            console.log("Most serviced data:", seriesData);
            console.log("Most serviced labels:", labelsData);

            if (seriesData.length === 0) {
                console.warn("No data available for most serviced instruments");
                return;
            }

            const mostServicedOptions = {
                series: seriesData,
                chart: {
                    type: 'pie',
                    height: 250
                },
                labels: labelsData,
                colors: ['#22C55E', '#001A6E', '#DC2626'],
                legend: {
                    position: 'bottom'
                },
                tooltip: {
                    y: {
                        formatter: function(value) {
                            return value + ' services'
                        }
                    }
                },
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 200
                        },
                        legend: {
                            position: 'bottom'
                        }
                    }
                }]
            };

            try {
                const mostServicedChart = new ApexCharts(document.querySelector("#mostServicedInstruments"), mostServicedOptions);
                mostServicedChart.render();

                Livewire.on('refreshMostServiced', () => {
                    mostServicedChart.updateSeries(<?php echo json_encode(array_column($mostServicedInstruments, 'count'), 512) ?>);
                    mostServicedChart.updateOptions({
                        labels: <?php echo json_encode(array_column($mostServicedInstruments, 'name'), 512) ?>
                    });
                });
            } catch (error) {
                console.error("Error initializing most serviced chart:", error);
            }
        }

        // Top Students Chart initialization function
        function initTopStudentsChart() {
            if (!document.querySelector("#topStudentWithMostBookings")) {
                console.error("Element #topStudentWithMostBookings not found");
                return;
            }

            const seriesData = <?php echo json_encode(array_column($topStudentWithMostBookings, 'count'), 512) ?>;
            const labelsData = <?php echo json_encode(array_column($topStudentWithMostBookings, 'name'), 512) ?>;

            if (seriesData.length === 0) {
                console.warn("No data available for top students");
                return;
            }

            const topStudentsOptions = {
                series: seriesData,
                chart: {
                    type: 'pie',
                    height: 250
                },
                labels: labelsData,
                colors: ['#22C55E', '#001A6E', '#DC2626'],
                legend: {
                    position: 'bottom'
                },
                tooltip: {
                    y: {
                        formatter: function(value) {
                            return value + ' bookings'
                        }
                    }
                },
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 200
                        },
                        legend: {
                            position: 'bottom'
                        }
                    }
                }]
            };

            try {
                const topStudentsChart = new ApexCharts(document.querySelector("#topStudentWithMostBookings"), topStudentsOptions);
                topStudentsChart.render();

                Livewire.on('refreshTopStudents', () => {
                    topStudentsChart.updateSeries(<?php echo json_encode(array_column($topStudentWithMostBookings, 'count'), 512) ?>);
                    topStudentsChart.updateOptions({
                        labels: <?php echo json_encode(array_column($topStudentWithMostBookings, 'name'), 512) ?>
                    });
                });
            } catch (error) {
                console.error("Error initializing top students chart:", error);
            }
        }
    </script>
</div>
<?php /**PATH D:\work\kinker\resources\views/livewire/super-admin-dashboard.blade.php ENDPATH**/ ?>