<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Stock Transactions Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 6px;
            text-align: left;
            font-size: 9px;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .transaction-in {
            color: #059669;
            font-weight: bold;
        }
        .transaction-out {
            color: #dc2626;
            font-weight: bold;
        }
        .item-type-chemical {
            color: #7c3aed;
        }
        .item-type-regular {
            color: #059669;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1><?php echo e($title); ?></h1>
        <p>Generated on: <?php echo e($generatedAt); ?></p>
        <?php if(isset($dateFrom) && isset($dateTo)): ?>
            <p>Period: <?php echo e($dateFrom); ?> to <?php echo e($dateTo); ?></p>
        <?php endif; ?>
    </div>

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Item</th>
                <th>Category</th>
                <th>Type</th>
                <th>Transaction</th>
                <th>Quantity</th>
                <th>Remaining</th>
                <th>Used For</th>
                <th>Conducted By</th>
                <th>Batch</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($transaction->transaction_date->format('Y-m-d')); ?></td>
                    <td><?php echo e($transaction->inventoryItem->name ?? 'N/A'); ?></td>
                    <td><?php echo e($transaction->inventoryItem->category->name ?? 'N/A'); ?></td>
                    <td class="item-type-<?php echo e($transaction->inventoryItem->item_type ?? 'regular'); ?>">
                        <?php echo e(ucfirst($transaction->inventoryItem->item_type ?? 'regular')); ?>

                    </td>
                    <td class="transaction-<?php echo e($transaction->transaction_type); ?>">
                        <?php echo e(ucfirst($transaction->transaction_type)); ?>

                    </td>
                    <td><?php echo e($transaction->quantity); ?></td>
                    <td><?php echo e($transaction->remaining_quantity); ?></td>
                    <td><?php echo e($transaction->used_for ?? 'N/A'); ?></td>
                    <td><?php echo e($transaction->conducted_by); ?></td>
                    <td><?php echo e($transaction->batch->batch_number ?? 'N/A'); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="10" style="text-align: center; color: #666;">No transactions found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="footer">
        <p>Laboratory Inventory Management System - Stock Transactions Report</p>
        <p>Total Transactions: <?php echo e($data->count()); ?></p>
    </div>
</body>
</html><?php /**PATH /home1/kinkarlab/public_html/resources/views/exports/stock-transaction-pdf.blade.php ENDPATH**/ ?>