<div>

    <div wire:show="showForm" <?php if(!$showForm): ?> style="display: none;" <?php endif; ?> class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">

        <div  class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between">
            <span class="font-semibold text-primary text-xl"><?php echo e($isEditing ? 'Edit Lab' : 'Lab Registration'); ?></span>
            <span wire:click="hideForm" class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-primary hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer"><i
                    class="fa fa-angle-left mr-2"></i>Back</span>

        </div>

        <div id="formDiv" class="w-full border-b-[2px] border-b-ternary/10 shadow-lg shadow-ternary/20" >
            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('lab.lab-form', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-19574388-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        </div>
    </div>


    <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('success')); ?>

            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php if(session()->has('error')): ?>
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('error')); ?>

            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->


    <div wire:show="!showForm" class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300 mt-6">
        <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between">
            <span class="font-semibold text-primary text-xl">Lab List</span>
            <span wire:click="hideForm" class="text-sm bg-primary/80 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                <i class="fa fa-user-plus mr-2"></i>
                Create New Lab</span>

        </div>
        <div class="w-full overflow-x-auto p-4">
            <div class="w-full flex justify-between gap-2 items-center">
                <div class="flex gap-2">


                    <button title="Export to pdf" wire:click="exportToPdf" class="bg-danger/20 text-danger h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white cursor-pointer transition ease-in duration-2000">
                        <i class="fa fa-file-pdf"></i>
                    </button>
                </div>
                <div class="flex items-center gap-2">
                    <input type="text" wire:model.live.debounce.1000ms="search" name="search" required placeholder="Search PI" class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                    <select wire:model.live="status" required class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                        <option value="All">All</option>
                        <option value="1">Active</option>
                        <option value="0">Inactive</option>
                    </select>
                </div>
            </div>
            <table class="w-full border-[2px] border-secondary/40 border-collapse mt-4" wire:loading.class="opacity-25">
                <tr>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Sr. No.</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Lab</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">In Charge</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Type/ Department</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Location</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Instruments</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Status</td>
                    <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Action</td>
                </tr>

                <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $labs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-secondary/10 cursor-pointer transition ease-in duration-2000">
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm"><?php echo e($loop->iteration); ?></td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                            <div class="flex items-center gap-2">
                                <!--[if BLOCK]><![endif]--><?php if($lab->lab_image): ?>
                                <img src="<?php echo e(asset('storage/' . $lab->lab_image)); ?>" alt="<?php echo e($lab->lab_name); ?>" class="h-12 w-12 object-cover rounded-full"/>
                                <?php else: ?>
                                <img src="<?php echo e(asset('assets/images/noProfile.png')); ?>" alt="Lab Image" class="h-12 w-12 object-cover rounded-full"/>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                <div>
                                    <span class=" text-md"><?php echo e($lab->lab_name); ?></span> <br>
                                </div>
                            </div>
                        </td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                           <!--[if BLOCK]><![endif]--><?php if($lab->principalInvestigator): ?>
                            <span><i class="fa fa-user mr-1 text-success"></i> <?php echo e($lab->principalInvestigator->first_name); ?></span> <br>
                            <?php else: ?>
                                <span><i class="fa fa-user mr-1 text-success"></i> No In Charge</span> <br>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <span><i class="fa fa-phone mr-1 text-danger"></i> <?php echo e($lab->contact_number); ?></span>
                        </td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                            <span><i class="fa fa-tag mr-1 text-success"></i> <?php echo e($lab->type); ?></span> <br>
                                <span><i class="fa fa-building mr-1 text-danger"></i> <?php echo e($lab->department); ?></span>
                        </td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                            <span><?php echo e($lab->room_number); ?>/  <?php echo e($lab->floor); ?></span> <br>
                            <span> <?php echo e($lab->building); ?></span>
                        </td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                            <span class="cursor-pointer group"><i class="fa-solid fa-flask mr-1 text-success group-hover:text-danger transition ease-in duration-2000"></i>
                                <span class="text-md font-bold"><?php echo e($lab->instruments->count()); ?></span>
                            </span> <br>
                        </td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                            <button wire:click="toggleStatus(<?php echo e($lab->id); ?>)" class="focus:outline-none">
                                <!--[if BLOCK]><![endif]--><?php if($lab->status == '0'): ?>
                                    <span class="bg-danger/20 text-danger px-2 py-0.5 rounded-full text-xs">Inactive</span>
                                <?php else: ?>
                                    <span class="bg-success/20 text-success px-2 py-0.5 rounded-full text-xs">Active</span>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </button>
                        </td>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                            <div class="flex gap-2">

                                <button wire:click="editLab(<?php echo e($lab->id); ?>)" title="Edit" class="bg-warning/20 text-warning h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-warning hover:text-white cursor-pointer transition ease-in duration-2000">
                                    <i class="fa fa-pen text-xs"></i>
                                </button>
                                <button wire:click="deleteLab(<?php echo e($lab->id); ?>)" wire:confirm="Are you sure you want to delete this PI?" title="Delete" class="bg-danger/20 text-danger h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white cursor-pointer transition ease-in duration-2000">
                                    <i class="fa fa-trash text-xs"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm text-center" colspan="9">No lab found</td>
                    </tr>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            </table>
            <div class="mt-4">
                <?php echo e($labs->links()); ?>

            </div>
        </div>
    </div>



</div><?php /**PATH /home1/kinkarlab/iitr.kinkarlab.com/resources/views/livewire/lab/lab-list.blade.php ENDPATH**/ ?>