<div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">

    <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('message')); ?>

            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php if(session()->has('error')): ?>
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('error')); ?>

            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between flex-wrap">
        <span class="font-semibold text-primary text-xl">Suppliers</span>
        <div class="flex items-center gap-2 justify-end">
            <span wire:click="openCreateModal"
                  class="text-sm bg-primary/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                <i class="fa fa-plus mr-2"></i>Add Supplier
            </span>
        </div>
    </div>

        <div class="w-full flex flex-col sm:flex-row justify-between gap-2 px-4">
            <div class="flex flex-col sm:flex-row gap-2">
                <button wire:click="exportSuppliers"
                        class="text-sm bg-success/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/80 text-white hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000 disabled:opacity-50 disabled:cursor-not-allowed"
                        wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="exportSuppliers">
                        <i class="fa fa-file-excel mr-2"></i>Excel
                    </span>
                    <span wire:loading wire:target="exportSuppliers">
                        <i class="fas fa-hourglass-half fa-spin mr-2"></i>Exporting...
                    </span>
                </button>

                <button wire:click="exportSuppliersPdf"
                        class="text-sm bg-danger/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/80 text-white hover:text-white hover:bg-danger hover:border-ternary/30 transition ease-in duration-2000 disabled:opacity-50 disabled:cursor-not-allowed"
                        wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="exportSuppliersPdf">
                        <i class="fa fa-file-pdf mr-2"></i>PDF
                    </span>
                    <span wire:loading wire:target="exportSuppliersPdf">
                        <i class="fas fa-hourglass-half fa-spin mr-2"></i>Exporting...
                    </span>
                </button>
            </div>
            <div class="relative w-full sm:w-auto">
                <input type="text" wire:model.live.debounce.500ms="search" placeholder="Search suppliers..."
                       class="px-3 py-1.5 w-full sm:max-w-64 text-sm font-medium bg-white placeholder-gray-500 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                <!--[if BLOCK]><![endif]--><?php if($search): ?>
                    <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-danger">
                        <i class="fa fa-times"></i>
                    </button>
                <?php else: ?>
                    <span class="absolute right-3 top-1/2 -translate-y-1/2 text-success">
                        <i class="fa fa-search"></i>
                    </span>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>

    <div class="w-full overflow-x-auto p-4 pt-0">
        <!--[if BLOCK]><![endif]--><?php if($suppliers->count() > 0): ?>
            <!-- Desktop Table View -->
            <div class="hidden md:block overflow-x-auto">
                <table class="w-full border-[2px] border-secondary/40 border-collapse"
                       wire:loading.class="opacity-25">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Sr. No.</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Name</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Contact Person</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Email</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Phone</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Address</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Created At</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-secondary/10 transition ease-in duration-2000">
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <?php echo e(($suppliers->currentPage() - 1) * $suppliers->perPage() + $index + 1); ?>

                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <i class="fa fa-truck text-primary mr-2 text-xs"></i><?php echo e($supplier->name); ?>

                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <?php echo e($supplier->contact_person ?? '-'); ?>

                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <!--[if BLOCK]><![endif]--><?php if($supplier->email): ?>
                                        <a href="mailto:<?php echo e($supplier->email); ?>" class="text-primary hover:underline">
                                            <i class="fa fa-envelope mr-1 text-xs"></i><?php echo e($supplier->email); ?>

                                        </a>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <!--[if BLOCK]><![endif]--><?php if($supplier->phone): ?>
                                        <a href="tel:<?php echo e($supplier->phone); ?>" class="text-primary hover:underline">
                                            <i class="fa fa-phone mr-1 text-xs"></i><?php echo e($supplier->phone); ?>

                                        </a>
                                    <?php else: ?>
                                        -
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm max-w-xs overflow-hidden">
                                    <?php echo e($supplier->address ?? '-'); ?>

                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <i class="far fa-calendar-alt mr-1 text-danger text-xs"></i>
                                    <?php echo e($supplier->created_at->format('M d, Y')); ?>

                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <div class="flex items-center gap-2">
                                        <button wire:click="openEditModal(<?php echo e($supplier->id); ?>)"
                                                class="text-primary hover:text-primary-dark transition-colors"
                                                title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </button>

                                        <button wire:click="delete(<?php echo e($supplier->id); ?>)"
                                                wire:confirm="Are you sure you want to delete this supplier?"
                                                class="text-red-600 hover:text-red-800 transition-colors"
                                                title="Delete">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>

            <!-- Mobile Card View -->
            <div class="md:hidden space-y-4" wire:loading.class="opacity-25">
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-white border-[2px] border-secondary/40 rounded-lg p-4 shadow-sm">
                        <div class="flex justify-between items-start mb-3">
                            <div class="flex-1">
                                <h3 class="font-semibold text-primary flex items-center">
                                    <i class="fa fa-truck text-primary mr-2 text-xs"></i>
                                    <?php echo e($supplier->name); ?>

                                </h3>
                                <!--[if BLOCK]><![endif]--><?php if($supplier->contact_person): ?>
                                    <p class="text-sm text-gray-600 mt-1">
                                        Contact: <?php echo e($supplier->contact_person); ?>

                                    </p>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <div class="flex items-center gap-2 ml-4">
                                <button wire:click="openEditModal(<?php echo e($supplier->id); ?>)"
                                        class="bg-primary/20 text-primary h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-primary hover:text-white cursor-pointer transition ease-in duration-2000"
                                        title="Edit">
                                    <i class="fas fa-edit text-xs"></i>
                                </button>

                                <button wire:click="delete(<?php echo e($supplier->id); ?>)"
                                        wire:confirm="Are you sure you want to delete this supplier?"
                                        class="bg-red-100 text-red-600 h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-red-600 hover:text-white cursor-pointer transition ease-in duration-2000"
                                        title="Delete">
                                    <i class="fas fa-trash text-xs"></i>
                                </button>
                            </div>
                        </div>
                        <div class="space-y-2 text-sm">
                            <!--[if BLOCK]><![endif]--><?php if($supplier->email): ?>
                                <div class="flex items-center">
                                    <i class="fa fa-envelope text-primary mr-2 text-xs w-4"></i>
                                    <a href="mailto:<?php echo e($supplier->email); ?>" class="text-primary hover:underline">
                                        <?php echo e($supplier->email); ?>

                                    </a>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <!--[if BLOCK]><![endif]--><?php if($supplier->phone): ?>
                                <div class="flex items-center">
                                    <i class="fa fa-phone text-primary mr-2 text-xs w-4"></i>
                                    <a href="tel:<?php echo e($supplier->phone); ?>" class="text-primary hover:underline">
                                        <?php echo e($supplier->phone); ?>

                                    </a>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <!--[if BLOCK]><![endif]--><?php if($supplier->address): ?>
                                <div class="flex items-start">
                                    <i class="fa fa-map-marker-alt text-primary mr-2 text-xs w-4 mt-1"></i>
                                    <span class="text-gray-600"><?php echo e($supplier->address); ?></span>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="flex justify-between items-center text-sm mt-3 pt-3 border-t border-gray-200">
                            <span class="text-gray-500">
                                <i class="far fa-calendar-alt mr-1 text-danger text-xs"></i>
                                <?php echo e($supplier->created_at->format('M d, Y')); ?>

                            </span>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </div>

            <!-- Pagination -->
            <div class="mt-4">
                <?php echo e($suppliers->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-12 bg-gray-50 rounded-lg border-2 border-dashed border-gray-200">
                <div class="text-gray-400 mb-4">
                    <i class="fas fa-truck text-5xl"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-600 mb-2">
                    <!--[if BLOCK]><![endif]--><?php if($search): ?>
                        No suppliers found for "<?php echo e($search); ?>"
                    <?php else: ?>
                        No Suppliers Found
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </h3>
                <p class="text-gray-500 max-w-md mx-auto mb-4">
                    <!--[if BLOCK]><![endif]--><?php if($search): ?>
                        Try adjusting your search terms or clear the search to see all suppliers.
                    <?php else: ?>
                        You don't have any suppliers yet. Create your first supplier to start tracking your inventory sources.
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </p>
                <!--[if BLOCK]><![endif]--><?php if(!$search): ?>
                    <button wire:click="openCreateModal"
                            class="bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-md inline-flex items-center transition-colors">
                        <i class="fas fa-plus mr-2"></i> Create New Supplier
                    </button>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <!-- Add/Edit Supplier Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showModal): ?>
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full max-h-[90vh] overflow-y-auto">
                <h3 class="text-lg font-semibold mb-4 text-primary"><?php echo e($editMode ? 'Edit Supplier' : 'Add New Supplier'); ?></h3>
                <form wire:submit="save">
                    <div class="w-full flex flex-col gap-4">
                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Name <span class="text-danger">*</span></label>
                            <input type="text" wire:model="name" placeholder="Enter supplier name"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Contact Person</label>
                            <input type="text" wire:model="contact_person" placeholder="Enter contact person name"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['contact_person'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Email</label>
                            <input type="email" wire:model="email" placeholder="Enter email address"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Phone</label>
                            <input type="text" wire:model="phone" placeholder="Enter phone number"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Address</label>
                            <textarea wire:model="address" placeholder="Enter supplier address" rows="3"
                                      class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000 resize-none"></textarea>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>
                    <div class="flex justify-end space-x-3 mt-4">
                        <button type="button" wire:click="closeModal"
                                class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                            Cancel
                        </button>
                        <button type="submit"
                                class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                            <span wire:loading.remove wire:target="save"><?php echo e($editMode ? 'Update' : 'Save'); ?></span>
                            <span wire:loading wire:target="save"><?php echo e($editMode ? 'Updating...' : 'Saving...'); ?> <i class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH /home1/kinkarlab/public_html/resources/views/livewire/inventory/supplier-list.blade.php ENDPATH**/ ?>