<div wire:clock >
   <div wire:loading.class="opacity-25">
       <div class="w-full grid xl:grid-cols-3 lg:grid-cols-3 md:grid-cols-2 grid-cols-1 gap-4">
           <!-- Main Info Card -->
           <div class="xl:col-span-2 lg:col-span-2 w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col">
               <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between gap-4 items-center ">
                   <span class="font-semibold text-primary text-xl"><?php echo e($pi->title); ?> <?php echo e($pi->first_name); ?> <?php echo e($pi->last_name); ?> Profile</span>
                   <span wire:click="hideViewPi"
                         class="text-sm bg-primary/30 px-2 py-0.5 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[px] border-primary/80 text-primary hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                 <i class="fa fa-xmark"></i>
                </span>
               </div>
               <div class="p-4 grid xl:grid-cols-3 gap-4">
                   <!-- Profile Photo -->
                   <div class="flex flex-col items-center gap-3">
                       <!--[if BLOCK]><![endif]--><?php if($pi->profile_photo): ?>
                       <img src="<?php echo e(asset('storage/'. $pi->profile_photo)); ?>" alt="PI Photo" class="w-48 h-48 rounded-full object-cover border-4 border-primary/20">
                       <?php else: ?>
                           <img src="<?php echo e(asset('assets/images/noProfile.png')); ?>" alt="PI Profile Photo" class="w-48 h-48 rounded-full object-cover border-4 border-primary/20"/>
                       <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                       <h2 class="text-xl font-semibold text-primary text-center"><?php echo e($pi->first_name); ?> <?php echo e($pi->last_name); ?></h2>
                       <span class="px-3 py-1 bg-primary/10 text-primary rounded-full text-sm font-medium">Principal Investigator</span>
                   </div>

                   <!-- Basic Info -->
                   <div class="xl:col-span-2 flex flex-col gap-2">
                       <h3 class="font-semibold text-primary">Basic Information</h3>
                       <div class="grid grid-cols-2 gap-2 text-sm">
                           <span class="text-gray-600">Department:</span>
                           <span class="font-medium"><?php echo e($pi->department); ?></span>
                           <span class="text-gray-600">Designation:</span>
                           <span class="font-medium"><?php echo e($pi->designation); ?></span>
                           <span class="text-gray-600">Email:</span>
                           <span class="font-medium"><?php echo e($pi->email); ?></span>
                           <span class="text-gray-600">Phone:</span>
                           <span class="font-medium"><?php echo e($pi->phone); ?></span>
                           <span class="text-gray-600">Office:</span>
                           <span class="font-medium"><?php echo e($pi->office_address); ?></span>
                           <span class="text-gray-600">Joining Date:</span>
                           <span class="font-medium">
                            <?php echo e(\Carbon\Carbon::parse($pi->joining_date)->format('d M, Y')); ?>

                        </span>
                           <span class="text-gray-600">Research Area</span>
                           <span class="font-medium">  <?php echo e($pi->specialization); ?> </span>
                           <span class="text-gray-600">Students</span>
                           <span class="font-medium">  <?php echo e($pi->students->count()); ?> </span>
                       </div>
                   </div>
               </div>


           </div>

           <!-- Stats Card -->
           <div class="w-full border-[1px] border-t-[4px] border-warning/20 border-t-warning bg-white flex gap-2 flex-col">
               <div class="bg-warning/10 px-4 py-2 border-b-[2px] border-b-warning/20">
                   <span class="font-semibold text-warning text-lg">Recent Activities</span>
               </div>
               <div class="p-4">
                   <div class="relative overflow-x-auto overflow-y-auto h-[300px]">
                       <table class="w-full border-[2px] border-secondary/40 border-collapse">
                           <tr>
                               <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Date</td>
                               <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Activity</td>
                           </tr>
                           <tr class="hover:bg-secondary/10 cursor-pointer transition ease-in duration-2000">
                               <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e(\Carbon\Carbon::parse($pi->created_at)->format('d M, Y')); ?></td>
                               <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">Account Created</td>
                           </tr>
                       </table>
                   </div>
               </div>
           </div>
       </div>
       <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col mt-4 mb-4 ">
           <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
               <span class="font-semibold text-primary text-lg">Recent Bookings</span>
           </div>
           <div class="p-4">
               <div class="relative overflow-x-auto">
                   <div class="w-full flex justify-between gap-2 items-center">
                       <div class="flex gap-2">

                       </div>
                       <div class="flex items-center gap-2">
                           <input type="date" wire:model.live.debounce.1000ms="search_date" name="search" required
                                  placeholder="Search PI"
                                  class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                       </div>
                   </div>
                   <table class="w-full border-[2px] border-secondary/40 border-collapse mt-4">
                       <tr>
                           <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Sr. No.</td>
                           <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Date</td>
                           <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Instrument</td>
                           <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Slot</td>
                           <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Status</td>
                           <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md">Cost</td>
                       </tr>
                               <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $bookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $booking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                       <tr class="hover:bg-secondary/10 cursor-pointer transition ease-in duration-2000">
                                           <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm"><?php echo e($loop->iteration); ?></td>
                                           <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm"><?php echo e(Carbon\Carbon::parse($booking->date)->format('d M, Y')); ?></td>
                                           <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm"><?php echo e($booking->instrument->name); ?></td>
                                           <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm"><?php echo e($booking->slots->first()->start_time); ?> - <?php echo e($booking->slots->last()->end_time); ?></td>
                                           <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                               <span>
                                                   <!--[if BLOCK]><![endif]--><?php if($booking->status == 'confirmed'): ?>
                                                       <span class="bg-success/20 text-success px-2 py-0.5 rounded-full text-xs">Confirmed</span>
                                                   <?php else: ?>
                                                       <span class="bg-danger/20 text-danger px-2 py-0.5 rounded-full text-xs">Cancelled</span>
                                                   <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                               </span>
                                               <span><i class="fa-regular text-<?php echo e($booking->status == 'confirmed'?'success':'danger'); ?> fa-comment mr-2"></i><?php echo e($booking->description??'--'); ?></span>
                                           </td>
                                           <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                               <!--[if BLOCK]><![endif]--><?php if($booking->status == 'confirmed'): ?>
                                                   <?php echo e($booking->getAmountAttribute()); ?> ₹
                                               <?php else: ?>
                                                   <span class="text-danger">No fee applied</span>
                                               <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                           </td>
                                       </tr>
                                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                           <tr>
                               <td class="border-[2px] border-secondary/40 px-4 py-1 text-ternary/80 font-medium text-sm text-center" colspan="6">No bookings found</td>
                           </tr>
                               <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                   </table>
                   <div class="mt-4">
                       <?php echo e($bookings->links()); ?>

                   </div>
               </div>
           </div>
       </div>
   </div>
</div><?php /**PATH /home1/kinkarlab/public_html/resources/views/livewire/pi/pi-view.blade.php ENDPATH**/ ?>