<div>
    <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('success')); ?>

            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php if(session()->has('error')): ?>
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('error')); ?>

            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <!--[if BLOCK]><![endif]--><?php if($viewInstrumentDetailView): ?>
      <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('instruments.instrument-view', ['instrument' => $viewInstrumentDetails]);

$__html = app('livewire')->mount($__name, $__params, 'lw-1595615946-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    <?php else: ?>


        <div wire:show="showForm" <?php if(!$showForm): ?> style="display: none;" <?php endif; ?> class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between">
                <span
                    class="font-semibold text-primary text-xl"><?php echo e($isEditing ? 'Edit Instrument' : 'Instrument Registration'); ?></span>
                <span wire:click="hideForm"
                      class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-primary hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer"><i
                        class="fa fa-angle-left mr-2"></i>Back</span>
            </div>
            <div id="formDiv" class="w-full border-b-[2px] border-b-ternary/10 shadow-lg shadow-ternary/20">
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('instruments.instrument-form', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-1595615946-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            </div>
        </div>

        <div wire:show="!showForm" class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300 mt-6">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between flex-wrap">
                <span class="font-semibold text-primary text-xl">Instrument List</span>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create instrument')): ?>
                    <span wire:click="hideForm"
                          class="text-sm bg-primary/80 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                <i class="fa fa-plus mr-2"></i>
                Create New Instrument</span>
                <?php endif; ?>
            </div>
            <div class="w-full lg:flex md:flex hidden justify-end gap-4 px-4">
                <div class="flex gap-1 items-center">
                    <button title="Generate QR Code"
                            class="bg-danger/20 text-danger px-2 py-0.5 flex justify-center items-center rounded-[3px] cursor-not-allowed">
                        <i class="fa fa-qrcode text-xs mr-1"></i> <span class="text-sm">Generate QR Code</span>
                    </button>
                </div>
                <div class="flex gap-1 items-center">
                    <button title="View"
                            class="bg-success/20 text-success px-2 py-0.5 flex justify-center items-center rounded-[3px] cursor-not-allowed">
                        <i class="fa fa-plus text-xs mr-1"></i> <span class="text-sm">View Accessories</span>
                    </button>
                </div>
                <div class="flex gap-1 items-center">
                    <button title="View"
                            class="bg-primary/20 text-primary px-2 py-0.5 flex justify-center items-center rounded-[3px] cursor-not-allowed">
                        <i class="fa fa-eye text-xs mr-1"></i> <span class="text-sm">View Instrument</span>
                    </button>
                </div>
                <div class="flex gap-1 items-center">
                    <button title="Edit"
                            class="bg-warning/20 text-warning px-2 py-0.5 flex justify-center items-center rounded-[3px] cursor-not-allowed">
                        <i class="fa fa-edit text-xs mr-1"></i> <span class="text-sm">Edit Instrument</span>
                    </button>
                </div>
                <div class="flex gap-1 items-center">
                    <button title="Edit"
                            class="bg-danger/20 text-danger px-2 py-0.5 flex justify-center items-center rounded-[3px] cursor-not-allowed">
                        <i class="fa fa-lock-open text-xs mr-1"></i> <span class="text-sm">Terms Not Created</span>
                    </button>
                </div>
                <div class="flex gap-1 items-center">
                    <button title="Edit"
                            class="bg-success/20 text-success px-2 py-0.5 flex justify-center items-center rounded-[3px] cursor-not-allowed">
                        <i class="fa fa-lock text-xs mr-1"></i> <span class="text-sm">Terms Created</span>
                    </button>
                </div>
            </div>

            <div class="w-full overflow-x-auto p-4">
                <div class="w-full flex justify-between gap-2 items-center">
                    <div class="flex gap-2">
                        <button title="Export to excel" wire:click="exportToExcel"
                                class="bg-success/20 text-success h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-success hover:text-white cursor-pointer transition ease-in duration-2000">
                            <i class="fa fa-file-excel"></i>
                        </button>
                        <button title="Export to pdf" wire:click="exportToPdf"
                                class="bg-danger/20 text-danger h-8 w-8 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white cursor-pointer transition ease-in duration-2000">
                            <i class="fa fa-file-pdf"></i>
                        </button>
                    </div>
                    <div class="flex items-center gap-2">
                        <input type="text" wire:model.live.debounce.1000ms="search" name="search" required
                               placeholder="Search Instrument"
                               class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
                        <select wire:model.live="status" required
                                class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <option value="All">All</option>
                            <option value="working">Working</option>
                            <option value="under_maintenance">Under Maintenance</option>
                            <option value="calibration_required">Calibration Required</option>
                            <option value="faulty">Faulty</option>
                            <option value="retired">Retired/Obsolete</option>
                        </select>
                    </div>
                </div>
                <table class="w-full border-[2px] border-secondary/40 border-collapse mt-4"
                       wire:loading.class="opacity-25">
                    <tr>
                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                            Sr. No.
                        </td>
                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                            Instrument
                        </td>
                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                            Lab
                        </td>
                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                            Service Engineer
                        </td>
                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                            Accessories
                        </td>
                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                            Booking Types
                        </td>
                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                            Status
                        </td>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create instrument')): ?>
                        <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                            Public Visibility
                        </td>
                        <?php endif; ?>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create instrument')): ?>
                            <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">
                                Action
                            </td>
                        <?php endif; ?>
                    </tr>

                    <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $instruments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instrument): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-secondary/10 cursor-pointer transition ease-in duration-2000">
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap"><?php echo e($loop->iteration); ?></td>
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm overflow-x-auto whitespace-nowrap max-w-[300px]">
                                <div class="flex w-full items-center gap-2">
                                    <?php if($instrument->photos): ?>
                                        <?php $photos = json_decode($instrument->photos); ?>
                                        <!--[if BLOCK]><![endif]--><?php if(count($photos) > 0): ?>
                                            <img src="<?php echo e(asset('storage/' . $photos[0])); ?>"
                                                 alt="<?php echo e($instrument->name); ?>"
                                                 class="h-12 w-12 object-cover rounded-full"/>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <div class="w-full">
                                        <span class=" text-md"><?php echo e($instrument->name); ?></span> <br>
                                        <span class="mt-1 text-xs"><?php echo e($instrument->instrumentCategory->title??''); ?></span>
                                    </div>
                                </div>

                            </td>
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap overflow-x-auto max-w-[300px]">
                                <span><i class="fa fa-vial mr-1 text-success"></i> <?php echo e($instrument->lab->lab_name); ?></span>
                                <br>
                                <span class="text-xs"><i class="fa fa-qrcode mr-1 text-danger"></i> <?php echo e($instrument->model_number); ?></span>
                            </td>
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap overflow-x-auto max-w-[300px]">
                                <span><i class="fa fa-user mr-1 text-success"></i> <?php echo e($instrument->engineer_name); ?></span>
                                <br>
                                <span class="text-xs"><i class="fa fa-phone mr-1 text-danger"></i> <?php echo e($instrument->engineer_mobile); ?></span>
                            </td>
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap overflow-x-auto max-w-[300px]">
                                <div class="flex items-center gap-2">
                                    <?php echo e($instrument->instrumentAccessories->count()); ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create instrument')): ?>
                                        <button wire:click="addAccessories(<?php echo e($instrument->id); ?>)" title="Add Accessory"
                                                class="bg-success/20 text-success h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-success hover:text-white cursor-pointer transition ease-in duration-2000">
                                            <i class="fa fa-plus text-xs"></i>
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap  overflow-x-auto max-w-[600px]">
                                <div class="grid grid-cols-2 gap-2 text-sm">
                                    <div class="flex items-center gap-2">
                                        <span>Booking Type:</span>
                                        <span class="font-semibold"><?php echo e(ucfirst($instrument->booking_type)); ?></span>
                                        <button wire:click="toggleShowPricingModal(<?php echo e($instrument->id); ?>)" title="View Pricing"
                                                class="bg-danger/20 text-danger flex-none h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white cursor-pointer transition ease-in duration-2000">
                                            <i class="fa fa-eye text-xs"></i>
                                        </button>
                                    </div>
                                </div>
                            </td>
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap  overflow-x-auto max-w-[300px]">
                                <div class="flex gap-4 items-center">
                                    <button wire:click="updateStatus(<?php echo e($instrument->id); ?>)" class="focus:outline-none">
                                        <!--[if BLOCK]><![endif]--><?php if($instrument->operating_status == 'working'): ?>
                                            <span class="bg-success/10 text-success px-2 py-0.5 rounded-full text-xs">Working</span>
                                        <?php elseif($instrument->operating_status == 'under_maintenance'): ?>
                                            <span class="bg-warning/10 text-warning px-2 py-0.5 rounded-full text-xs">Under Maintenance</span>
                                        <?php elseif($instrument->operating_status == 'calibration_required'): ?>
                                            <span class="bg-warning/10 text-warning px-2 py-0.5 rounded-full text-xs">Calibration Required</span>
                                        <?php elseif($instrument->operating_status == 'faulty'): ?>
                                            <span class="bg-danger/10 text-danger px-2 py-0.5 rounded-full text-xs">Faulty</span>
                                        <?php else: ?>
                                            <span class="bg-danger/10 text-danger px-2 py-0.5 rounded-full text-xs">Retired/Obsolete</span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </button>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create instrument')): ?>
                                        <!--[if BLOCK]><![endif]--><?php if($instrument->operating_status == 'under_maintenance'): ?>
                                            <!--[if BLOCK]><![endif]--><?php if(!$instrument->anyPendingService()): ?>
                                                <button wire:click="sendForService(<?php echo e($instrument->id); ?>)"
                                                        title="Send for service"
                                                        class="bg-danger/10 text-danger h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white cursor-pointer transition ease-in duration-2000">
                                                    <i class="fa fa-paper-plane text-xs animate-bounce"></i>
                                                </button>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php endif; ?>
                                </div>
                            </td>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create instrument')): ?>
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap  overflow-x-auto max-w-[300px]">
                                <div class="flex gap-4 items-center">
                                    <button wire:click="updatePublicStatus(<?php echo e($instrument->id); ?>)" class="focus:outline-none">
                                        <!--[if BLOCK]><![endif]--><?php if($instrument->public_visibility_status): ?>
                                            <span class="bg-success/10 text-success px-2 py-0.5 rounded-full text-xs">Visible</span>
                                        <?php else: ?>
                                            <span class="bg-danger/10 text-danger px-2 py-0.5 rounded-full text-xs">Not Visible</span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </button>
                                </div>
                            </td>
                            <?php endif; ?>


                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create instrument')): ?>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap  overflow-x-auto max-w-[300px]">
                                    <div class="flex gap-2">
                                        <button wire:click="generateQrCode(<?php echo e($instrument->id); ?>)"
                                                title="Generate QR Code"
                                                class="bg-danger/20 text-danger h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white cursor-pointer transition ease-in duration-2000">
                                            <i class="fa fa-qrcode text-xs"></i>
                                        </button>
                                        <button wire:click="viewInstrument(<?php echo e($instrument->id); ?>)" title="View"
                                                class="bg-primary/20 text-primary h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-primary hover:text-white cursor-pointer transition ease-in duration-2000">
                                            <i class="fa fa-eye text-xs"></i>
                                        </button>
                                        <button wire:click="editInstrument(<?php echo e($instrument->id); ?>)" title="Edit"
                                                class="bg-warning/20 text-warning h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-warning hover:text-white cursor-pointer transition ease-in duration-2000">
                                            <i class="fa fa-pen text-xs"></i>
                                        </button>
                                        <button wire:click="createInstrumentTerms(<?php echo e($instrument->id); ?>)"
                                                title="Create terms"
                                                class="bg-<?php echo e($instrument->instrumentTerm?'success':'danger'); ?>/20 text-<?php echo e($instrument->instrumentTerm?'success':'danger'); ?> h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-<?php echo e($instrument->instrumentTerm?'success':'danger'); ?> hover:text-white cursor-pointer transition ease-in duration-2000">
                                            <i class="fa fa-<?php echo e($instrument->instrumentTerm?'lock':'lock-open'); ?> text-xs"></i>
                                        </button>

                                        
                                        
                                        
                                    </div>
                                </td>
                            <?php endif; ?>

                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm text-center"
                                colspan="10">No instruments found
                            </td>
                        </tr>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </table>
                <div class="mt-4">
                    <?php echo e($instruments->links()); ?>

                </div>
            </div>
        </div>

    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create instrument')): ?>
        <!--[if BLOCK]><![endif]--><?php if($showStatusModal): ?>
            <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50">
                <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                    <h3 class="text-lg font-semibold mb-4 text-primary">Update Instrument Status</h3>
                    <form wire:submit.prevent="confirmStatusUpdate">
                        <div class="w-full flex flex-col gap-4">
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Status <span
                                        class="text-danger">*</span></label>
                                <select wire:model.live="selectedStatus" required
                                        class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <option value="">Select Status</option>
                                    <option value="working">Working</option>
                                    <option value="under_maintenance">Under Maintenance</option>
                                    <option value="calibration_required">Calibration Required</option>
                                    <option value="faulty">Faulty</option>
                                    <option value="retired">Retired/ Obsolete</option>
                                </select>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedStatus'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i
                                        class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        <div class="flex justify-end space-x-3 mt-4">
                            <button type="button" wire:click="$set('showStatusModal', false)"
                                    class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                                Back
                            </button>
                            <button type="submit"
                                    class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                                <span wire:loading.remove wire:target="confirmStatusUpdate">Update Status</span>
                                <span wire:loading wire:target="confirmStatusUpdate">Updating... <i
                                        class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php endif; ?>

    <!--[if BLOCK]><![endif]--><?php if($showInstrumentTermsForm): ?>
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 h-screen py-20 overflow-y-auto">
            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('instruments.instrument-terms-form', ['instrument' => $addTermsForInstrument]);

$__html = app('livewire')->mount($__name, $__params, 'lw-1595615946-2', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!--[if BLOCK]><![endif]--><?php if($showQrCodeModal): ?>
            <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 h-screen py-20 overflow-y-auto">
                <div class="bg-white rounded-lg shadow-xl w-full max-w-md">
                    <!-- Modal Header -->
                    <div class="flex justify-between items-center border-b px-6 py-4">
                        <h3 class="text-lg font-semibold">Instrument QR Code</h3>
                        <button wire:click="$set('showQrCodeModal', false)" class="text-gray-500 hover:text-gray-700">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>

                    <!-- Modal Content -->
                    <div class="p-6">
                        <div class="flex flex-col items-center">
                            <!--[if BLOCK]><![endif]--><?php if($qrCodeData): ?>
                                <img src="<?php echo e($qrCodeData); ?>" alt="QR Code" class="w-64 h-64">
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <div class="text-center">
                                <h4 class="font-medium text-gray-900"><?php echo e($instrument->name); ?></h4>
                            </div>

                            <!-- Updated printing section -->
                            <div class="mt-6 w-full">
                                <div class="flex items-center justify-center gap-2">
                                    <input type="number" wire:model="qrCodeCount" min="1" max="100" placeholder="How many qr codes?"
                                           class="px-2 py-1 w-20 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <button wire:click="printQrCodes(<?php echo e($instrument->id); ?>)"
                                            class="px-4 py-1 bg-primary text-white rounded hover:bg-primary-dark transition">
                                        Print QR Codes
                                    </button>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['qrCodeCount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs mt-1 text-center"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    </div>

                    <!-- Modal Footer -->
                    <div class="border-t px-6 py-3 bg-gray-50 flex justify-end">
                        <button wire:click="$set('showQrCodeModal', false)"
                                class="px-4 py-2 bg-danger text-white rounded hover:bg-primary-dark transition">
                            Close
                        </button>
                    </div>
                </div>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

         <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create instrument')): ?>
            <!--[if BLOCK]><![endif]--><?php if($showAccessoryModal): ?>
                <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50">
                    <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                        <h3 class="text-lg font-semibold mb-4 text-primary">Add Accessory</h3>
                        <form wire:submit="submitAccessory">
                            <div class="w-full flex flex-col gap-4">
                                <div class="w-full flex flex-col gap-1">
                                    <label class="font-semibold text-primary">Name <span
                                            class="text-danger">*</span></label>
                                    <input type="text" wire:model="accessoryName" placeholder="Enter accessory name"
                                           class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['accessoryName'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i
                                            class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="w-full flex flex-col gap-1">
                                    <label class="font-semibold text-primary">Model Number </label>
                                    <input type="text" wire:model="accessoryModelNumber"
                                           placeholder="Enter model number"
                                           class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['accessoryModelNumber'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i
                                            class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="w-full flex flex-col gap-1">
                                    <label class="font-semibold text-primary">Purchase Date</label>
                                    <input type="date" wire:model="accessoryPurchaseDate"
                                           class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['accessoryPurchaseDate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i
                                            class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="w-full flex flex-col gap-1">
                                    <label class="font-semibold text-primary">Price </label>
                                    <input type="number" wire:model="accessoryPrice" placeholder="Enter price"
                                           class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['accessoryPrice'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i
                                            class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="w-full flex flex-col gap-1">
                                    <label class="font-semibold text-primary">Description </label>
                                    <textarea wire:model="accessoryDescription" rows="3" placeholder="Enter description"
                                              class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"></textarea>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['accessoryDescription'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i
                                            class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="w-full flex flex-col gap-1">
                                    <label class="font-semibold text-primary">Status </label>
                                    <select wire:model="accessoryStatus"
                                            class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                        <option value="available">Available</option>
                                        <option value="notAvailable">Not Available</option>
                                    </select>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['accessoryStatus'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i
                                            class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="w-full flex flex-col gap-1">
                                    <label class="font-semibold text-primary">Photo </label>
                                    <span class="text-danger text-xs">*Max size: 2MB</span>
                                    <input type="file" wire:model="accessoryPhoto" accept="image/*"
                                           class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <div wire:loading wire:target="accessoryPhoto" class="text-sm text-danger"><i
                                            class="fas fa-hourglass-half fa-spin mr-2"></i> Uploading file... Please
                                        wait
                                    </div>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['accessoryPhoto'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i
                                            class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                            <div class="flex justify-end space-x-3 mt-4">
                                <button type="button" wire:click="$set('showAccessoryModal', false)"
                                        class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                                    Back
                                </button>
                                <button type="submit" id="submitButton"
                                        class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                                    <span wire:loading.remove wire:target="submitAccessory">Submit Accessory</span>
                                    <span wire:loading wire:target="submitAccessory">Submitting... <i
                                            class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        <?php endif; ?>

    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create instrument')): ?>
        <!--[if BLOCK]><![endif]--><?php if($showStatusModal): ?>
            <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50">
                <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                    <h3 class="text-lg font-semibold mb-4 text-primary">Update Instrument Status</h3>
                    <form wire:submit.prevent="confirmStatusUpdate">
                        <div class="w-full flex flex-col gap-4">
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Status <span
                                        class="text-danger">*</span></label>
                                <select wire:model.live="selectedStatus" required
                                        class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <option value="">Select Status</option>
                                    <option value="working">Working</option>
                                    <option value="under_maintenance">Under Maintenance</option>
                                    <option value="calibration_required">Calibration Required</option>
                                    <option value="faulty">Faulty</option>
                                    <option value="retired">Retired/ Obsolete</option>
                                </select>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedStatus'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i
                                        class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                        <div class="flex justify-end space-x-3 mt-4">
                            <button type="button" wire:click="$set('showStatusModal', false)"
                                    class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                                Back
                            </button>
                            <button type="submit"
                                    class="text-sm bg-primary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/90 text-ternary hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                                <span wire:loading.remove wire:target="confirmStatusUpdate">Update Status</span>
                                <span wire:loading wire:target="confirmStatusUpdate">Updating... <i
                                        class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php endif; ?>

    <!--[if BLOCK]><![endif]--><?php if($showPricingModal): ?>
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                <h3 class="text-lg font-semibold mb-4 text-primary">Instrument Pricing Details</h3>
                <!--[if BLOCK]><![endif]--><?php if($selectedInstrumentForPricing): ?>
                    <div class="w-full flex flex-col gap-4">
                        <!--[if BLOCK]><![endif]--><?php if($selectedInstrumentForPricing->booking_type == 'slot' || $selectedInstrumentForPricing->booking_type == 'both'): ?>
                            <div class="w-full flex flex-col gap-2">
                               <!--[if BLOCK]><![endif]--><?php if(isset($selectedInstrumentForPricing->booking_cost['internal']['slot'])): ?>
                                <h4 class="font-semibold text-primary">Slot Based Pricing</h4>
                                <div class="grid grid-cols-2 gap-2 text-sm">
                                    <span>Internal:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['internal']['slot'] ?? 'N/A'); ?> + <?php echo e($selectedInstrumentForPricing->booking_cost['internal']['slot_gst'] ?? 'N/A'); ?>% GST</span>
                                    <span>Other Educational:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['other_educational_institute']['slot'] ?? 'N/A'); ?> + <?php echo e($selectedInstrumentForPricing->booking_cost['other_educational_institute']['slot_gst'] ?? 'N/A'); ?>% GST</span>
                                    <span>R&D Labs:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['r_and_d_labs']['slot'] ?? 'N/A'); ?> + <?php echo e($selectedInstrumentForPricing->booking_cost['r_and_d_labs']['slot_gst'] ?? 'N/A'); ?>% GST</span>
                                    <span>Industries:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['industries']['slot'] ?? 'N/A'); ?> + <?php echo e($selectedInstrumentForPricing->booking_cost['industries']['slot_gst'] ?? 'N/A'); ?>% GST</span>
                                    <span>Startups:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['startups']['slot'] ?? 'N/A'); ?> + <?php echo e($selectedInstrumentForPricing->booking_cost['startups']['slot_gst'] ?? 'N/A'); ?>% GST</span>
                                </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                               <!--[if BLOCK]><![endif]--><?php if(isset($selectedInstrumentForPricing->booking_cost['internal']['booking'])): ?>
                                <h4 class="font-semibold text-primary">Booking Based Pricing</h4>
                                <div class="grid grid-cols-2 gap-2 text-sm">
                                    <span>Internal:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['internal']['booking'] ?? 'N/A'); ?> + <?php echo e($selectedInstrumentForPricing->booking_cost['internal']['booking_gst'] ?? 'N/A'); ?>% GST</span>
                                    <span>Other Educational:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['other_educational_institute']['booking'] ?? 'N/A'); ?> + <?php echo e($selectedInstrumentForPricing->booking_cost['other_educational_institute']['booking_gst'] ?? 'N/A'); ?>% GST</span>
                                    <span>R&D Labs:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['r_and_d_labs']['booking'] ?? 'N/A'); ?> + <?php echo e($selectedInstrumentForPricing->booking_cost['r_and_d_labs']['booking_gst'] ?? 'N/A'); ?>% GST</span>
                                    <span>Industries:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['industries']['booking'] ?? 'N/A'); ?> + <?php echo e($selectedInstrumentForPricing->booking_cost['industries']['booking_gst'] ?? 'N/A'); ?>% GST</span>
                                    <span>Startups:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['startups']['booking'] ?? 'N/A'); ?> + <?php echo e($selectedInstrumentForPricing->booking_cost['startups']['booking_gst'] ?? 'N/A'); ?>% GST</span>
                                </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <!--[if BLOCK]><![endif]--><?php if($selectedInstrumentForPricing->booking_type == 'sample' || $selectedInstrumentForPricing->booking_type == 'both'): ?>
                            <div class="w-full flex flex-col gap-2">
                                <h4 class="font-semibold text-primary">Sample Based Pricing</h4>
                                <div class="grid grid-cols-2 gap-2 text-sm">
                                    <span>Internal:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['internal']['sample'] ?? 'N/A'); ?>+ <?php echo e($selectedInstrumentForPricing->booking_cost['internal']['sample_gst'] ?? 'N/A'); ?>% GST</span>
                                    <span>Other Educational:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['other_educational_institute']['sample'] ?? 'N/A'); ?>+ <?php echo e($selectedInstrumentForPricing->booking_cost['other_educational_institute']['sample_gst'] ?? 'N/A'); ?>% GST</span>
                                    <span>R&D Labs:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['r_and_d_labs']['sample'] ?? 'N/A'); ?>+ <?php echo e($selectedInstrumentForPricing->booking_cost['r_and_d_labs']['sample_gst'] ?? 'N/A'); ?>% GST</span>
                                    <span>Industries:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['industries']['sample'] ?? 'N/A'); ?>+ <?php echo e($selectedInstrumentForPricing->booking_cost['industries']['sample_gst'] ?? 'N/A'); ?>% GST</span>
                                    <span>Startups:</span>
                                    <span class="font-semibold">₹<?php echo e($selectedInstrumentForPricing->booking_cost['startups']['sample'] ?? 'N/A'); ?>+ <?php echo e($selectedInstrumentForPricing->booking_cost['startups']['sample_gst'] ?? 'N/A'); ?>% GST</span>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                    <div class="flex justify-end space-x-3 mt-4">
                        <button wire:click="hidePricingModal"
                                class="text-sm bg-danger/20 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/90 text-danger hover:text-white hover:bg-danger hover:border-danger/30 transition ease-in duration-2000">
                            Close
                        </button>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!--[if BLOCK]><![endif]--><?php if($showInstrumentTermsForm): ?>
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 h-screen py-20 overflow-y-auto">
            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('instruments.instrument-terms-form', ['instrument' => $addTermsForInstrument]);

$__html = app('livewire')->mount($__name, $__params, 'lw-1595615946-3', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!--[if BLOCK]><![endif]--><?php if($showQrCodeModal): ?>
            <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 h-screen py-20 overflow-y-auto">
                <div class="bg-white rounded-lg shadow-xl w-full max-w-md">
                    <!-- Modal Header -->
                    <div class="flex justify-between items-center border-b px-6 py-4">
                        <h3 class="text-lg font-semibold">Instrument QR Code</h3>
                        <button wire:click="$set('showQrCodeModal', false)" class="text-gray-500 hover:text-gray-700">
                            <i class="fa fa-times"></i>
                        </button>
                    </div>

                    <!-- Modal Content -->
                    <div class="p-6">
                        <div class="flex flex-col items-center">
                            <!--[if BLOCK]><![endif]--><?php if($qrCodeData): ?>
                                <img src="<?php echo e($qrCodeData); ?>" alt="QR Code" class="w-64 h-64">
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <div class="text-center">
                                <h4 class="font-medium text-gray-900"><?php echo e($instrument->name); ?></h4>
                            </div>

                            <!-- Updated printing section -->
                            <div class="mt-6 w-full">
                                <div class="flex items-center justify-center gap-2">
                                    <input type="number" wire:model="qrCodeCount" min="1" max="100" placeholder="How many qr codes?"
                                           class="px-2 py-1 w-20 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                    <button wire:click="printQrCodes(<?php echo e($instrument->id); ?>)"
                                            class="px-4 py-1 bg-primary text-white rounded hover:bg-primary-dark transition">
                                        Print QR Codes
                                    </button>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['qrCodeCount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="text-red-500 text-xs mt-1 text-center"><?php echo e($message); ?></p>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        </div>
                    </div>

                    <!-- Modal Footer -->
                    <div class="border-t px-6 py-3 bg-gray-50 flex justify-end">
                        <button wire:click="$set('showQrCodeModal', false)"
                                class="px-4 py-2 bg-danger text-white rounded hover:bg-primary-dark transition">
                            Close
                        </button>
                    </div>
                </div>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH /home1/kinkarlab/public_html/resources/views/livewire/instruments/instrument-list.blade.php ENDPATH**/ ?>