<div>
    <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('success')); ?>

            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!-- Stats Cards -->
    <div class="w-full grid xl:grid-cols-4 lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-4 mb-6">
        <!-- Top Booked Instrument -->
        <div class="bg-white border-[1px] border-t-[4px] border-primary/20 border-t-primary shadow-lg shadow-gray-300 p-4 rounded-lg">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-sm font-medium text-gray-500">Top Booked Instrument</h3>
                    <p class="text-2xl font-bold text-primary"><?php echo e($statsData['top_instrument']); ?></p>
                    <p class="text-xs text-gray-400"><?php echo e($statsData['top_instrument_count']); ?> bookings</p>
                </div>
                <div class="bg-primary/10 p-3 rounded-full">
                    <i class="fa fa-trophy text-primary text-xl"></i>
                </div>
            </div>
        </div>

        <!-- Today's Bookings -->
        <div class="bg-white border-[1px] border-t-[4px] border-success/20 border-t-success shadow-lg shadow-gray-300 p-4 rounded-lg">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-sm font-medium text-gray-500">Today's Bookings</h3>
                    <p class="text-2xl font-bold text-success"><?php echo e($statsData['today_bookings']); ?></p>
                    <p class="text-xs text-gray-400"><?php echo e($statsData['today_usage_hours']); ?> hours</p>
                </div>
                <div class="bg-success/10 p-3 rounded-full">
                    <i class="fa fa-calendar-day text-success text-xl"></i>
                </div>
            </div>
        </div>

        <!-- This Month's Bookings -->
        <div class="bg-white border-[1px] border-t-[4px] border-warning/20 border-t-warning shadow-lg shadow-gray-300 p-4 rounded-lg">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-sm font-medium text-gray-500">This Month's Bookings</h3>
                    <p class="text-2xl font-bold text-warning"><?php echo e($statsData['month_bookings']); ?></p>
                    <p class="text-xs text-gray-400"><?php echo e(now()->format('M Y')); ?></p>
                </div>
                <div class="bg-warning/10 p-3 rounded-full">
                    <i class="fa fa-calendar-alt text-warning text-xl"></i>
                </div>
            </div>
        </div>

        <!-- Total Instruments -->
        <div class="bg-white border-[1px] border-t-[4px] border-danger/20 border-t-danger shadow-lg shadow-gray-300 p-4 rounded-lg">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-sm font-medium text-gray-500">Total Instruments</h3>
                    <p class="text-2xl font-bold text-danger"><?php echo e(\App\Models\Instrument::count()); ?></p>
                    <p class="text-xs text-gray-400">Active instruments</p>
                </div>
                <div class="bg-danger/10 p-3 rounded-full">
                    <i class="fa fa-microscope text-danger text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Instrument Usage Section -->
    <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300 mb-6">
        <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between items-center">
            <span class="font-semibold text-primary text-xl">Instrument Usage</span>
            <div class="flex items-center gap-2">
                <label class="text-sm font-medium text-primary">Date:</label>
                <input type="date" wire:model.live="selectedDate" 
                       class="px-2 py-1 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
            </div>
        </div>
        
        <div class="w-full overflow-x-auto p-4">
            <table class="w-full border-[2px] border-secondary/40 border-collapse">
                <thead>
                    <tr>
                        <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Sr. No.</th>
                        <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Instrument</th>
                        <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Lab</th>
                        <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Today's Usage (hrs)</th>
                        <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Overall Usage (hrs)</th>
                        <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Today's Bookings</th>
                    </tr>
                </thead>
                <tbody>
                    <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $this->paginatedInstrumentData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $instrument): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-secondary/10 transition ease-in duration-200">
                            <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e((($instrumentPage - 1) * $perPage) + $index + 1); ?></td>
                            <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e($instrument['name']); ?></td>
                            <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e($instrument['lab']); ?></td>
                            <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                <span class="bg-success/10 text-success px-2 py-1 rounded-full text-xs"><?php echo e($instrument['today_usage']); ?></span>
                            </td>
                            <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                <span class="bg-primary/10 text-primary px-2 py-1 rounded-full text-xs"><?php echo e($instrument['overall_usage']); ?></span>
                            </td>
                            <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e($instrument['today_bookings']); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="border-[2px] border-secondary/40 px-4 py-8 text-center text-gray-500">
                                <div class="flex flex-col items-center">
                                    <i class="fa fa-microscope text-4xl text-gray-300 mb-2"></i>
                                    <p>No instrument usage data found for selected date</p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </tbody>
            </table>
            
            <!-- Instrument Pagination -->
            <!--[if BLOCK]><![endif]--><?php if($this->instrumentTotalPages > 1): ?>
                <div class="mt-4 flex justify-between items-center">
                    <div class="text-sm text-gray-500">
                        Showing <?php echo e((($instrumentPage - 1) * $perPage) + 1); ?> to <?php echo e(min($instrumentPage * $perPage, count($instrumentUsageData))); ?> of <?php echo e(count($instrumentUsageData)); ?> results
                    </div>
                    <div class="flex items-center gap-2">
                        <button wire:click="previousInstrumentPage" 
                                <?php if($instrumentPage <= 1): ?> disabled <?php endif; ?>
                                class="px-3 py-1 text-sm bg-primary/20 text-primary rounded hover:bg-primary hover:text-white transition disabled:opacity-50 disabled:cursor-not-allowed">
                            Previous
                        </button>
                        
                        <!--[if BLOCK]><![endif]--><?php for($i = 1; $i <= $this->instrumentTotalPages; $i++): ?>
                            <button wire:click="gotoInstrumentPage(<?php echo e($i); ?>)"
                                    class="px-3 py-1 text-sm rounded transition <?php echo e($instrumentPage == $i ? 'bg-primary text-white' : 'bg-gray-200 text-gray-700 hover:bg-primary hover:text-white'); ?>">
                                <?php echo e($i); ?>

                            </button>
                        <?php endfor; ?><!--[if ENDBLOCK]><![endif]-->
                        
                        <button wire:click="nextInstrumentPage" 
                                <?php if($instrumentPage >= $this->instrumentTotalPages): ?> disabled <?php endif; ?>
                                class="px-3 py-1 text-sm bg-primary/20 text-primary rounded hover:bg-primary hover:text-white transition disabled:opacity-50 disabled:cursor-not-allowed">
                            Next
                        </button>
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>

    <!-- Student Usage Section -->
    <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">
        <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between items-center">
            <span class="font-semibold text-primary text-xl">Student Usage Tracker</span>
            <div class="flex items-center gap-2">
                <label class="text-sm font-medium text-primary">Date:</label>
                <input type="date" wire:model.live="selectedDate" 
                       class="px-2 py-1 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"/>
            </div>
        </div>
        
        <div class="w-full overflow-x-auto p-4">
            <table class="w-full border-[2px] border-secondary/40 border-collapse">
                <thead>
                    <tr>
                        <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Sr. No.</th>
                        <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Student</th>
                        <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Academic ID</th>
                        <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">PI</th>
                        <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Today's Usage (hrs)</th>
                        <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Overall Usage (hrs)</th>
                        <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Today's Bookings</th>
                    </tr>
                </thead>
                <tbody>
                    <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $this->paginatedStudentData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-secondary/10 transition ease-in duration-200">
                            <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e((($studentPage - 1) * $perPage) + $index + 1); ?></td>
                            <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e($student['name']); ?></td>
                            <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e($student['academic_id']); ?></td>
                            <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e($student['pi_name']); ?></td>
                            <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                <span class="bg-success/10 text-success px-2 py-1 rounded-full text-xs"><?php echo e($student['today_usage']); ?></span>
                            </td>
                            <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                <span class="bg-primary/10 text-primary px-2 py-1 rounded-full text-xs"><?php echo e($student['overall_usage']); ?></span>
                            </td>
                            <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e($student['today_bookings']); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="border-[2px] border-secondary/40 px-4 py-8 text-center text-gray-500">
                                <div class="flex flex-col items-center">
                                    <i class="fa fa-user-graduate text-4xl text-gray-300 mb-2"></i>
                                    <p>No student usage data found for selected date</p>
                                </div>
                            </td>
                        </tr>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </tbody>
            </table>
            
            <!-- Student Pagination -->
            <!--[if BLOCK]><![endif]--><?php if($this->studentTotalPages > 1): ?>
                <div class="mt-4 flex justify-between items-center">
                    <div class="text-sm text-gray-500">
                        Showing <?php echo e((($studentPage - 1) * $perPage) + 1); ?> to <?php echo e(min($studentPage * $perPage, count($studentUsageData))); ?> of <?php echo e(count($studentUsageData)); ?> results
                    </div>
                    <div class="flex items-center gap-2">
                        <button wire:click="previousStudentPage" 
                                <?php if($studentPage <= 1): ?> disabled <?php endif; ?>
                                class="px-3 py-1 text-sm bg-primary/20 text-primary rounded hover:bg-primary hover:text-white transition disabled:opacity-50 disabled:cursor-not-allowed">
                            Previous
                        </button>
                        
                        <!--[if BLOCK]><![endif]--><?php for($i = 1; $i <= $this->studentTotalPages; $i++): ?>
                            <button wire:click="gotoStudentPage(<?php echo e($i); ?>)"
                                    class="px-3 py-1 text-sm rounded transition <?php echo e($studentPage == $i ? 'bg-primary text-white' : 'bg-gray-200 text-gray-700 hover:bg-primary hover:text-white'); ?>">
                                <?php echo e($i); ?>

                            </button>
                        <?php endfor; ?><!--[if ENDBLOCK]><![endif]-->
                        
                        <button wire:click="nextStudentPage" 
                                <?php if($studentPage >= $this->studentTotalPages): ?> disabled <?php endif; ?>
                                class="px-3 py-1 text-sm bg-primary/20 text-primary rounded hover:bg-primary hover:text-white transition disabled:opacity-50 disabled:cursor-not-allowed">
                            Next
                        </button>
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>
</div><?php /**PATH /home1/kinkarlab/iitr.kinkarlab.com/resources/views/livewire/usage/super-admin-usage.blade.php ENDPATH**/ ?>