<div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">

    <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('success')); ?>

            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php if(session()->has('error')): ?>
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('error')); ?>

            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php if(session()->has('info')): ?>
        <div id="infoMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-info bg-blue-100 border-l-4 border-blue-500 text-blue-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('info')); ?>

            <div onclick="document.getElementById('infoMessage').classList.add('hidden')"
                 class="cursor-pointer bg-blue-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between flex-wrap">
        <span class="font-semibold text-primary text-xl">Stock Management</span>
        <div class="flex items-center gap-2 justify-end">




            <span wire:click="toggleStockIntakeModal"
                  class="text-sm bg-primary/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                <i class="fa fa-plus mr-2"></i>Stock Intake
            </span>
        </div>
    </div>

        <div class="w-full flex flex-col xl:flex-row justify-between gap-4 px-4">
            <div class="flex flex-col sm:flex-row gap-2">
                <button wire:click="exportTransactions"
                        class="text-sm bg-success/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/80 text-white hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000 disabled:opacity-50 disabled:cursor-not-allowed"
                        wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="exportTransactions">
                        <i class="fa fa-file-excel mr-2"></i>Excel
                    </span>
                    <span wire:loading wire:target="exportTransactions">
                        <i class="fas fa-hourglass-half fa-spin mr-2"></i>Exporting...
                    </span>
                </button>

                <button wire:click="exportTransactionsPdf"
                        class="text-sm bg-danger/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/80 text-white hover:text-white hover:bg-danger hover:border-ternary/30 transition ease-in duration-2000 disabled:opacity-50 disabled:cursor-not-allowed"
                        wire:loading.attr="disabled">
                    <span wire:loading.remove wire:target="exportTransactionsPdf">
                        <i class="fa fa-file-pdf mr-2"></i>PDF
                    </span>
                    <span wire:loading wire:target="exportTransactionsPdf">
                        <i class="fas fa-hourglass-half fa-spin mr-2"></i>Exporting...
                    </span>
                </button>
            </div>
            <div class="flex flex-col sm:flex-row lg:flex-wrap xl:flex-nowrap gap-2">

                <select wire:model.live="itemFilter"
                        class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">All Items</option>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $inventoryItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>

                <select wire:model.live="supplierFilter"
                        class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">All Suppliers</option>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </select>

                <select wire:model.live="statusFilter"
                        class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <option value="">All Status</option>
                    <option value="expired">Expired</option>
                    <option value="expiring_soon">Expiring Soon</option>
                    <option value="low_stock">Low Stock</option>
                    <option value="out_of_stock">Out of Stock</option>
                </select>

                <input type="date" wire:model.live="dateFrom" placeholder="From Date"
                       class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">

                <input type="date" wire:model.live="dateTo" placeholder="To Date"
                       class="px-3 py-1.5 text-sm font-medium bg-white border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">







                <div class="relative">
                    <input type="text" wire:model.live.debounce.500ms="search" placeholder="Search batches..."
                           class="px-3 py-1.5 max-w-64 text-sm font-medium bg-white placeholder-gray-500 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                    <!--[if BLOCK]><![endif]--><?php if($search): ?>
                        <button wire:click="$set('search', '')" class="absolute right-3 top-1/2 -translate-y-1/2 text-gray-400 hover:text-danger">
                            <i class="fa fa-times"></i>
                        </button>
                    <?php else: ?>
                        <span class="absolute right-3 top-1/2 -translate-y-1/2 text-success">
                        <i class="fa fa-search"></i>
                    </span>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        </div>

    <div class="w-full overflow-x-auto p-4 pt-0">
        <!--[if BLOCK]><![endif]--><?php if($stockBatches->count() > 0): ?>
            <div class="overflow-x-auto">
                <table class="w-full border-[2px] border-secondary/40 border-collapse"
                       wire:loading.class="opacity-25">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Sr. No.</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Batch Number</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Item</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Variant</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Supplier</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Quantity</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Expiry Date</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Status</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md text-left whitespace-nowrap">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $stockBatches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $batch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-secondary/10 transition ease-in duration-2000">
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <?php echo e(($stockBatches->currentPage() - 1) * $stockBatches->perPage() + $index + 1); ?>

                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <div class="flex items-center">
                                        <i class="fa fa-barcode text-primary mr-2"></i>
                                        <div>
                                            <div class="font-semibold"><?php echo e($batch->batch_number); ?></div>
                                            <div class="text-xs text-gray-500">
                                                Received: <?php echo e($batch->received_date->format('M d, Y')); ?>

                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <!--[if BLOCK]><![endif]--><?php if($batch->batchItems->count() > 0): ?>
                                        <div class="space-y-2">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batch->batchItems->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batchItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="flex items-start">
                                                    <i class="fa <?php echo e($batchItem->inventoryItem->item_type === 'chemical' ? 'fa-flask' : 'fa-box'); ?> text-primary mr-2 text-xs mt-1"></i>
                                                    <div>
                                                        <div class="font-semibold text-sm"><?php echo e($batchItem->inventoryItem->name); ?></div>
                                                        <span class="px-2 py-1 text-xs font-medium rounded-full
                                                            <?php echo e($batchItem->inventoryItem->item_type === 'chemical' ? 'bg-purple-100 text-purple-800' : 'bg-blue-100 text-blue-800'); ?>">
                                                            <?php echo e(ucfirst($batchItem->inventoryItem->item_type)); ?>

                                                        </span>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($batch->batchItems->count() > 3): ?>
                                                <div class="text-xs text-gray-500 text-center py-1">
                                                    <i class="fa fa-ellipsis-h mr-1"></i>+<?php echo e($batch->batchItems->count() - 3); ?> more items
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    <?php else: ?>
                                        <span class="text-gray-400 text-xs">No items</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <!--[if BLOCK]><![endif]--><?php if($batch->batchItems->count() > 0): ?>
                                        <div class="space-y-2">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batch->batchItems->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batchItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <!--[if BLOCK]><![endif]--><?php if($batchItem->variant): ?>
                                                    <div class="text-xs bg-gradient-to-r from-purple-50 to-purple-100 px-2 py-1 rounded border border-purple-200">
                                                        <span class="font-medium text-purple-800 flex items-center">
                                                            <i class="fa <?php echo e($batchItem->variant->isLiquidUnit() ? 'fa-flask' : 'fa-weight-hanging'); ?> mr-1 text-xs"></i>
                                                            <?php echo e($batchItem->variant->display_name); ?>

                                                        </span>
                                                        <!--[if BLOCK]><![endif]--><?php if($batchItem->variant->barcode): ?>
                                                            <div class="text-purple-600 text-xs mt-1">
                                                                <i class="fa fa-barcode mr-1"></i><?php echo e($batchItem->variant->barcode); ?>

                                                            </div>
                                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                    </div>
                                                <?php else: ?>
                                                    <span class="text-gray-400 text-xs">N/A</span>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    <?php else: ?>
                                        <span class="text-gray-400 text-xs">N/A</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <!--[if BLOCK]><![endif]--><?php if($batch->supplier): ?>
                                        <div>
                                            <div class="font-semibold"><?php echo e($batch->supplier->name); ?></div>
                                            <!--[if BLOCK]><![endif]--><?php if($batch->supplier->contact_person): ?>
                                                <div class="text-xs text-gray-500"><?php echo e($batch->supplier->contact_person); ?></div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    <?php else: ?>
                                        <span class="text-gray-400">Not specified</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <?php
                                        // Calculate totals from batch items
                                        $totalInitialQuantity = $batch->batchItems->sum('initial_quantity');
                                        $totalCurrentQuantity = $batch->batchItems->sum('current_quantity');
                                        $usagePercentage = $totalInitialQuantity > 0 ? (($totalInitialQuantity - $totalCurrentQuantity) / $totalInitialQuantity) * 100 : 0;
                                        $isLowStock = $totalCurrentQuantity <= ($totalInitialQuantity * 0.2);
                                        $isFullyUsed = $totalCurrentQuantity <= 0;
                                    ?>

                                    <!--[if BLOCK]><![endif]--><?php if($batch->batchItems->count() > 0): ?>
                                        <div class="space-y-2">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batch->batchItems->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batchItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $itemUsagePercentage = $batchItem->initial_quantity > 0 ? (($batchItem->initial_quantity - $batchItem->current_quantity) / $batchItem->initial_quantity) * 100 : 0;
                                                    $itemIsLowStock = $batchItem->current_quantity <= ($batchItem->initial_quantity * 0.2);
                                                    $itemIsFullyUsed = $batchItem->current_quantity <= 0;
                                                ?>
                                                <div class="text-xs border border-gray-200 rounded p-2">
                                                    <div class="font-medium text-gray-700 mb-1"><?php echo e($batchItem->inventoryItem->name); ?></div>
                                                    <div class="flex items-center justify-between mb-1">
                                                        <span class="text-xs">Current:</span>
                                                        <span class="px-1 py-0.5 text-xs font-medium rounded
                                                            <?php echo e($itemIsFullyUsed ? 'bg-red-100 text-red-800' : ($itemIsLowStock ? 'bg-yellow-100 text-yellow-800' : 'bg-green-100 text-green-800')); ?>">
                                                            <?php echo e($batchItem->formatted_current_quantity); ?>

                                                        </span>
                                                    </div>
                                                    <div class="flex items-center justify-between mb-1">
                                                        <span class="text-xs text-gray-500">Initial:</span>
                                                        <span class="text-xs text-gray-600"><?php echo e($batchItem->formatted_initial_quantity); ?></span>
                                                    </div>
                                                    <div class="w-full bg-gray-200 rounded-full h-1">
                                                        <div class="bg-gradient-to-r from-green-400 to-green-600 h-1 rounded-full transition-all duration-300"
                                                             style="width: <?php echo e(100 - $itemUsagePercentage); ?>%"></div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($batch->batchItems->count() > 3): ?>
                                                <div class="text-xs text-gray-500 text-center py-1">
                                                    <i class="fa fa-ellipsis-h mr-1"></i>+<?php echo e($batch->batchItems->count() - 3); ?> more items
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    <?php else: ?>
                                        <span class="text-gray-400 text-xs">No items</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <!--[if BLOCK]><![endif]--><?php if($batch->batchItems->count() > 0): ?>
                                        <div class="space-y-2">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batch->batchItems->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batchItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <!--[if BLOCK]><![endif]--><?php if($batchItem->expiry_date): ?>
                                                    <?php
                                                        $isExpired = $batchItem->isExpired();
                                                        $isExpiringSoon = $batchItem->isExpiringSoon();
                                                    ?>
                                                    <div class="text-xs border border-gray-200 rounded p-2">
                                                        <div class="font-medium text-gray-700 mb-1"><?php echo e($batchItem->inventoryItem->name); ?></div>
                                                        <div class="text-sm font-medium
                                                            <?php echo e($isExpired ? 'text-red-600' : ($isExpiringSoon ? 'text-yellow-600' : 'text-green-600')); ?>">
                                                            <?php echo e($batchItem->expiry_date->format('M d, Y')); ?>

                                                        </div>
                                                        <!--[if BLOCK]><![endif]--><?php if($isExpired): ?>
                                                            <span class="px-1 py-0.5 text-xs font-medium rounded bg-red-100 text-red-800">
                                                                <i class="fa fa-exclamation-triangle mr-1"></i>Expired
                                                            </span>
                                                        <?php elseif($isExpiringSoon): ?>
                                                            <span class="px-1 py-0.5 text-xs font-medium rounded bg-yellow-100 text-yellow-800">
                                                                <?php
                                                                    $days = now()->diffInDays($batchItem->expiry_date, false);
                                                                    $roundedDays = floor(abs($days));
                                                                ?>
                                                                <i class="fa fa-clock mr-1"></i>
                                                                <?php echo e($roundedDays); ?> <?php echo e($days < 0 ? 'days ago' : 'days left'); ?>

                                                            </span>
                                                        <?php else: ?>
                                                            <span class="px-1 py-0.5 text-xs font-medium rounded bg-green-100 text-green-800">
                                                                <i class="fa fa-check mr-1"></i>Valid
                                                            </span>
                                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                    </div>
                                                <?php else: ?>
                                                    <div class="text-xs border border-gray-200 rounded p-2">
                                                        <div class="font-medium text-gray-700 mb-1"><?php echo e($batchItem->inventoryItem->name); ?></div>
                                                        <span class="text-gray-400 text-xs">No expiry</span>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($batch->batchItems->count() > 3): ?>
                                                <div class="text-xs text-gray-500 text-center py-1">
                                                    <i class="fa fa-ellipsis-h mr-1"></i>+<?php echo e($batch->batchItems->count() - 3); ?> more items
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    <?php else: ?>
                                        <span class="text-gray-400 text-xs">No items</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">
                                    <!--[if BLOCK]><![endif]--><?php if($batch->batchItems->count() > 0): ?>
                                        <div class="space-y-2">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batch->batchItems->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batchItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    $itemIsExpired = $batchItem->expiry_date && $batchItem->isExpired();
                                                    $itemIsExpiringSoon = $batchItem->expiry_date && $batchItem->isExpiringSoon();
                                                    $itemIsLowStock = $batchItem->current_quantity <= ($batchItem->initial_quantity * 0.2) && $batchItem->current_quantity > 0;
                                                    $itemIsFullyUsed = $batchItem->current_quantity <= 0;
                                                ?>
                                                <div class="text-xs border border-gray-200 rounded p-2">
                                                    <div class="font-medium text-gray-700 mb-1"><?php echo e($batchItem->inventoryItem->name); ?></div>
                                                    <!--[if BLOCK]><![endif]--><?php if($itemIsFullyUsed): ?>
                                                        <span class="px-1 py-0.5 text-xs font-medium rounded bg-gray-100 text-gray-800">
                                                            <i class="fa fa-check-circle mr-1"></i>Fully Used
                                                        </span>
                                                    <?php elseif($itemIsExpired): ?>
                                                        <span class="px-1 py-0.5 text-xs font-medium rounded bg-red-100 text-red-800">
                                                            <i class="fa fa-exclamation-triangle mr-1"></i>Expired
                                                        </span>
                                                    <?php elseif($itemIsExpiringSoon): ?>
                                                        <span class="px-1 py-0.5 text-xs font-medium rounded bg-yellow-100 text-yellow-800">
                                                            <i class="fa fa-clock mr-1"></i>Expiring Soon
                                                        </span>
                                                    <?php elseif($itemIsLowStock): ?>
                                                        <span class="px-1 py-0.5 text-xs font-medium rounded bg-yellow-100 text-yellow-800">
                                                            <i class="fa fa-exclamation-circle mr-1"></i>Low Stock
                                                        </span>
                                                    <?php else: ?>
                                                        <span class="px-1 py-0.5 text-xs font-medium rounded bg-green-100 text-green-800">
                                                            <i class="fa fa-check-circle mr-1"></i>Available
                                                        </span>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                    <div class="text-xs text-gray-500 mt-1">
                                                        Cost: $<?php echo e(number_format($batchItem->unit_cost, 2)); ?>

                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($batch->batchItems->count() > 3): ?>
                                                <div class="text-xs text-gray-500 text-center py-1">
                                                    <i class="fa fa-ellipsis-h mr-1"></i>+<?php echo e($batch->batchItems->count() - 3); ?> more items
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    <?php else: ?>
                                        <span class="text-gray-400 text-xs">No items</span>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                                    <div class="flex items-center gap-2">
                                        <button wire:click="openBatchViewModal(<?php echo e($batch->id); ?>)"
                                                class="text-purple-600 hover:text-purple-800 transition-colors"
                                                title="View Batch Items">
                                            <i class="fas fa-eye"></i>
                                        </button>

                                        <!--[if BLOCK]><![endif]--><?php if($batch->batchItems->where('current_quantity', '>', 0)->count() > 0): ?>
                                            <button wire:click="openStockOutModal(<?php echo e($batch->id); ?>)"
                                                    class="text-blue-600 hover:text-blue-800 transition-colors"
                                                    title="Stock Out">
                                                <i class="fas fa-minus-circle"></i>
                                            </button>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                        <button wire:click="openTransactionHistoryModal(<?php echo e($batch->id); ?>)"
                                                class="text-green-600 hover:text-green-800 transition-colors"
                                                title="Transaction History">
                                            <i class="fas fa-history"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="mt-4">
                <?php echo e($stockBatches->links()); ?>

            </div>
        <?php else: ?>
            <div class="text-center py-12 bg-gray-50 rounded-lg border-2 border-dashed border-gray-200">
                <div class="text-gray-400 mb-4">
                    <i class="fas fa-warehouse text-5xl"></i>
                </div>
                <h3 class="text-lg font-medium text-gray-600 mb-2">
                    <!--[if BLOCK]><![endif]--><?php if($search): ?>
                        No stock batches found for "<?php echo e($search); ?>"
                    <?php else: ?>
                        No Stock Batches Found
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </h3>
                <p class="text-gray-500 max-w-md mx-auto mb-4">
                    <!--[if BLOCK]><![endif]--><?php if($search): ?>
                        Try adjusting your search terms or clear the search to see all stock batches.
                    <?php else: ?>
                        You don't have any stock batches yet. Record your first stock intake to start tracking inventory.
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </p>
                <!--[if BLOCK]><![endif]--><?php if(!$search): ?>
                    <button wire:click="toggleStockIntakeModal"
                            class="bg-primary hover:bg-primary-dark text-white px-4 py-2 rounded-md inline-flex items-center transition-colors">
                        <i class="fas fa-plus mr-2"></i> Record Stock Intake
                    </button>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    </div>

    <!-- Stock Intake Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showStockIntakeModal): ?>
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-4xl w-full max-h-[90vh] overflow-y-auto">
                <h3 class="text-lg font-semibold mb-4 text-primary">Stock Intake</h3>
                <form wire:submit="saveStockIntake">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Batch Items Section -->
                        <div class="md:col-span-2">
                            <div class="flex justify-between items-center mb-4">
                                <h4 class="text-md font-semibold text-primary">Items in this Batch</h4>
                                <button type="button" wire:click="addBatchItem"
                                        class="text-sm bg-success/80 px-4 py-1 whitespace-nowrap rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/80 text-white hover:text-white hover:bg-success hover:border-ternary/30 transition ease-in duration-2000">
                                    <i class="fa fa-plus mr-2"></i>Add Item
                                </button>
                            </div>

                            <!--[if BLOCK]><![endif]--><?php if(count($batchItems) > 0): ?>
                                <div class="space-y-4">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batchItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $batchItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="border-[2px] border-secondary/40 rounded-md p-4">
                                            <div class="flex justify-between items-center mb-3">
                                                <h5 class="font-medium text-gray-700">Item <?php echo e($index + 1); ?></h5>
                                                <?php if(count($batchItems) > 1): ?>
                                                    <button type="button" wire:click="removeBatchItem(<?php echo e($index); ?>)"
                                                            class="text-red-600 hover:text-red-800 transition-colors"
                                                            title="Remove Item">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>

                                            <div class="grid grid-cols-1 md:grid-cols-2 gap-3">
                                                <!-- Item Selection -->
                                                <div>
                                                    <label class="font-semibold text-primary">Item <span class="text-danger">*</span></label>
                                                    <select wire:model.live="batchItems.<?php echo e($index); ?>.inventory_item_id"
                                                            class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                        <option value="">Select Item</option>
                                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $inventoryItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($item->id); ?>">
                                                                <?php echo e($item->name); ?> (<?php echo e(ucfirst($item->item_type)); ?>)
                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                    </select>
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ["batchItems.{$index}.inventory_item_id"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <!-- Variant Selection (for chemicals) -->
                                                <?php
                                                    $selectedItem = $batchItem['inventory_item_id'] ? $inventoryItems->find($batchItem['inventory_item_id']) : null;
                                                    $availableVariants = $selectedItem && $selectedItem->isChemical() ? $selectedItem->variants : collect();
                                                ?>
                                                <!--[if BLOCK]><![endif]--><?php if($selectedItem && $selectedItem->isChemical() && $availableVariants->count() > 0): ?>
                                                    <div>
                                                        <label class="font-semibold text-primary">Variant <span class="text-danger">*</span></label>
                                                        <select wire:model="batchItems.<?php echo e($index); ?>.item_variant_id"
                                                                class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                            <option value="">Select Variant</option>
                                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $availableVariants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($variant->id); ?>">
                                                                    <?php echo e($variant->display_name); ?>

                                                                    <!--[if BLOCK]><![endif]--><?php if($variant->barcode): ?> - <?php echo e($variant->barcode); ?> <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                                </option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                                        </select>
                                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ["batchItems.{$index}.item_variant_id"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                    </div>
                                                <?php else: ?>
                                                    <div></div> <!-- Empty div to maintain grid layout -->
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                                <!-- Initial Quantity -->
                                                <div>
                                                    <label class="font-semibold text-primary">
                                                        Initial Quantity <span class="text-danger">*</span>
                                                        <?php
                                                            $selectedVariant = $batchItem['item_variant_id'] ? $availableVariants->find($batchItem['item_variant_id']) : null;
                                                        ?>
                                                        <!--[if BLOCK]><![endif]--><?php if($selectedVariant): ?>
                                                            <span class="text-xs text-gray-500">(in <?php echo e($selectedVariant->unit_type); ?>)</span>
                                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                    </label>
                                                    <input type="number" step="0.01" wire:model="batchItems.<?php echo e($index); ?>.initial_quantity" min="0.01" placeholder="Enter quantity"
                                                           class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ["batchItems.{$index}.initial_quantity"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <!-- Unit Cost -->
                                                <div>
                                                    <label class="font-semibold text-primary">Unit Cost <span class="text-danger">*</span></label>
                                                    <input type="number" step="0.01" wire:model="batchItems.<?php echo e($index); ?>.unit_cost" min="0" placeholder="Enter unit cost"
                                                           class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ["batchItems.{$index}.unit_cost"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>

                                                <!-- Manufacturing Date -->
                                                <?php
                                                    $selectedItemForDates = $batchItem['inventory_item_id'] ? $inventoryItems->find($batchItem['inventory_item_id']) : null;
                                                ?>
                                                <!--[if BLOCK]><![endif]--><?php if($selectedItemForDates && $selectedItemForDates->isChemical()): ?>
                                                    <div>
                                                        <label class="font-semibold text-primary">Manufacture Date <span class="text-danger">*</span></label>
                                                        <input type="date" wire:model="batchItems.<?php echo e($index); ?>.manufacture_date" max="<?php echo e(date('Y-m-d')); ?>"
                                                               class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ["batchItems.{$index}.manufacture_date"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                    </div>

                                                    <!-- Expiry Date -->
                                                    <div>
                                                        <label class="font-semibold text-primary">Expiry Date <span class="text-danger">*</span></label>
                                                        <input type="date" wire:model="batchItems.<?php echo e($index); ?>.expiry_date" min="<?php echo e(date('Y-m-d', strtotime('+1 day'))); ?>"
                                                               class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ["batchItems.{$index}.expiry_date"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                    </div>
                                                <?php else: ?>
                                                    <!-- Optional dates for regular items -->
                                                    <div>
                                                        <label class="font-semibold text-primary">Manufacture Date</label>
                                                        <input type="date" wire:model="batchItems.<?php echo e($index); ?>.manufacture_date" max="<?php echo e(date('Y-m-d')); ?>"
                                                               class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ["batchItems.{$index}.manufacture_date"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                    </div>

                                                    <!-- Expiry Date -->
                                                    <div>
                                                        <label class="font-semibold text-primary">Expiry Date</label>
                                                        <input type="date" wire:model="batchItems.<?php echo e($index); ?>.expiry_date" min="<?php echo e(date('Y-m-d', strtotime('+1 day'))); ?>"
                                                               class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ["batchItems.{$index}.expiry_date"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                    </div>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                                <!-- Item Notes -->
                                                <div class="md:col-span-2">
                                                    <label class="font-semibold text-primary">Item Notes</label>
                                                    <textarea wire:model="batchItems.<?php echo e($index); ?>.notes" placeholder="Enter notes for this item (optional)" rows="2"
                                                              class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000 resize-none"></textarea>
                                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ["batchItems.{$index}.notes"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-xs"><i class="fa fa-triangle-exclamation mr-1"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php else: ?>
                                <p class="text-gray-500 text-sm bg-gray-50 p-4 rounded-lg border-2 border-dashed border-gray-200 text-center">
                                    No items added yet. Click "Add Item" to add items to this batch.
                                </p>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Batch Number -->
                        <div>
                            <label class="font-semibold text-primary">Batch Number <span class="text-danger">*</span></label>
                            <div class="flex gap-2">
                                <input type="text" wire:model="batch_number" wire:blur="validateBatchNumber" placeholder="Enter batch number"
                                       class="px-2 py-2 flex-1 text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <button type="button" wire:click="generateBatchNumber"
                                        class="px-3 py-2 text-sm bg-secondary/80 text-white rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] hover:bg-secondary transition-colors"
                                        title="Generate Batch Number">
                                    <i class="fa fa-refresh"></i>
                                </button>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['batch_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Supplier -->
                        <div>
                            <label class="font-semibold text-primary">Supplier</label>
                            <select wire:model="supplier_id"
                                    class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <option value="">Select Supplier (Optional)</option>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $suppliers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supplier): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($supplier->id); ?>"><?php echo e($supplier->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['supplier_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>



                        <!-- Received Date -->
                        <div>
                            <label class="font-semibold text-primary">Received Date <span class="text-danger">*</span></label>
                            <input type="date" wire:model="received_date" max="<?php echo e(date('Y-m-d')); ?>"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['received_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>



                        <!-- Notes -->
                        <div class="md:col-span-2">
                            <label class="font-semibold text-primary">Notes</label>
                            <textarea wire:model="notes" placeholder="Enter any additional notes (optional)" rows="3"
                                      class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000 resize-none"></textarea>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>

                    <!-- Modal Actions -->
                    <div class="flex justify-end gap-2 mt-6">
                        <button type="button" wire:click="closeStockIntakeModal"
                                class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-200 rounded-md hover:bg-gray-300 transition-colors">
                            Cancel
                        </button>
                        <button type="submit"
                                class="px-4 py-2 text-sm font-medium text-white bg-primary rounded-md hover:bg-primary-dark transition-colors">
                            <i class="fa fa-save mr-2"></i>Record Stock Intake
                        </button>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!-- Stock Out Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showStockOutModal): ?>
        <?php
            $selectedBatch = \App\Models\StockBatch::with(['batchItems.inventoryItem', 'batchItems.variant', 'supplier'])->find($selected_batch_id);
            $expiryWarning = $this->checkExpiryWarning();
        ?>
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-6xl w-full max-h-[90vh] overflow-y-auto">
                <h3 class="text-lg font-semibold mb-4 text-primary">Stock Out</h3>

                <!--[if BLOCK]><![endif]--><?php if($selectedBatch): ?>
                    <!-- Batch Information -->
                    <div class="bg-gray-50 p-4 rounded-lg mb-4">
                        <h4 class="font-semibold text-gray-700 mb-2">Batch Information</h4>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm">
                            <div>
                                <span class="font-medium text-gray-600">Batch Number:</span>
                                <span class="ml-2 font-semibold"><?php echo e($selectedBatch->batch_number); ?></span>
                            </div>
                            <div>
                                <span class="font-medium text-gray-600">Received Date:</span>
                                <span class="ml-2"><?php echo e($selectedBatch->received_date->format('M d, Y')); ?></span>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php if($selectedBatch->supplier): ?>
                                <div>
                                    <span class="font-medium text-gray-600">Supplier:</span>
                                    <span class="ml-2"><?php echo e($selectedBatch->supplier->name); ?></span>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <!--[if BLOCK]><![endif]--><?php if($selectedBatch->expiry_date): ?>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm mt-2">
                                <div>
                                    <span class="font-medium text-gray-600">Expiry Date:</span>
                                    <span class="ml-2 <?php echo e($selectedBatch->isExpired() ? 'text-red-600 font-semibold' : ($selectedBatch->isExpiringSoon() ? 'text-yellow-600' : 'text-green-600')); ?>">
                                        <?php echo e($selectedBatch->expiry_date->format('M d, Y')); ?>

                                    </span>
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!-- Expiry Warning -->
                    <!--[if BLOCK]><![endif]--><?php if($expiryWarning): ?>
                        <div class="mb-4 p-4 rounded-lg border-l-4
                            <?php echo e($expiryWarning['type'] === 'expired' ? 'bg-red-50 border-red-400' : 'bg-yellow-50 border-yellow-400'); ?>">
                            <div class="flex items-center">
                                <i class="fa <?php echo e($expiryWarning['type'] === 'expired' ? 'fa-exclamation-triangle text-red-500' : 'fa-clock text-yellow-500'); ?> mr-2"></i>
                                <span class="font-medium <?php echo e($expiryWarning['type'] === 'expired' ? 'text-red-800' : 'text-yellow-800'); ?>">
                                    <?php echo e($expiryWarning['type'] === 'expired' ? 'Expired Item Warning' : 'Expiry Notice'); ?>

                                </span>
                            </div>
                            <p class="mt-1 text-sm <?php echo e($expiryWarning['type'] === 'expired' ? 'text-red-700' : 'text-yellow-700'); ?>">
                                <?php echo e($expiryWarning['message']); ?>

                            </p>
                            <!--[if BLOCK]><![endif]--><?php if($expiryWarning['type'] === 'expired'): ?>
                                <div class="mt-3">
                                    <label class="flex items-center">
                                        <input type="checkbox" wire:model="override_expiry" class="mr-2">
                                        <span class="text-sm font-medium text-red-800">I acknowledge this item is expired and approve its usage</span>
                                    </label>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['override_expiry'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 text-sm block mt-1"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                    <!-- Available Items for Stock Out -->
                    <div class="mb-6">
                        <h4 class="font-semibold text-gray-700 mb-3">Select Items to Stock Out</h4>
                        <!--[if BLOCK]><![endif]--><?php if(count($stockOutItems) > 0): ?>
                            <div class="overflow-x-auto">
                                <table class="w-full border-[2px] border-secondary/40 border-collapse">
                                    <thead class="bg-gray-50">
                                        <tr>
                                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Select</th>
                                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Item</th>
                                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Variant</th>
                                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Available</th>
                                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Quantity to Use</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $stockOutItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $stockOutItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr class="hover:bg-secondary/10 transition ease-in duration-2000">
                                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-center">
                                                    <input type="checkbox" wire:model="stockOutItems.<?php echo e($index); ?>.selected" class="rounded">
                                                </td>
                                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                                    <div class="font-semibold"><?php echo e($stockOutItem['item_name']); ?></div>
                                                </td>
                                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                                    <!--[if BLOCK]><![endif]--><?php if($stockOutItem['variant_name']): ?>
                                                        <div class="text-xs bg-gradient-to-r from-purple-50 to-purple-100 px-2 py-1 rounded border border-purple-200">
                                                            <span class="font-medium text-purple-800"><?php echo e($stockOutItem['variant_name']); ?></span>
                                                        </div>
                                                    <?php else: ?>
                                                        <span class="text-gray-400 text-xs">N/A</span>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </td>
                                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                                    <?php
                                                        $batchItem = \App\Models\BatchItem::find($stockOutItem['batch_item_id']);
                                                        $availableDisplay = $batchItem ? $batchItem->formatted_current_quantity : number_format($stockOutItem['available_quantity'], 2);
                                                    ?>
                                                    <div class="font-semibold text-green-600"><?php echo e($availableDisplay); ?></div>
                                                </td>
                                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                                    <!--[if BLOCK]><![endif]--><?php if($stockOutItem['selected']): ?>
                                                        <input type="number" step="0.01" wire:model="stockOutItems.<?php echo e($index); ?>.out_quantity"
                                                               min="0.01" max="<?php echo e($stockOutItem['available_quantity']); ?>" placeholder="Enter quantity"
                                                               class="px-2 py-1 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] focus:ring-0 focus:outline-none focus:border-primary">
                                                    <?php else: ?>
                                                        <span class="text-gray-400 text-sm">Select item first</span>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="text-center py-8 bg-gray-50 rounded-lg border-2 border-dashed border-gray-200">
                                <div class="text-gray-400 mb-4">
                                    <i class="fas fa-box text-4xl"></i>
                                </div>
                                <h3 class="text-lg font-medium text-gray-600 mb-2">No Items Available</h3>
                                <p class="text-gray-500">This batch doesn't have any items available for stock out.</p>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <form wire:submit="saveStockOut">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!-- Used For -->
                        <div>
                            <label class="font-semibold text-primary">Used For <span class="text-danger">*</span></label>
                            <input type="text" wire:model="used_for" placeholder="Experiment/Project name"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['used_for'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Conducted By -->
                        <div>
                            <label class="font-semibold text-primary">Conducted By <span class="text-danger">*</span></label>
                            <input type="text" wire:model="conducted_by" placeholder="Person conducting the usage"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['conducted_by'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Approved By -->
                        <div>
                            <label class="font-semibold text-primary">Approved By</label>
                            <input type="text" wire:model="approved_by" placeholder="Supervisor/Approver (optional)"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['approved_by'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Transaction Date -->
                        <div>
                            <label class="font-semibold text-primary">Transaction Date <span class="text-danger">*</span></label>
                            <input type="date" wire:model="transaction_date" max="<?php echo e(date('Y-m-d')); ?>"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['transaction_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Notes -->
                        <div class="md:col-span-2">
                            <label class="font-semibold text-primary">Notes</label>
                            <textarea wire:model="out_notes" placeholder="Enter any additional notes (optional)" rows="3"
                                      class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000 resize-none"></textarea>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['out_notes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>

                    <!-- Modal Actions -->
                    <div class="flex justify-end gap-2 mt-6">
                        <button type="button" wire:click="closeStockOutModal"
                                class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-200 rounded-md hover:bg-gray-300 transition-colors">
                            Cancel
                        </button>

                        <button type="submit"
                                class="px-4 py-2 text-sm font-medium text-white bg-blue-600 rounded-md hover:bg-blue-700 transition-colors">
                            <i class="fa fa-minus-circle mr-2"></i>Record Stock Out
                        </button>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!-- Transaction History Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showTransactionHistoryModal): ?>
        <?php
            $selectedBatch = \App\Models\StockBatch::with(['batchItems.inventoryItem', 'batchItems.variant', 'supplier'])->find($selected_batch_for_history);
        ?>
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-6xl w-full max-h-[90vh] overflow-y-auto">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold text-primary">Transaction History</h3>
                    <button wire:click="closeTransactionHistoryModal" class="text-gray-400 hover:text-gray-600">
                        <i class="fas fa-times text-xl"></i>
                    </button>
                </div>

                <!--[if BLOCK]><![endif]--><?php if($selectedBatch): ?>
                    <!-- Batch Information Header -->
                    <div class="bg-gray-50 p-4 rounded-lg mb-4">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm">
                            <div>
                                <span class="font-medium text-gray-600">Batch Number:</span>
                                <span class="ml-2 font-semibold"><?php echo e($selectedBatch->batch_number); ?></span>
                            </div>
                            <div>
                                <span class="font-medium text-gray-600">Received Date:</span>
                                <span class="ml-2"><?php echo e($selectedBatch->received_date->format('M d, Y')); ?></span>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php if($selectedBatch->supplier): ?>
                                <div>
                                    <span class="font-medium text-gray-600">Supplier:</span>
                                    <span class="ml-2"><?php echo e($selectedBatch->supplier->name); ?></span>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm mt-2">
                            <div>
                                <span class="font-medium text-gray-600">Total Items:</span>
                                <span class="ml-2 font-semibold text-blue-600"><?php echo e($selectedBatch->batchItems->count()); ?></span>
                            </div>
                            <div>
                                <span class="font-medium text-gray-600">Items Available:</span>
                                <span class="ml-2 font-semibold text-green-600"><?php echo e($selectedBatch->batchItems->where('current_quantity', '>', 0)->count()); ?></span>
                            </div>
                            <div>
                                <span class="font-medium text-gray-600">Items Fully Used:</span>
                                <span class="ml-2 font-semibold text-gray-600"><?php echo e($selectedBatch->batchItems->where('current_quantity', '<=', 0)->count()); ?></span>
                            </div>
                        </div>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <!-- Transaction History Table -->
                <div class="overflow-x-auto">
                    <!--[if BLOCK]><![endif]--><?php if($this->transactionHistory->count() > 0): ?>
                        <table class="w-full border-[2px] border-secondary/40 border-collapse">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Date</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Type</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Quantity</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Remaining</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Used For</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Conducted By</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Approved By</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Notes</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $this->transactionHistory; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="hover:bg-secondary/10 transition ease-in duration-2000">
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="flex items-center">
                                                <i class="fa fa-calendar text-primary mr-2"></i>
                                                <div>
                                                    <div class="font-semibold"><?php echo e($transaction->transaction_date->format('M d, Y')); ?></div>
                                                    <div class="text-xs text-gray-500"><?php echo e($transaction->created_at->format('H:i')); ?></div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <span class="px-3 py-1 text-xs font-medium rounded-full
                                                <?php echo e($transaction->transaction_type === 'in' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                                                <i class="fa <?php echo e($transaction->transaction_type === 'in' ? 'fa-plus' : 'fa-minus'); ?> mr-1"></i>
                                                <?php echo e($transaction->transaction_type === 'in' ? 'Stock In' : 'Stock Out'); ?>

                                            </span>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="font-semibold <?php echo e($transaction->transaction_type === 'in' ? 'text-green-600' : 'text-red-600'); ?>">
                                                <?php echo e($transaction->transaction_type === 'in' ? '+' : '-'); ?>

                                                <!--[if BLOCK]><![endif]--><?php if($transaction->batchItem && $transaction->batchItem->variant): ?>
                                                    <?php echo e(\App\Helpers\UnitConverter::formatBestUnit($transaction->quantity, \App\Helpers\UnitConverter::getBaseUnit($transaction->batchItem->variant->unit_type))); ?>

                                                <?php else: ?>
                                                    <?php echo e(number_format($transaction->quantity, 2)); ?>

                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="font-semibold text-blue-600">
                                                <!--[if BLOCK]><![endif]--><?php if($transaction->batchItem && $transaction->batchItem->variant): ?>
                                                    <?php echo e(\App\Helpers\UnitConverter::formatBestUnit($transaction->remaining_quantity, \App\Helpers\UnitConverter::getBaseUnit($transaction->batchItem->variant->unit_type))); ?>

                                                <?php else: ?>
                                                    <?php echo e(number_format($transaction->remaining_quantity, 2)); ?>

                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="max-w-xs">
                                                <span class="font-semibold"><?php echo e($transaction->used_for); ?></span>
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="flex items-center">
                                                <i class="fa fa-user text-primary mr-2"></i>
                                                <span><?php echo e($transaction->conducted_by); ?></span>
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <!--[if BLOCK]><![endif]--><?php if($transaction->approved_by): ?>
                                                <div class="flex items-center">
                                                    <i class="fa fa-user-check text-green-600 mr-2"></i>
                                                    <span><?php echo e($transaction->approved_by); ?></span>
                                                </div>
                                            <?php else: ?>
                                                <span class="text-gray-400 text-xs">Not specified</span>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <!--[if BLOCK]><![endif]--><?php if($transaction->notes): ?>
                                                <div class="max-w-xs">
                                                    <span class="text-sm"><?php echo e(Str::limit($transaction->notes, 50)); ?></span>
                                                    <!--[if BLOCK]><![endif]--><?php if(strlen($transaction->notes) > 50): ?>
                                                        <span class="text-xs text-gray-500 block mt-1" title="<?php echo e($transaction->notes); ?>">
                                                            <i class="fa fa-info-circle mr-1"></i>Hover for full text
                                                        </span>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            <?php else: ?>
                                                <span class="text-gray-400 text-xs">No notes</span>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </tbody>
                        </table>
                    <?php else: ?>
                        <div class="text-center py-12 bg-gray-50 rounded-lg border-2 border-dashed border-gray-200">
                            <div class="text-gray-400 mb-4">
                                <i class="fas fa-history text-5xl"></i>
                            </div>
                            <h3 class="text-lg font-medium text-gray-600 mb-2">No Transaction History</h3>
                            <p class="text-gray-500">No transactions have been recorded for this batch yet.</p>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>

                <!-- Modal Actions -->
                <div class="flex justify-end gap-2 mt-6">
                    <button wire:click="closeTransactionHistoryModal"
                            class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-200 rounded-md hover:bg-gray-300 transition-colors">
                        Close
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <!-- Batch View Modal -->
    <!--[if BLOCK]><![endif]--><?php if($showBatchViewModal): ?>
        <?php
            $selectedBatch = \App\Models\StockBatch::with(['batchItems.inventoryItem', 'batchItems.variant', 'supplier'])->find($selected_batch_for_view);
        ?>
        <div class="fixed inset-0 bg-black/50 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-6xl w-full max-h-[90vh] overflow-y-auto">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold text-primary">Batch Items</h3>
                    <button wire:click="closeBatchViewModal" class="text-gray-400 hover:text-gray-600">
                        <i class="fas fa-times text-xl"></i>
                    </button>
                </div>

                <!--[if BLOCK]><![endif]--><?php if($selectedBatch): ?>
                    <!-- Batch Information Header -->
                    <div class="bg-gray-50 p-4 rounded-lg mb-4">
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm">
                            <div>
                                <span class="font-medium text-gray-600">Batch Number:</span>
                                <span class="ml-2 font-semibold"><?php echo e($selectedBatch->batch_number); ?></span>
                            </div>
                            <div>
                                <span class="font-medium text-gray-600">Received Date:</span>
                                <span class="ml-2"><?php echo e($selectedBatch->received_date->format('M d, Y')); ?></span>
                            </div>
                            <!--[if BLOCK]><![endif]--><?php if($selectedBatch->supplier): ?>
                                <div>
                                    <span class="font-medium text-gray-600">Supplier:</span>
                                    <span class="ml-2"><?php echo e($selectedBatch->supplier->name); ?></span>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                        <!--[if BLOCK]><![endif]--><?php if($selectedBatch->expiry_date || $selectedBatch->manufacture_date): ?>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 text-sm mt-2">
                                <!--[if BLOCK]><![endif]--><?php if($selectedBatch->manufacture_date): ?>
                                    <div>
                                        <span class="font-medium text-gray-600">Manufacture Date:</span>
                                        <span class="ml-2"><?php echo e($selectedBatch->manufacture_date->format('M d, Y')); ?></span>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <!--[if BLOCK]><![endif]--><?php if($selectedBatch->expiry_date): ?>
                                    <div>
                                        <span class="font-medium text-gray-600">Expiry Date:</span>
                                        <span class="ml-2 <?php echo e($selectedBatch->isExpired() ? 'text-red-600 font-semibold' : ($selectedBatch->isExpiringSoon() ? 'text-yellow-600' : 'text-green-600')); ?>">
                                            <?php echo e($selectedBatch->expiry_date->format('M d, Y')); ?>

                                        </span>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                <!-- Batch Items Table -->
                <div class="overflow-x-auto">
                    <!-- Debug Info -->
                    <div class="mb-4 p-2 bg-yellow-100 border border-yellow-400 rounded text-sm">
                        <strong>Debug Info:</strong><br>
                        Selected Batch ID: <?php echo e($selected_batch_for_view); ?><br>
                        Batch Items Count: <?php echo e(count($batchItemsForView)); ?><br>
                        Batch Items Type: <?php echo e(gettype($batchItemsForView)); ?>

                    </div>

                    <!--[if BLOCK]><![endif]--><?php if(count($batchItemsForView) > 0): ?>
                        <table class="w-full border-[2px] border-secondary/40 border-collapse">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Item</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Variant</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Initial Qty</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Current Qty</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Used Qty</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Unit Cost</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Status</th>
                                    <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left whitespace-nowrap">Notes</th>
                                </tr>
                            </thead>
                            <tbody>
                                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $batchItemsForView; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $batchItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="hover:bg-secondary/10 transition ease-in duration-2000">
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="flex items-start">
                                                <i class="fa <?php echo e($batchItem->inventoryItem->item_type === 'chemical' ? 'fa-flask' : 'fa-box'); ?> text-primary mr-2 text-xs mt-1"></i>
                                                <div>
                                                    <div class="font-semibold"><?php echo e($batchItem->inventoryItem->name); ?></div>
                                                    <span class="px-2 py-1 text-xs font-medium rounded-full
                                                        <?php echo e($batchItem->inventoryItem->item_type === 'chemical' ? 'bg-purple-100 text-purple-800' : 'bg-blue-100 text-blue-800'); ?>">
                                                        <?php echo e(ucfirst($batchItem->inventoryItem->item_type)); ?>

                                                    </span>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <!--[if BLOCK]><![endif]--><?php if($batchItem->variant): ?>
                                                <div class="text-xs bg-gradient-to-r from-purple-50 to-purple-100 px-2 py-1 rounded border border-purple-200">
                                                    <span class="font-medium text-purple-800 flex items-center">
                                                        <i class="fa <?php echo e($batchItem->variant->isLiquidUnit() ? 'fa-flask' : 'fa-weight-hanging'); ?> mr-1 text-xs"></i>
                                                        <?php echo e($batchItem->variant->display_name); ?>

                                                    </span>
                                                    <!--[if BLOCK]><![endif]--><?php if($batchItem->variant->barcode): ?>
                                                        <div class="text-purple-600 text-xs mt-1">
                                                            <i class="fa fa-barcode mr-1"></i><?php echo e($batchItem->variant->barcode); ?>

                                                        </div>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            <?php else: ?>
                                                <span class="text-gray-400 text-xs">N/A</span>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="font-semibold text-blue-600">
                                                <?php echo e($batchItem->formatted_initial_quantity); ?>

                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="font-semibold <?php echo e($batchItem->current_quantity > 0 ? 'text-green-600' : 'text-red-600'); ?>">
                                                <?php echo e($batchItem->formatted_current_quantity); ?>

                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="font-semibold text-orange-600">
                                                <?php echo e($batchItem->formatted_used_quantity); ?>

                                            </div>
                                            <div class="text-xs text-gray-500">
                                                <?php echo e(number_format($batchItem->usage_percentage, 1)); ?>% used
                                            </div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <div class="font-semibold">$<?php echo e(number_format($batchItem->unit_cost, 2)); ?></div>
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <!--[if BLOCK]><![endif]--><?php if($batchItem->current_quantity <= 0): ?>
                                                <span class="px-2 py-1 text-xs font-medium rounded-full bg-red-100 text-red-800">
                                                    <i class="fa fa-times-circle mr-1"></i>Fully Used
                                                </span>
                                            <?php elseif($batchItem->isLowStock()): ?>
                                                <span class="px-2 py-1 text-xs font-medium rounded-full bg-yellow-100 text-yellow-800">
                                                    <i class="fa fa-exclamation-circle mr-1"></i>Low Stock
                                                </span>
                                            <?php else: ?>
                                                <span class="px-2 py-1 text-xs font-medium rounded-full bg-green-100 text-green-800">
                                                    <i class="fa fa-check-circle mr-1"></i>Available
                                                </span>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </td>
                                        <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                            <!--[if BLOCK]><![endif]--><?php if($batchItem->notes): ?>
                                                <div class="max-w-xs">
                                                    <span class="text-sm"><?php echo e(Str::limit($batchItem->notes, 50)); ?></span>
                                                    <!--[if BLOCK]><![endif]--><?php if(strlen($batchItem->notes) > 50): ?>
                                                        <span class="text-xs text-gray-500 block mt-1" title="<?php echo e($batchItem->notes); ?>">
                                                            <i class="fa fa-info-circle mr-1"></i>Hover for full text
                                                        </span>
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            <?php else: ?>
                                                <span class="text-gray-400 text-xs">No notes</span>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                            </tbody>
                        </table>
                    <?php else: ?>
                        <div class="text-center py-12 bg-gray-50 rounded-lg border-2 border-dashed border-gray-200">
                            <div class="text-gray-400 mb-4">
                                <i class="fas fa-box text-5xl"></i>
                            </div>
                            <h3 class="text-lg font-medium text-gray-600 mb-2">No Items in Batch</h3>
                            <p class="text-gray-500">This batch doesn't contain any items yet.</p>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>

                <!-- Modal Actions -->
                <div class="flex justify-end gap-2 mt-6">
                    <button wire:click="closeBatchViewModal"
                            class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-200 rounded-md hover:bg-gray-300 transition-colors">
                        Close
                    </button>
                </div>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH /home1/kinkarlab/public_html/resources/views/livewire/inventory/stock-management.blade.php ENDPATH**/ ?>