<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" >

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e($title ?? config('app.name', 'Laravel')); ?></title>

      <!--THEME:--ADD TO TOP OT PREVENT FLICKERING -->
      <script>

         /* Function to apply or remove the dark theme */
        function updateTheme(isDark) {
            if (isDark) {
                document.documentElement.classList.add('dark');
            } else {
                document.documentElement.classList.remove('dark');
            }
        }

        /* Check the initial theme preference */
        const darkModeMediaQuery = window.matchMedia('(prefers-color-scheme: dark)');
        updateTheme(darkModeMediaQuery.matches);

        /* listen to changed in (prefers-color-scheme: dark) */
        darkModeMediaQuery.addEventListener('change', (event) => {
            updateTheme(event.matches);
        });

        /* Add This to update theme when page is wire navigated */
        document.addEventListener('livewire:navigated', () => {
          const darkModeMediaQuery = window.matchMedia('(prefers-color-scheme: dark)');
          updateTheme(darkModeMediaQuery.matches);  // Re-apply the theme based on system preference
         });
      </script>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />
    <!-- Scripts -->


    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <?php echo <<<EOT
                <style>
                    :root {
                        --wc-brand-primary: #a855f7;
                        
                        --wc-light-primary: #fff;  /* white */
                        --wc-light-secondary: oklch(0.967 0.003 264.542);/* --color-gray-100 */
                        --wc-light-accent: oklch(0.985 0.002 247.839);/* --color-gray-50 */
                        --wc-light-border: oklch(0.928 0.006 264.531);/* --color-gray-200 */

                        --wc-dark-primary: oklch(0.21 0.034 264.665); /* --color-zinc-900 */
                        --wc-dark-secondary: oklch(0.278 0.033 256.848);/* --color-zinc-800 */
                        --wc-dark-accent: oklch(0.373 0.034 259.733);/* --color-zinc-700 */
                        --wc-dark-border: oklch(0.373 0.034 259.733);/* --color-zinc-700 */
                    }
                    [x-cloak] {
                        display: none !important;
                    }
                </style>
            EOT; ?>
</head>

<body  x-data x-cloak class="font-sans antialiased">
    <div class="min-h-screen bg-[var(--wc-light-primary)] dark:bg-[var(--wc-dark-primary)]">

        <!-- Page Content -->
        <main class="h-[calc(100vh_-_0.0rem)]">
            <?php echo e($slot); ?>

        </main>

    </div>

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <?php if(auth()->check()): ?>
                        <?php 
                            echo Blade::render('@livewire(\'wirechat.modal\')');
                            echo Blade::render('<x-wirechat::toast/>');
                            echo Blade::render('<x-wirechat::notification/>');
                        ?>
                <?php endif; ?>
</body>

</html>
<?php /**PATH D:\work\kinker\resources\views/vendor/wirechat/layouts/app.blade.php ENDPATH**/ ?>