<div>
    <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('success')); ?>

            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php if(session()->has('error')): ?>
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('error')); ?>

            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <!--[if BLOCK]><![endif]--><?php if($isEditing): ?>
        <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex flex-col shadow-lg shadow-gray-300">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between">
                <span class="font-semibold text-primary text-xl">New Booking</span>
                <button wire:click="hideForm" class="text-sm bg-primary/20 text-primary px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                    <i class="fa fa-angle-left mr-2"></i>Back
                </button>
            </div>
            <div class="w-full p-4">
                <div class="w-full grid lg:grid-cols-4 gap-4">

                    <!-- Instrument Details -->
                    <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white h-max flex shadow-lg shadow-primary/10 flex-col">
                        <div class="bg-primary/10 px-4 py-1 border-b-[2px] border-b-primary/20 flex justify-between">
                            <span class="font-semibold text-primary text-md">Find the instrument</span>
                        </div>
                        <div class="w-full grid  gap-2 p-4 ">
                            <div class="w-full flex flex-col gap-1">

                                <!--[if BLOCK]><![endif]--><?php if(!auth()->user()->hasRole('student')): ?>
                                    <label class="font-semibold text-primary">Booking for <span class="text-danger">*</span></label>
                                    <select wire:model.live="student" class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded focus:border-primary">
                                        <option value="">--Select Student--</option>
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($student->id); ?>"><?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </select>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['student'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"> <i class="fa fa-exclamation-triangle mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <!-- Instrument Selection -->
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Select Instrument <span class="text-danger">*</span></label>
                                <select wire:model.live="instrument" class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded focus:border-primary">
                                    <option value="">--Select Instrument--</option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $instruments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instrument): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($instrument->id); ?>"><?php echo e($instrument->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['instrument'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"> <i class="fa fa-exclamation-triangle mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>

                            <!--[if BLOCK]><![endif]--><?php if($selectedInstrument): ?>
                                <!--[if BLOCK]><![endif]--><?php if($selectedInstrument->booking_type === 'both'): ?>
                                    <div class="w-full flex flex-col gap-1">
                                        <label class="font-semibold text-primary">Booking Type <span class="text-danger">*</span></label>
                                        <select wire:model.live="booking_type" class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded focus:border-primary">
                                            <option value="">--Select Booking Type--</option>
                                            <!--[if BLOCK]><![endif]--><?php if($selectedInstrument->booking_type === 'slot' || $selectedInstrument->booking_type === 'both'): ?>
                                                <option value="slot" <?php echo e($selectedInstrument->booking_type === 'slot'?'selected':''); ?>>Slot</option>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                            <!--[if BLOCK]><![endif]--><?php if($selectedInstrument->booking_type === 'sample' || $selectedInstrument->booking_type === 'both'): ?>
                                                <option value="sample" <?php echo e($selectedInstrument->booking_type === 'sample'?'selected':''); ?>>Sample</option>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </select>
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['booking_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"> <i class="fa fa-exclamation-triangle mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <!--[if BLOCK]><![endif]--><?php if($isInstrumentAvailable): ?>
                                <div class="w-full flex flex-col gap-1">
                                    <label class="font-semibold text-primary">Date <span class="text-danger">*</span></label>
                                    <input
                                        type="date"
                                        wire:model.live.debounce.500ms="date"
                                        min="<?php echo e(date('Y-m-d')); ?>"
                                        x-data
                                        x-init="() => {
            $watch('instrument', value => {
                if(value) {
                    setTimeout(() => $el.showPicker(), 100);
                }
            })
        }"
                                        class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded focus:border-primary"
                                    />
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-exclamation-triangle mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php else: ?>
                                <div class="w-full flex gap-2">
                                    <button
                                        type="button"
                                        wire:click="notifyForInstrument"
                                        class="text-sm bg-success/30 px-4 py-1 w-full rounded font-semibold border-[2px] border-success text-ternary hover:text-white hover:bg-success hover:border-ternary transition">
                                            <span> <i class="fa fa-bell mr-2"></i>
                                                Notify me
                                            </span>

                                    </button>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->



                        </div>

                        <!--[if BLOCK]><![endif]--><?php if($selectedInstrument): ?>
                            <div>
                                <div class="bg-primary/10 px-4 py-1 border-b-[2px] border-b-primary/20 flex justify-between">
                                    <span class="font-semibold text-primary text-md">Instrument Details</span>
                                </div>
                                <div class=" flex flex-col items-center py-4">
                                    <?php if($selectedInstrument->photos): ?>
                                        <?php $photos = json_decode($selectedInstrument->photos); ?>
                                        <!--[if BLOCK]><![endif]--><?php if(count($photos) > 0): ?>
                                            <img src="<?php echo e(asset('storage/' . $photos[0])); ?>" alt="<?php echo e($selectedInstrument->name); ?>" class="h-40 w-auto object-cover rounded-[3px]"/>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <p class="font-semibold text-lg text-danger mt-4"> <?php echo e($selectedInstrument->name); ?></p>
                                    <p class="text-black font-semibold text-sm"> <span class="text-<?php echo e($selectedInstrument->operating_status == 'working' ? 'success' :
    ($selectedInstrument->operating_status == 'under_maintenance' || $selectedInstrument->operating_status == 'calibration_required' ? 'warning' : 'danger')); ?> bg-<?php echo e($selectedInstrument->operating_status == 'working' ? 'success' :
    ($selectedInstrument->operating_status == 'under_maintenance' || $selectedInstrument->operating_status == 'calibration_required' ? 'warning' : 'danger')); ?>/20 border-[1px] border-<?php echo e($selectedInstrument->operating_status == 'working' ? 'success' :
    ($selectedInstrument->operating_status == 'under_maintenance' || $selectedInstrument->operating_status == 'calibration_required' ? 'warning' : 'danger')); ?>/40 px-4 py-1 rounded-full text-sm">
    <?php echo e(ucfirst(str_replace('_', ' ', $selectedInstrument->operating_status))); ?>

</span></p>




















































                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!-- Available Slots or Sample Details -->
                    <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white h-max flex flex-col lg:col-span-3">
                        <!--[if BLOCK]><![endif]--><?php if($selectedDate && $selectedInstrument): ?>
                            <!--[if BLOCK]><![endif]--><?php if($booking_type === 'slot'): ?>
                                <div class="bg-primary/10 px-4 py-1 border-b-[2px] border-b-primary/20 flex justify-between items-center">
                                    <div class="flex flex-col">
                                        <span class="font-semibold text-primary text-md">Time Slots for <?php echo e($selectedDate); ?></span>
                                        <!--[if BLOCK]><![endif]--><?php if($instrumentTerms && $instrumentTerms->booking_slot_duration): ?>
                                            <span class="text-sm text-primary/70">Duration: <?php echo e($instrumentTerms->booking_slot_duration); ?> minutes per booking</span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                    <!--[if BLOCK]><![endif]--><?php if(count($selectedSlots) > 0): ?>
                                        <button 
                                            wire:click="clearAllSelections" 
                                            class="text-xs bg-red-100 text-red-600 px-3 py-1 rounded border border-red-300 hover:bg-red-200 transition">
                                            <i class="fa fa-times mr-1"></i>Clear All
                                        </button>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>

                                <!--[if BLOCK]><![endif]--><?php if(count($allSlots) > 0): ?>
                                <div class="p-4">
                                    <!--[if BLOCK]><![endif]--><?php if($instrumentTerms && $instrumentTerms->booking_slot_duration && $instrumentTerms->booking_slot_duration > 30): ?>
                                        <div class="mb-4 p-3 bg-blue-50 border border-blue-200 rounded-lg">
                                            <p class="text-sm text-blue-800">
                                                <i class="fa fa-info-circle mr-2"></i>
                                                Minimum booking duration: <?php echo e($instrumentTerms->booking_slot_duration); ?> minutes (<?php echo e($instrumentTerms->booking_slot_duration / 30); ?> slots). 
                                                Clicking any slot will automatically select the minimum duration. You can extend bookings by selecting additional consecutive slots.
                                            </p>
                                            <p class="text-xs text-blue-600 mt-1">
                                                Consecutive slots will be grouped into single bookings. Gaps between selections will create separate bookings.
                                            </p>
                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    
                                    <div class="grid xl:grid-cols-5 lg:grid-cols-4 md:grid-cols-5 sm:grid-cols-3 grid-cols-2 gap-4">
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $allSlots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $isBooked = in_array($slot->id, $bookedSlotIds);
                                                $isPassed = in_array($slot->id, $passedSlotIds);
                                                $isSelected = in_array($slot->id, $selectedSlots);
                                                $isUnavailable = $isBooked || $isPassed;
                                                
                                                // Find which consecutive group this slot belongs to for visual grouping
                                                $groupIndex = -1;
                                                if ($isSelected) {
                                                    // Use PHP to group consecutive slots (simplified version for blade)
                                                    $selectedSlotsSorted = collect($selectedSlots)->sort()->values()->toArray();
                                                    $groups = [];
                                                    $currentGroup = [];
                                                    
                                                    foreach ($selectedSlotsSorted as $selectedSlotId) {
                                                        if (empty($currentGroup)) {
                                                            $currentGroup = [$selectedSlotId];
                                                        } else {
                                                            $lastSlotInGroup = end($currentGroup);
                                                            $lastSlot = $allSlots->firstWhere('id', $lastSlotInGroup);
                                                            $currentSlot = $allSlots->firstWhere('id', $selectedSlotId);
                                                            
                                                            if ($lastSlot && $currentSlot && $lastSlot->end_time === $currentSlot->start_time) {
                                                                $currentGroup[] = $selectedSlotId;
                                                            } else {
                                                                if (count($currentGroup) > 0) {
                                                                    $groups[] = $currentGroup;
                                                                }
                                                                $currentGroup = [$selectedSlotId];
                                                            }
                                                        }
                                                    }
                                                    
                                                    if (count($currentGroup) > 0) {
                                                        $groups[] = $currentGroup;
                                                    }
                                                    
                                                    // Find which group contains this slot
                                                    foreach ($groups as $index => $group) {
                                                        if (in_array($slot->id, $group)) {
                                                            $groupIndex = $index;
                                                            break;
                                                        }
                                                    }
                                                }
                                                
                                                $groupColors = ['bg-green-200 border-green-500', 'bg-blue-200 border-blue-500', 'bg-purple-200 border-purple-500', 'bg-orange-200 border-orange-500', 'bg-pink-200 border-pink-500'];
                                                $selectedClass = $isSelected && $groupIndex >= 0 ? $groupColors[$groupIndex % count($groupColors)] : 'bg-green-200 border-green-500';
                                            ?>
                                            <div
                                                wire:click="selectSlot(<?php echo e($slot->id); ?>)"
                                                class="border-2 p-3 rounded-lg text-center transition-all duration-200 relative
                    <?php echo e($isBooked ? 'bg-red-100 border-red-400 opacity-70 cursor-not-allowed' : ''); ?>

                    <?php echo e($isPassed ? 'bg-gray-100 border-gray-400 opacity-70 cursor-not-allowed' : ''); ?>

                    <?php echo e(!$isUnavailable ? 'hover:bg-green-50 border-green-300 cursor-pointer' : ''); ?>

                    <?php echo e($isSelected && !$isUnavailable ? $selectedClass : ''); ?>"
                                            >
                                                <!--[if BLOCK]><![endif]--><?php if($isSelected && $groupIndex >= 0): ?>
                                                    <div class="absolute -top-2 -right-2 bg-white border-2 border-current rounded-full w-6 h-6 flex items-center justify-center text-xs font-bold">
                                                        <?php echo e($groupIndex + 1); ?>

                                                    </div>
                                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                <div class="font-medium mb-1"><?php echo e(date('h:i A', strtotime($slot->start_time))); ?> - <?php echo e(date('h:i A', strtotime($slot->end_time))); ?></div>
                                                <div class="text-sm font-semibold 
                    <?php echo e($isBooked ? 'text-red-600' : ''); ?>

                    <?php echo e($isPassed ? 'text-gray-600' : ''); ?>

                    <?php echo e(!$isUnavailable ? 'text-green-600' : ''); ?>">
                                                    <!--[if BLOCK]><![endif]--><?php if($isBooked): ?>
                                                        Booked by: <?php echo e($slotBookingDetails[$slot->id]['booked_by'] ?? 'Unknown'); ?>

                                                    <?php elseif($isPassed): ?>
                                                        Passed
                                                    <?php else: ?>
                                                        Available
                                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedSlots'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 block mt-2"><i class="fa fa-exclamation-triangle mr-2"></i> Please select at least one available time slot</span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                
                                <!--[if BLOCK]><![endif]--><?php if(count($selectedSlots) > 0): ?>
                                    <div class="mt-4 p-4 bg-gray-50 border border-gray-200 rounded-lg">
                                        <h4 class="font-semibold text-primary mb-2">Selected Bookings Summary:</h4>
                                        <?php
                                            // Group consecutive slots for summary
                                            $selectedSlotsSorted = collect($selectedSlots)->sort()->values()->toArray();
                                            $groups = [];
                                            $currentGroup = [];
                                            
                                            foreach ($selectedSlotsSorted as $selectedSlotId) {
                                                if (empty($currentGroup)) {
                                                    $currentGroup = [$selectedSlotId];
                                                } else {
                                                    $lastSlotInGroup = end($currentGroup);
                                                    $lastSlot = $allSlots->firstWhere('id', $lastSlotInGroup);
                                                    $currentSlot = $allSlots->firstWhere('id', $selectedSlotId);
                                                    
                                                    if ($lastSlot && $currentSlot && $lastSlot->end_time === $currentSlot->start_time) {
                                                        $currentGroup[] = $selectedSlotId;
                                                    } else {
                                                        if (count($currentGroup) > 0) {
                                                            $groups[] = $currentGroup;
                                                        }
                                                        $currentGroup = [$selectedSlotId];
                                                    }
                                                }
                                            }
                                            
                                            if (count($currentGroup) > 0) {
                                                $groups[] = $currentGroup;
                                            }
                                            
                                            $bookingCount = 0;
                                        ?>
                                        
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $bookingCount++;
                                                $firstSlot = $allSlots->firstWhere('id', $group[0]);
                                                $lastSlot = $allSlots->firstWhere('id', end($group));
                                                $duration = count($group) * 30; // Each slot is 30 minutes
                                            ?>
                                            <!--[if BLOCK]><![endif]--><?php if($firstSlot && $lastSlot): ?>
                                                <div class="flex justify-between items-center py-1">
                                                    <span class="text-sm">Booking <?php echo e($bookingCount); ?>:</span>
                                                    <span class="text-sm font-medium">
                                                        <?php echo e(date('h:i A', strtotime($firstSlot->start_time))); ?> - <?php echo e(date('h:i A', strtotime($lastSlot->end_time))); ?>

                                                        (<?php echo e($duration); ?> minutes, <?php echo e(count($group)); ?> slots)
                                                    </span>
                                                </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        
                                        <!--[if BLOCK]><![endif]--><?php if($bookingCount > 1): ?>
                                            <div class="mt-2 pt-2 border-t border-gray-300">
                                                <span class="text-sm font-semibold text-primary">Total: <?php echo e($bookingCount); ?> separate bookings will be created</span>
                                            </div>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <?php else: ?>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <?php else: ?>
                                <div class="bg-primary/10 px-4 py-1 border-b-[2px] border-b-primary/20 flex justify-between">
                                    <span class="font-semibold text-primary text-md">Sample Details</span>
                                </div>
                                <div class="p-4">
                                    <div class="w-full flex flex-col gap-2">
                                        <label class="font-semibold text-primary">Sample Quantity <span class="text-danger">*</span></label>
                                        <input type="number" wire:model="sample_quantity" min="1" class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded focus:border-primary" />
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['sample_quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-exclamation-triangle mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <!--[if BLOCK]><![endif]--><?php if($instrumentTerms && $instrumentTerms->sop): ?>
                                    <div class="w-full flex flex-col gap-2 mt-2 p-4 bg-gray-50 rounded-lg">
                                        <h3 class="font-semibold text-primary">Standard Operating Procedure</h3>
                                        <div class="prose max-w-none text-sm">
                                            <?php echo $instrumentTerms->sop; ?>

                                        </div>
                                        <div class="flex items-center gap-2 mt-2">
                                            <input
                                                type="checkbox"
                                                wire:model="sopAcknowledged"
                                                id="sopAcknowledged"
                                                class="rounded border-primary/40 text-primary focus:ring-primary"
                                            />
                                            <label for="sopAcknowledged" class="text-sm font-medium text-gray-700">
                                                I have read and understood the Standard Operating Procedure
                                            </label>
                                        </div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                <!--[if BLOCK]><![endif]--><?php if($instrumentTerms && $instrumentTerms->instrument_sample_questions): ?>
                                    <div class="w-full flex flex-col gap-2 mt-2 p-4 bg-gray-50 rounded-lg">
                                        <h3 class="font-semibold text-primary">Sample Questions</h3>
                                        <div class="w-full grid lg:grid-cols-3 md:grid-cols-2 grid-cols-1 gap-4">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = json_decode($instrumentTerms->instrument_sample_questions); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="flex flex-col gap-2 mt-2">
                                                    <p class="text-sm font-medium"><?php echo e($question); ?></p>
                                                    <div class="flex items-center gap-4">
                                                        <label class="inline-flex items-center">
                                                            <input type="radio" wire:model="sample_answers.<?php echo e($index); ?>.answer" value="yes" class="form-radio text-primary">
                                                            <span class="ml-2">Yes</span>
                                                        </label>
                                                        <label class="inline-flex items-center">
                                                            <input type="radio" wire:model="sample_answers.<?php echo e($index); ?>.answer" value="no" class="form-radio text-primary">
                                                            <span class="ml-2">No</span>
                                                        </label>
                                                    </div>
                                                    <div class="w-full">
                                                        <input type="text" wire:model="sample_answers.<?php echo e($index); ?>.description" placeholder="Description" class="w-full px-2 py-1 text-sm border-[2px] border-primary/40 rounded">
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <div class="p-4">
                                <div class="w-full flex flex-col gap-1 mt-4">
                                    <label class="font-semibold text-primary">Description</label>
                                    <textarea wire:model="description" name="description" rows="3" placeholder="Description"
                                              class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"></textarea>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="flex justify-center items-center h-full">
                                <img class="h-40 " src="<?php echo e(config('app.logo')); ?>" alt="">
                            </div>

                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($isInstrumentAvailable): ?>
                            <div class="w-full flex justify-end px-4 pb-4 gap-2">
                                <button
                                    type="button"
                                    wire:click="submit"
                                    class="text-sm bg-success/30 px-4 py-1 rounded font-semibold border-[2px] border-success text-ternary hover:text-white hover:bg-success hover:border-ternary transition"
                                    <?php echo e(($booking_type === 'slot' && empty($selectedSlots)) || ($booking_type === 'sample' && empty($sample_quantity)) ? 'disabled' : ''); ?>

                                >
                        <span wire:loading.remove wire:target="submit"> <i class="fa fa-plus mr-2"></i>
                            Create Booking
                        </span>
                                    <span wire:loading wire:target="submit">
                      Creating booking   <i class="fas fa-hourglass-half fa-spin ml-2"></i>
                      </span>
                                </button>
                            </div>
                        <?php else: ?>

                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>


        </div>
    <?php else: ?>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('bookings.booking-list', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-3303318499-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH /home1/kinkarlab/iitr.kinkarlab.com/resources/views/livewire/bookings/create.blade.php ENDPATH**/ ?>