<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Items Report</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
            font-size: 24px;
        }
        .header p {
            margin: 5px 0;
            color: #666;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
            font-size: 10px;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
        .status-active {
            color: #059669;
            font-weight: bold;
        }
        .status-low {
            color: #dc2626;
            font-weight: bold;
        }
        .item-type-chemical {
            color: #7c3aed;
            font-weight: bold;
        }
        .item-type-regular {
            color: #059669;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1><?php echo e($title); ?></h1>
        <p>Generated on: <?php echo e($generatedAt); ?></p>
        <?php if(isset($dateFrom) && isset($dateTo)): ?>
            <p>Period: <?php echo e($dateFrom); ?> to <?php echo e($dateTo); ?></p>
        <?php endif; ?>
    </div>

    <table>
        <thead>
            <tr>
                <th>Name</th>
                <th>Category</th>
                <th>Type</th>
                <th>Current Stock</th>
                <th>Min Level</th>
                <th>Status</th>
                <th>Storage</th>
                <th>Hazard Info</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                    <td><?php echo e($item->name); ?></td>
                    <td><?php echo e($item->category->name ?? 'N/A'); ?></td>
                    <td class="item-type-<?php echo e($item->item_type); ?>">
                        <?php echo e(ucfirst($item->item_type ?? 'regular')); ?>

                    </td>
                    <td><?php echo e($item->getCurrentStock()); ?></td>
                    <td><?php echo e($item->min_stock_level ?? 'N/A'); ?></td>
                    <td class="<?php echo e($item->isLowStock() ? 'status-low' : 'status-active'); ?>">
                        <?php echo e($item->isLowStock() ? 'Low Stock' : 'Normal'); ?>

                    </td>
                    <td><?php echo e($item->storage_conditions ?? 'N/A'); ?></td>
                    <td><?php echo e($item->hazard_information ?? 'N/A'); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="8" style="text-align: center; color: #666;">No items found</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="footer">
        <p>Laboratory Inventory Management System - Items Report</p>
        <p>Total Items: <?php echo e($data->count()); ?></p>
    </div>
</body>
</html><?php /**PATH /home1/kinkarlab/public_html/resources/views/exports/item-pdf.blade.php ENDPATH**/ ?>