<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e(config('app.name')); ?>- Home</title>
    <link rel="icon" type="image/x-icon" href="<?php echo e(config('app.fav_icon')); ?>">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,100..900;1,100..900&display=swap"
          rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
          integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
          crossorigin="anonymous" referrerpolicy="no-referrer"/>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <?php echo ToastMagic::styles(); ?>


    <style>
        ::-webkit-scrollbar {
            width: 2px;
            height: 2px;
        }

        /* Track */
        ::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        /* Handle */
        ::-webkit-scrollbar-thumb {
            background: #001A6E;
        }

        /* Handle on hover */
        ::-webkit-scrollbar-thumb:hover {
            background: #555;
        }

        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        /* Firefox */
        input[type=number] {
            -moz-appearance: textfield;
        }


        input[type="date"]::-webkit-datetime-edit {
            color: #172432b3; /* Change placeholder text color */
        }

        input[type="date"]::-webkit-calendar-picker-indicator {
            opacity: 0;
        }


        select {
            -webkit-appearance: none !important; /* Hides the arrow in WebKit-based browsers (Chrome, Safari, Edge) */
            -moz-appearance: none !important; /* Hides the arrow in Firefox */
            appearance: none !important; /* Standard property */
            background: white !important;
            color: rgba(0, 0, 0, 0.7) !important; /* Removes background if needed */
        }

        select option {
            color: rgba(14, 14, 14, 0.9) !important; /* Match placeholder text */
            background-color: #ffffff !important;
        }
    </style>
</head>
<body class="bg-gray-100 relative" style="font-family: 'Public Sans', serif; height: 100vh; width: 100%; overflow:hidden">
<div
    class="w-full lg:h-max md:h-max sm:max-h-64 max-h-64 lg:overflow-y-visible md:overflow-y-visible sm:overflow-y-auto overflow-y-auto">
    <div class="bg-black/80 w-full flex flex-col justify-center lg:items-center  items-start gap-2 relative px-2 ">
        <div class="w-max h-max lg:hidden flex">
            <i id="toggleButton"
               class="fa-solid fa-bars  ml-1 text-lg text-white p-2 rounded-sm hover:bg-lightTheme hover:text-primary transition ease-in duration-2000"
               onclick="
            let menuList = document.getElementById('menuList');
            if(menuList.classList.contains('hidden')){
                menuList.classList.remove('hidden');
            }else{
                menuList.classList.add('hidden');
            }
            " aria-hidden="true"></i>
        </div>
        <ul class="  lg:flex hidden lg:flex-row flex-col text-white/90 uppercase w-full items-center justify-center font-medium"
            id="menuList">

            <a href="">
                <li class="relative py-3 lg:hover:bg-primary  md:hover:bg-primary text-sm lg:hover:text-white md:hover:text-white px-4 transition ease-in duration-2000 group  items-center">
                    <a href="">
                        Home
                    </a>

                </li>
            </a>
                <a href="">
                    <li class="relative py-3 lg:hover:bg-primary  md:hover:bg-primary text-sm lg:hover:text-white md:hover:text-white px-4 transition ease-in duration-2000 group  items-center">
                        <a href=>
                            Home
                        </a>
                            <ul class="lg:absolute md:absolute static left-0 top-10 z-20 hidden group-hover:block bg-black/90 text-white">
                                    <a href="">
                                        <li class="w-[250px] py-2.5 lg:hover:bg-primary  md:hover:bg-primary text-sm lg:hover:text-white md:hover:text-white px-4 transition ease-in duration-2000 border-b-[1px] border-white border-dashed relative group/items justify-between">
                                            <a href="">
                                                Home 1
                                            </a>
                                        </li>
                                    </a>
                            </ul>
                    </li>
                </a>
        </ul>
    </div>
</div>

<?php echo e($slot); ?>


<div class="w-full bg-primary p-2 flex justify-between  ">
    <span>
        <p class="text-center text-sm text-white">© 2024-25 <?php echo e(config('app.name')); ?> All Rights Reserved. </p>
    </span>
    <span class="text-white text-sm">
         Designed with ❤ by
            <a href="<?php echo e(config('app.developer_link')); ?>" target="_blank" class=" text-md font-semibold text-white hover:text-danger underline transition ease-in duration-2000"><?php echo e(config('app.developed_by')); ?></a>
    </span>
</div>


</body>
</html>

<?php /**PATH D:\work\kinker\resources\views/layouts/public-layout.blade.php ENDPATH**/ ?>