
<!-- resources/views/exports/pi-pdf.blade.php -->
<!DOCTYPE html>
<html>
<head>
    <title>Principal Investigators</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .status-active {
            color: green;
        }
        .status-inactive {
            color: red;
        }
    </style>
</head>
<body>
<div class="header">
    <h2>Students List</h2>
    <p>Generated on: <?php echo e(date('Y-m-d H:i:s')); ?></p>
</div>

<table>
    <thead>
    <tr>
        <th>ID</th>
        <th>Name</th>
        <th>Academic ID</th>
        <th>Department</th>
        <th>Research Area</th>
        <th>Email</th>
        <th>Mobile</th>
        <th>Status</th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $studentList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($student->id); ?></td>
            <td><?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?></td>
            <td><?php echo e($student->academic_id); ?></td>
            <td><?php echo e($student->department); ?></td>
            <td><?php echo e($student->research_area); ?></td>
            <td><?php echo e($student->email); ?></td>
            <td><?php echo e($student->mobile_number); ?></td>
            <td><?php echo e($student->status == 1 ? 'Active' : 'Inactive'); ?></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</body>
</html>

<?php /**PATH /home1/kinkarlab/public_html/resources/views/exports/student-pdf.blade.php ENDPATH**/ ?>