<!-- resources/views/exports/pi-pdf.blade.php -->
<!DOCTYPE html>
<html>
<head>
    <title>Lab Deatils</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .status-active {
            color: green;
        }
        .status-inactive {
            color: red;
        }
    </style>
</head>
<body>
<div class="header">
    <h2>Labs List</h2>
    <p>Generated on: <?php echo e(date('Y-m-d H:i:s')); ?></p>
</div>

<table>
    <thead>
    <tr>
        <th>Sr. No.</th>
        <th>Name</th>
        <th>Department</th>
        <th>Building</th>
        <th>Floor</th>
        <th>Room Number</th>
        <th>Type</th>
        <th>Contact</th>
        <th>Status</th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $labList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lab): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($loop->iteration); ?></td>
            <td><?php echo e($lab->lab_name); ?></td>
            <td><?php echo e($lab->department); ?></td>
            <td><?php echo e($lab->building); ?></td>
            <td><?php echo e($lab->floor); ?></td>
            <td><?php echo e($lab->room_number); ?></td>
            <td><?php echo e($lab->type); ?></td>
            <td><?php echo e($lab->contact_number); ?></td>
            <td class="<?php echo e($lab->status == 1 ? 'status-active' : 'status-inactive'); ?>">
                <?php echo e($lab->status == 1 ? 'Active' : 'Inactive'); ?>

            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</body>
</html>
<?php /**PATH /home1/kinkarlab/public_html/resources/views/exports/lab-pdf.blade.php ENDPATH**/ ?>