<div>
    <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('success')); ?>

            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <?php if(session()->has('error')): ?>
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('error')); ?>

            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
    <!--[if BLOCK]><![endif]--><?php if($isEditing): ?>
        <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex flex-col shadow-lg shadow-gray-300">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between">
                <span class="font-semibold text-primary text-xl">New Booking</span>
                <button wire:click="hideForm" class="text-sm bg-primary/20 text-primary px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 hover:text-white hover:bg-primary hover:border-primary/30 transition ease-in duration-2000">
                    <i class="fa fa-angle-left mr-2"></i>Back
                </button>
            </div>
            <div class="w-full p-4">
                <div class="w-full grid lg:grid-cols-4 gap-4">

                    <!-- Instrument Details -->
                    <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white h-max flex shadow-lg shadow-primary/10 flex-col">
                        <div class="bg-primary/10 px-4 py-1 border-b-[2px] border-b-primary/20 flex justify-between">
                            <span class="font-semibold text-primary text-md">Find the instrument</span>
                        </div>
                        <div class="w-full grid  gap-2 p-4 ">
                            <div class="w-full flex flex-col gap-1">

                                <!--[if BLOCK]><![endif]--><?php if(!auth()->user()->hasRole('student')): ?>
                                    <label class="font-semibold text-primary">Booking for <span class="text-danger">*</span></label>
                                    <select wire:model.live="student" class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded focus:border-primary">
                                        <option value="">--Select Student--</option>
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($student->id); ?>"><?php echo e($student->first_name); ?> <?php echo e($student->last_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </select>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['student'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"> <i class="fa fa-exclamation-triangle mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <!-- Instrument Selection -->
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Select Instrument <span class="text-danger">*</span></label>
                                <select wire:model.live="instrument" class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded focus:border-primary">
                                    <option value="">--Select Instrument--</option>
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $instruments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instrument): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($instrument->id); ?>"><?php echo e($instrument->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['instrument'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"> <i class="fa fa-exclamation-triangle mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>

                            <!--[if BLOCK]><![endif]--><?php if($selectedInstrument): ?>
                            <!-- Booking Type Selection -->
                            <div class="w-full flex flex-col gap-1">
                                <label class="font-semibold text-primary">Booking Type <span class="text-danger">*</span></label>
                                <select wire:model.live="booking_type" class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded focus:border-primary">
                                    <option value="">--Select Booking Type--</option>
                                    <!--[if BLOCK]><![endif]--><?php if($selectedInstrument->booking_type === 'slot' || $selectedInstrument->booking_type === 'both'): ?>
                                        <option value="slot" <?php echo e($selectedInstrument->booking_type === 'slot'?'selected':''); ?>>Slot</option>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <!--[if BLOCK]><![endif]--><?php if($selectedInstrument->booking_type === 'sample' || $selectedInstrument->booking_type === 'both'): ?>
                                        <option value="sample" <?php echo e($selectedInstrument->booking_type === 'sample'?'selected':''); ?>>Sample</option>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </select>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['booking_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"> <i class="fa fa-exclamation-triangle mr-2"></i><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                            <!--[if BLOCK]><![endif]--><?php if($isInstrumentAvailable): ?>
                                <div class="w-full flex flex-col gap-1">
                                    <label class="font-semibold text-primary">Date <span class="text-danger">*</span></label>
                                    <input
                                        type="date"
                                        wire:model.live.debounce.500ms="date"
                                        min="<?php echo e(date('Y-m-d')); ?>"
                                        x-data
                                        x-init="() => {
            $watch('instrument', value => {
                if(value) {
                    setTimeout(() => $el.showPicker(), 100);
                }
            })
        }"
                                        class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded focus:border-primary"
                                    />
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-exclamation-triangle mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            <?php else: ?>
                                <div class="w-full flex gap-2">
                                    <button
                                        type="button"
                                        wire:click="notifyForInstrument"
                                        class="text-sm bg-success/30 px-4 py-1 w-full rounded font-semibold border-[2px] border-success text-ternary hover:text-white hover:bg-success hover:border-ternary transition">
                                            <span> <i class="fa fa-bell mr-2"></i>
                                                Notify me
                                            </span>

                                    </button>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->



                        </div>

                        <!--[if BLOCK]><![endif]--><?php if($selectedInstrument): ?>
                            <div>
                                <div class="bg-primary/10 px-4 py-1 border-b-[2px] border-b-primary/20 flex justify-between">
                                    <span class="font-semibold text-primary text-md">Instrument Details</span>
                                </div>
                                <div class=" flex flex-col items-center py-4">
                                    <?php if($selectedInstrument->photos): ?>
                                        <?php $photos = json_decode($selectedInstrument->photos); ?>
                                        <!--[if BLOCK]><![endif]--><?php if(count($photos) > 0): ?>
                                            <img src="<?php echo e(asset('storage/' . $photos[0])); ?>" alt="<?php echo e($selectedInstrument->name); ?>" class="h-40 w-auto object-cover rounded-[3px]"/>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <p class="font-semibold text-lg text-danger mt-4"> <?php echo e($selectedInstrument->name); ?></p>
                                    <p class="text-black font-semibold text-sm"> <span class="text-<?php echo e($selectedInstrument->operating_status == 'working' ? 'success' :
    ($selectedInstrument->operating_status == 'under_maintenance' || $selectedInstrument->operating_status == 'calibration_required' ? 'warning' : 'danger')); ?> bg-<?php echo e($selectedInstrument->operating_status == 'working' ? 'success' :
    ($selectedInstrument->operating_status == 'under_maintenance' || $selectedInstrument->operating_status == 'calibration_required' ? 'warning' : 'danger')); ?>/20 border-[1px] border-<?php echo e($selectedInstrument->operating_status == 'working' ? 'success' :
    ($selectedInstrument->operating_status == 'under_maintenance' || $selectedInstrument->operating_status == 'calibration_required' ? 'warning' : 'danger')); ?>/40 px-4 py-1 rounded-full text-sm">
    <?php echo e(ucfirst(str_replace('_', ' ', $selectedInstrument->operating_status))); ?>

</span></p>
                                    <!--[if BLOCK]><![endif]--><?php if($selectedInstrument->booking_type == 'slot' || $selectedInstrument->booking_type == 'both'): ?>
                                        <div class="w-full flex flex-col gap-2 mt-4 px-4">
                                            <!--[if BLOCK]><![endif]--><?php if(isset($selectedInstrument->booking_cost['internal']['booking'])): ?>
                                            <h4 class="font-semibold text-primary">Booking Based Pricing</h4>
                                            <div class="grid grid-cols-2 gap-2 text-sm">
                                                <span>Internal:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['internal']['booking'] ?? 'N/A'); ?></span>
                                                <span>Other Educational:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['other_educational_institute']['booking'] ?? 'N/A'); ?></span>
                                                <span>R&D Labs:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['r_and_d_labs']['booking'] ?? 'N/A'); ?></span>
                                                <span>Industries:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['industries']['booking'] ?? 'N/A'); ?></span>
                                                <span>Startups:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['startups']['booking'] ?? 'N/A'); ?></span>
                                            </div>


                                          <?php else: ?>
                                            <h4 class="font-semibold text-primary">Slot Based Pricing</h4>
                                            <div class="grid grid-cols-2 gap-2 text-sm">
                                                <span>Internal:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['internal']['slot'] ?? 'N/A'); ?></span>
                                                <span>Other Educational:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['other_educational_institute']['slot'] ?? 'N/A'); ?></span>
                                                <span>R&D Labs:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['r_and_d_labs']['slot'] ?? 'N/A'); ?></span>
                                                <span>Industries:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['industries']['slot'] ?? 'N/A'); ?></span>
                                                <span>Startups:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['startups']['slot'] ?? 'N/A'); ?></span>
                                            </div>
                                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    <!--[if BLOCK]><![endif]--><?php if($selectedInstrument->booking_type == 'sample' || $selectedInstrument->booking_type == 'both'): ?>
                                        <div class="w-full flex flex-col gap-2 mt-4 px-4">
                                            <h4 class="font-semibold text-primary">Sample Based Pricing</h4>
                                            <div class="grid grid-cols-2 gap-2 text-sm">
                                                <span>Internal:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['internal']['sample'] ?? 'N/A'); ?></span>
                                                <span>Other Educational:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['other_educational_institute']['sample'] ?? 'N/A'); ?></span>
                                                <span>R&D Labs:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['r_and_d_labs']['sample'] ?? 'N/A'); ?></span>
                                                <span>Industries:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['industries']['sample'] ?? 'N/A'); ?></span>
                                                <span>Startups:</span>
                                                <span class="font-semibold">₹<?php echo e($selectedInstrument->booking_cost['startups']['sample'] ?? 'N/A'); ?></span>
                                            </div>
                                        </div>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>

                    <!-- Available Slots or Sample Details -->
                    <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white h-max flex flex-col lg:col-span-3">
                        <!--[if BLOCK]><![endif]--><?php if($selectedDate && $selectedInstrument): ?>
                            <!--[if BLOCK]><![endif]--><?php if($booking_type === 'slot'): ?>
                                <div class="bg-primary/10 px-4 py-1 border-b-[2px] border-b-primary/20 flex justify-between">
                                    <span class="font-semibold text-primary text-md">Time Slots for <?php echo e($selectedDate); ?></span>
                                </div>

                                <!--[if BLOCK]><![endif]--><?php if(count($allSlots) > 0): ?>
                                <div class="grid xl:grid-cols-5 lg:grid-cols-4 md:grid-cols-5 sm:grid-cols-3 grid-cols-2 gap-4 p-4">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $allSlots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $isBooked = in_array($slot->id, $bookedSlotIds);
                                            $isSelected = in_array($slot->id, $selectedSlots);
                                        ?>
                                        <label
                                            class="border-2 p-3 rounded-lg text-center cursor-pointer transition-all duration-200
                <?php echo e($isBooked ? 'bg-red-100 border-red-400 opacity-70 cursor-not-allowed' : 'hover:bg-green-50 border-green-300'); ?>

                <?php echo e($isSelected && !$isBooked ? 'bg-green-200 border-green-500' : ''); ?>"
                                        >
                                            <input
                                                type="checkbox"
                                                name="slots[]"
                                                value="<?php echo e($slot->id); ?>"
                                                wire:model.live="selectedSlots"
                                                <?php echo e($isBooked ? 'disabled' : ''); ?>

                                                class="hidden"
                                            >
                                            <div class="font-medium mb-1"><?php echo e(date('h:i A', strtotime($slot->start_time))); ?> - <?php echo e(date('h:i A', strtotime($slot->end_time))); ?></div>
                                            <div class="text-sm font-semibold <?php echo e($isBooked ? 'text-red-600' : 'text-green-600'); ?>">
                                                <?php echo e($isBooked ? 'Booked' : 'Available'); ?>

                                            </div>
                                        </label>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['selectedSlots'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500 block mt-2"><i class="fa fa-exclamation-triangle mr-2"></i> Please select at least one available time slot</span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                <?php else: ?>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <?php else: ?>
                                <div class="bg-primary/10 px-4 py-1 border-b-[2px] border-b-primary/20 flex justify-between">
                                    <span class="font-semibold text-primary text-md">Sample Details</span>
                                </div>
                                <div class="p-4">
                                    <div class="w-full flex flex-col gap-2">
                                        <label class="font-semibold text-primary">Sample Quantity <span class="text-danger">*</span></label>
                                        <input type="number" wire:model="sample_quantity" min="1" class="px-2 py-2 w-full text-sm font-medium bg-transparent border-[2px] border-primary/40 rounded focus:border-primary" />
                                        <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['sample_quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-exclamation-triangle mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <!--[if BLOCK]><![endif]--><?php if($instrumentTerms && $instrumentTerms->sop): ?>
                                    <div class="w-full flex flex-col gap-2 mt-2 p-4 bg-gray-50 rounded-lg">
                                        <h3 class="font-semibold text-primary">Standard Operating Procedure</h3>
                                        <div class="prose max-w-none text-sm">
                                            <?php echo $instrumentTerms->sop; ?>

                                        </div>
                                        <div class="flex items-center gap-2 mt-2">
                                            <input
                                                type="checkbox"
                                                wire:model="sopAcknowledged"
                                                id="sopAcknowledged"
                                                class="rounded border-primary/40 text-primary focus:ring-primary"
                                            />
                                            <label for="sopAcknowledged" class="text-sm font-medium text-gray-700">
                                                I have read and understood the Standard Operating Procedure
                                            </label>
                                        </div>
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                                <!--[if BLOCK]><![endif]--><?php if($instrumentTerms && $instrumentTerms->instrument_sample_questions): ?>
                                    <div class="w-full flex flex-col gap-2 mt-2 p-4 bg-gray-50 rounded-lg">
                                        <h3 class="font-semibold text-primary">Sample Questions</h3>
                                        <div class="w-full grid lg:grid-cols-3 md:grid-cols-2 grid-cols-1 gap-4">
                                            <!--[if BLOCK]><![endif]--><?php $__currentLoopData = json_decode($instrumentTerms->instrument_sample_questions); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="flex flex-col gap-2 mt-2">
                                                    <p class="text-sm font-medium"><?php echo e($question); ?></p>
                                                    <div class="flex items-center gap-4">
                                                        <label class="inline-flex items-center">
                                                            <input type="radio" wire:model="sample_answers.<?php echo e($index); ?>.answer" value="yes" class="form-radio text-primary">
                                                            <span class="ml-2">Yes</span>
                                                        </label>
                                                        <label class="inline-flex items-center">
                                                            <input type="radio" wire:model="sample_answers.<?php echo e($index); ?>.answer" value="no" class="form-radio text-primary">
                                                            <span class="ml-2">No</span>
                                                        </label>
                                                    </div>
                                                    <div class="w-full">
                                                        <input type="text" wire:model="sample_answers.<?php echo e($index); ?>.description" placeholder="Description" class="w-full px-2 py-1 text-sm border-[2px] border-primary/40 rounded">
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                        </div>

                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            <div class="p-4">
                                <div class="w-full flex flex-col gap-1 mt-4">
                                    <label class="font-semibold text-primary">Description</label>
                                    <textarea wire:model="description" name="description" rows="3" placeholder="Description"
                                              class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"></textarea>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i> <?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="flex justify-center items-center h-full">
                                <img class="h-40 " src="<?php echo e(config('app.logo')); ?>" alt="">
                            </div>

                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!--[if BLOCK]><![endif]--><?php if($isInstrumentAvailable): ?>
                            <div class="w-full flex justify-end px-4 pb-4 gap-2">
                                <button
                                    type="button"
                                    wire:click="submit"
                                    class="text-sm bg-success/30 px-4 py-1 rounded font-semibold border-[2px] border-success text-ternary hover:text-white hover:bg-success hover:border-ternary transition"
                                    <?php echo e(($booking_type === 'slot' && empty($selectedSlots)) || ($booking_type === 'sample' && empty($sample_quantity)) ? 'disabled' : ''); ?>

                                >
                        <span wire:loading.remove wire:target="submit"> <i class="fa fa-plus mr-2"></i>
                            Create Booking
                        </span>
                                    <span wire:loading wire:target="submit">
                      Creating booking   <i class="fas fa-hourglass-half fa-spin ml-2"></i>
                      </span>
                                </button>
                            </div>
                        <?php else: ?>

                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>


        </div>
    <?php else: ?>
        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('bookings.booking-list', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-2707098278-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH /home1/kinkarlab/public_html/resources/views/livewire/bookings/create.blade.php ENDPATH**/ ?>