<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport"
          content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title><?php echo e(config('app.name')); ?>- Admin Dashboard</title>
    <link rel="icon" type="image/x-icon" href="<?php echo e(config('app.fav_icon')); ?>">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,100..900;1,100..900&display=swap"
          rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
          integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
          crossorigin="anonymous" referrerpolicy="no-referrer"/>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>

    <?php echo ToastMagic::styles(); ?>


    <?php echo <<<EOT
                <style>
                    :root {
                        --wc-brand-primary: #a855f7;
                        
                        --wc-light-primary: #fff;  /* white */
                        --wc-light-secondary: oklch(0.967 0.003 264.542);/* --color-gray-100 */
                        --wc-light-accent: oklch(0.985 0.002 247.839);/* --color-gray-50 */
                        --wc-light-border: oklch(0.928 0.006 264.531);/* --color-gray-200 */

                        --wc-dark-primary: oklch(0.21 0.034 264.665); /* --color-zinc-900 */
                        --wc-dark-secondary: oklch(0.278 0.033 256.848);/* --color-zinc-800 */
                        --wc-dark-accent: oklch(0.373 0.034 259.733);/* --color-zinc-700 */
                        --wc-dark-border: oklch(0.373 0.034 259.733);/* --color-zinc-700 */
                    }
                    [x-cloak] {
                        display: none !important;
                    }
                </style>
            EOT; ?>
    <style>
        ::-webkit-scrollbar {
            width: 2px;
            height: 2px;
        }

        /* Track */
        ::-webkit-scrollbar-track {
            background: #f1f1f1;
        }

        /* Handle */
        ::-webkit-scrollbar-thumb {
            background: #001A6E;
        }

        /* Handle on hover */
        ::-webkit-scrollbar-thumb:hover {
            background: #555;
        }

        input::-webkit-outer-spin-button,
        input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }

        /* Firefox */
        input[type=number] {
            -moz-appearance: textfield;
        }


        /*input[type="date"]::-webkit-datetime-edit {*/
        /*    color: #172432b3; !* Change placeholder text color *!*/
        /*}*/

        /*input[type="date"]::-webkit-calendar-picker-indicator {*/
        /*    opacity: 0;*/
        /*}*/


        select {
            -webkit-appearance: none !important; /* Hides the arrow in WebKit-based browsers (Chrome, Safari, Edge) */
            -moz-appearance: none !important; /* Hides the arrow in Firefox */
            appearance: none !important; /* Standard property */
            background: white !important;
            color: rgba(0, 0, 0, 0.7) !important; /* Removes background if needed */
        }

        select option {
            color: rgba(14, 14, 14, 0.9) !important; /* Match placeholder text */
            background-color: #ffffff !important;
        }
    </style>
</head>
<body class="bg-gray-100 relative" style="font-family: 'Public Sans', serif; height: 100vh; width: 100%; overflow:hidden">
<div id="sideBarOverlay" class="xl:w-0 lg:w-0  h-full bg-black/40 absolute top-0 left-0 z-40"
     onclick="document.getElementById('sideBarDiv').classList.toggle('hidden'); document.getElementById('sideBarDiv').classList.toggle('flex'); document.getElementById('sideBarOverlay').classList.toggle('w-full');"></div>

<div class="flex w-full ">
    <div id="sideBarDiv" class="z-20 w-72 p-4 h-[100vh] bg-primary overflow-x-hidden overflow-y-auto flex-none xl:static lg:static absolute top-0 left-0 xl:flex  lg:flex flex-col flex hidden z-50">
        <div class="w-full flex flex-none flex-col justify-center items-center border-b-[1px] pb-2 border-b-gray-100/20 shadow-lg shadow-gray-700/10">
            <?php if(auth()->user()->hasRole('super_admin')): ?>
                <img src="<?php echo e(config('app.dark_logo')); ?>" class="h-40 w-40 rounded-full object-cover"
                     alt="<?php echo e(auth()->user()->name); ?>">

            <?php elseif(auth()->user()->hasRole('pi')): ?>
                <img src="<?php echo e(auth()->user()->principalInvestigators->first()->profile_photo
                ? asset('storage/' . auth()->user()->principalInvestigators->first()->profile_photo)
                : config('app.dark_logo')); ?>"
                     class="h-40 w-40 rounded-full object-cover"
                     alt="<?php echo e(auth()->user()->name); ?>">
            <?php elseif(auth()->user()->hasRole('technician')): ?>
                <img src="<?php echo e(auth()->user()->technicians->first()->profile_photo
                ? asset('storage/' . auth()->user()->technicians->first()->profile_photo)
                : config('app.dark_logo')); ?>"
                     class="h-40 w-40 rounded-full object-cover"
                     alt="<?php echo e(auth()->user()->name); ?>">
            <?php else: ?>
                <img src="<?php echo e(auth()->user()->students->first()->profile_photo
                ? asset('storage/' . auth()->user()->students->first()->profile_photo)
                : config('app.dark_logo')); ?>"
                     class="h-40 w-40 rounded-full object-cover"
                     alt="<?php echo e(auth()->user()->name); ?>">

            <?php endif; ?>


            <span class="font-semibold text-white/80 mt-2 text-2xl"><?php echo e(auth()->user()->name); ?></span>
            <p class="text-primaryLight text-xs text-center"><i class="fa-solid fa-envelope mr-1"></i>
                <?php echo e(auth()->user()->email); ?>

            </p>
        </div>

        <div class="w-full flex h-full  flex-col justify-between mt-12 gap-3">
            <div class="flex flex-col gap-3">
                <?php if(auth()->user()->hasRole('super_admin')): ?>
                    <a href="<?php echo e(route('dashboard')); ?>">
                        <div
                            class=" <?php echo e(Route::currentRouteName()==='dashboard'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'); ?> w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-tv mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Dashboard</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create pi')): ?>
                    <a href="<?php echo e(route('pi.list')); ?>">
                        <div
                            class=" <?php echo e(Route::currentRouteName()==='pi.list'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'); ?> w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-user mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Faculty In-Charge</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                <?php endif; ?>

                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create pi')): ?>
                    <a href="<?php echo e(route('technician.list')); ?>">
                        <div
                            class=" <?php echo e(Route::currentRouteName()==='technician.list'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'); ?> w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-user-gear mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Lab In-Charge</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create lab')): ?>
                    <a href="<?php echo e(route('lab.list')); ?>">
                        <div
                            class=" <?php echo e(Route::currentRouteName()==='lab.list'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'); ?> w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa-solid fa-flask mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Labs</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create student')): ?>
                    <a href="<?php echo e(route('student.list')); ?>">
                        <div
                            class=" <?php echo e(Route::currentRouteName()==='student.list'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'); ?> w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-user-graduate mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Students</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create instrumentCategory')): ?>
                    <a href="<?php echo e(route('instrument.instrument-category')); ?>">
                        <div
                            class=" <?php echo e(Route::currentRouteName()==='instrument.instrument-category'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'); ?> w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-layer-group mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Instrument Category</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view instrument')): ?>
                    <a href="<?php echo e(route('instrument.instrument')); ?>">
                        <div
                            class=" <?php echo e(Route::currentRouteName()==='instrument.instrument'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'); ?> w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-microscope mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Instruments</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view bookings')): ?>
                    <a href="<?php echo e(route('bookings.create')); ?>">
                        <div
                            class=" <?php echo e(Route::currentRouteName()==='bookings.create'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'); ?> w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-calendar-days mr-2 text-sm"></i>
                                <span class="text-lg font-medium">
                                 <?php if(!auth()->user()->hasRole('student')): ?>
                                        Bookings
                                    <?php else: ?>
                                        My Bookings
                                    <?php endif; ?>
                            </span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view pending bookings')): ?>
                    <a href="<?php echo e(route('bookings.pendingBookings')); ?>">
                        <div
                            class=" <?php echo e(Route::currentRouteName()==='bookings.pendingBookings'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'); ?> w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-hourglass-half mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Bookings For Approval </span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                <?php endif; ?>
                <a href="<?php echo e(route('usage.index')); ?>">
                    <div
                        class=" <?php echo e(Route::currentRouteName()==='usage.index'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'); ?> w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                        <div class="flex items-center">
                            <i class="fa fa-chart-bar mr-2 text-sm"></i>
                            <span class="text-lg font-medium">Usage</span>
                        </div>
                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                    </div>
                </a>
            </div>
            <div class="flex flex-col gap-3">
                <a href="<?php echo e(route('instrument.other-complaints')); ?>">
                    <div
                        class=" <?php echo e(Route::currentRouteName()==='instrument.other-complaints'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'); ?> w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                        <div class="flex items-center">
                            <i class="fa fa-exclamation-triangle mr-2 text-sm"></i>
                            <span class="text-lg font-medium">Instrument Complaints</span>
                        </div>
                        <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                    </div>
                </a>
                <span class="text-white text-xs">Account Settings</span>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create roles')): ?>
                    <a href="<?php echo e(route('rolesPermissions.create')); ?>">
                        <div
                            class=" <?php echo e(Route::currentRouteName()==='rolesPermissions.create'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'); ?> w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-lock mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Roles & Permissions</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('account settings')): ?>
                    <a href="<?php echo e(route('account.settings')); ?>">
                        <div
                            class=" <?php echo e(Route::currentRouteName()==='account.settings'?'bg-primaryLight/90 border-[2px] border-white text-primary':'border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10'); ?> w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                            <div class="flex items-center">
                                <i class="fa fa-user-shield mr-2 text-sm"></i>
                                <span class="text-lg font-medium">Admin Settings</span>
                            </div>
                            <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                        </div>
                    </a>
                <?php endif; ?>
                <div onclick="document.getElementById('passwordUpdateDiv').classList.toggle('hidden')"  class="cursor-pointer border-[2px] border-primary  bg-primary text-white/90 hover:bg-primaryLight/10 w-full flex justify-between items-center py-1 px-4 rounded-[3px] relative transition ease-in duration-2000">
                    <div class="flex items-center">
                        <i class="fa fa-lock-open mr-2 text-sm"></i>
                        <span class="text-lg font-medium">Update Password</span>
                    </div>
                    <div class="h-16 w-12 bg-primary absolute top-1 -right-6 rotate-45"></div>
                </div>
            </div>
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                

                
                
                
                
                
                
                
                
                
                
                
                
                

                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                

                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                

                
                
                
                
                
                
                
                
                
                
                
                

                
                
                
                
                
                
                
                
                
                
                
                

                
                
                
                
                
                
                
                
                
                
                
                

                
                
                
                
                
                
                
                
                
                
                
                

                
                
                
                
                
                
                
                
                
                
                
                

                
                
                
                
                
                
                
                
                
                
                
                

                
                
                
                
                
                
                
                
                
                
                
                
                
        </div>
        <div class="hidden" id="passwordUpdateDiv">
            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('accounts.update-password', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-1667053786-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        </div>
    </div>
    <div class=" h-[100vh] w-full overflow-y-auto">
        <div
            class="w-full px-4 py-2 flex xl:justify-between lg:justify-between md:justify-between sm:justify-between justify-between items-center bg-white sticky top-0 border-b-[2px] border-b-primary/20 z-20">
            <div class="flex items-center">
                <div class="rounded-full h-10 w-10 xl:hidden lg:hidden flex justify-center items-center text-secondary"
                     onclick="document.getElementById('sideBarDiv').classList.toggle('hidden');
                             document.getElementById('sideBarOverlay').classList.toggle('w-full');"><i
                        class="fa fa-bars text-xl" title="Search......"></i></div>
                <span class="font-bold text-primary text-xl xl:block lg:block md:block sm:block hidden">
                   <?php if(auth()->user()->hasRole('super_admin')): ?>
                    Super Admin Dashboard
                    <?php elseif(auth()->user()->hasRole('pi')): ?>
                    Principle Investigator Dashboard
                    <?php elseif(auth()->user()->hasRole('guest')): ?>
                        Dashboard
                    <?php elseif(auth()->user()->hasRole('technician')): ?>
                      Technician Dashboard
                    <?php else: ?>
                    Student Dashboard
                    <?php endif; ?>
                </span>

            </div>
            <div class="w-max flex items-center">
                <div class="flex items-center ̥gap-2 mx-4 cursor-pointer relative">
                    <?php if(auth()->user()): ?>
                        <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('pages.auth.logout', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-1667053786-1', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                    <?php endif; ?>

                </div>
            </div>
        </div>

        <div class="p-4 w-full relative pb-12" style="min-height: 90vh">
            <?php echo e($slot); ?>

        </div>

        <div class="w-full px-4 py-2 flex xl:justify-between lg:justify-between md:justify-between flex-wrap items-center bg-white sticky bottom-0 border-t-[2px] border-b-primary/20">
            <div class="flex items-center gap-2">
                <span class="text-black/70 text-sm font-semibold">
                    &copy; <?php echo e(date('Y')); ?>

                </span>
                <span class="text-primary text-sm font-semibold hover:text-danger transition ease-in duration-2000"><?php echo e(config('app.name')); ?></span>
            </div>
            <div>
                <span class="text-black/70 text-sm font-semibold">Developed by:</span>
                <a href="<?php echo e(config('app.developer_link')); ?>" target="_blank"
                   class="mt-2 text-primary text-md font-semibold hover:text-danger transition ease-in duration-2000"><?php echo e(config('app.developed_by')); ?></a>
            </div>
        </div>

    </div>
</div>


<?php if(session()->has('success')): ?>
    <div id="successMessage"
         class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
        <?php echo e(session('success')); ?>

        <div onclick="document.getElementById('successMessage').classList.add('hidden')"
             class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
            <i class="fa fa-xmark "></i>
        </div>
    </div>
<?php endif; ?>
<?php if(session()->has('error')): ?>
    <div id="dangerMessage"
         class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
        <?php echo e(session('error')); ?>

        <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
             class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
            <i class="fa fa-xmark "></i>
        </div>
    </div>
<?php endif; ?>
<?php echo $__env->yieldPushContent('scripts'); ?>
<script src="https://code.jquery.com/jquery-3.7.1.js" integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4=" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>

<script>

    jQuery(document).on("click", "button", function () {
        setTimeout(function () {
            jQuery(".alert").hide();
        }, 3000);
    });
</script>
<script> document.querySelectorAll('input[type="date"]').forEach(input => {
        input.setAttribute('max', '9999-12-31');
    });</script>
<?php echo ToastMagic::scripts(); ?>

<script src="https://cdn.ckeditor.com/ckeditor5/41.1.0/classic/ckeditor.js"></script>
<?php if(auth()->check()): ?>
                        <?php 
                            echo Blade::render('@livewire(\'wirechat.modal\')');
                            echo Blade::render('<x-wirechat::toast/>');
                            echo Blade::render('<x-wirechat::notification/>');
                        ?>
                <?php endif; ?>
</body>
</html>

<?php /**PATH /home1/kinkarlab/iitr.kinkarlab.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>