<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title><?php echo e(config('app.name')); ?> - Lab Instrument Management Software</title>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta content="" name="keywords">
    <meta content="" name="description">

    <!-- Google Web Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=DM+Sans:ital,opsz,wght@0,9..40,100..1000;1,9..40,100..1000&family=Inter:slnt,wght@-10..0,100..900&display=swap" rel="stylesheet">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>



    

    <!-- Icon Font Stylesheet -->
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css"/>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.4.1/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Libraries Stylesheet -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/front/lib/animate/animate.min.css')); ?>"/>
    <link href="<?php echo e(asset('assets/front/lib/lightbox/css/lightbox.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/front/lib/owlcarousel/assets/owl.carousel.min.css')); ?>" rel="stylesheet">


    <!-- Customized Bootstrap Stylesheet -->
    <link href="<?php echo e(asset('assets/front/css/bootstrap.min.css')); ?>" rel="stylesheet">

    <!-- Template Stylesheet -->
    <link href="<?php echo e(asset('assets/front/css/style.css')); ?>" rel="stylesheet">


    <link href="https://assets.calendly.com/assets/external/widget.css" rel="stylesheet">
    <script src="https://assets.calendly.com/assets/external/widget.js" type="text/javascript" async></script>
    <script type="text/javascript">window.onload = function() { Calendly.initBadgeWidget({ url: '', text: 'Demo', color: '#0b0b0b', textColor: '#ffffff' }); }</script>


    <!-- Calendly badge widget end -->




    <script type="text/javascript">
        document.addEventListener('DOMContentLoaded', function () {
            document.querySelectorAll('.calendlyDemoBtn').forEach(function (button) {
                button.addEventListener('click', function (e) {
                    e.preventDefault();
                    Calendly.initPopupWidget({
                        url: 'https://calendly.com/md-himsoftsolution/kinkar-lab-demo'
                    });
                });
            });
        });
    </script>


</head>

<body>

<?php if(session('success')): ?>
    <div class="col-12" id="successMessageDiv" style="width: 100%; z-index: 999; position: absolute; right: 10px; top: 10px; display: flex; justify-content: end">
        <div class="alert alert-success" style="width: max-content">
            <?php echo e(session('success')); ?>  <i class="fa fa-plus" style="transform: rotate(45deg); margin-left: 30px; cursor: pointer"
                                         onclick="document.getElementById('successMessageDiv').style.display='none'"
            ></i>
        </div>
    </div>
<?php endif; ?>

<?php if($errors->any()): ?>
    <div class="col-12"  style="width: 100%; position: absolute; right: 10px; top: 10px; display: flex; justify-content: end">
        <div class="alert alert-danger" style="width: max-content">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    </div>
<?php endif; ?>


<!-- Topbar Start -->
<div class="container-fluid topbar px-0 px-lg-4 bg-light py-2 d-none d-lg-block">
    <div class="container">
        <div class="row gx-0 align-items-center">
            <div class="col-lg-8 text-center text-lg-start mb-lg-0">
                <div class="d-flex flex-wrap">
                    <div class="ps-3">
                        <a href="mailto:md@himsoftsolution.com" class="text-muted small"><i class="fas fa-envelope text-primary me-2"></i>md@himsoftsolution.com</a>
                    </div>
                    <div class="ps-3">
                        <a href="tel:+91 9988420634" class="text-muted small"><i class="fas fa-phone text-primary me-2"></i>+91 9988420634</a>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 text-center text-lg-end">
                <div class="d-flex justify-content-end">
                    <div class="d-flex border-end border-primary pe-3">
                        <a class="btn p-0 text-primary me-3" target="_blank" href="https://www.facebook.com/himsoftsolution#"><i class="fab fa-facebook-f"></i></a>
                        <a class="btn p-0 text-primary me-0" target="_blank" href="https://www.linkedin.com/company/him-soft-solution/?originalSubdomain=in"><i class="fab fa-linkedin-in"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Topbar End -->

<!-- Navbar & Hero Start -->
<div class="container-fluid nav-bar px-0 px-lg-4 py-lg-0">
    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light">
            <a href="#" class="navbar-brand p-0">

                <img src="<?php echo e(config('app.logo')); ?>" alt="Logo">
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
                <span class="fa fa-bars"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarCollapse">
                <div class="navbar-nav mx-0 mx-lg-auto">
                    <a href="<?php echo e(route('index')); ?>" class="nav-item nav-link active">Home</a>
                    <a href="#about" class="nav-item nav-link">About</a>
                    <a href="#challenges" class="nav-item nav-link">Challenges</a>
                    <a href="#solution" class="nav-item nav-link">Solution</a>
                    <a href="#features" class="nav-item nav-link">Features</a>
                    <a href="#contact" class="nav-item nav-link">Contact</a>

                    <div class="nav-btn">

                        <a href="<?php echo e(route('login')); ?>" class=" btn btn-primary rounded-pill py-1 px-3 ms-3 flex-shrink-0">Login </a>

                    </div>
                </div>
            </div>
            <div class="d-none d-xl-flex flex-shrink-0 ps-4">
                <a href="tel:+ 0123 456 7890" class="btn btn-light btn-lg-square rounded-circle position-relative wow tada" data-wow-delay=".9s">
                    <i class="fa fa-phone-alt fa-2x"></i>
                    <div class="position-absolute" style="top: 7px; right: 12px;">
                        <span><i class="fa fa-comment-dots text-secondary"></i></span>
                    </div>
                </a>
                <div class="d-flex flex-column ms-3">
                    <span style="color: black">Call to Our Experts</span>
                    <a href="tel:+ 0123 456 7890"><span class="text-dark">(+91) 172-4082961</span></a>
                </div>
            </div>
        </nav>
    </div>
</div>


<div class="container-fluid bg-light about py-5" id="about">
    <div class="container">
        <div class="row g-5">
            <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('instruments.public-instruments-list', []);

$__html = app('livewire')->mount($__name, $__params, 'lw-1834170147-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
        </div>
    </div>
</div>


<!-- Copyright Start -->
<div class="container-fluid copyright py-4">
    <div class="container">
        <div class="row g-4 align-items-center">
            <div class="col-md-6 text-center text-md-end mb-md-0">
                <span class=" text-white"><a href="#" class="border-bottom text-white" style="font-weight: bold"><i class="fas fa-copyright text-light me-2"></i><?php echo e(config('app.name')); ?></a>, All right reserved.</span>
            </div>
            <div class="col-md-6 text-center text-md-start text-white">
                <!--/*** This template is free as long as you keep the below author’s credit link/attribution link/backlink. ***/-->
                <!--/*** If you'd like to use the template without the below author’s credit link/attribution link/backlink, ***/-->
                <!--/*** you can purchase the Credit Removal License from "https://htmlcodex.com/credit-removal". ***/-->
                Designed By <a class="border-bottom text-white font-bold" style="font-weight: bold" href="<?php echo e(config('app.developer_link')); ?>"><?php echo e(config('app.developed_by')); ?></a>
            </div>
        </div>
    </div>
</div>
<!-- Copyright End -->


<!-- Back to Top -->
<a href="#" class="btn btn-primary btn-lg-square rounded-circle back-to-top"><i class="fa fa-arrow-up"></i></a>


<!-- JavaScript Libraries -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="<?php echo e(asset('assets/front/lib/wow/wow.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/lib/easing/easing.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/lib/waypoints/waypoints.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/lib/counterup/counterup.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/lib/lightbox/js/lightbox.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/front/lib/owlcarousel/owl.carousel.min.js')); ?>"></script>


<!-- Template Javascript -->
<script src="<?php echo e(asset('assets/front/js/main.js')); ?>"></script>
</body>

</html>
<?php /**PATH D:\work\kinker\resources\views/publicInstruments.blade.php ENDPATH**/ ?>