<div>
    <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col">
        <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between items-center">
            <span class="font-semibold text-primary text-xl">Service Details</span>

            <div class="flex items-center gap-4">
                <button wire:click="hideViewInstrumentServiceDetails" class="text-sm bg-danger/20 text-danger px-2 py-0.5 mr-2 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/80 hover:text-white hover:bg-danger hover:border-danger/30 transition ease-in duration-2000">
                    <i class="fa fa-xmark"></i>
                </button>
            </div>
        </div>

        <div class="p-4 grid xl:grid-cols-2 gap-4">
            <!-- Basic Service Info -->
            <div class="flex flex-col gap-2">
                <h3 class="font-semibold text-primary text-lg">Service Information</h3>
                <div class="grid grid-cols-2 gap-2 text-sm text-black">
                    <span>Service Type:</span>
                    <span class="font-semibold"><?php echo e(ucfirst($service->service_type)); ?></span>
                    <span>Status:</span>
                    <span class="font-semibold"><?php echo e(ucfirst($service->status)); ?></span>
                    <span>Description:</span>
                    <span class="font-semibold"><?php echo e($service->description); ?></span>
                    <span>Next Service Date:</span>
                    <span class="font-semibold"><?php echo e($service->next_service_date ?? 'Not Scheduled'); ?></span>
                </div>
            </div>

            <!-- Instrument Info -->
            <div class="flex flex-col gap-2">
                <h3 class="font-semibold text-primary text-lg">Instrument Information</h3>
                <div class="grid grid-cols-2 gap-2 text-sm">
                    <span>Instrument Name:</span>
                    <span class="font-semibold"><?php echo e($service->instrument->name); ?></span>
                    <span>Model Number:</span>
                    <span class="font-semibold"><?php echo e($service->instrument->model_number); ?></span>
                    <span>Serial Number:</span>
                    <span class="font-semibold"><?php echo e($service->instrument->serial_number); ?></span>
                </div>
            </div>

            <!-- Parts Information -->
            <!--[if BLOCK]><![endif]--><?php if($service->instrument_details): ?>
                <div class="flex flex-col gap-2 col-span-2">
                    <h3 class="font-semibold text-primary text-lg">Parts Information</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = json_decode($service->instrument_details, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $part): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="border rounded-lg p-4 hover:shadow-lg transition">
                                <h4 class="font-semibold text-primary mb-2"><?php echo e($part['part_name']); ?></h4>
                                <p class="text-sm text-gray-600 mb-2"><?php echo e($part['part_description']); ?></p>
                                <p class="text-sm text-gray-500">Old Part Received: <?php echo e($part['oldPartReceived'] ? 'Yes' : 'No'); ?></p>
                                <!--[if BLOCK]><![endif]--><?php if(!empty($part['part_images'])): ?>
                                    <div class="mt-2 grid grid-cols-2 gap-2">
                                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $part['part_images']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(asset('storage/' . $image)); ?>" target="_blank">
                                                <img src="<?php echo e(asset('storage/' . $image)); ?>" alt="Part Image" class="w-full h-24 object-cover rounded">
                                            </a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

            <!-- Invoice Information -->
            <!--[if BLOCK]><![endif]--><?php if($service->invoice_details): ?>
                <?php
                    $invoiceDetails = json_decode($service->invoice_details, true);
                ?>
                <div class="flex flex-col gap-2 col-span-2">
                    <h3 class="font-semibold text-primary text-lg">Invoice Information</h3>
                    <div class="grid grid-cols-2 gap-4">
                        <div class="grid grid-cols-2 gap-2 text-sm">
                            <span>Invoice Cost:</span>
                            <span class="font-semibold">₹<?php echo e($invoiceDetails['invoice_cost']); ?></span>
                            <span>Invoice Date:</span>
                            <span class="font-semibold"><?php echo e($invoiceDetails['invoice_date']); ?></span>
                        </div>
                        <div class="flex justify-end">
                            <a href="<?php echo e(asset('storage/' . $invoiceDetails['invoice_image'])); ?>" target="_blank" class="flex items-center gap-2 px-4 py-2 border rounded-lg hover:bg-gray-50">
                                <i class="fa fa-file-invoice text-primary text-xl"></i>
                                <span class="text-sm font-semibold">View Invoice</span>
                            </a>
                        </div>
                    </div>
                </div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    </div>
</div><?php /**PATH /home1/kinkarlab/public_html/resources/views/livewire/instruments/view-instrument-service-details.blade.php ENDPATH**/ ?>