<div>
    <!--[if BLOCK]><![endif]--><?php if(session()->has('success')): ?>
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            <?php echo e(session('success')); ?>

            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

    <!--[if BLOCK]><![endif]--><?php if($userType === 'student'): ?>
        <!-- Student Usage View -->
        <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300 mb-6">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
                <span class="font-semibold text-primary text-xl">My Usage Summary</span>
            </div>
            
            <div class="p-4">
                <div class="grid xl:grid-cols-4 lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-4 mb-6">
                    <!-- Student Info -->
                    <div class="bg-primary/5 border-[1px] border-primary/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Student</h3>
                                <p class="text-lg font-bold text-primary"><?php echo e($userData['student_name'] ?? 'N/A'); ?></p>
                                <p class="text-xs text-gray-400"><?php echo e($userData['academic_id'] ?? 'N/A'); ?></p>
                            </div>
                            <div class="bg-primary/10 p-3 rounded-full">
                                <i class="fa fa-user-graduate text-primary text-xl"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Total Bookings -->
                    <div class="bg-success/5 border-[1px] border-success/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Total Bookings</h3>
                                <p class="text-2xl font-bold text-success"><?php echo e($userData['total_bookings'] ?? 0); ?></p>
                                <p class="text-xs text-gray-400">All time</p>
                            </div>
                            <div class="bg-success/10 p-3 rounded-full">
                                <i class="fa fa-calendar-check text-success text-xl"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Total Hours -->
                    <div class="bg-warning/5 border-[1px] border-warning/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Total Usage</h3>
                                <p class="text-2xl font-bold text-warning"><?php echo e($userData['total_hours'] ?? 0); ?></p>
                                <p class="text-xs text-gray-400">Hours</p>
                            </div>
                            <div class="bg-warning/10 p-3 rounded-full">
                                <i class="fa fa-clock text-warning text-xl"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Instruments Used -->
                    <div class="bg-danger/5 border-[1px] border-danger/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Instruments Used</h3>
                                <p class="text-2xl font-bold text-danger"><?php echo e(count($userData['instruments'] ?? [])); ?></p>
                                <p class="text-xs text-gray-400">Different instruments</p>
                            </div>
                            <div class="bg-danger/10 p-3 rounded-full">
                                <i class="fa fa-microscope text-danger text-xl"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Instrument Usage Details -->
        <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
                <span class="font-semibold text-primary text-xl">My Instrument Usage</span>
            </div>
            
            <div class="w-full overflow-x-auto p-4">
                <table class="w-full border-[2px] border-secondary/40 border-collapse">
                    <thead>
                        <tr>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Sr. No.</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Instrument</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Lab</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Total Hours</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Bookings</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Last Booking</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $this->paginatedInstrumentData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $instrument): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-secondary/10 transition ease-in duration-200">
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e((($instrumentPage - 1) * $perPage) + $index + 1); ?></td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e($instrument['instrument_name']); ?></td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e($instrument['lab_name']); ?></td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                    <span class="bg-primary/10 text-primary px-2 py-1 rounded-full text-xs"><?php echo e($instrument['total_hours']); ?></span>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e($instrument['booking_count']); ?></td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                    <!--[if BLOCK]><![endif]--><?php if($instrument['last_booking'] !== 'No bookings'): ?>
                                        <?php echo e(\Carbon\Carbon::parse($instrument['last_booking'])->format('d M Y')); ?>

                                    <?php else: ?>
                                        <?php echo e($instrument['last_booking']); ?>

                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="border-[2px] border-secondary/40 px-4 py-8 text-center text-gray-500">
                                    <div class="flex flex-col items-center">
                                        <i class="fa fa-microscope text-4xl text-gray-300 mb-2"></i>
                                        <p>No instrument usage found</p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
                
                <!-- Instrument Pagination -->
                <!--[if BLOCK]><![endif]--><?php if($this->instrumentTotalPages > 1): ?>
                    <div class="mt-4 flex justify-between items-center">
                        <div class="text-sm text-gray-500">
                            Showing <?php echo e((($instrumentPage - 1) * $perPage) + 1); ?> to <?php echo e(min($instrumentPage * $perPage, count($userData['instruments'] ?? []))); ?> of <?php echo e(count($userData['instruments'] ?? [])); ?> results
                        </div>
                        <div class="flex items-center gap-2">
                            <button wire:click="previousInstrumentPage" 
                                    <?php if($instrumentPage <= 1): ?> disabled <?php endif; ?>
                                    class="px-3 py-1 text-sm bg-primary/20 text-primary rounded hover:bg-primary hover:text-white transition disabled:opacity-50 disabled:cursor-not-allowed">
                                Previous
                            </button>
                            
                            <!--[if BLOCK]><![endif]--><?php for($i = 1; $i <= $this->instrumentTotalPages; $i++): ?>
                                <button wire:click="gotoInstrumentPage(<?php echo e($i); ?>)"
                                        class="px-3 py-1 text-sm rounded transition <?php echo e($instrumentPage == $i ? 'bg-primary text-white' : 'bg-gray-200 text-gray-700 hover:bg-primary hover:text-white'); ?>">
                                    <?php echo e($i); ?>

                                </button>
                            <?php endfor; ?><!--[if ENDBLOCK]><![endif]-->
                            
                            <button wire:click="nextInstrumentPage" 
                                    <?php if($instrumentPage >= $this->instrumentTotalPages): ?> disabled <?php endif; ?>
                                    class="px-3 py-1 text-sm bg-primary/20 text-primary rounded hover:bg-primary hover:text-white transition disabled:opacity-50 disabled:cursor-not-allowed">
                                Next
                            </button>
                        </div>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>

    <?php elseif($userType === 'pi'): ?>
        <!-- PI Usage View -->
        <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300 mb-6">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
                <span class="font-semibold text-primary text-xl">PI Usage Summary</span>
            </div>
            
            <div class="p-4">
                <div class="grid xl:grid-cols-4 lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-4 mb-6">
                    <!-- PI Info -->
                    <div class="bg-primary/5 border-[1px] border-primary/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Principal Investigator</h3>
                                <p class="text-lg font-bold text-primary"><?php echo e($userData['pi_name'] ?? 'N/A'); ?></p>
                                <p class="text-xs text-gray-400"><?php echo e($userData['department'] ?? 'N/A'); ?></p>
                            </div>
                            <div class="bg-primary/10 p-3 rounded-full">
                                <i class="fa fa-user-tie text-primary text-xl"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Total Students -->
                    <div class="bg-success/5 border-[1px] border-success/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Total Students</h3>
                                <p class="text-2xl font-bold text-success"><?php echo e($userData['total_students'] ?? 0); ?></p>
                                <p class="text-xs text-gray-400">Under supervision</p>
                            </div>
                            <div class="bg-success/10 p-3 rounded-full">
                                <i class="fa fa-users text-success text-xl"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Total Bookings -->
                    <div class="bg-warning/5 border-[1px] border-warning/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Total Bookings</h3>
                                <p class="text-2xl font-bold text-warning"><?php echo e($userData['total_bookings'] ?? 0); ?></p>
                                <p class="text-xs text-gray-400">All students</p>
                            </div>
                            <div class="bg-warning/10 p-3 rounded-full">
                                <i class="fa fa-calendar-check text-warning text-xl"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Total Hours -->
                    <div class="bg-danger/5 border-[1px] border-danger/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Total Usage</h3>
                                <p class="text-2xl font-bold text-danger"><?php echo e($userData['total_hours'] ?? 0); ?></p>
                                <p class="text-xs text-gray-400">Hours</p>
                            </div>
                            <div class="bg-danger/10 p-3 rounded-full">
                                <i class="fa fa-clock text-danger text-xl"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Student Usage Details -->
        <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
                <span class="font-semibold text-primary text-xl">Student Usage Details</span>
            </div>
            
            <div class="w-full overflow-x-auto p-4">
                <table class="w-full border-[2px] border-secondary/40 border-collapse">
                    <thead>
                        <tr>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Sr. No.</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Student Name</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Academic ID</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Total Bookings</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Total Hours</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Last Booking</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $this->paginatedStudentData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-secondary/10 transition ease-in duration-200">
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e((($studentPage - 1) * $perPage) + $index + 1); ?></td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e($student['name']); ?></td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e($student['academic_id']); ?></td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm"><?php echo e($student['total_bookings']); ?></td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                    <span class="bg-primary/10 text-primary px-2 py-1 rounded-full text-xs"><?php echo e($student['total_hours']); ?></span>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                    <!--[if BLOCK]><![endif]--><?php if($student['last_booking'] !== 'No bookings'): ?>
                                        <?php echo e(\Carbon\Carbon::parse($student['last_booking'])->format('d M Y')); ?>

                                    <?php else: ?>
                                        <?php echo e($student['last_booking']); ?>

                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="6" class="border-[2px] border-secondary/40 px-4 py-8 text-center text-gray-500">
                                    <div class="flex flex-col items-center">
                                        <i class="fa fa-user-graduate text-4xl text-gray-300 mb-2"></i>
                                        <p>No student usage data found</p>
                                    </div>
                                </td>
                            </tr>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                </table>
                
                <!-- Student Pagination -->
                <!--[if BLOCK]><![endif]--><?php if($this->studentTotalPages > 1): ?>
                    <div class="mt-4 flex justify-between items-center">
                        <div class="text-sm text-gray-500">
                            Showing <?php echo e((($studentPage - 1) * $perPage) + 1); ?> to <?php echo e(min($studentPage * $perPage, count($studentUsageData))); ?> of <?php echo e(count($studentUsageData)); ?> results
                        </div>
                        <div class="flex items-center gap-2">
                            <button wire:click="previousStudentPage" 
                                    <?php if($studentPage <= 1): ?> disabled <?php endif; ?>
                                    class="px-3 py-1 text-sm bg-primary/20 text-primary rounded hover:bg-primary hover:text-white transition disabled:opacity-50 disabled:cursor-not-allowed">
                                Previous
                            </button>
                            
                            <!--[if BLOCK]><![endif]--><?php for($i = 1; $i <= $this->studentTotalPages; $i++): ?>
                                <button wire:click="gotoStudentPage(<?php echo e($i); ?>)"
                                        class="px-3 py-1 text-sm rounded transition <?php echo e($studentPage == $i ? 'bg-primary text-white' : 'bg-gray-200 text-gray-700 hover:bg-primary hover:text-white'); ?>">
                                    <?php echo e($i); ?>

                                </button>
                            <?php endfor; ?><!--[if ENDBLOCK]><![endif]-->
                            
                            <button wire:click="nextStudentPage" 
                                    <?php if($studentPage >= $this->studentTotalPages): ?> disabled <?php endif; ?>
                                    class="px-3 py-1 text-sm bg-primary/20 text-primary rounded hover:bg-primary hover:text-white transition disabled:opacity-50 disabled:cursor-not-allowed">
                                Next
                            </button>
                        </div>
                    </div>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>

    <?php else: ?>
        <!-- Other User Types -->
        <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
                <span class="font-semibold text-primary text-xl">Usage Information</span>
            </div>
            
            <div class="p-8 text-center">
                <div class="flex flex-col items-center">
                    <i class="fa fa-info-circle text-6xl text-gray-300 mb-4"></i>
                    <h3 class="text-lg font-medium text-gray-600 mb-2">Usage Tracking Not Available</h3>
                    <p class="text-gray-500">Usage tracking is only available for Students and Principal Investigators.</p>
                </div>
            </div>
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
</div><?php /**PATH /home1/kinkarlab/iitr.kinkarlab.com/resources/views/livewire/usage/user-usage.blade.php ENDPATH**/ ?>