<!DOCTYPE html>
<html>
<head>
    <title>Instrument List</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .status-working {
            color: green;
        }
        .status-faulty {
            color: red;
        }
        .status-under_maintenance {
            color: orange;
        }
    </style>
</head>
<body>
<div class="header">
    <h2>Instrument List</h2>
    <p>Generated on: <?php echo e(date('Y-m-d H:i:s')); ?></p>
</div>

<table>
    <thead>
    <tr>
        <th>Name</th>
        <th>Category</th>
        <th>Lab</th>
        <th>Model Number</th>
        <th>Serial Number</th>
        <th>Per Hour Cost</th>
        <th>Operating Status</th>
        <th>Engineer Name</th>
        <th>Engineer Contact</th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $instruments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instrument): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($instrument->name); ?></td>
            <td><?php echo e($instrument->instrumentCategory ? $instrument->instrumentCategory->title : 'N/A'); ?></td>
            <td><?php echo e($instrument->lab ? $instrument->lab->lab_name : 'N/A'); ?></td>
            <td><?php echo e($instrument->model_number); ?></td>
            <td><?php echo e($instrument->serial_number); ?></td>
            <td><?php echo e($instrument->booking_cost); ?></td>
            <td class="status-<?php echo e($instrument->operating_status); ?>"><?php echo e(ucfirst($instrument->operating_status)); ?></td>
            <td><?php echo e($instrument->engineer_name); ?></td>
            <td><?php echo e($instrument->engineer_email); ?> / <?php echo e($instrument->engineer_mobile); ?></td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</body>
</html>
<?php /**PATH /home1/kinkarlab/public_html/resources/views/exports/instrument-pdf.blade.php ENDPATH**/ ?>