<!DOCTYPE html>
<html>
<head>
    <title>PI Funds Report</title>
    <style>
        body { font-family: Arial, sans-serif; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; }
        .header { text-align: center; margin-bottom: 20px; }
        .date { text-align: right; margin-bottom: 10px; }
    </style>
</head>
<body>
    <div class="header">
        <h2>Principal Investigator's Funds Report</h2>
    </div>
    <div class="date">
        Generated on: <?php echo e(date('d M Y, h:i A')); ?>

    </div>
    <table>
        <thead>
            <tr>
                <th>Sr. No.</th>
                <th>Principal Investigator</th>
                <th>Amount</th>
                <th>Fund Added On</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $funds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fund): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($fund->principalInvestigator->full_name); ?></td>
                    <td><?php echo e(number_format($fund->amount, 2)); ?></td>
                    <td><?php echo e($fund->created_at->format('d M Y, h:i A')); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html><?php /**PATH /home1/kinkarlab/public_html/resources/views/exports/pi-funds-pdf.blade.php ENDPATH**/ ?>