<!-- resources/views/exports/pi-pdf.blade.php -->
<!DOCTYPE html>
<html>
<head>
    <title>Principal Investigators</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .status-active {
            color: green;
        }
        .status-inactive {
            color: red;
        }
    </style>
</head>
<body>
<div class="header">
    <h2>Principal Investigators List</h2>
    <p>Generated on: <?php echo e(date('Y-m-d H:i:s')); ?></p>
</div>

<table>
    <thead>
    <tr>
        <th>Sr. No.</th>
        <th>Name</th>
        <th>Email</th>
        <th>Phone</th>
        <th>Designation</th>
        <th>Department</th>
        <th>Status</th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $piList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($loop->iteration); ?></td>
            <td><?php echo e($pi->getFullNameAttribute()); ?></td>
            <td><?php echo e($pi->email); ?></td>
            <td><?php echo e($pi->phone); ?></td>
            <td><?php echo e($pi->designation); ?></td>
            <td><?php echo e($pi->department); ?></td>
            <td class="<?php echo e($pi->status == 1 ? 'status-active' : 'status-inactive'); ?>">
                <?php echo e($pi->status == 1 ? 'Active' : 'Inactive'); ?>

            </td>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</body>
</html>
<?php /**PATH /home1/kinkarlab/public_html/resources/views/exports/pi-pdf.blade.php ENDPATH**/ ?>