<?php

use App\Livewire\Pi\PiList;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;

Route::get('/migrate-tenant', function () {
    dd("heelo");

})->middleware('check.tenant');;

Route::view('/instrument-info/{hash}', 'pages.instruments.instrumentInfo')->middleware(['auth', 'verified'])->name('instrument.show');

// Route to run queue:work once
Route::get('/run-queue-worker', function () {
    Artisan::call('queue:work', [
        '--stop-when-empty' => true,
    ]);
    return "Queue worker processed all jobs and exited.";
});

Route::get('important-route/run-storage-link', function () {
    Artisan::call('storage:link');
    return "Storage linked successfully!";
});

Route::get('important-route/run-migrations', function () {
    Artisan::call('migrate', ['--force' => true]);
    $output = Artisan::output();

    return nl2br($output ?: 'No new migrations to run. Database is already up to date.');
});

Route::get('important-route/fresh-migrate-seed', function () {
    Artisan::call('migrate:fresh --seed');
    return "Fresh migration and seed completed!";
});

Route::get('important-route/run-permission-seeder', function () {
    Artisan::call('db:seed', [
        '--class' => 'PermissionSeeder',
    ]);
    return "PermissionSeeder has been executed!";
});


Route::get('important-route/run-database-seeder', function () {
    Artisan::call('db:seed', [
        '--class' => 'DatabaseSeeder',
    ]);

    return nl2br(Artisan::output());
});






Route::get('/tenants', function () {
    return view('tenants'); // This is the Blade view that includes the Livewire component
})->name('tenants');


/**** Middleware Part to check Subdomin *** */
Route::middleware(['tenant'])->group(function () {

    Route::get('/heelo',function(){
        dd("heeloasdf");
        dd("heelo");
    });
Route::view('/', 'index')->name('index');
Route::view('/instruments', 'publicInstruments')->name('publicInstruments');

Route::get('/dashboard', function () {
    $user = Auth::user();
    if ($user->hasRole('super_admin')) {
        return view('dashboard');
    } elseif ($user->hasRole('pi')) {
        return redirect()->route('student.list');
    } elseif ($user->hasRole('student')) {
        return redirect()->route('bookings.create');
    } elseif ($user->hasRole('guest')) {
        return redirect()->route('bookings.create');
    }elseif ($user->hasRole('technician')) {
        return redirect()->route('instrument.instrument');
    }
    return redirect('/login');
})
    ->middleware(['auth', 'verified'])
    ->name('dashboard');


Route::view('profile', 'profile')
    ->middleware(['auth'])
    ->name('profile');

Route::prefix('pi')->name('pi.')->group(function () {
    Route::view('/', 'pages.pi.index')
        ->middleware(['auth'])
        ->middleware( 'can:create pi')
        ->name('list');
});
Route::prefix('lab-incharge')->name('technician.')->group(function () {
    Route::view('/', 'pages.technician.index')
        ->middleware(['auth'])
        ->middleware( 'can:create pi')
        ->name('list');
});
Route::prefix('lab')->name('lab.')->group(function () {
    Route::view('/', 'pages.lab.index')
        ->middleware(['auth'])
        ->middleware('can:create lab')
        ->name('list');
});
Route::prefix('student')->name('student.')->group(function () {
    Route::view('/', 'pages.student.index')
        ->middleware(['auth'])
        ->middleware( 'can:create student')
        ->name('list');
});
Route::prefix('instrument')->name('instrument.')->group(function () {
    Route::view('/category', 'pages.instruments.category')
        ->middleware(['auth'])
        ->middleware( 'can:create instrumentCategory')
        ->name('instrument-category');

    Route::view('/instrument', 'pages.instruments.instrument')
        ->middleware(['auth'])
        ->middleware( 'can:view instrument')
        ->name('instrument');

    Route::view('/complaint', 'pages.instruments.complaint')
        ->middleware(['auth'])
        ->middleware( 'can:view instrument complaint')
        ->name('complaints');

    Route::view('/other-complaints', 'pages.instruments.otherComplaints')
        ->middleware(['auth'])
        ->name('other-complaints');

    Route::view('/service', 'pages.instruments')
        ->middleware(['auth'])
        ->middleware( 'can:view instrument services')
        ->name('service');
});
Route::prefix('bookings')->name('bookings.')->group(function () {
    Route::view('/pending-for-approval', 'pages.bookings.pendingBookings')
        ->middleware(['auth'])
        ->middleware( 'can:view pending bookings')
        ->name('pendingBookings');

    Route::get('/{instrument_id?}/{student_id?}', function ($instrument_id = null, $student_id = null) {
        return view('pages.bookings.create', compact('instrument_id', 'student_id'));
    })
        ->middleware(['auth'])
        ->name('create');
});
Route::prefix('rolesPermissions')->name('rolesPermissions.')->group(function () {
    Route::view('/', 'pages.rolesPermissions.index')
        ->middleware(['auth'])
        ->middleware( 'can:create roles')
        ->name('create');
});
Route::prefix('funds')->name('funds.')->group(function () {
    Route::view('/', 'pages.funds.indexs')
        ->middleware(['auth'])
        ->middleware( 'can:add funds')
        ->name('create');
});
Route::prefix('account')->name('account.')->group(function () {
    Route::view('/', 'pages.account.settings')
        ->middleware(['auth'])
        ->middleware( 'can:account settings')
        ->name('settings');
});
Route::prefix('usage')->name('usage.')->group(function () {
    Route::view('/', 'pages.usage.index')
        ->middleware(['auth'])
        ->name('index');
});
Route::prefix('inventory')->name('inventory.')->group(function () {

    Route::view('/storage', 'pages.inventory.storage')
        ->middleware(['auth'])
        ->middleware( 'can:view storages')
        ->name('storage');

    Route::view('/sub-boxes/{id}', 'pages.inventory.subBoxes')
        ->middleware(['auth'])
        ->middleware( 'can:view storages')
        ->name('sub-boxes');

    Route::view('/items-slots', 'pages.inventory.itemsSlots')
        ->middleware(['auth'])
        ->middleware( 'can:view item slotss')
        ->name('items-slots');

    Route::view('/slot-items', 'pages.inventory.slotItems')
        ->middleware(['auth'])
        ->middleware( 'can:view item slotss')
        ->name('slot-items');

    // QR Code Info Routes
    Route::view('/box-info/{hash}', 'pages.inventory.boxInfo')
        ->name('box-info');

    Route::view('/items-slot-info/{hash}', 'pages.inventory.itemsSlotInfo')
        ->name('items-slot-info');

    Route::view('/bio-bank', 'pages.inventory.inventory')
        ->middleware(['auth'])
        ->name('bioBank');

    Route::view('/consumables', 'pages.inventory.inventory')
        ->middleware(['auth'])
        ->name('consumables');

    // Laboratory Inventory System Routes
    Route::view('/lab-dashboard', 'pages.inventory.dashboard')
        ->middleware(['auth'])
        ->middleware('can:view lab dashboardd')
        ->name('lab-dashboard');

    Route::view('/categories', 'pages.inventory.categories')
        ->middleware(['auth'])
        ->middleware('can:manage lab categoriess')
        ->name('categories');

    Route::view('/items', 'pages.inventory.items')
        ->middleware(['auth'])
        ->middleware('can:manage lab itemss')
        ->name('items');

    Route::view('/suppliers', 'pages.inventory.suppliers')
        ->middleware(['auth'])
        ->middleware('can:manage lab supplierss')
        ->name('suppliers');

    Route::view('/stock', 'pages.inventory.stock')
        ->middleware(['auth'])
        ->middleware('can:manage lab stockk')
        ->name('stock');

    Route::view('/alerts', 'pages.inventory.alerts')
        ->middleware(['auth'])
        ->middleware('can:manage lab stock alertss')
        ->name('alerts');

    Route::view('/reports', 'pages.inventory.reports')
        ->middleware(['auth'])
        ->middleware('can:manage lab stock reportss')
        ->name('reports');
});

require __DIR__.'/auth.php';

// Add this with your other routes
Route::post('/contact', [App\Http\Controllers\ContactController::class, 'submit'])->name('contact.submit');

});
