<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>{{ $title }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
        }
        .info {
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .status-out-of-stock {
            color: #dc2626;
            font-weight: bold;
        }
        .status-critical {
            color: #ea580c;
            font-weight: bold;
        }
        .status-low {
            color: #d97706;
            font-weight: bold;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $title }}</h1>
    </div>

    <div class="info">
        <p><strong>Generated on:</strong> {{ $generatedAt }}</p>
        <p><strong>Total Items:</strong> {{ $data->count() }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Item Name</th>
                <th>Category</th>
                <th>Type</th>
                <th>Current Stock</th>
                <th>Min Level</th>
                <th>Deficit</th>
                <th>Status</th>
                <th>Storage Conditions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($data as $item)
                @php
                    $currentStock = $item->getCurrentStock();
                    $deficit = max(0, $item->min_stock_level - $currentStock);
                    $statusClass = 'status-low';
                    $status = 'Low Stock';
                    
                    if ($currentStock <= 0) {
                        $statusClass = 'status-out-of-stock';
                        $status = 'Out of Stock';
                    } elseif ($currentStock <= ($item->min_stock_level * 0.5)) {
                        $statusClass = 'status-critical';
                        $status = 'Critical';
                    }
                @endphp
                <tr>
                    <td>{{ $item->name }}</td>
                    <td>{{ $item->category->name ?? 'N/A' }}</td>
                    <td>{{ ucfirst($item->item_type ?? 'regular') }}</td>
                    <td>{{ $currentStock }}</td>
                    <td>{{ $item->min_stock_level }}</td>
                    <td>{{ $deficit }}</td>
                    <td class="{{ $statusClass }}">{{ $status }}</td>
                    <td>{{ $item->storage_conditions ?? 'N/A' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <p>Laboratory Inventory Management System - Low Stock Report</p>
    </div>
</body>
</html>