<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>{{ $title }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
        }
        .info {
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .status-expired {
            color: #dc2626;
            font-weight: bold;
        }
        .status-critical {
            color: #ea580c;
            font-weight: bold;
        }
        .status-expiring {
            color: #d97706;
            font-weight: bold;
        }
        .status-active {
            color: #059669;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $title }}</h1>
    </div>

    <div class="info">
        <p><strong>Generated on:</strong> {{ $generatedAt }}</p>
        <p><strong>Total Items:</strong> {{ $data->count() }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Item Name</th>
                <th>Category</th>
                <th>Type</th>
                <th>Batch Number</th>
                <th>Expiry Date</th>
                <th>Days Left</th>
                <th>Quantity</th>
                <th>Supplier</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($data as $batchItem)
                @php
                    $daysLeft = $batchItem->expiry_date ? now()->diffInDays($batchItem->expiry_date, false) : null;
                    $statusClass = 'status-active';
                    $status = 'Active';
                    
                    if ($batchItem->expiry_date && $batchItem->expiry_date->isPast()) {
                        $statusClass = 'status-expired';
                        $status = 'Expired';
                    } elseif ($daysLeft !== null && $daysLeft <= 7) {
                        $statusClass = 'status-critical';
                        $status = 'Critical';
                    } elseif ($daysLeft !== null && $daysLeft <= 30) {
                        $statusClass = 'status-expiring';
                        $status = 'Expiring Soon';
                    }
                @endphp
                <tr>
                    <td>{{ $batchItem->inventoryItem->name ?? 'N/A' }}</td>
                    <td>{{ $batchItem->inventoryItem->category->name ?? 'N/A' }}</td>
                    <td>{{ ucfirst($batchItem->inventoryItem->item_type ?? 'regular') }}</td>
                    <td>{{ $batchItem->stockBatch->batch_number ?? 'N/A' }}</td>
                    <td>{{ $batchItem->expiry_date ? $batchItem->expiry_date->format('Y-m-d') : 'N/A' }}</td>
                    <td>{{ $daysLeft !== null ? $daysLeft : 'N/A' }}</td>
                    <td>{{ $batchItem->current_quantity }}</td>
                    <td>{{ $batchItem->stockBatch->supplier->name ?? 'N/A' }}</td>
                    <td class="{{ $statusClass }}">{{ $status }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <p>Laboratory Inventory Management System - Expiry Report</p>
    </div>
</body>
</html>