<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>{{ $title }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        .header h1 {
            margin: 0;
            color: #333;
        }
        .info {
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ $title }}</h1>
    </div>

    <div class="info">
        <p><strong>Period:</strong> {{ $dateFrom }} to {{ $dateTo }}</p>
        <p><strong>Generated on:</strong> {{ $generatedAt }}</p>
        <p><strong>Total Transactions:</strong> {{ $data->count() }}</p>
    </div>

    <table>
        <thead>
            <tr>
                <th>Item Name</th>
                <th>Category</th>
                <th>Type</th>
                <th>Date</th>
                <th>Quantity</th>
                <th>Used For</th>
                <th>Conducted By</th>
                <th>Approved By</th>
                <th>Batch Number</th>
            </tr>
        </thead>
        <tbody>
            @foreach($data as $transaction)
                <tr>
                    <td>{{ $transaction->inventoryItem->name ?? 'N/A' }}</td>
                    <td>{{ $transaction->inventoryItem->category->name ?? 'N/A' }}</td>
                    <td>{{ ucfirst($transaction->inventoryItem->item_type ?? 'regular') }}</td>
                    <td>{{ $transaction->transaction_date->format('Y-m-d') }}</td>
                    <td>{{ $transaction->quantity }}</td>
                    <td>{{ $transaction->used_for ?? 'N/A' }}</td>
                    <td>{{ $transaction->conducted_by }}</td>
                    <td>{{ $transaction->approved_by ?? 'N/A' }}</td>
                    <td>{{ $transaction->batch->batch_number ?? 'N/A' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="footer">
        <p>Laboratory Inventory Management System - Consumption Report</p>
    </div>
</body>
</html>