<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instrument Details</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#001A6E',
                        secondary: '#009990',
                    }
                }
            }
        }
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css"
          integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg=="
          crossorigin="anonymous" referrerpolicy="no-referrer"/>
    <style>
        body {
            font-family: 'Inter', sans-serif;
        }
        .info-card {
            transition: all 0.3s ease;
        }
        .info-card:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body class="bg-gray-50">
<div class="max-w-4xl mx-auto px-2 py-2">
    <!-- Header -->

    @php
        $instrument = App\Models\Instrument::findOrFail(decode_id(request()->route('hash')));
    @endphp

    <!-- Main Card -->
    <div class="bg-white rounded-xl shadow-lg overflow-hidden border-t-4 border-primary">
        <div class="w-full flex justify-center flex-col items-center ">
            <img src="{{asset('assets/images/logo.png')}}" alt="" class="h-28">
            <span class="text-center font-semibold text-primary">DEPARTMENT OF BIOSCIENCES AND BIOENGINEERING</span>
        </div>
        <!-- Card Header -->
        <div class="bg-gradient-to-r from-primary to-primary/90 px-6 py-2 mt-4">
            <h2 class="text-xl font-semibold text-white"><i class="fa-solid fa-flask"></i> {{$instrument->name}}</h2>
            <p class="text-primary-200 text-sm text-white/80">{{$instrument->model_number}} • {{$instrument->serial_number}}</p>
        </div>

        <!-- Card Body -->
        <div class="p-2 grid grid-cols-1 gap-8">
            <!-- Left Column - Basic Info -->
            <div class="space-y-6">
                <div class="info-card bg-gray-50 p-5 rounded-lg border border-gray-200">
                    <h3 class="text-lg font-semibold text-primary mb-4 pb-2 border-b border-gray-200 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2h-1V9z" clip-rule="evenodd" />
                        </svg>
                        Basic Information
                    </h3>
                    <div class="space-y-3">
                        <div class="grid lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-2">
                            <span class="text-black font-semibold text-sm">Category:</span>
                            <span class="font-semibold text-secondary text-md">{{$instrument->instrumentCategory->title}}</span>
                        </div>
                        <div class="grid lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-2">
                            <span class="text-black font-semibold text-sm">Lab Location:</span>
                            <span class="font-semibold text-secondary text-md">{{$instrument->lab->lab_name}}</span>
                        </div>
                        <div class="grid lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-2">
                            <span class="text-black font-semibold text-sm">Status:</span>
                            <span class="font-semibold text-secondary text-md capitalize">
                                    <span class="inline-block w-3 h-3 rounded-full
                                        {{ $instrument->operating_status === 'working' ? 'bg-green-500' :
                                           ($instrument->operating_status === 'maintenance' ? 'bg-yellow-500' : 'bg-red-500') }}"></span>
                                    {{$instrument->operating_status}}
                                </span>
                        </div>
                    </div>
                </div>

                <div class="info-card bg-gray-50 p-5 rounded-lg border border-gray-200">
                    <h3 class="text-lg font-semibold text-primary mb-4 pb-2 border-b border-gray-200 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd" />
                        </svg>
                        Booking Information
                    </h3>
                    <div class="space-y-3">
                        <div class="grid lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-2">
                            <span class="font-semibold text-secondary text-md text-secondary">
                                    @if($instrument->booking_type == 'slot' || $instrument->booking_type == 'both')
                                         <div class="w-full flex flex-col gap-2">
                               @isset($instrument->booking_cost['internal']['slot'])
                                                 <h4 class="font-semibold text-primary">Slot Based Pricing</h4>
                                                 <div class="grid grid-cols-2 gap-2 text-sm">
                                    <span>Internal:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['internal']['slot'] ?? 'N/A' }} + {{ $instrument->booking_cost['internal']['slot_gst'] ?? 'N/A' }}% GST</span>
                                    <span>Other Educational:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['other_educational_institute']['slot'] ?? 'N/A' }} + {{ $instrument->booking_cost['other_educational_institute']['slot_gst'] ?? 'N/A' }}% GST</span>
                                    <span>R&D Labs:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['r_and_d_labs']['slot'] ?? 'N/A' }} + {{ $instrument->booking_cost['r_and_d_labs']['slot_gst'] ?? 'N/A' }}% GST</span>
                                    <span>Industries:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['industries']['slot'] ?? 'N/A' }} + {{ $instrument->booking_cost['industries']['slot_gst'] ?? 'N/A' }}% GST</span>
                                    <span>Startups:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['startups']['slot'] ?? 'N/A' }} + {{ $instrument->booking_cost['startups']['slot_gst'] ?? 'N/A' }}% GST</span>
                                </div>
                                             @endisset
                                             @isset($instrument->booking_cost['internal']['booking'])
                                                 <h4 class="font-semibold text-primary">Booking Based Pricing</h4>
                                                 <div class="grid grid-cols-2 gap-2 text-sm">
                                    <span>Internal:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['internal']['booking'] ?? 'N/A' }} + {{ $instrument->booking_cost['internal']['booking_gst'] ?? 'N/A' }}% GST</span>
                                    <span>Other Educational:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['other_educational_institute']['booking'] ?? 'N/A' }} + {{ $instrument->booking_cost['other_educational_institute']['booking_gst'] ?? 'N/A' }}% GST</span>
                                    <span>R&D Labs:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['r_and_d_labs']['booking'] ?? 'N/A' }} + {{ $instrument->booking_cost['r_and_d_labs']['booking_gst'] ?? 'N/A' }}% GST</span>
                                    <span>Industries:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['industries']['booking'] ?? 'N/A' }} + {{ $instrument->booking_cost['industries']['booking_gst'] ?? 'N/A' }}% GST</span>
                                    <span>Startups:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['startups']['booking'] ?? 'N/A' }} + {{ $instrument->booking_cost['startups']['booking_gst'] ?? 'N/A' }}% GST</span>
                                </div>
                                             @endisset
                            </div>
                                     @endif
                                     @if($instrument->booking_type == 'sample' || $instrument->booking_type == 'both')
                                         <div class="w-full flex flex-col gap-2">
                                <h4 class="font-semibold text-primary">Sample Based Pricing</h4>
                                <div class="grid grid-cols-2 gap-2 text-sm">
                                    <span>Internal:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['internal']['sample'] ?? 'N/A' }}+ {{ $instrument->booking_cost['internal']['sample_gst'] ?? 'N/A' }}% GST</span>
                                    <span>Other Educational:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['other_educational_institute']['sample'] ?? 'N/A' }}+ {{ $instrument->booking_cost['other_educational_institute']['sample_gst'] ?? 'N/A' }}% GST</span>
                                    <span>R&D Labs:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['r_and_d_labs']['sample'] ?? 'N/A' }}+ {{ $instrument->booking_cost['r_and_d_labs']['sample_gst'] ?? 'N/A' }}% GST</span>
                                    <span>Industries:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['industries']['sample'] ?? 'N/A' }}+ {{ $instrument->booking_cost['industries']['sample_gst'] ?? 'N/A' }}% GST</span>
                                    <span>Startups:</span>
                                    <span class="font-semibold">₹{{ $instrument->booking_cost['startups']['sample'] ?? 'N/A' }}+ {{ $instrument->booking_cost['startups']['sample_gst'] ?? 'N/A' }}% GST</span>
                                </div>
                            </div>
                                     @endif
                            </span>
                        </div>
                        <div class="grid lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-2">
                            <span class="text-black font-semibold text-sm">Upcoming Booking:</span>
                            <span class="font-semibold text-secondary text-md">{{$instrument->getNextBookingDateTime()}}</span>
                        </div>
                        <div class="grid lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-2">
                            <span class="text-black font-semibold text-sm">Next Available Slot:</span>
                            <span class="font-semibold text-secondary text-md text-green-600">{{$instrument->getNextAvailableSlot()}}</span>
                        </div>
                    </div>
                </div>

                <div class="info-card bg-primary/5 p-5 rounded-lg border border-primary/20">
                    <h3 class="text-lg font-semibold text-primary mb-3">Quick Actions</h3>
                    <div class="flex flex-wrap gap-3">
                        <a href="{{route('login')}}" class="px-4 py-2 bg-primary text-white rounded-md hover:bg-primary/90 transition flex items-center">
                            <svg xmlns="http://www.w3.org/2000/svg" class="h-4 w-4 mr-2" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clip-rule="evenodd" />
                            </svg>
                            Book Now
                        </a>

                    </div>
                </div>

                <div class="info-card bg-gray-50 p-5 rounded-lg border border-gray-200">
                    <h3 class="text-lg font-semibold text-primary mb-4 pb-2 border-b border-gray-200 flex items-center">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5 mr-2" viewBox="0 0 20 20" fill="currentColor">
                            <path d="M10 2a6 6 0 00-6 6v3.586l-.707.707A1 1 0 004 14h12a1 1 0 00.707-1.707L16 11.586V8a6 6 0 00-6-6zM10 18a3 3 0 01-3-3h6a3 3 0 01-3 3z" />
                        </svg>
                        Description
                    </h3>
                    <p class="text-gray-700">{{$instrument->description}}</p>
                </div>
            </div>
        </div>

        <!-- Card Footer -->
        <div class="bg-gray-50 px-6 py-3 border-t border-gray-200 text-sm text-secondary">
            Last updated: <span class="text-primary">{{ now()->format('M d, Y \a\t h:i A') }}</span> <br>
            Developed by: <a href="https://himsoftsolution.com" class="font-semibold text-primary" >Him Soft Solution</a>
        </div>
    </div>
</div>
</body>
</html>
