<div>
    @if (session()->has('success'))
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            {{ session('success') }}
            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif

    @if($userType === 'student')
        <!-- Student Usage View -->
        <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300 mb-6">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
                <span class="font-semibold text-primary text-xl">My Usage Summary</span>
            </div>
            
            <div class="p-4">
                <div class="grid xl:grid-cols-4 lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-4 mb-6">
                    <!-- Student Info -->
                    <div class="bg-primary/5 border-[1px] border-primary/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Student</h3>
                                <p class="text-lg font-bold text-primary">{{ $userData['student_name'] ?? 'N/A' }}</p>
                                <p class="text-xs text-gray-400">{{ $userData['academic_id'] ?? 'N/A' }}</p>
                            </div>
                            <div class="bg-primary/10 p-3 rounded-full">
                                <i class="fa fa-user-graduate text-primary text-xl"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Total Bookings -->
                    <div class="bg-success/5 border-[1px] border-success/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Total Bookings</h3>
                                <p class="text-2xl font-bold text-success">{{ $userData['total_bookings'] ?? 0 }}</p>
                                <p class="text-xs text-gray-400">All time</p>
                            </div>
                            <div class="bg-success/10 p-3 rounded-full">
                                <i class="fa fa-calendar-check text-success text-xl"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Total Hours -->
                    <div class="bg-warning/5 border-[1px] border-warning/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Total Usage</h3>
                                <p class="text-2xl font-bold text-warning">{{ $userData['total_hours'] ?? 0 }}</p>
                                <p class="text-xs text-gray-400">Hours</p>
                            </div>
                            <div class="bg-warning/10 p-3 rounded-full">
                                <i class="fa fa-clock text-warning text-xl"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Instruments Used -->
                    <div class="bg-danger/5 border-[1px] border-danger/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Instruments Used</h3>
                                <p class="text-2xl font-bold text-danger">{{ count($userData['instruments'] ?? []) }}</p>
                                <p class="text-xs text-gray-400">Different instruments</p>
                            </div>
                            <div class="bg-danger/10 p-3 rounded-full">
                                <i class="fa fa-microscope text-danger text-xl"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Instrument Usage Details -->
        <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
                <span class="font-semibold text-primary text-xl">My Instrument Usage</span>
            </div>
            
            <div class="w-full overflow-x-auto p-4">
                <table class="w-full border-[2px] border-secondary/40 border-collapse">
                    <thead>
                        <tr>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Sr. No.</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Instrument</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Lab</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Total Hours</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Bookings</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Last Booking</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($this->paginatedInstrumentData as $index => $instrument)
                            <tr class="hover:bg-secondary/10 transition ease-in duration-200">
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">{{ (($instrumentPage - 1) * $perPage) + $index + 1 }}</td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">{{ $instrument['instrument_name'] }}</td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">{{ $instrument['lab_name'] }}</td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                    <span class="bg-primary/10 text-primary px-2 py-1 rounded-full text-xs">{{ $instrument['total_hours'] }}</span>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">{{ $instrument['booking_count'] }}</td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                    @if($instrument['last_booking'] !== 'No bookings')
                                        {{ \Carbon\Carbon::parse($instrument['last_booking'])->format('d M Y') }}
                                    @else
                                        {{ $instrument['last_booking'] }}
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="border-[2px] border-secondary/40 px-4 py-8 text-center text-gray-500">
                                    <div class="flex flex-col items-center">
                                        <i class="fa fa-microscope text-4xl text-gray-300 mb-2"></i>
                                        <p>No instrument usage found</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
                
                <!-- Instrument Pagination -->
                @if($this->instrumentTotalPages > 1)
                    <div class="mt-4 flex justify-between items-center">
                        <div class="text-sm text-gray-500">
                            Showing {{ (($instrumentPage - 1) * $perPage) + 1 }} to {{ min($instrumentPage * $perPage, count($userData['instruments'] ?? [])) }} of {{ count($userData['instruments'] ?? []) }} results
                        </div>
                        <div class="flex items-center gap-2">
                            <button wire:click="previousInstrumentPage" 
                                    @if($instrumentPage <= 1) disabled @endif
                                    class="px-3 py-1 text-sm bg-primary/20 text-primary rounded hover:bg-primary hover:text-white transition disabled:opacity-50 disabled:cursor-not-allowed">
                                Previous
                            </button>
                            
                            @for($i = 1; $i <= $this->instrumentTotalPages; $i++)
                                <button wire:click="gotoInstrumentPage({{ $i }})"
                                        class="px-3 py-1 text-sm rounded transition {{ $instrumentPage == $i ? 'bg-primary text-white' : 'bg-gray-200 text-gray-700 hover:bg-primary hover:text-white' }}">
                                    {{ $i }}
                                </button>
                            @endfor
                            
                            <button wire:click="nextInstrumentPage" 
                                    @if($instrumentPage >= $this->instrumentTotalPages) disabled @endif
                                    class="px-3 py-1 text-sm bg-primary/20 text-primary rounded hover:bg-primary hover:text-white transition disabled:opacity-50 disabled:cursor-not-allowed">
                                Next
                            </button>
                        </div>
                    </div>
                @endif
            </div>
        </div>

    @elseif($userType === 'pi')
        <!-- PI Usage View -->
        <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300 mb-6">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
                <span class="font-semibold text-primary text-xl">PI Usage Summary</span>
            </div>
            
            <div class="p-4">
                <div class="grid xl:grid-cols-4 lg:grid-cols-2 md:grid-cols-2 grid-cols-1 gap-4 mb-6">
                    <!-- PI Info -->
                    <div class="bg-primary/5 border-[1px] border-primary/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Principal Investigator</h3>
                                <p class="text-lg font-bold text-primary">{{ $userData['pi_name'] ?? 'N/A' }}</p>
                                <p class="text-xs text-gray-400">{{ $userData['department'] ?? 'N/A' }}</p>
                            </div>
                            <div class="bg-primary/10 p-3 rounded-full">
                                <i class="fa fa-user-tie text-primary text-xl"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Total Students -->
                    <div class="bg-success/5 border-[1px] border-success/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Total Students</h3>
                                <p class="text-2xl font-bold text-success">{{ $userData['total_students'] ?? 0 }}</p>
                                <p class="text-xs text-gray-400">Under supervision</p>
                            </div>
                            <div class="bg-success/10 p-3 rounded-full">
                                <i class="fa fa-users text-success text-xl"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Total Bookings -->
                    <div class="bg-warning/5 border-[1px] border-warning/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Total Bookings</h3>
                                <p class="text-2xl font-bold text-warning">{{ $userData['total_bookings'] ?? 0 }}</p>
                                <p class="text-xs text-gray-400">All students</p>
                            </div>
                            <div class="bg-warning/10 p-3 rounded-full">
                                <i class="fa fa-calendar-check text-warning text-xl"></i>
                            </div>
                        </div>
                    </div>

                    <!-- Total Hours -->
                    <div class="bg-danger/5 border-[1px] border-danger/20 p-4 rounded-lg">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-sm font-medium text-gray-500">Total Usage</h3>
                                <p class="text-2xl font-bold text-danger">{{ $userData['total_hours'] ?? 0 }}</p>
                                <p class="text-xs text-gray-400">Hours</p>
                            </div>
                            <div class="bg-danger/10 p-3 rounded-full">
                                <i class="fa fa-clock text-danger text-xl"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Student Usage Details -->
        <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
                <span class="font-semibold text-primary text-xl">Student Usage Details</span>
            </div>
            
            <div class="w-full overflow-x-auto p-4">
                <table class="w-full border-[2px] border-secondary/40 border-collapse">
                    <thead>
                        <tr>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Sr. No.</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Student Name</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Academic ID</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Total Bookings</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Total Hours</th>
                            <th class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-2 text-ternary/80 font-bold text-sm text-left">Last Booking</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($this->paginatedStudentData as $index => $student)
                            <tr class="hover:bg-secondary/10 transition ease-in duration-200">
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">{{ (($studentPage - 1) * $perPage) + $index + 1 }}</td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">{{ $student['name'] }}</td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">{{ $student['academic_id'] }}</td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">{{ $student['total_bookings'] }}</td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                    <span class="bg-primary/10 text-primary px-2 py-1 rounded-full text-xs">{{ $student['total_hours'] }}</span>
                                </td>
                                <td class="border-[2px] border-secondary/40 px-4 py-2 text-ternary/80 font-medium text-sm">
                                    @if($student['last_booking'] !== 'No bookings')
                                        {{ \Carbon\Carbon::parse($student['last_booking'])->format('d M Y') }}
                                    @else
                                        {{ $student['last_booking'] }}
                                    @endif
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="border-[2px] border-secondary/40 px-4 py-8 text-center text-gray-500">
                                    <div class="flex flex-col items-center">
                                        <i class="fa fa-user-graduate text-4xl text-gray-300 mb-2"></i>
                                        <p>No student usage data found</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
                
                <!-- Student Pagination -->
                @if($this->studentTotalPages > 1)
                    <div class="mt-4 flex justify-between items-center">
                        <div class="text-sm text-gray-500">
                            Showing {{ (($studentPage - 1) * $perPage) + 1 }} to {{ min($studentPage * $perPage, count($studentUsageData)) }} of {{ count($studentUsageData) }} results
                        </div>
                        <div class="flex items-center gap-2">
                            <button wire:click="previousStudentPage" 
                                    @if($studentPage <= 1) disabled @endif
                                    class="px-3 py-1 text-sm bg-primary/20 text-primary rounded hover:bg-primary hover:text-white transition disabled:opacity-50 disabled:cursor-not-allowed">
                                Previous
                            </button>
                            
                            @for($i = 1; $i <= $this->studentTotalPages; $i++)
                                <button wire:click="gotoStudentPage({{ $i }})"
                                        class="px-3 py-1 text-sm rounded transition {{ $studentPage == $i ? 'bg-primary text-white' : 'bg-gray-200 text-gray-700 hover:bg-primary hover:text-white' }}">
                                    {{ $i }}
                                </button>
                            @endfor
                            
                            <button wire:click="nextStudentPage" 
                                    @if($studentPage >= $this->studentTotalPages) disabled @endif
                                    class="px-3 py-1 text-sm bg-primary/20 text-primary rounded hover:bg-primary hover:text-white transition disabled:opacity-50 disabled:cursor-not-allowed">
                                Next
                            </button>
                        </div>
                    </div>
                @endif
            </div>
        </div>

    @else
        <!-- Other User Types -->
        <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">
                <span class="font-semibold text-primary text-xl">Usage Information</span>
            </div>
            
            <div class="p-8 text-center">
                <div class="flex flex-col items-center">
                    <i class="fa fa-info-circle text-6xl text-gray-300 mb-4"></i>
                    <h3 class="text-lg font-medium text-gray-600 mb-2">Usage Tracking Not Available</h3>
                    <p class="text-gray-500">Usage tracking is only available for Students and Principal Investigators.</p>
                </div>
            </div>
        </div>
    @endif
</div>