<div>
    {{-- ✅ Toast Success/Error --}}
    @if (session()->has('success'))
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            {{ session('success') }}
            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark"></i>
            </div>
        </div>
    @endif

    {{-- ✅ Panel Wrapper --}}
    <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300 mt-6">
        {{-- ✅ Header --}}
        <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between items-center">
            <span class="font-semibold text-primary text-xl">Tenant Management</span>
            <span wire:click="showCreateForm" class="text-sm bg-primary/80 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
                <i class="fa fa-plus mr-2"></i>
                Create New Tenant
            </span>
        </div>

        {{-- ✅ Search --}}
        <div class="flex justify-between items-center px-4 py-2">
            <input 
                type="text" 
                placeholder="Search tenants..." 
                wire:model.live.debounce.500ms="search"
                class="px-2 py-1 w-1/3 text-sm font-medium bg-transparent placeholder-primary/70 border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000"
            >
        </div>

        {{-- ✅ Tenant Create/Edit Form --}}
        @if($showForm)
        <div class="px-4 pb-4">
            <div class="border-[1px] border-primary/30 rounded-md bg-primary/5 p-4 shadow-md">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold text-primary">
                        {{ $isEditing ? 'Edit Tenant' : 'Create New Tenant' }}
                    </h3>
                    <button wire:click="hideCreateForm" class="text-sm bg-gray-200 px-3 py-1 rounded hover:bg-gray-300">
                        <i class="fa fa-arrow-left mr-1"></i> Cancel
                    </button>
                </div>

                <form wire:submit.prevent="save">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Tenant Name</label>
                            <input type="text" wire:model.defer="name" class="form-input w-full rounded border-gray-300" required>
                            @error('name') <span class="text-red-600 text-xs">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Database</label>
                            <input type="text" wire:model.defer="database" class="form-input w-full rounded border-gray-300" required>
                            @error('database') <span class="text-red-600 text-xs">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Username</label>
                            <input type="text" wire:model.defer="username" class="form-input w-full rounded border-gray-300" required>
                            @error('username') <span class="text-red-600 text-xs">{{ $message }}</span> @enderror
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700">Password</label>
                            <input type="password" wire:model.defer="password" class="form-input w-full rounded border-gray-300">
                            @error('password') <span class="text-red-600 text-xs">{{ $message }}</span> @enderror
                        </div>
                    </div>
                    <div class="flex justify-end mt-4 gap-2">
                        <button wire:click="hideCreateForm" type="button" class="px-4 py-1 bg-gray-300 rounded hover:bg-gray-400">Cancel</button>
                        <button type="submit" class="px-4 py-1 bg-primary text-white rounded hover:bg-primary-dark">Save</button>
                    </div>
                </form>
            </div>
        </div>
        @endif

        {{-- ✅ Table --}}
        <div class="w-full overflow-x-auto px-4 pb-4">
            <table class="w-full border-[2px] border-secondary/40 border-collapse" wire:loading.class="opacity-25">
                <thead class="bg-gray-100">
                    <tr>
                        <th class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-bold text-md">ID</th>
                        <th class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-bold text-md">Name</th>
                        <th class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-bold text-md">Database</th>
                        <th class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-bold text-md">Username</th>
                        <th class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-bold text-md text-right">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse ($tenants as $tenant)
                        <tr class="hover:bg-secondary/10 transition duration-300">
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 text-sm">{{ $tenant->id }}</td>
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 text-sm">{{ $tenant->name }}</td>
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 text-sm">{{ $tenant->database }}</td>
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 text-sm">{{ $tenant->username }}</td>
                            <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 text-sm text-right">
                                <div class="flex justify-end gap-2">
                                    <button wire:click="editTenant({{ $tenant->id }})" title="Edit" class="bg-warning/20 text-warning h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-warning hover:text-white transition">
                                        <i class="fa fa-pen text-xs"></i>
                                    </button>
                                    <button wire:click="confirmDelete({{ $tenant->id }})" title="Delete" class="bg-danger/20 text-danger h-6 w-6 flex justify-center items-center rounded-[3px] hover:bg-danger hover:text-white transition">
                                        <i class="fa fa-trash text-xs"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="5" class="text-center py-4 text-gray-500">No tenants found</td>
                        </tr>
                    @endforelse
                </tbody>
            </table>

            {{-- ✅ Pagination --}}
            @if($tenants->hasPages())
                <div class="mt-4">
                    {{ $tenants->links() }}
                </div>
            @endif
        </div>
    </div>
</div>
