<div>

    <div class="w-full grid xl:grid-cols-5 lg:grid-cols-3 md:grid-cols-4 sm:grid-cols-2 grid-cols-1 gap-2">
        <a href="{{route('lab.list')}}">
            <div class="w-full border-[1px] border-t-[4px] border-ternary/20 border-t-primary bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Labs</span>
                    <span class="font-bold text-2xl text-primary">{{$totalLabs}}</span>
                </div>
                <div>
                    <i class="fa-solid fa-flask text-4xl text-primary"></i>
                </div>
            </div>
        </a>

        <!-- Total PIs -->
        <a href="{{route('pi.list')}}">
            <div class="w-full border-[1px] border-t-[4px] border-warning/20 border-t-warning bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Principal Investigators</span>
                    <span class="font-bold text-2xl text-warning">{{$totalPis}}</span>
                </div>
                <div>
                    <i class="fa fa-user-tie text-4xl text-warning"></i>
                </div>
            </div>
        </a>

        <!-- Total Students -->
        <a href="{{route('student.list')}}">
            <div class="w-full border-[1px] border-t-[4px] border-success/20 border-t-success bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Students</span>
                    <span class="font-bold text-2xl text-success">{{$totalStudents}}</span>
                </div>
                <div>
                    <i class="fa fa-user-graduate text-4xl text-success"></i>
                </div>
            </div>
        </a>

        <!-- Total Categories -->
        <a href="{{route('instrument.instrument-category')}}">
            <div class="w-full border-[1px] border-t-[4px] border-danger/20 border-t-danger bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Instrument Categories</span>
                    <span class="font-bold text-2xl text-danger">{{$instrumentCategories}}</span>
                </div>
                <div>
                    <i class="fa fa-list text-4xl text-danger"></i>
                </div>
            </div>
        </a>
        <!-- Total Instruments -->
        <a href="{{route('instrument.instrument')}}">
            <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Instruments</span>
                    <span class="font-bold text-2xl text-primary">{{$totalInstruments}}</span>
                </div>
                <div>
                    <i class="fa fa-microscope text-4xl text-primary"></i>
                </div>
            </div>
        </a>

        <a href="{{route('instrument.instrument')}}">
            <!-- Instruments Not Working -->
            <div class="w-full border-[1px] border-t-[4px] border-warning/20 border-t-warning bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Instruments Down</span>
                    <span class="font-bold text-2xl text-warning">{{$instrumentUnderMaintenance}}</span>
                </div>
                <div>
                    <i class="fa fa-battery-quarter text-4xl text-warning"></i>
                </div>
            </div>
        </a>

        <!-- Pending Services -->
        <a href="{{route('instrument.service')}}">
            <div class="w-full border-[1px] border-t-[4px] border-success/20 border-t-success bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Under Services</span>
                    <span class="font-bold text-2xl text-success">{{$underService}}</span>
                </div>
                <div>
                    <i class="fa fa-wrench text-4xl text-success"></i>
                </div>
            </div>
        </a>
        <!-- Pending Approvals -->
        <a href="{{route('instrument.complaints')}}">
            <div class="w-full border-[1px] border-t-[4px] border-danger/20 border-t-danger bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Complaints</span>
                    <span class="font-bold text-2xl text-danger">{{$totalComplaints}}</span>
                </div>
                <div>
                    <i class="fa fa-exclamation-triangle text-4xl text-danger"></i>
                </div>
            </div>
        </a>
        <!-- Active Bookings -->
        <a href="{{route('bookings.create')}}">
            <div class="w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 items-center justify-between p-4">
                <div class="flex flex-col gap-2">
                    <span class="font-semibold text-black text-md">Active Bookings</span>
                    <span class="font-bold text-2xl text-primary"> {{$activeBookings}} </span>
                </div>
                <div>
                    <i class="fa fa-calendar-check text-4xl text-primary"></i>
                </div>
            </div>
        </a>


        <!-- Monthly Collection -->
        <div class="w-full border-[1px] border-t-[4px] border-success/20 border-t-success bg-white flex gap-2 items-center justify-between p-4">
            <div class="flex flex-col gap-2">
                <span class="font-semibold text-black text-md">Collection <span class="text-xs">(This Month)</span></span>
                <span class="font-bold text-2xl text-success">₹{{$thisMonthCollection}}</span>
            </div>
            <div>
                <i class="fa fa-money-bill-trend-up text-4xl text-success"></i>
            </div>
        </div>


    </div>
    <div class="w-full grid lg:grid-cols-3 md:grid-cols-2 grid-cols-1 mt-6 gap-4">
        <div class="w-full  border-[1px] lg:col-span-2 border-t-[4px] border-ternary/20 border-t-primary bg-white flex gap-2 flex-col">
            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between items-center">
                <span class="font-semibold text-ternary text-lg">Monthly Booking Calendar</span>
                <span class="font-medium text-primary">{{ $currentMonthName }}</span>
            </div>

            <div class="w-full p-4">
                <!-- Calendar Header (Day names) -->
                <div class="grid grid-cols-7 gap-1 mb-2">
                    @foreach(['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'] as $day)
                        <div class="text-center text-sm font-medium text-ternary/70 py-1">
                            {{ $day }}
                        </div>
                    @endforeach
                </div>
                <!-- Calendar Grid -->
                <div class="grid grid-cols-7 gap-1">
                    @foreach($calendarData as $week)
                        @foreach($week as $day)
                            @if($day === null)
                                <!-- Empty cell -->
                                <div class="aspect-square bg-gray-50 rounded"></div>
                            @else
                                <!-- Day cell with booking indicators -->
                                <div class="aspect-square border border-gray-200 h-full @if(Carbon\Carbon::parse($day['date'])->isToday()) bg-gray-300 @endif rounded p-1 flex flex-col justify-between">
                                    <div class="text-right h-maxi lg:text-sm md:text-sm  text-xs @if(Carbon\Carbon::parse($day['date'])->isToday()) font-bold text-primary @endif">
                                        {{ $day['day'] }}
                                    </div>
                                    <div class="flex-grow flex h-max items-center justify-center gap-1 text-left">
                                        @if($day['confirmed'] > 0)
                                            <span class="font-semibold lg:text-sm md:text-sm  text-xs text-green-700">{{$day['confirmed']}} {{$day['cancelled'] > 0?'/':''}} </span>
                                        @endif
                                        @if($day['cancelled'] > 0)
                                            <span class="font-semibold lg:text-sm md:text-sm  text-xs text-red-700">{{$day['cancelled']}}</span>
                                        @endif
                                    </div>
                                </div>
                            @endif
                        @endforeach
                    @endforeach
                </div>
            </div>
        </div>
        <div class="w-full border-[1px] border-t-[4px] border-ternary/20 border-t-warning bg-white flex gap-2 flex-col">
            <div class="bg-warning/10 px-4 py-2 border-b-[2px] border-b-warning/20">
                <span class="font-semibold text-warning text-lg">Today's Bookings</span>
            </div>

            <div class="w-full overflow-x-auto p-4">
                @if(count($todaysBookings) > 0)
                    <div class="space-y-3">
                        @foreach($todaysBookings as $booking)
                            <div class="border border-gray-200 rounded-lg p-3 hover:bg-gray-50 transition ease-in duration-200">
                                <div class="flex justify-between items-start">
                                    <div class="flex-1">
                                        <div class="font-semibold text-primary text-sm mb-1">
                                            <i class="fa fa-microscope mr-1"></i>
                                            {{ $booking['instrument_name'] }}
                                        </div>
                                        <div class="text-sm text-gray-600 mb-1">
                                            <i class="fa fa-user mr-1"></i>
                                            {{ $booking['student_name'] }}
                                        </div>
                                        @if($booking['start_time'] && $booking['end_time'])
                                            <div class="text-xs text-warning font-medium">
                                                <i class="fa fa-clock mr-1"></i>
                                                {{ date('h:i A', strtotime($booking['start_time'])) }} - {{ date('h:i A', strtotime($booking['end_time'])) }}
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8 text-gray-500">
                        <i class="fa fa-calendar-times text-3xl mb-2"></i>
                        <p class="text-sm">No bookings for today</p>
                    </div>
                @endif
            </div>
        </div>
{{--        <div class="w-full border-[1px] border-t-[4px] border-ternary/20 border-t-primary bg-white flex gap-2 flex-col ">--}}
{{--            <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20">--}}
{{--                <span class="font-semibold text-primary text-lg">Top Booked Instruments</span>--}}
{{--            </div>--}}
{{--            <div class="w-full overflow-x-auto p-4">--}}
{{--                <div id="topInstrumentsBooked"></div>--}}
{{--            </div>--}}
{{--        </div>--}}
{{--        <div class="w-full border-[1px] border-t-[4px] border-ternary/20 border-t-success bg-white flex gap-2 flex-col ">--}}
{{--            <div class="bg-success/10 px-4 py-2 border-b-[2px] border-b-success/20">--}}
{{--                <span class="font-semibold text-success text-lg">Most Serviced Instruments</span>--}}
{{--            </div>--}}

{{--            <div class="w-full overflow-x-auto p-4">--}}
{{--                <div id="mostServicedInstruments"></div>--}}
{{--            </div>--}}
{{--        </div>--}}

    </div>
    <script>

        // Top Booked Instruments Chart initialization function
        function initTopBookedInstrumentsChart() {
            // Check if element exists and data is available
            if (!document.querySelector("#topInstrumentsBooked")) {
                console.error("Element #topInstrumentsBooked not found");
                return;
            }

            const seriesData = @json(array_column($topBookedInstruments, 'count'));
            const labelsData = @json(array_column($topBookedInstruments, 'name'));

            if (seriesData.length === 0) {
                console.warn("No data available for top booked instruments");
                return;
            }

            const topInstrumentsOptions = {
                series: seriesData,
                chart: {
                    type: 'pie',
                    height: 250
                },
                labels: labelsData,
                colors: ['#001A6E', '#22C55E', '#DC2626'],
                legend: {
                    position: 'bottom'
                },
                tooltip: {
                    y: {
                        formatter: function(value) {
                            return value + ' bookings'
                        }
                    }
                },
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 200
                        },
                        legend: {
                            position: 'bottom'
                        }
                    }
                }]
            };

            try {
                const topInstrumentsChart = new ApexCharts(document.querySelector("#topInstrumentsBooked"), topInstrumentsOptions);
                topInstrumentsChart.render();

                Livewire.on('refreshTopInstruments', () => {
                    topInstrumentsChart.updateSeries(@json(array_column($topBookedInstruments, 'count')));
                    topInstrumentsChart.updateOptions({
                        labels: @json(array_column($topBookedInstruments, 'name'))
                    });
                });
            } catch (error) {
                console.error("Error initializing top instruments chart:", error);
            }
        }

        // Most Serviced Instruments Chart initialization function
        function initMostServicedInstrumentsChart() {
            // Debug output
            console.log("Initializing Most Serviced Instruments chart");

            // Check if element exists
            if (!document.querySelector("#mostServicedInstruments")) {
                console.error("Element #mostServicedInstruments not found");
                return;
            }

            const seriesData = @json(array_column($mostServicedInstruments, 'count'));
            const labelsData = @json(array_column($mostServicedInstruments, 'name'));

            console.log("Most serviced data:", seriesData);
            console.log("Most serviced labels:", labelsData);

            if (seriesData.length === 0) {
                console.warn("No data available for most serviced instruments");
                return;
            }

            const mostServicedOptions = {
                series: seriesData,
                chart: {
                    type: 'pie',
                    height: 250
                },
                labels: labelsData,
                colors: ['#22C55E', '#001A6E', '#DC2626'],
                legend: {
                    position: 'bottom'
                },
                tooltip: {
                    y: {
                        formatter: function(value) {
                            return value + ' services'
                        }
                    }
                },
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 200
                        },
                        legend: {
                            position: 'bottom'
                        }
                    }
                }]
            };

            try {
                const mostServicedChart = new ApexCharts(document.querySelector("#mostServicedInstruments"), mostServicedOptions);
                mostServicedChart.render();

                Livewire.on('refreshMostServiced', () => {
                    mostServicedChart.updateSeries(@json(array_column($mostServicedInstruments, 'count')));
                    mostServicedChart.updateOptions({
                        labels: @json(array_column($mostServicedInstruments, 'name'))
                    });
                });
            } catch (error) {
                console.error("Error initializing most serviced chart:", error);
            }
        }

        // Today's bookings - no chart initialization needed as it's a simple list
    </script>
</div>
