<div class="mt-6 w-full border-[1px] border-t-[4px] border-primary/20 border-t-primary bg-white flex gap-2 flex-col shadow-lg shadow-gray-300 mt-6">
    @if (session()->has('success'))
        <div id="successMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-success bg-green-100 border-l-4 border-green-500 text-green-700 px-4 py-2 mb-4 pr-20">
            {{ session('success') }}
            <div onclick="document.getElementById('successMessage').classList.add('hidden')"
                 class="cursor-pointer bg-green-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif
    @if (session()->has('error'))
        <div id="dangerMessage"
             class="absolute max-w-[600px] top-4 right-4 alert alert-danger bg-red-100 border-l-4 border-red-500 text-red-700 px-4 py-2 mb-4 pr-20">
            {{ session('error') }}
            <div onclick="document.getElementById('dangerMessage').classList.add('hidden')"
                 class="cursor-pointer bg-red-200 py-2 px-4 h-full flex justify-center absolute top-0 right-0 items-center">
                <i class="fa fa-xmark "></i>
            </div>
        </div>
    @endif

    <div class="bg-primary/10 px-4 py-2 border-b-[2px] border-b-primary/20 flex justify-between">
        <span class="font-semibold text-primary text-xl">Roles</span>
        <span wire:click="showAddRoleDivFunction" class="text-sm bg-primary/80 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-primary/80 text-white hover:text-white hover:bg-primary hover:border-ternary/30 transition ease-in duration-2000 cursor-pointer">
            <i class="fa fa-plus mr-2"></i>Add Role
        </span>
    </div>

    <div class="w-full overflow-x-auto p-4">
        <table class="w-full border-[2px] border-secondary/40 border-collapse" wire:loading.class="opacity-25">
            <tr>
                <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">Sr. No.</td>
                <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">Name</td>
                <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">Permission Assigned</td>
                <td class="border-[2px] border-secondary/40 bg-gray-100 px-4 py-1.5 text-ternary/80 font-bold text-md whitespace-nowrap">Action</td>
            </tr>

            @forelse($roles as $role)
                <tr class="hover:bg-secondary/10 cursor-pointer transition ease-in duration-2000">
                    <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">{{$loop->iteration}}</td>

                    <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                        <span><i class="fa fa-tag mr-1 text-success"></i> {{ ucfirst($role->name) }}</span> <br>
                    </td>
                    <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                        <span  wire:click="assignPermissions({{ $role->id }})"><i class="fa fa-key mr-1 text-success"></i> {{$role->permissions->count()}}</span> <br>
                    </td>
{{--                    <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">--}}
{{--                        <span><i class="fa fa-tag mr-1 text-success"></i> </span> <br>--}}
{{--                    </td>--}}
{{--                    <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm">--}}
{{--                        @foreach($role->permissions as $permission)--}}
{{--                            <span class="inline-block bg-success/10 text-success border-[1px] border-success/20 px-4 py-0.5 rounded-full text-xs mb-2">--}}
{{--                                {{ ucfirst($permission->name) }}--}}
{{--                                <i wire:click="deleteSpecificPermissionForRole({{ $role->id }}, '{{ $permission->name }}')"--}}
{{--                                   class="fa fa-xmark ml-2 text-danger hover:text-primary cursor-pointer">--}}
{{--                                </i>--}}
{{--                            </span>--}}
{{--                        @endforeach--}}
{{--                    </td>--}}
                    <td class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm whitespace-nowrap">
                        <div class="flex gap-2">
                            <button wire:click="assignRoleToUser({{ $role->id }})" {{ in_array($role->name, ['super_admin']) ? 'disabled' : '' }} title="Assign role to user"
                                    class="{{ in_array($role->name, ['super_admin']) ? 'bg-gray-300 text-gray-500 cursor-not-allowed' : 'bg-secondary/20 text-secondary hover:bg-secondary hover:text-white cursor-pointer' }} h-6 w-6 flex justify-center items-center rounded-[3px] transition ease-in duration-2000">
                                <i class="fa fa-user-plus text-xs"></i>
                            </button>
                            <button wire:click="assignPermissions({{ $role->id }})" {{ in_array($role->name, ['super_admin']) ? 'disabled' : '' }} title="Assign permissions"
                                    class="{{ in_array($role->name, ['super_admin']) ? 'bg-gray-300 text-gray-500 cursor-not-allowed' : 'bg-success/20 text-success hover:bg-success hover:text-white cursor-pointer' }} h-6 w-6 flex justify-center items-center rounded-[3px] transition ease-in duration-2000">
                                <i class="fa fa-key text-xs"></i>
                            </button>

                            <button wire:click="editRole({{ $role->id }})" {{ in_array($role->name, ['super_admin']) ? 'disabled' : '' }} title="Edit role"
                                    class="{{ in_array($role->name, ['super_admin']) ? 'bg-gray-300 text-gray-500 cursor-not-allowed' : 'bg-primary/20 text-primary hover:bg-primary hover:text-white cursor-pointer' }} h-6 w-6 flex justify-center items-center rounded-[3px] transition ease-in duration-2000">
                                <i class="fa fa-pencil text-xs"></i>
                            </button>
                            <button wire:click="deleteRole({{ $role->id }})"
                                    {{ in_array($role->name, ['super_admin', 'pi', 'student']) ? 'disabled' : '' }} wire:confirm="Are you sure you want to delete the role {{$role->name}}" title="Delete role"
                                    class="{{ in_array($role->name, ['super_admin', 'pi', 'student']) ? 'bg-gray-300 text-gray-500 cursor-not-allowed' : 'bg-danger/20 text-danger hover:bg-danger hover:text-white cursor-pointer' }} h-6 w-6 flex justify-center items-center rounded-[3px] transition ease-in duration-2000">
                                <i class="fa fa-trash text-xs"></i>
                            </button>
                        </div>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="4" class="border-[2px] border-secondary/40 px-4 py-1.5 text-ternary/80 font-medium text-sm text-center">No roles found</td>
                </tr>
            @endforelse
        </table>
    </div>

    @if($addRoleDiv)
        <div class="fixed inset-0 bg-black/70 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                <h3 class="text-lg font-semibold mb-4 text-primary">{{ $isEditing ? 'Edit Role' : 'Add New Role' }}</h3>
                <form wire:submit="saveRole">
                    <div class="w-full flex flex-col gap-4">
                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Name <span class="text-danger">*</span></label>
                            <input type="text" wire:model="name" placeholder="Enter name"
                                   class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                            @error('title') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>
                    </div>
                    <div class="flex justify-end space-x-3 mt-4">
                        <button type="button" wire:click="resetForm"
                                class="text-sm bg-secondary/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-secondary/90 text-ternary hover:text-white hover:bg-secondary hover:border-ternary/30 transition ease-in duration-2000">Back</button>
                        <button type="submit"
                                class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-success/30 transition ease-in duration-2000">
                            <span wire:loading.remove wire:target="saveDesignation">{{ $isEditing ? 'Update Role' : 'Add Role' }}</span>
                            <span wire:loading wire:target="saveDesignation">{{ $isEditing ? 'Updating Role...' : 'Saving Role...' }} <i class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif
    @if($showAssignPermissionsDiv)
        <div class="fixed inset-0 bg-black/70 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-7xl w-full">
                <h3 class="text-lg font-semibold mb-4 text-primary">Assign Permissions</h3>
                <form wire:submit="savePermissions">
                    <div class="w-full grid lg:grid-cols-5 md:grid-cols-4 sm:grid-cols-2 grid-cols-1  gap-4">
                            @foreach($permissions as $permission)
                                    <div class="w-full flex flex-col gap-1">
                                            <label class="inline-flex items-center">
                                                <input type="checkbox"
                                                       wire:model="selectedPermissions"
                                                       value="{{ $permission->name }}"
                                                       class="form-checkbox h-5 w-5 text-primary rounded-[2px] focus:outline-none focus:ring-0">
                                                <span class="ml-2">{{ $permission->name }}</span>
                                            </label>
                                    </div>
                            @endforeach
                    </div>

                    <div class="flex justify-end space-x-3 mt-4">
                        <button type="button" wire:click="resetForm"
                                class="text-sm bg-danger/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/90 text-ternary hover:text-white hover:bg-danger hover:border-ternary/30 transition ease-in duration-2000">Back</button>
                        <button type="submit"
                                class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-success/30 transition ease-in duration-2000">
                            <span wire:loading.remove wire:target="savePermissions">Assign Permission</span>
                            <span wire:loading wire:target="savePermissions">Assigning Permissions... <i class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif
    @if($showAssignRoleToUserDiv)
        <div class="fixed inset-0 bg-black/70 flex items-center justify-center z-50 p-6">
            <div class="bg-white p-6 rounded-lg shadow-xl max-w-md w-full">
                <h3 class="text-lg font-semibold mb-4 text-primary">Assign Role to User</h3>
                <form wire:submit="assignRoleToUserSubmit">
                    <div class="w-full flex flex-col gap-4">
                        <div class="w-full flex flex-col gap-1">
                            <label class="font-semibold text-primary">Select User <span class="text-danger">*</span></label>
                            <select wire:model="selectedUserId" class="px-2 py-2 w-full text-sm font-medium bg-transparent placeholder-black border-[2px] border-primary/40 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] focus:ring-0 focus:outline-none focus:border-primary transition ease-in duration-2000">
                                <option value="">Select a user</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }} ({{ $user->email }})</option>
                                @endforeach
                            </select>
                            @error('selectedUserId') <span class="text-red-500"><i class="fa fa-triangle-exclamation mr-2"></i>{{ $message }}</span> @enderror
                        </div>
                    </div>
                    <div class="flex justify-end space-x-3 mt-4">
                        <button type="button" wire:click="resetForm"
                                class="text-sm bg-danger/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-danger/90 text-ternary hover:text-white hover:bg-danger hover:border-ternary/30 transition ease-in duration-2000">Back</button>
                        <button type="submit"
                                class="text-sm bg-success/30 px-4 py-1 rounded-[3px] rounded-tr-[8px] rounded-bl-[8px] font-semibold border-[2px] border-success/90 text-ternary hover:text-white hover:bg-success hover:border-success/30 transition ease-in duration-2000">
                            <span wire:loading.remove wire:target="assignRoleToUserSubmit">Assign Role</span>
                            <span wire:loading wire:target="assignRoleToUserSubmit">Assigning Role... <i class="fas fa-hourglass-half fa-spin ml-2"></i></span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    @endif
</div>


